/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.ts.Ac3Extractor;
import com.google.android.exoplayer2.extractor.ts.Ac4Extractor;
import com.google.android.exoplayer2.extractor.ts.AdtsExtractor;
import com.google.android.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.google.android.exoplayer2.extractor.ts.TsExtractor;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsTrackMetadataEntry;
import com.google.android.exoplayer2.source.hls.WebvttExtractor;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DefaultHlsExtractorFactory
implements HlsExtractorFactory {
    public static final String AAC_FILE_EXTENSION = ".aac";
    public static final String AC3_FILE_EXTENSION = ".ac3";
    public static final String EC3_FILE_EXTENSION = ".ec3";
    public static final String AC4_FILE_EXTENSION = ".ac4";
    public static final String MP3_FILE_EXTENSION = ".mp3";
    public static final String MP4_FILE_EXTENSION = ".mp4";
    public static final String M4_FILE_EXTENSION_PREFIX = ".m4";
    public static final String MP4_FILE_EXTENSION_PREFIX = ".mp4";
    public static final String CMF_FILE_EXTENSION_PREFIX = ".cmf";
    public static final String VTT_FILE_EXTENSION = ".vtt";
    public static final String WEBVTT_FILE_EXTENSION = ".webvtt";
    private final int payloadReaderFactoryFlags;
    private final boolean exposeCea608WhenMissingDeclarations;

    public DefaultHlsExtractorFactory() {
        this(0, true);
    }

    public DefaultHlsExtractorFactory(int payloadReaderFactoryFlags, boolean exposeCea608WhenMissingDeclarations) {
        this.payloadReaderFactoryFlags = payloadReaderFactoryFlags;
        this.exposeCea608WhenMissingDeclarations = exposeCea608WhenMissingDeclarations;
    }

    @Override
    public HlsExtractorFactory.Result createExtractor(@Nullable Extractor previousExtractor, Uri uri, Format format, @Nullable List<Format> muxedCaptionFormats, @Nullable DrmInitData drmInitData, TimestampAdjuster timestampAdjuster, Map<String, List<String>> responseHeaders, ExtractorInput extractorInput) throws InterruptedException, IOException {
        TsExtractor tsExtractor;
        FragmentedMp4Extractor fragmentedMp4Extractor;
        Mp3Extractor mp3Extractor;
        Ac4Extractor ac4Extractor;
        Ac3Extractor ac3Extractor;
        AdtsExtractor adtsExtractor;
        WebvttExtractor webvttExtractor;
        if (previousExtractor != null) {
            if (DefaultHlsExtractorFactory.isReusable(previousExtractor)) {
                return DefaultHlsExtractorFactory.buildResult(previousExtractor);
            }
            HlsExtractorFactory.Result result = DefaultHlsExtractorFactory.buildResultForSameExtractorType(previousExtractor, format, timestampAdjuster);
            if (result == null) {
                throw new IllegalArgumentException("Unexpected previousExtractor type: " + previousExtractor.getClass().getSimpleName());
            }
        }
        Extractor extractorByFileExtension = this.createExtractorByFileExtension(uri, format, muxedCaptionFormats, drmInitData, timestampAdjuster);
        extractorInput.resetPeekPosition();
        if (DefaultHlsExtractorFactory.sniffQuietly(extractorByFileExtension, extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult(extractorByFileExtension);
        }
        if (!(extractorByFileExtension instanceof WebvttExtractor) && DefaultHlsExtractorFactory.sniffQuietly(webvttExtractor = new WebvttExtractor(format.language, timestampAdjuster), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult(webvttExtractor);
        }
        if (!(extractorByFileExtension instanceof AdtsExtractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(adtsExtractor = new AdtsExtractor()), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)adtsExtractor);
        }
        if (!(extractorByFileExtension instanceof Ac3Extractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(ac3Extractor = new Ac3Extractor()), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)ac3Extractor);
        }
        if (!(extractorByFileExtension instanceof Ac4Extractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(ac4Extractor = new Ac4Extractor()), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)ac4Extractor);
        }
        if (!(extractorByFileExtension instanceof Mp3Extractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(mp3Extractor = new Mp3Extractor(0, 0L)), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)mp3Extractor);
        }
        if (!(extractorByFileExtension instanceof FragmentedMp4Extractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(fragmentedMp4Extractor = DefaultHlsExtractorFactory.createFragmentedMp4Extractor(timestampAdjuster, format, drmInitData, muxedCaptionFormats)), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)fragmentedMp4Extractor);
        }
        if (!(extractorByFileExtension instanceof TsExtractor) && DefaultHlsExtractorFactory.sniffQuietly((Extractor)(tsExtractor = DefaultHlsExtractorFactory.createTsExtractor(this.payloadReaderFactoryFlags, this.exposeCea608WhenMissingDeclarations, format, muxedCaptionFormats, timestampAdjuster)), extractorInput)) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)tsExtractor);
        }
        return DefaultHlsExtractorFactory.buildResult(extractorByFileExtension);
    }

    private Extractor createExtractorByFileExtension(Uri uri, Format format, @Nullable List<Format> muxedCaptionFormats, @Nullable DrmInitData drmInitData, TimestampAdjuster timestampAdjuster) {
        String lastPathSegment = uri.getLastPathSegment();
        if (lastPathSegment == null) {
            lastPathSegment = "";
        }
        if ("text/vtt".equals(format.sampleMimeType) || lastPathSegment.endsWith(WEBVTT_FILE_EXTENSION) || lastPathSegment.endsWith(VTT_FILE_EXTENSION)) {
            return new WebvttExtractor(format.language, timestampAdjuster);
        }
        if (lastPathSegment.endsWith(AAC_FILE_EXTENSION)) {
            return new AdtsExtractor();
        }
        if (lastPathSegment.endsWith(AC3_FILE_EXTENSION) || lastPathSegment.endsWith(EC3_FILE_EXTENSION)) {
            return new Ac3Extractor();
        }
        if (lastPathSegment.endsWith(AC4_FILE_EXTENSION)) {
            return new Ac4Extractor();
        }
        if (lastPathSegment.endsWith(MP3_FILE_EXTENSION)) {
            return new Mp3Extractor(0, 0L);
        }
        if (lastPathSegment.endsWith(".mp4") || lastPathSegment.startsWith(M4_FILE_EXTENSION_PREFIX, lastPathSegment.length() - 4) || lastPathSegment.startsWith(".mp4", lastPathSegment.length() - 5) || lastPathSegment.startsWith(CMF_FILE_EXTENSION_PREFIX, lastPathSegment.length() - 5)) {
            return DefaultHlsExtractorFactory.createFragmentedMp4Extractor(timestampAdjuster, format, drmInitData, muxedCaptionFormats);
        }
        return DefaultHlsExtractorFactory.createTsExtractor(this.payloadReaderFactoryFlags, this.exposeCea608WhenMissingDeclarations, format, muxedCaptionFormats, timestampAdjuster);
    }

    private static TsExtractor createTsExtractor(int userProvidedPayloadReaderFactoryFlags, boolean exposeCea608WhenMissingDeclarations, Format format, @Nullable List<Format> muxedCaptionFormats, TimestampAdjuster timestampAdjuster) {
        int payloadReaderFactoryFlags = 0x10 | userProvidedPayloadReaderFactoryFlags;
        if (muxedCaptionFormats != null) {
            payloadReaderFactoryFlags |= 0x20;
        } else {
            muxedCaptionFormats = exposeCea608WhenMissingDeclarations ? Collections.singletonList(Format.createTextSampleFormat(null, (String)"application/cea-608", (int)0, null)) : Collections.emptyList();
        }
        String codecs = format.codecs;
        if (!TextUtils.isEmpty((CharSequence)codecs)) {
            if (!"audio/mp4a-latm".equals(MimeTypes.getAudioMediaMimeType((String)codecs))) {
                payloadReaderFactoryFlags |= 2;
            }
            if (!"video/avc".equals(MimeTypes.getVideoMediaMimeType((String)codecs))) {
                payloadReaderFactoryFlags |= 4;
            }
        }
        return new TsExtractor(2, timestampAdjuster, (TsPayloadReader.Factory)new DefaultTsPayloadReaderFactory(payloadReaderFactoryFlags, muxedCaptionFormats));
    }

    private static FragmentedMp4Extractor createFragmentedMp4Extractor(TimestampAdjuster timestampAdjuster, Format format, @Nullable DrmInitData drmInitData, @Nullable List<Format> muxedCaptionFormats) {
        return new FragmentedMp4Extractor(DefaultHlsExtractorFactory.isFmp4Variant(format) ? 4 : 0, timestampAdjuster, null, drmInitData, muxedCaptionFormats != null ? muxedCaptionFormats : Collections.emptyList());
    }

    private static boolean isFmp4Variant(Format format) {
        Metadata metadata = format.metadata;
        if (metadata == null) {
            return false;
        }
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (!(entry instanceof HlsTrackMetadataEntry)) continue;
            return !((HlsTrackMetadataEntry)entry).variantInfos.isEmpty();
        }
        return false;
    }

    @Nullable
    private static HlsExtractorFactory.Result buildResultForSameExtractorType(Extractor previousExtractor, Format format, TimestampAdjuster timestampAdjuster) {
        if (previousExtractor instanceof WebvttExtractor) {
            return DefaultHlsExtractorFactory.buildResult(new WebvttExtractor(format.language, timestampAdjuster));
        }
        if (previousExtractor instanceof AdtsExtractor) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)new AdtsExtractor());
        }
        if (previousExtractor instanceof Ac3Extractor) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)new Ac3Extractor());
        }
        if (previousExtractor instanceof Ac4Extractor) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)new Ac4Extractor());
        }
        if (previousExtractor instanceof Mp3Extractor) {
            return DefaultHlsExtractorFactory.buildResult((Extractor)new Mp3Extractor());
        }
        return null;
    }

    private static HlsExtractorFactory.Result buildResult(Extractor extractor) {
        return new HlsExtractorFactory.Result(extractor, extractor instanceof AdtsExtractor || extractor instanceof Ac3Extractor || extractor instanceof Ac4Extractor || extractor instanceof Mp3Extractor, DefaultHlsExtractorFactory.isReusable(extractor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sniffQuietly(Extractor extractor, ExtractorInput input) throws InterruptedException, IOException {
        boolean result = false;
        try {
            result = extractor.sniff(input);
        }
        catch (EOFException eOFException) {
        }
        finally {
            input.resetPeekPosition();
        }
        return result;
    }

    private static boolean isReusable(Extractor previousExtractor) {
        return previousExtractor instanceof TsExtractor || previousExtractor instanceof FragmentedMp4Extractor;
    }
}

