/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.hls.Aes128DataSource;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class HlsMediaChunk
extends MediaChunk {
    public static final String PRIV_TIMESTAMP_FRAME_OWNER = "com.apple.streaming.transportStreamTimestamp";
    private static final AtomicInteger uidSource = new AtomicInteger();
    public final int uid;
    public final int discontinuitySequenceNumber;
    public final Uri playlistUrl;
    @Nullable
    private final DataSource initDataSource;
    @Nullable
    private final DataSpec initDataSpec;
    private final boolean isMasterTimestampSource;
    private final boolean hasGapTag;
    private final TimestampAdjuster timestampAdjuster;
    private final boolean shouldSpliceIn;
    private final HlsExtractorFactory extractorFactory;
    @Nullable
    private final List<Format> muxedCaptionFormats;
    @Nullable
    private final DrmInitData drmInitData;
    @Nullable
    private final Extractor previousExtractor;
    private final Id3Decoder id3Decoder;
    private final ParsableByteArray scratchId3Data;
    private final boolean mediaSegmentEncrypted;
    private final boolean initSegmentEncrypted;
    private Extractor extractor;
    private boolean isExtractorReusable;
    private HlsSampleStreamWrapper output;
    private int nextLoadPosition;
    private boolean initDataLoadRequired;
    private volatile boolean loadCanceled;
    private boolean loadCompleted;

    public static HlsMediaChunk createInstance(HlsExtractorFactory extractorFactory, DataSource dataSource, Format format, long startOfPlaylistInPeriodUs, HlsMediaPlaylist mediaPlaylist, int segmentIndexInPlaylist, Uri playlistUrl, @Nullable List<Format> muxedCaptionFormats, int trackSelectionReason, @Nullable Object trackSelectionData, boolean isMasterTimestampSource, TimestampAdjusterProvider timestampAdjusterProvider, @Nullable HlsMediaChunk previousChunk, @Nullable byte[] mediaSegmentKey, @Nullable byte[] initSegmentKey) {
        boolean shouldSpliceIn;
        ParsableByteArray scratchId3Data;
        Id3Decoder id3Decoder;
        HlsMediaPlaylist.Segment mediaSegment = mediaPlaylist.segments.get(segmentIndexInPlaylist);
        DataSpec dataSpec = new DataSpec(UriUtil.resolveToUri((String)mediaPlaylist.baseUri, (String)mediaSegment.url), mediaSegment.byterangeOffset, mediaSegment.byterangeLength, null);
        boolean mediaSegmentEncrypted = mediaSegmentKey != null;
        byte[] mediaSegmentIv = mediaSegmentEncrypted ? HlsMediaChunk.getEncryptionIvArray(mediaSegment.encryptionIV) : null;
        DataSource mediaDataSource = HlsMediaChunk.buildDataSource(dataSource, mediaSegmentKey, mediaSegmentIv);
        HlsMediaPlaylist.Segment initSegment = mediaSegment.initializationSegment;
        DataSpec initDataSpec = null;
        boolean initSegmentEncrypted = false;
        DataSource initDataSource = null;
        if (initSegment != null) {
            initSegmentEncrypted = initSegmentKey != null;
            byte[] initSegmentIv = initSegmentEncrypted ? HlsMediaChunk.getEncryptionIvArray(initSegment.encryptionIV) : null;
            Uri initSegmentUri = UriUtil.resolveToUri((String)mediaPlaylist.baseUri, (String)initSegment.url);
            initDataSpec = new DataSpec(initSegmentUri, initSegment.byterangeOffset, initSegment.byterangeLength, null);
            initDataSource = HlsMediaChunk.buildDataSource(dataSource, initSegmentKey, initSegmentIv);
        }
        long segmentStartTimeInPeriodUs = startOfPlaylistInPeriodUs + mediaSegment.relativeStartTimeUs;
        long segmentEndTimeInPeriodUs = segmentStartTimeInPeriodUs + mediaSegment.durationUs;
        int discontinuitySequenceNumber = mediaPlaylist.discontinuitySequence + mediaSegment.relativeDiscontinuitySequence;
        Extractor previousExtractor = null;
        if (previousChunk != null) {
            id3Decoder = previousChunk.id3Decoder;
            scratchId3Data = previousChunk.scratchId3Data;
            shouldSpliceIn = !playlistUrl.equals((Object)previousChunk.playlistUrl) || !previousChunk.loadCompleted;
            previousExtractor = previousChunk.isExtractorReusable && previousChunk.discontinuitySequenceNumber == discontinuitySequenceNumber && !shouldSpliceIn ? previousChunk.extractor : null;
        } else {
            id3Decoder = new Id3Decoder();
            scratchId3Data = new ParsableByteArray(10);
            shouldSpliceIn = false;
        }
        return new HlsMediaChunk(extractorFactory, mediaDataSource, dataSpec, format, mediaSegmentEncrypted, initDataSource, initDataSpec, initSegmentEncrypted, playlistUrl, muxedCaptionFormats, trackSelectionReason, trackSelectionData, segmentStartTimeInPeriodUs, segmentEndTimeInPeriodUs, mediaPlaylist.mediaSequence + (long)segmentIndexInPlaylist, discontinuitySequenceNumber, mediaSegment.hasGapTag, isMasterTimestampSource, timestampAdjusterProvider.getAdjuster(discontinuitySequenceNumber), mediaSegment.drmInitData, previousExtractor, id3Decoder, scratchId3Data, shouldSpliceIn);
    }

    private HlsMediaChunk(HlsExtractorFactory extractorFactory, DataSource mediaDataSource, DataSpec dataSpec, Format format, boolean mediaSegmentEncrypted, DataSource initDataSource, @Nullable DataSpec initDataSpec, boolean initSegmentEncrypted, Uri playlistUrl, @Nullable List<Format> muxedCaptionFormats, int trackSelectionReason, Object trackSelectionData, long startTimeUs, long endTimeUs, long chunkMediaSequence, int discontinuitySequenceNumber, boolean hasGapTag, boolean isMasterTimestampSource, TimestampAdjuster timestampAdjuster, @Nullable DrmInitData drmInitData, @Nullable Extractor previousExtractor, Id3Decoder id3Decoder, ParsableByteArray scratchId3Data, boolean shouldSpliceIn) {
        super(mediaDataSource, dataSpec, format, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkMediaSequence);
        this.mediaSegmentEncrypted = mediaSegmentEncrypted;
        this.discontinuitySequenceNumber = discontinuitySequenceNumber;
        this.initDataSource = initDataSource;
        this.initDataSpec = initDataSpec;
        this.initSegmentEncrypted = initSegmentEncrypted;
        this.playlistUrl = playlistUrl;
        this.isMasterTimestampSource = isMasterTimestampSource;
        this.timestampAdjuster = timestampAdjuster;
        this.hasGapTag = hasGapTag;
        this.extractorFactory = extractorFactory;
        this.muxedCaptionFormats = muxedCaptionFormats;
        this.drmInitData = drmInitData;
        this.previousExtractor = previousExtractor;
        this.id3Decoder = id3Decoder;
        this.scratchId3Data = scratchId3Data;
        this.shouldSpliceIn = shouldSpliceIn;
        this.initDataLoadRequired = initDataSpec != null;
        this.uid = uidSource.getAndIncrement();
    }

    public void init(HlsSampleStreamWrapper output) {
        this.output = output;
    }

    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    public void cancelLoad() {
        this.loadCanceled = true;
    }

    public void load() throws IOException, InterruptedException {
        if (this.extractor == null && this.previousExtractor != null) {
            this.extractor = this.previousExtractor;
            this.isExtractorReusable = true;
            this.initDataLoadRequired = false;
            this.output.init(this.uid, this.shouldSpliceIn, true);
        }
        this.maybeLoadInitData();
        if (!this.loadCanceled) {
            if (!this.hasGapTag) {
                this.loadMedia();
            }
            this.loadCompleted = true;
        }
    }

    private void maybeLoadInitData() throws IOException, InterruptedException {
        if (!this.initDataLoadRequired) {
            return;
        }
        this.feedDataToExtractor(this.initDataSource, this.initDataSpec, this.initSegmentEncrypted);
        this.nextLoadPosition = 0;
        this.initDataLoadRequired = false;
    }

    private void loadMedia() throws IOException, InterruptedException {
        if (!this.isMasterTimestampSource) {
            this.timestampAdjuster.waitUntilInitialized();
        } else if (this.timestampAdjuster.getFirstSampleTimestampUs() == Long.MAX_VALUE) {
            this.timestampAdjuster.setFirstSampleTimestampUs(this.startTimeUs);
        }
        this.feedDataToExtractor((DataSource)this.dataSource, this.dataSpec, this.mediaSegmentEncrypted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedDataToExtractor(DataSource dataSource, DataSpec dataSpec, boolean dataIsEncrypted) throws IOException, InterruptedException {
        boolean skipLoadedBytes;
        DataSpec loadDataSpec;
        if (dataIsEncrypted) {
            loadDataSpec = dataSpec;
            skipLoadedBytes = this.nextLoadPosition != 0;
        } else {
            loadDataSpec = dataSpec.subrange((long)this.nextLoadPosition);
            skipLoadedBytes = false;
        }
        try {
            DefaultExtractorInput input = this.prepareExtraction(dataSource, loadDataSpec);
            if (skipLoadedBytes) {
                input.skipFully(this.nextLoadPosition);
            }
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read((ExtractorInput)input, null);
                }
            }
            finally {
                this.nextLoadPosition = (int)(input.getPosition() - dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            Util.closeQuietly((DataSource)dataSource);
        }
    }

    private DefaultExtractorInput prepareExtraction(DataSource dataSource, DataSpec dataSpec) throws IOException, InterruptedException {
        long bytesToRead = dataSource.open(dataSpec);
        DefaultExtractorInput extractorInput = new DefaultExtractorInput(dataSource, dataSpec.absoluteStreamPosition, bytesToRead);
        if (this.extractor == null) {
            long id3Timestamp = this.peekId3PrivTimestamp((ExtractorInput)extractorInput);
            extractorInput.resetPeekPosition();
            HlsExtractorFactory.Result result = this.extractorFactory.createExtractor(this.previousExtractor, dataSpec.uri, this.trackFormat, this.muxedCaptionFormats, this.drmInitData, this.timestampAdjuster, dataSource.getResponseHeaders(), (ExtractorInput)extractorInput);
            this.extractor = result.extractor;
            this.isExtractorReusable = result.isReusable;
            if (result.isPackedAudioExtractor) {
                this.output.setSampleOffsetUs(id3Timestamp != -9223372036854775807L ? this.timestampAdjuster.adjustTsTimestamp(id3Timestamp) : this.startTimeUs);
            } else {
                this.output.setSampleOffsetUs(0L);
            }
            this.output.init(this.uid, this.shouldSpliceIn, false);
            this.extractor.init((ExtractorOutput)this.output);
        }
        return extractorInput;
    }

    private long peekId3PrivTimestamp(ExtractorInput input) throws IOException, InterruptedException {
        input.resetPeekPosition();
        try {
            input.peekFully(this.scratchId3Data.data, 0, 10);
        }
        catch (EOFException e) {
            return -9223372036854775807L;
        }
        this.scratchId3Data.reset(10);
        int id = this.scratchId3Data.readUnsignedInt24();
        if (id != Id3Decoder.ID3_TAG) {
            return -9223372036854775807L;
        }
        this.scratchId3Data.skipBytes(3);
        int id3Size = this.scratchId3Data.readSynchSafeInt();
        int requiredCapacity = id3Size + 10;
        if (requiredCapacity > this.scratchId3Data.capacity()) {
            byte[] data = this.scratchId3Data.data;
            this.scratchId3Data.reset(requiredCapacity);
            System.arraycopy(data, 0, this.scratchId3Data.data, 0, 10);
        }
        input.peekFully(this.scratchId3Data.data, 10, id3Size);
        Metadata metadata = this.id3Decoder.decode(this.scratchId3Data.data, id3Size);
        if (metadata == null) {
            return -9223372036854775807L;
        }
        int metadataLength = metadata.length();
        for (int i = 0; i < metadataLength; ++i) {
            Metadata.Entry frame = metadata.get(i);
            if (!(frame instanceof PrivFrame)) continue;
            PrivFrame privFrame = (PrivFrame)frame;
            if (!PRIV_TIMESTAMP_FRAME_OWNER.equals(privFrame.owner)) continue;
            System.arraycopy(privFrame.privateData, 0, this.scratchId3Data.data, 0, 8);
            this.scratchId3Data.reset(8);
            return this.scratchId3Data.readLong() & 0x1FFFFFFFFL;
        }
        return -9223372036854775807L;
    }

    private static byte[] getEncryptionIvArray(String ivString) {
        String trimmedIv = Util.toLowerInvariant((String)ivString).startsWith("0x") ? ivString.substring(2) : ivString;
        byte[] ivData = new BigInteger(trimmedIv, 16).toByteArray();
        byte[] ivDataWithPadding = new byte[16];
        int offset = ivData.length > 16 ? ivData.length - 16 : 0;
        System.arraycopy(ivData, offset, ivDataWithPadding, ivDataWithPadding.length - ivData.length + offset, ivData.length - offset);
        return ivDataWithPadding;
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] fullSegmentEncryptionKey, byte[] encryptionIv) {
        if (fullSegmentEncryptionKey != null) {
            return new Aes128DataSource(dataSource, fullSegmentEncryptionKey, encryptionIv);
        }
        return dataSource;
    }
}

