/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ConstantBitrateSeekMap;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ts.AdtsReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.EOFException;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
public final class AdtsExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new AdtsExtractor()};
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING = 1;
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING_ALWAYS = 2;
    private static final int MAX_PACKET_SIZE = 2048;
    private static final int MAX_SNIFF_BYTES = 8192;
    private static final int NUM_FRAMES_FOR_AVERAGE_FRAME_SIZE = 1000;
    private final int flags;
    private final AdtsReader reader;
    private final ParsableByteArray packetBuffer;
    private final ParsableByteArray scratch;
    private final ParsableBitArray scratchBits;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private long firstSampleTimestampUs;
    private long firstFramePosition;
    private int averageFrameSize;
    private boolean hasCalculatedAverageFrameSize;
    private boolean startedPacket;
    private boolean hasOutputSeekMap;

    public AdtsExtractor() {
        this(0);
    }

    public AdtsExtractor(int flags) {
        if ((flags & 2) != 0) {
            flags |= 1;
        }
        this.flags = flags;
        this.reader = new AdtsReader(true);
        this.packetBuffer = new ParsableByteArray(2048);
        this.averageFrameSize = -1;
        this.firstFramePosition = -1L;
        this.scratch = new ParsableByteArray(10);
        this.scratchBits = new ParsableBitArray(this.scratch.getData());
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        int startPosition;
        int headerPosition = startPosition = this.peekId3Header(input);
        int totalValidFramesSize = 0;
        int validFramesCount = 0;
        do {
            input.peekFully(this.scratch.getData(), 0, 2);
            this.scratch.setPosition(0);
            int syncBytes = this.scratch.readUnsignedShort();
            if (!AdtsReader.isAdtsSyncWord(syncBytes)) {
                validFramesCount = 0;
                totalValidFramesSize = 0;
                input.resetPeekPosition();
                input.advancePeekPosition(++headerPosition);
                continue;
            }
            if (++validFramesCount >= 4 && totalValidFramesSize > 188) {
                return true;
            }
            input.peekFully(this.scratch.getData(), 0, 4);
            this.scratchBits.setPosition(14);
            int frameSize = this.scratchBits.readBits(13);
            if (frameSize <= 6) {
                validFramesCount = 0;
                totalValidFramesSize = 0;
                input.resetPeekPosition();
                input.advancePeekPosition(++headerPosition);
                continue;
            }
            input.advancePeekPosition(frameSize - 6);
            totalValidFramesSize += frameSize;
        } while (headerPosition - startPosition < 8192);
        return false;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.reader.createTracks(output, new TsPayloadReader.TrackIdGenerator(0, 1));
        output.endTracks();
    }

    @Override
    public void seek(long position, long timeUs) {
        this.startedPacket = false;
        this.reader.seek();
        this.firstSampleTimestampUs = timeUs;
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        int bytesRead;
        boolean canUseConstantBitrateSeeking;
        Assertions.checkStateNotNull((Object)this.extractorOutput);
        long inputLength = input.getLength();
        boolean bl = canUseConstantBitrateSeeking = (this.flags & 2) != 0 || (this.flags & 1) != 0 && inputLength != -1L;
        if (canUseConstantBitrateSeeking) {
            this.calculateAverageFrameSize(input);
        }
        boolean readEndOfStream = (bytesRead = input.read(this.packetBuffer.getData(), 0, 2048)) == -1;
        this.maybeOutputSeekMap(inputLength, readEndOfStream);
        if (readEndOfStream) {
            return -1;
        }
        this.packetBuffer.setPosition(0);
        this.packetBuffer.setLimit(bytesRead);
        if (!this.startedPacket) {
            this.reader.packetStarted(this.firstSampleTimestampUs, 4);
            this.startedPacket = true;
        }
        this.reader.consume(this.packetBuffer);
        return 0;
    }

    private int peekId3Header(ExtractorInput input) throws IOException {
        int firstFramePosition = 0;
        while (true) {
            input.peekFully(this.scratch.getData(), 0, 10);
            this.scratch.setPosition(0);
            if (this.scratch.readUnsignedInt24() != 0x494433) break;
            this.scratch.skipBytes(3);
            int length = this.scratch.readSynchSafeInt();
            firstFramePosition += 10 + length;
            input.advancePeekPosition(length);
        }
        input.resetPeekPosition();
        input.advancePeekPosition(firstFramePosition);
        if (this.firstFramePosition == -1L) {
            this.firstFramePosition = firstFramePosition;
        }
        return firstFramePosition;
    }

    @RequiresNonNull(value={"extractorOutput"})
    private void maybeOutputSeekMap(long inputLength, boolean readEndOfStream) {
        boolean useConstantBitrateSeeking;
        if (this.hasOutputSeekMap) {
            return;
        }
        boolean bl = useConstantBitrateSeeking = (this.flags & 1) != 0 && this.averageFrameSize > 0;
        if (useConstantBitrateSeeking && this.reader.getSampleDurationUs() == -9223372036854775807L && !readEndOfStream) {
            return;
        }
        if (useConstantBitrateSeeking && this.reader.getSampleDurationUs() != -9223372036854775807L) {
            this.extractorOutput.seekMap(this.getConstantBitrateSeekMap(inputLength, (this.flags & 2) != 0));
        } else {
            this.extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        }
        this.hasOutputSeekMap = true;
    }

    private void calculateAverageFrameSize(ExtractorInput input) throws IOException {
        if (this.hasCalculatedAverageFrameSize) {
            return;
        }
        this.averageFrameSize = -1;
        input.resetPeekPosition();
        if (input.getPosition() == 0L) {
            this.peekId3Header(input);
        }
        int numValidFrames = 0;
        long totalValidFramesSize = 0L;
        try {
            while (input.peekFully(this.scratch.getData(), 0, 2, true)) {
                this.scratch.setPosition(0);
                int syncBytes = this.scratch.readUnsignedShort();
                if (!AdtsReader.isAdtsSyncWord(syncBytes)) {
                    numValidFrames = 0;
                } else if (input.peekFully(this.scratch.getData(), 0, 4, true)) {
                    this.scratchBits.setPosition(14);
                    int currentFrameSize = this.scratchBits.readBits(13);
                    if (currentFrameSize <= 6) {
                        this.hasCalculatedAverageFrameSize = true;
                        throw ParserException.createForMalformedContainer((String)"Malformed ADTS stream", null);
                    }
                    totalValidFramesSize += (long)currentFrameSize;
                    if (++numValidFrames != 1000 && input.advancePeekPosition(currentFrameSize - 6, true)) continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        input.resetPeekPosition();
        this.averageFrameSize = numValidFrames > 0 ? (int)(totalValidFramesSize / (long)numValidFrames) : -1;
        this.hasCalculatedAverageFrameSize = true;
    }

    private SeekMap getConstantBitrateSeekMap(long inputLength, boolean allowSeeksIfLengthUnknown) {
        int bitrate = AdtsExtractor.getBitrateFromFrameSize(this.averageFrameSize, this.reader.getSampleDurationUs());
        return new ConstantBitrateSeekMap(inputLength, this.firstFramePosition, bitrate, this.averageFrameSize, allowSeeksIfLengthUnknown);
    }

    private static int getBitrateFromFrameSize(int frameSize, long durationUsPerFrame) {
        return (int)((long)frameSize * 8L * 1000000L / durationUsPerFrame);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

