/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.util.Assertions;

@Deprecated
public final class VorbisBitArray {
    private final byte[] data;
    private final int byteLimit;
    private int byteOffset;
    private int bitOffset;

    public VorbisBitArray(byte[] data) {
        this.data = data;
        this.byteLimit = data.length;
    }

    public void reset() {
        this.byteOffset = 0;
        this.bitOffset = 0;
    }

    public boolean readBit() {
        boolean returnValue = ((this.data[this.byteOffset] & 0xFF) >> this.bitOffset & 1) == 1;
        this.skipBits(1);
        return returnValue;
    }

    public int readBits(int numBits) {
        int bitsRead;
        int tempByteOffset = this.byteOffset;
        int returnValue = (this.data[tempByteOffset++] & 0xFF) >> this.bitOffset & 255 >> 8 - bitsRead;
        for (bitsRead = Math.min(numBits, 8 - this.bitOffset); bitsRead < numBits; bitsRead += 8) {
            returnValue |= (this.data[tempByteOffset++] & 0xFF) << bitsRead;
        }
        this.skipBits(numBits);
        return returnValue &= -1 >>> 32 - numBits;
    }

    public void skipBits(int numBits) {
        int numBytes = numBits / 8;
        this.byteOffset += numBytes;
        this.bitOffset += numBits - numBytes * 8;
        if (this.bitOffset > 7) {
            ++this.byteOffset;
            this.bitOffset -= 8;
        }
        this.assertValidOffset();
    }

    public int getPosition() {
        return this.byteOffset * 8 + this.bitOffset;
    }

    public void setPosition(int position) {
        this.byteOffset = position / 8;
        this.bitOffset = position - this.byteOffset * 8;
        this.assertValidOffset();
    }

    public int bitsLeft() {
        return (this.byteLimit - this.byteOffset) * 8 - this.bitOffset;
    }

    private void assertValidOffset() {
        Assertions.checkState((this.byteOffset >= 0 && (this.byteOffset < this.byteLimit || this.byteOffset == this.byteLimit && this.bitOffset == 0) ? 1 : 0) != 0);
    }
}

