/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.CommentFrame;
import com.google.android.exoplayer2.metadata.id3.InternalFrame;
import com.google.android.exoplayer2.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public final class GaplessInfoHolder {
    private static final String GAPLESS_DOMAIN = "com.apple.iTunes";
    private static final String GAPLESS_DESCRIPTION = "iTunSMPB";
    private static final Pattern GAPLESS_COMMENT_PATTERN = Pattern.compile("^ [0-9a-fA-F]{8} ([0-9a-fA-F]{8}) ([0-9a-fA-F]{8})");
    public int encoderDelay = -1;
    public int encoderPadding = -1;

    public boolean setFromXingHeaderValue(int value) {
        int encoderDelay = value >> 12;
        int encoderPadding = value & 0xFFF;
        if (encoderDelay > 0 || encoderPadding > 0) {
            this.encoderDelay = encoderDelay;
            this.encoderPadding = encoderPadding;
            return true;
        }
        return false;
    }

    public boolean setFromMetadata(Metadata metadata) {
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (entry instanceof CommentFrame) {
                CommentFrame commentFrame = (CommentFrame)entry;
                if (!GAPLESS_DESCRIPTION.equals(commentFrame.description) || !this.setFromComment(commentFrame.text)) continue;
                return true;
            }
            if (!(entry instanceof InternalFrame)) continue;
            InternalFrame internalFrame = (InternalFrame)entry;
            if (!GAPLESS_DOMAIN.equals(internalFrame.domain) || !GAPLESS_DESCRIPTION.equals(internalFrame.description) || !this.setFromComment(internalFrame.text)) continue;
            return true;
        }
        return false;
    }

    private boolean setFromComment(String data) {
        Matcher matcher = GAPLESS_COMMENT_PATTERN.matcher(data);
        if (matcher.find()) {
            try {
                int encoderDelay = Integer.parseInt((String)Util.castNonNull((Object)matcher.group(1)), 16);
                int encoderPadding = Integer.parseInt((String)Util.castNonNull((Object)matcher.group(2)), 16);
                if (encoderDelay > 0 || encoderPadding > 0) {
                    this.encoderDelay = encoderDelay;
                    this.encoderPadding = encoderPadding;
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasGaplessInfo() {
        return this.encoderDelay != -1 && this.encoderPadding != -1;
    }
}

