/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import android.graphics.Color;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.span.HorizontalTextInVerticalContextSpan;
import com.google.android.exoplayer2.text.span.RubySpan;
import com.google.android.exoplayer2.text.span.SpanUtil;
import com.google.android.exoplayer2.text.webvtt.WebvttCssStyle;
import com.google.android.exoplayer2.text.webvtt.WebvttCueInfo;
import com.google.android.exoplayer2.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class WebvttCueParser {
    private static final int TEXT_ALIGNMENT_START = 1;
    private static final int TEXT_ALIGNMENT_CENTER = 2;
    private static final int TEXT_ALIGNMENT_END = 3;
    private static final int TEXT_ALIGNMENT_LEFT = 4;
    private static final int TEXT_ALIGNMENT_RIGHT = 5;
    public static final Pattern CUE_HEADER_PATTERN = Pattern.compile("^(\\S+)\\s+-->\\s+(\\S+)(.*)?$");
    private static final Pattern CUE_SETTING_PATTERN = Pattern.compile("(\\S+?):(\\S+)");
    private static final char CHAR_LESS_THAN = '<';
    private static final char CHAR_GREATER_THAN = '>';
    private static final char CHAR_SLASH = '/';
    private static final char CHAR_AMPERSAND = '&';
    private static final char CHAR_SEMI_COLON = ';';
    private static final char CHAR_SPACE = ' ';
    private static final String ENTITY_LESS_THAN = "lt";
    private static final String ENTITY_GREATER_THAN = "gt";
    private static final String ENTITY_AMPERSAND = "amp";
    private static final String ENTITY_NON_BREAK_SPACE = "nbsp";
    private static final String TAG_BOLD = "b";
    private static final String TAG_CLASS = "c";
    private static final String TAG_ITALIC = "i";
    private static final String TAG_LANG = "lang";
    private static final String TAG_RUBY = "ruby";
    private static final String TAG_RUBY_TEXT = "rt";
    private static final String TAG_UNDERLINE = "u";
    private static final String TAG_VOICE = "v";
    private static final int STYLE_BOLD = 1;
    private static final int STYLE_ITALIC = 2;
    static final float DEFAULT_POSITION = 0.5f;
    private static final String TAG = "WebvttCueParser";
    private static final Map<String, Integer> DEFAULT_TEXT_COLORS;
    private static final Map<String, Integer> DEFAULT_BACKGROUND_COLORS;

    @Nullable
    public static WebvttCueInfo parseCue(ParsableByteArray webvttData, List<WebvttCssStyle> styles) {
        String firstLine = webvttData.readLine();
        if (firstLine == null) {
            return null;
        }
        Matcher cueHeaderMatcher = CUE_HEADER_PATTERN.matcher(firstLine);
        if (cueHeaderMatcher.matches()) {
            return WebvttCueParser.parseCue(null, cueHeaderMatcher, webvttData, styles);
        }
        String secondLine = webvttData.readLine();
        if (secondLine == null) {
            return null;
        }
        cueHeaderMatcher = CUE_HEADER_PATTERN.matcher(secondLine);
        if (cueHeaderMatcher.matches()) {
            return WebvttCueParser.parseCue(firstLine.trim(), cueHeaderMatcher, webvttData, styles);
        }
        return null;
    }

    static Cue.Builder parseCueSettingsList(String cueSettingsList) {
        WebvttCueInfoBuilder builder = new WebvttCueInfoBuilder();
        WebvttCueParser.parseCueSettingsList(cueSettingsList, builder);
        return builder.toCueBuilder();
    }

    static Cue newCueForText(CharSequence text) {
        WebvttCueInfoBuilder infoBuilder = new WebvttCueInfoBuilder();
        infoBuilder.text = text;
        return infoBuilder.toCueBuilder().build();
    }

    static SpannedString parseCueText(@Nullable String id, String markup, List<WebvttCssStyle> styles) {
        SpannableStringBuilder spannedText = new SpannableStringBuilder();
        ArrayDeque<StartTag> startTagStack = new ArrayDeque<StartTag>();
        int pos = 0;
        ArrayList<Element> nestedElements = new ArrayList<Element>();
        block4: while (pos < markup.length()) {
            char curr = markup.charAt(pos);
            block0 : switch (curr) {
                case '<': {
                    String tagName;
                    boolean isVoidTag;
                    int ltPos;
                    if (pos + 1 >= markup.length()) {
                        ++pos;
                        break;
                    }
                    boolean isClosingTag = markup.charAt((ltPos = pos) + 1) == '/';
                    String fullTagExpression = markup.substring(ltPos + (isClosingTag ? 2 : 1), (isVoidTag = markup.charAt((pos = WebvttCueParser.findEndOfTag(markup, ltPos + 1)) - 2) == '/') ? pos - 2 : pos - 1);
                    if (fullTagExpression.trim().isEmpty() || !WebvttCueParser.isSupportedTag(tagName = WebvttCueParser.getTagName(fullTagExpression))) continue block4;
                    if (isClosingTag) {
                        while (!startTagStack.isEmpty()) {
                            StartTag startTag = (StartTag)startTagStack.pop();
                            WebvttCueParser.applySpansForTag(id, startTag, nestedElements, spannedText, styles);
                            if (!startTagStack.isEmpty()) {
                                nestedElements.add(new Element(startTag, spannedText.length()));
                            } else {
                                nestedElements.clear();
                            }
                            if (!startTag.name.equals(tagName)) continue;
                            break block0;
                        }
                        continue block4;
                    }
                    if (isVoidTag) continue block4;
                    startTagStack.push(StartTag.buildStartTag(fullTagExpression, spannedText.length()));
                    break;
                }
                case '&': {
                    int entityEndIndex;
                    int semiColonEndIndex = markup.indexOf(59, pos + 1);
                    int spaceEndIndex = markup.indexOf(32, pos + 1);
                    int n = semiColonEndIndex == -1 ? spaceEndIndex : (entityEndIndex = spaceEndIndex == -1 ? semiColonEndIndex : Math.min(semiColonEndIndex, spaceEndIndex));
                    if (entityEndIndex != -1) {
                        WebvttCueParser.applyEntity(markup.substring(pos + 1, entityEndIndex), spannedText);
                        if (entityEndIndex == spaceEndIndex) {
                            spannedText.append((CharSequence)" ");
                        }
                        pos = entityEndIndex + 1;
                        break;
                    }
                    spannedText.append(curr);
                    ++pos;
                    break;
                }
                default: {
                    spannedText.append(curr);
                    ++pos;
                }
            }
        }
        while (!startTagStack.isEmpty()) {
            WebvttCueParser.applySpansForTag(id, (StartTag)startTagStack.pop(), nestedElements, spannedText, styles);
        }
        WebvttCueParser.applySpansForTag(id, StartTag.buildWholeCueVirtualTag(), Collections.emptyList(), spannedText, styles);
        return SpannedString.valueOf((CharSequence)spannedText);
    }

    @Nullable
    private static WebvttCueInfo parseCue(@Nullable String id, Matcher cueHeaderMatcher, ParsableByteArray webvttData, List<WebvttCssStyle> styles) {
        WebvttCueInfoBuilder builder = new WebvttCueInfoBuilder();
        try {
            builder.startTimeUs = WebvttParserUtil.parseTimestampUs((String)Assertions.checkNotNull((Object)cueHeaderMatcher.group(1)));
            builder.endTimeUs = WebvttParserUtil.parseTimestampUs((String)Assertions.checkNotNull((Object)cueHeaderMatcher.group(2)));
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Skipping cue with bad header: " + cueHeaderMatcher.group()));
            return null;
        }
        WebvttCueParser.parseCueSettingsList((String)Assertions.checkNotNull((Object)cueHeaderMatcher.group(3)), builder);
        StringBuilder textBuilder = new StringBuilder();
        String line = webvttData.readLine();
        while (!TextUtils.isEmpty((CharSequence)line)) {
            if (textBuilder.length() > 0) {
                textBuilder.append("\n");
            }
            textBuilder.append(line.trim());
            line = webvttData.readLine();
        }
        builder.text = WebvttCueParser.parseCueText(id, textBuilder.toString(), styles);
        return builder.build();
    }

    private static void parseCueSettingsList(String cueSettingsList, WebvttCueInfoBuilder builder) {
        Matcher cueSettingMatcher = CUE_SETTING_PATTERN.matcher(cueSettingsList);
        while (cueSettingMatcher.find()) {
            String name = (String)Assertions.checkNotNull((Object)cueSettingMatcher.group(1));
            String value = (String)Assertions.checkNotNull((Object)cueSettingMatcher.group(2));
            try {
                if ("line".equals(name)) {
                    WebvttCueParser.parseLineAttribute(value, builder);
                    continue;
                }
                if ("align".equals(name)) {
                    builder.textAlignment = WebvttCueParser.parseTextAlignment(value);
                    continue;
                }
                if ("position".equals(name)) {
                    WebvttCueParser.parsePositionAttribute(value, builder);
                    continue;
                }
                if ("size".equals(name)) {
                    builder.size = WebvttParserUtil.parsePercentage(value);
                    continue;
                }
                if ("vertical".equals(name)) {
                    builder.verticalType = WebvttCueParser.parseVerticalAttribute(value);
                    continue;
                }
                Log.w((String)TAG, (String)("Unknown cue setting " + name + ":" + value));
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Skipping bad cue setting: " + cueSettingMatcher.group()));
            }
        }
    }

    private static void parseLineAttribute(String s, WebvttCueInfoBuilder builder) {
        int commaIndex = s.indexOf(44);
        if (commaIndex != -1) {
            builder.lineAnchor = WebvttCueParser.parseLineAnchor(s.substring(commaIndex + 1));
            s = s.substring(0, commaIndex);
        }
        if (s.endsWith("%")) {
            builder.line = WebvttParserUtil.parsePercentage(s);
            builder.lineType = 0;
        } else {
            builder.line = Integer.parseInt(s);
            builder.lineType = 1;
        }
    }

    private static int parseLineAnchor(String s) {
        switch (s) {
            case "start": {
                return 0;
            }
            case "center": 
            case "middle": {
                return 1;
            }
            case "end": {
                return 2;
            }
        }
        Log.w((String)TAG, (String)("Invalid anchor value: " + s));
        return Integer.MIN_VALUE;
    }

    private static void parsePositionAttribute(String s, WebvttCueInfoBuilder builder) {
        int commaIndex = s.indexOf(44);
        if (commaIndex != -1) {
            builder.positionAnchor = WebvttCueParser.parsePositionAnchor(s.substring(commaIndex + 1));
            s = s.substring(0, commaIndex);
        }
        builder.position = WebvttParserUtil.parsePercentage(s);
    }

    private static int parsePositionAnchor(String s) {
        switch (s) {
            case "line-left": 
            case "start": {
                return 0;
            }
            case "center": 
            case "middle": {
                return 1;
            }
            case "line-right": 
            case "end": {
                return 2;
            }
        }
        Log.w((String)TAG, (String)("Invalid anchor value: " + s));
        return Integer.MIN_VALUE;
    }

    private static int parseVerticalAttribute(String s) {
        switch (s) {
            case "rl": {
                return 1;
            }
            case "lr": {
                return 2;
            }
        }
        Log.w((String)TAG, (String)("Invalid 'vertical' value: " + s));
        return Integer.MIN_VALUE;
    }

    private static int parseTextAlignment(String s) {
        switch (s) {
            case "start": {
                return 1;
            }
            case "left": {
                return 4;
            }
            case "center": 
            case "middle": {
                return 2;
            }
            case "end": {
                return 3;
            }
            case "right": {
                return 5;
            }
        }
        Log.w((String)TAG, (String)("Invalid alignment value: " + s));
        return 2;
    }

    private static int findEndOfTag(String markup, int startPos) {
        int index = markup.indexOf(62, startPos);
        return index == -1 ? markup.length() : index + 1;
    }

    private static void applyEntity(String entity, SpannableStringBuilder spannedText) {
        switch (entity) {
            case "lt": {
                spannedText.append('<');
                break;
            }
            case "gt": {
                spannedText.append('>');
                break;
            }
            case "nbsp": {
                spannedText.append(' ');
                break;
            }
            case "amp": {
                spannedText.append('&');
                break;
            }
            default: {
                Log.w((String)TAG, (String)("ignoring unsupported entity: '&" + entity + ";'"));
            }
        }
    }

    private static boolean isSupportedTag(String tagName) {
        switch (tagName) {
            case "b": 
            case "c": 
            case "i": 
            case "lang": 
            case "ruby": 
            case "rt": 
            case "u": 
            case "v": {
                return true;
            }
        }
        return false;
    }

    private static void applySpansForTag(@Nullable String cueId, StartTag startTag, List<Element> nestedElements, SpannableStringBuilder text, List<WebvttCssStyle> styles) {
        int start = startTag.position;
        int end = text.length();
        switch (startTag.name) {
            case "b": {
                text.setSpan((Object)new StyleSpan(1), start, end, 33);
                break;
            }
            case "i": {
                text.setSpan((Object)new StyleSpan(2), start, end, 33);
                break;
            }
            case "ruby": {
                WebvttCueParser.applyRubySpans(text, cueId, startTag, nestedElements, styles);
                break;
            }
            case "u": {
                text.setSpan((Object)new UnderlineSpan(), start, end, 33);
                break;
            }
            case "c": {
                WebvttCueParser.applyDefaultColors(text, startTag.classes, start, end);
                break;
            }
            case "lang": 
            case "v": 
            case "": {
                break;
            }
            default: {
                return;
            }
        }
        List<StyleMatch> applicableStyles = WebvttCueParser.getApplicableStyles(styles, cueId, startTag);
        for (int i = 0; i < applicableStyles.size(); ++i) {
            WebvttCueParser.applyStyleToText(text, applicableStyles.get((int)i).style, start, end);
        }
    }

    private static void applyRubySpans(SpannableStringBuilder text, @Nullable String cueId, StartTag startTag, List<Element> nestedElements, List<WebvttCssStyle> styles) {
        int rubyTagPosition = WebvttCueParser.getRubyPosition(styles, cueId, startTag);
        ArrayList<Element> sortedNestedElements = new ArrayList<Element>(nestedElements.size());
        sortedNestedElements.addAll(nestedElements);
        Collections.sort(sortedNestedElements, Element.BY_START_POSITION_ASC);
        int deletedCharCount = 0;
        int lastRubyTextEnd = startTag.position;
        for (int i = 0; i < sortedNestedElements.size(); ++i) {
            if (!TAG_RUBY_TEXT.equals(((Element)((Element)sortedNestedElements.get((int)i))).startTag.name)) continue;
            Element rubyTextElement = (Element)sortedNestedElements.get(i);
            int rubyPosition = WebvttCueParser.firstKnownRubyPosition(WebvttCueParser.getRubyPosition(styles, cueId, rubyTextElement.startTag), rubyTagPosition, 1);
            int adjustedRubyTextStart = ((Element)rubyTextElement).startTag.position - deletedCharCount;
            int adjustedRubyTextEnd = rubyTextElement.endPosition - deletedCharCount;
            CharSequence rubyText = text.subSequence(adjustedRubyTextStart, adjustedRubyTextEnd);
            text.delete(adjustedRubyTextStart, adjustedRubyTextEnd);
            text.setSpan((Object)new RubySpan(rubyText.toString(), rubyPosition), lastRubyTextEnd, adjustedRubyTextStart, 33);
            deletedCharCount += rubyText.length();
            lastRubyTextEnd = adjustedRubyTextStart;
        }
    }

    private static int getRubyPosition(List<WebvttCssStyle> styles, @Nullable String cueId, StartTag startTag) {
        List<StyleMatch> styleMatches = WebvttCueParser.getApplicableStyles(styles, cueId, startTag);
        for (int i = 0; i < styleMatches.size(); ++i) {
            WebvttCssStyle style = styleMatches.get((int)i).style;
            if (style.getRubyPosition() == -1) continue;
            return style.getRubyPosition();
        }
        return -1;
    }

    private static int firstKnownRubyPosition(int position1, int position2, int position3) {
        if (position1 != -1) {
            return position1;
        }
        if (position2 != -1) {
            return position2;
        }
        if (position3 != -1) {
            return position3;
        }
        throw new IllegalArgumentException();
    }

    private static void applyDefaultColors(SpannableStringBuilder text, Set<String> classes, int start, int end) {
        for (String className : classes) {
            int color;
            if (DEFAULT_TEXT_COLORS.containsKey(className)) {
                color = DEFAULT_TEXT_COLORS.get(className);
                text.setSpan((Object)new ForegroundColorSpan(color), start, end, 33);
                continue;
            }
            if (!DEFAULT_BACKGROUND_COLORS.containsKey(className)) continue;
            color = DEFAULT_BACKGROUND_COLORS.get(className);
            text.setSpan((Object)new BackgroundColorSpan(color), start, end, 33);
        }
    }

    private static void applyStyleToText(SpannableStringBuilder spannedText, WebvttCssStyle style, int start, int end) {
        if (style == null) {
            return;
        }
        if (style.getStyle() != -1) {
            SpanUtil.addOrReplaceSpan((Spannable)spannedText, (Object)new StyleSpan(style.getStyle()), (int)start, (int)end, (int)33);
        }
        if (style.isLinethrough()) {
            spannedText.setSpan((Object)new StrikethroughSpan(), start, end, 33);
        }
        if (style.isUnderline()) {
            spannedText.setSpan((Object)new UnderlineSpan(), start, end, 33);
        }
        if (style.hasFontColor()) {
            SpanUtil.addOrReplaceSpan((Spannable)spannedText, (Object)new ForegroundColorSpan(style.getFontColor()), (int)start, (int)end, (int)33);
        }
        if (style.hasBackgroundColor()) {
            SpanUtil.addOrReplaceSpan((Spannable)spannedText, (Object)new BackgroundColorSpan(style.getBackgroundColor()), (int)start, (int)end, (int)33);
        }
        if (style.getFontFamily() != null) {
            SpanUtil.addOrReplaceSpan((Spannable)spannedText, (Object)new TypefaceSpan(style.getFontFamily()), (int)start, (int)end, (int)33);
        }
        switch (style.getFontSizeUnit()) {
            case 1: {
                SpanUtil.addOrReplaceSpan((Spannable)spannedText, (Object)new AbsoluteSizeSpan((int)style.getFontSize(), true), (int)start, (int)end, (int)33);
                break;
            }
            case 2: {
                SpanUtil.addOrReplaceSpan((Spannable)spannedText, (Object)new RelativeSizeSpan(style.getFontSize()), (int)start, (int)end, (int)33);
                break;
            }
            case 3: {
                SpanUtil.addOrReplaceSpan((Spannable)spannedText, (Object)new RelativeSizeSpan(style.getFontSize() / 100.0f), (int)start, (int)end, (int)33);
                break;
            }
        }
        if (style.getCombineUpright()) {
            spannedText.setSpan((Object)new HorizontalTextInVerticalContextSpan(), start, end, 33);
        }
    }

    private static String getTagName(String tagExpression) {
        Assertions.checkArgument((!(tagExpression = tagExpression.trim()).isEmpty() ? 1 : 0) != 0);
        return Util.splitAtFirst((String)tagExpression, (String)"[ \\.]")[0];
    }

    private static List<StyleMatch> getApplicableStyles(List<WebvttCssStyle> declaredStyles, @Nullable String id, StartTag tag) {
        ArrayList<StyleMatch> applicableStyles = new ArrayList<StyleMatch>();
        for (int i = 0; i < declaredStyles.size(); ++i) {
            WebvttCssStyle style = declaredStyles.get(i);
            int score = style.getSpecificityScore(id, tag.name, tag.classes, tag.voice);
            if (score <= 0) continue;
            applicableStyles.add(new StyleMatch(score, style));
        }
        Collections.sort(applicableStyles);
        return applicableStyles;
    }

    static {
        HashMap<String, Integer> defaultColors = new HashMap<String, Integer>();
        defaultColors.put("white", Color.rgb((int)255, (int)255, (int)255));
        defaultColors.put("lime", Color.rgb((int)0, (int)255, (int)0));
        defaultColors.put("cyan", Color.rgb((int)0, (int)255, (int)255));
        defaultColors.put("red", Color.rgb((int)255, (int)0, (int)0));
        defaultColors.put("yellow", Color.rgb((int)255, (int)255, (int)0));
        defaultColors.put("magenta", Color.rgb((int)255, (int)0, (int)255));
        defaultColors.put("blue", Color.rgb((int)0, (int)0, (int)255));
        defaultColors.put("black", Color.rgb((int)0, (int)0, (int)0));
        DEFAULT_TEXT_COLORS = Collections.unmodifiableMap(defaultColors);
        HashMap<String, Integer> defaultBackgroundColors = new HashMap<String, Integer>();
        defaultBackgroundColors.put("bg_white", Color.rgb((int)255, (int)255, (int)255));
        defaultBackgroundColors.put("bg_lime", Color.rgb((int)0, (int)255, (int)0));
        defaultBackgroundColors.put("bg_cyan", Color.rgb((int)0, (int)255, (int)255));
        defaultBackgroundColors.put("bg_red", Color.rgb((int)255, (int)0, (int)0));
        defaultBackgroundColors.put("bg_yellow", Color.rgb((int)255, (int)255, (int)0));
        defaultBackgroundColors.put("bg_magenta", Color.rgb((int)255, (int)0, (int)255));
        defaultBackgroundColors.put("bg_blue", Color.rgb((int)0, (int)0, (int)255));
        defaultBackgroundColors.put("bg_black", Color.rgb((int)0, (int)0, (int)0));
        DEFAULT_BACKGROUND_COLORS = Collections.unmodifiableMap(defaultBackgroundColors);
    }

    private static class Element {
        private static final Comparator<Element> BY_START_POSITION_ASC = (e1, e2) -> Integer.compare(e1.startTag.position, e2.startTag.position);
        private final StartTag startTag;
        private final int endPosition;

        private Element(StartTag startTag, int endPosition) {
            this.startTag = startTag;
            this.endPosition = endPosition;
        }
    }

    private static final class StartTag {
        public final String name;
        public final int position;
        public final String voice;
        public final Set<String> classes;

        private StartTag(String name, int position, String voice, Set<String> classes) {
            this.position = position;
            this.name = name;
            this.voice = voice;
            this.classes = classes;
        }

        public static StartTag buildStartTag(String fullTagExpression, int position) {
            String voice;
            Assertions.checkArgument((!(fullTagExpression = fullTagExpression.trim()).isEmpty() ? 1 : 0) != 0);
            int voiceStartIndex = fullTagExpression.indexOf(" ");
            if (voiceStartIndex == -1) {
                voice = "";
            } else {
                voice = fullTagExpression.substring(voiceStartIndex).trim();
                fullTagExpression = fullTagExpression.substring(0, voiceStartIndex);
            }
            String[] nameAndClasses = Util.split((String)fullTagExpression, (String)"\\.");
            String name = nameAndClasses[0];
            HashSet<String> classes = new HashSet<String>();
            for (int i = 1; i < nameAndClasses.length; ++i) {
                classes.add(nameAndClasses[i]);
            }
            return new StartTag(name, position, voice, classes);
        }

        public static StartTag buildWholeCueVirtualTag() {
            return new StartTag("", 0, "", Collections.emptySet());
        }
    }

    private static final class StyleMatch
    implements Comparable<StyleMatch> {
        public final int score;
        public final WebvttCssStyle style;

        public StyleMatch(int score, WebvttCssStyle style) {
            this.score = score;
            this.style = style;
        }

        @Override
        public int compareTo(StyleMatch another) {
            return Integer.compare(this.score, another.score);
        }
    }

    private static final class WebvttCueInfoBuilder {
        public long startTimeUs = 0L;
        public long endTimeUs = 0L;
        public @MonotonicNonNull CharSequence text;
        public int textAlignment = 2;
        public float line = -3.4028235E38f;
        public int lineType = 1;
        public int lineAnchor = 0;
        public float position = -3.4028235E38f;
        public int positionAnchor = Integer.MIN_VALUE;
        public float size = 1.0f;
        public int verticalType = Integer.MIN_VALUE;

        public WebvttCueInfo build() {
            return new WebvttCueInfo(this.toCueBuilder().build(), this.startTimeUs, this.endTimeUs);
        }

        public Cue.Builder toCueBuilder() {
            float position = this.position != -3.4028235E38f ? this.position : WebvttCueInfoBuilder.derivePosition(this.textAlignment);
            int positionAnchor = this.positionAnchor != Integer.MIN_VALUE ? this.positionAnchor : WebvttCueInfoBuilder.derivePositionAnchor(this.textAlignment);
            Cue.Builder cueBuilder = new Cue.Builder().setTextAlignment(WebvttCueInfoBuilder.convertTextAlignment(this.textAlignment)).setLine(WebvttCueInfoBuilder.computeLine(this.line, this.lineType), this.lineType).setLineAnchor(this.lineAnchor).setPosition(position).setPositionAnchor(positionAnchor).setSize(Math.min(this.size, WebvttCueInfoBuilder.deriveMaxSize(positionAnchor, position))).setVerticalType(this.verticalType);
            if (this.text != null) {
                cueBuilder.setText(this.text);
            }
            return cueBuilder;
        }

        private static float computeLine(float line, int lineType) {
            if (line != -3.4028235E38f && lineType == 0 && (line < 0.0f || line > 1.0f)) {
                return 1.0f;
            }
            if (line != -3.4028235E38f) {
                return line;
            }
            if (lineType == 0) {
                return 1.0f;
            }
            return -3.4028235E38f;
        }

        private static float derivePosition(int textAlignment) {
            switch (textAlignment) {
                case 4: {
                    return 0.0f;
                }
                case 5: {
                    return 1.0f;
                }
            }
            return 0.5f;
        }

        private static int derivePositionAnchor(int textAlignment) {
            switch (textAlignment) {
                case 1: 
                case 4: {
                    return 0;
                }
                case 3: 
                case 5: {
                    return 2;
                }
            }
            return 1;
        }

        @Nullable
        private static Layout.Alignment convertTextAlignment(int textAlignment) {
            switch (textAlignment) {
                case 1: 
                case 4: {
                    return Layout.Alignment.ALIGN_NORMAL;
                }
                case 2: {
                    return Layout.Alignment.ALIGN_CENTER;
                }
                case 3: 
                case 5: {
                    return Layout.Alignment.ALIGN_OPPOSITE;
                }
            }
            Log.w((String)WebvttCueParser.TAG, (String)("Unknown textAlignment: " + textAlignment));
            return null;
        }

        private static float deriveMaxSize(int positionAnchor, float position) {
            switch (positionAnchor) {
                case 0: {
                    return 1.0f - position;
                }
                case 2: {
                    return position;
                }
                case 1: {
                    if (position <= 0.5f) {
                        return position * 2.0f;
                    }
                    return (1.0f - position) * 2.0f;
                }
            }
            throw new IllegalStateException(String.valueOf(positionAnchor));
        }
    }
}

