/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.ttml;

import android.text.Layout;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.SimpleSubtitleDecoder;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.ttml.TextEmphasis;
import com.google.android.exoplayer2.text.ttml.TtmlNode;
import com.google.android.exoplayer2.text.ttml.TtmlRegion;
import com.google.android.exoplayer2.text.ttml.TtmlStyle;
import com.google.android.exoplayer2.text.ttml.TtmlSubtitle;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ColorParser;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.util.XmlPullParserUtil;
import com.google.common.base.Ascii;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

@Deprecated
public final class TtmlDecoder
extends SimpleSubtitleDecoder {
    private static final String TAG = "TtmlDecoder";
    private static final String TTP = "http://www.w3.org/ns/ttml#parameter";
    private static final String ATTR_BEGIN = "begin";
    private static final String ATTR_DURATION = "dur";
    private static final String ATTR_END = "end";
    private static final String ATTR_STYLE = "style";
    private static final String ATTR_REGION = "region";
    private static final String ATTR_IMAGE = "backgroundImage";
    private static final Pattern CLOCK_TIME = Pattern.compile("^([0-9][0-9]+):([0-9][0-9]):([0-9][0-9])(?:(\\.[0-9]+)|:([0-9][0-9])(?:\\.([0-9]+))?)?$");
    private static final Pattern OFFSET_TIME = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)(h|m|s|ms|f|t)$");
    private static final Pattern FONT_SIZE = Pattern.compile("^(([0-9]*.)?[0-9]+)(px|em|%)$");
    static final Pattern SIGNED_PERCENTAGE = Pattern.compile("^([-+]?\\d+\\.?\\d*?)%$");
    static final Pattern PERCENTAGE_COORDINATES = Pattern.compile("^(\\d+\\.?\\d*?)% (\\d+\\.?\\d*?)%$");
    private static final Pattern PIXEL_COORDINATES = Pattern.compile("^(\\d+\\.?\\d*?)px (\\d+\\.?\\d*?)px$");
    private static final Pattern CELL_RESOLUTION = Pattern.compile("^(\\d+) (\\d+)$");
    private static final int DEFAULT_FRAME_RATE = 30;
    private static final FrameAndTickRate DEFAULT_FRAME_AND_TICK_RATE = new FrameAndTickRate(30.0f, 1, 1);
    private static final CellResolution DEFAULT_CELL_RESOLUTION = new CellResolution(32, 15);
    private final XmlPullParserFactory xmlParserFactory;

    public TtmlDecoder() {
        super(TAG);
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
            this.xmlParserFactory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    @Override
    protected Subtitle decode(byte[] data, int length, boolean reset) throws SubtitleDecoderException {
        try {
            XmlPullParser xmlParser = this.xmlParserFactory.newPullParser();
            HashMap<String, TtmlStyle> globalStyles = new HashMap<String, TtmlStyle>();
            HashMap<String, TtmlRegion> regionMap = new HashMap<String, TtmlRegion>();
            HashMap<String, String> imageMap = new HashMap<String, String>();
            regionMap.put("", new TtmlRegion(""));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data, 0, length);
            xmlParser.setInput((InputStream)inputStream, null);
            TtmlSubtitle ttmlSubtitle = null;
            ArrayDeque<TtmlNode> nodeStack = new ArrayDeque<TtmlNode>();
            int unsupportedNodeDepth = 0;
            int eventType = xmlParser.getEventType();
            FrameAndTickRate frameAndTickRate = DEFAULT_FRAME_AND_TICK_RATE;
            CellResolution cellResolution = DEFAULT_CELL_RESOLUTION;
            TtsExtent ttsExtent = null;
            while (eventType != 1) {
                TtmlNode parent = (TtmlNode)nodeStack.peek();
                if (unsupportedNodeDepth == 0) {
                    String name = xmlParser.getName();
                    if (eventType == 2) {
                        if ("tt".equals(name)) {
                            frameAndTickRate = TtmlDecoder.parseFrameAndTickRates(xmlParser);
                            cellResolution = TtmlDecoder.parseCellResolution(xmlParser, DEFAULT_CELL_RESOLUTION);
                            ttsExtent = TtmlDecoder.parseTtsExtent(xmlParser);
                        }
                        if (!TtmlDecoder.isSupportedTag(name)) {
                            Log.i((String)TAG, (String)("Ignoring unsupported tag: " + xmlParser.getName()));
                            ++unsupportedNodeDepth;
                        } else if ("head".equals(name)) {
                            TtmlDecoder.parseHeader(xmlParser, globalStyles, cellResolution, ttsExtent, regionMap, imageMap);
                        } else {
                            try {
                                TtmlNode node = TtmlDecoder.parseNode(xmlParser, parent, regionMap, frameAndTickRate);
                                nodeStack.push(node);
                                if (parent != null) {
                                    parent.addChild(node);
                                }
                            }
                            catch (SubtitleDecoderException e) {
                                Log.w((String)TAG, (String)"Suppressing parser error", (Throwable)((Object)e));
                                ++unsupportedNodeDepth;
                            }
                        }
                    } else if (eventType == 4) {
                        ((TtmlNode)Assertions.checkNotNull((Object)parent)).addChild(TtmlNode.buildTextNode(xmlParser.getText()));
                    } else if (eventType == 3) {
                        if (xmlParser.getName().equals("tt")) {
                            ttmlSubtitle = new TtmlSubtitle((TtmlNode)Assertions.checkNotNull((Object)((TtmlNode)nodeStack.peek())), globalStyles, regionMap, imageMap);
                        }
                        nodeStack.pop();
                    }
                } else if (eventType == 2) {
                    ++unsupportedNodeDepth;
                } else if (eventType == 3) {
                    --unsupportedNodeDepth;
                }
                xmlParser.next();
                eventType = xmlParser.getEventType();
            }
            if (ttmlSubtitle != null) {
                return ttmlSubtitle;
            }
            throw new SubtitleDecoderException("No TTML subtitles found");
        }
        catch (XmlPullParserException xppe) {
            throw new SubtitleDecoderException("Unable to decode source", xppe);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error when reading input.", e);
        }
    }

    private static FrameAndTickRate parseFrameAndTickRates(XmlPullParser xmlParser) throws SubtitleDecoderException {
        int frameRate = 30;
        String frameRateString = xmlParser.getAttributeValue(TTP, "frameRate");
        if (frameRateString != null) {
            frameRate = Integer.parseInt(frameRateString);
        }
        float frameRateMultiplier = 1.0f;
        String frameRateMultiplierString = xmlParser.getAttributeValue(TTP, "frameRateMultiplier");
        if (frameRateMultiplierString != null) {
            String[] parts = Util.split((String)frameRateMultiplierString, (String)" ");
            if (parts.length != 2) {
                throw new SubtitleDecoderException("frameRateMultiplier doesn't have 2 parts");
            }
            float numerator = Integer.parseInt(parts[0]);
            float denominator = Integer.parseInt(parts[1]);
            frameRateMultiplier = numerator / denominator;
        }
        int subFrameRate = TtmlDecoder.DEFAULT_FRAME_AND_TICK_RATE.subFrameRate;
        String subFrameRateString = xmlParser.getAttributeValue(TTP, "subFrameRate");
        if (subFrameRateString != null) {
            subFrameRate = Integer.parseInt(subFrameRateString);
        }
        int tickRate = TtmlDecoder.DEFAULT_FRAME_AND_TICK_RATE.tickRate;
        String tickRateString = xmlParser.getAttributeValue(TTP, "tickRate");
        if (tickRateString != null) {
            tickRate = Integer.parseInt(tickRateString);
        }
        return new FrameAndTickRate((float)frameRate * frameRateMultiplier, subFrameRate, tickRate);
    }

    private static CellResolution parseCellResolution(XmlPullParser xmlParser, CellResolution defaultValue) throws SubtitleDecoderException {
        String cellResolution = xmlParser.getAttributeValue(TTP, "cellResolution");
        if (cellResolution == null) {
            return defaultValue;
        }
        Matcher cellResolutionMatcher = CELL_RESOLUTION.matcher(cellResolution);
        if (!cellResolutionMatcher.matches()) {
            Log.w((String)TAG, (String)("Ignoring malformed cell resolution: " + cellResolution));
            return defaultValue;
        }
        try {
            int columns = Integer.parseInt((String)Assertions.checkNotNull((Object)cellResolutionMatcher.group(1)));
            int rows = Integer.parseInt((String)Assertions.checkNotNull((Object)cellResolutionMatcher.group(2)));
            if (columns == 0 || rows == 0) {
                throw new SubtitleDecoderException("Invalid cell resolution " + columns + " " + rows);
            }
            return new CellResolution(columns, rows);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Ignoring malformed cell resolution: " + cellResolution));
            return defaultValue;
        }
    }

    @Nullable
    private static TtsExtent parseTtsExtent(XmlPullParser xmlParser) {
        String ttsExtent = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)"extent");
        if (ttsExtent == null) {
            return null;
        }
        Matcher extentMatcher = PIXEL_COORDINATES.matcher(ttsExtent);
        if (!extentMatcher.matches()) {
            Log.w((String)TAG, (String)("Ignoring non-pixel tts extent: " + ttsExtent));
            return null;
        }
        try {
            int width = Integer.parseInt((String)Assertions.checkNotNull((Object)extentMatcher.group(1)));
            int height = Integer.parseInt((String)Assertions.checkNotNull((Object)extentMatcher.group(2)));
            return new TtsExtent(width, height);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Ignoring malformed tts extent: " + ttsExtent));
            return null;
        }
    }

    private static Map<String, TtmlStyle> parseHeader(XmlPullParser xmlParser, Map<String, TtmlStyle> globalStyles, CellResolution cellResolution, @Nullable TtsExtent ttsExtent, Map<String, TtmlRegion> globalRegions, Map<String, String> imageMap) throws IOException, XmlPullParserException {
        do {
            xmlParser.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xmlParser, (String)ATTR_STYLE)) {
                String styleId;
                String parentStyleId = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)ATTR_STYLE);
                TtmlStyle style = TtmlDecoder.parseStyleAttributes(xmlParser, new TtmlStyle());
                if (parentStyleId != null) {
                    for (String id : TtmlDecoder.parseStyleIds(parentStyleId)) {
                        style.chain(globalStyles.get(id));
                    }
                }
                if ((styleId = style.getId()) == null) continue;
                globalStyles.put(styleId, style);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xmlParser, (String)ATTR_REGION)) {
                TtmlRegion ttmlRegion = TtmlDecoder.parseRegionAttributes(xmlParser, cellResolution, ttsExtent);
                if (ttmlRegion == null) continue;
                globalRegions.put(ttmlRegion.id, ttmlRegion);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xmlParser, (String)"metadata")) continue;
            TtmlDecoder.parseMetadata(xmlParser, imageMap);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xmlParser, (String)"head"));
        return globalStyles;
    }

    private static void parseMetadata(XmlPullParser xmlParser, Map<String, String> imageMap) throws IOException, XmlPullParserException {
        do {
            String id;
            xmlParser.next();
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xmlParser, (String)"image") || (id = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)"id")) == null) continue;
            String encodedBitmapData = xmlParser.nextText();
            imageMap.put(id, encodedBitmapData);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xmlParser, (String)"metadata"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TtmlRegion parseRegionAttributes(XmlPullParser xmlParser, CellResolution cellResolution, @Nullable TtsExtent ttsExtent) {
        float height;
        float width;
        float line;
        float position;
        String regionId = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)"id");
        if (regionId == null) {
            return null;
        }
        String regionOrigin = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)"origin");
        if (regionOrigin == null) {
            Log.w((String)TAG, (String)"Ignoring region without an origin");
            return null;
        }
        Matcher originPercentageMatcher = PERCENTAGE_COORDINATES.matcher(regionOrigin);
        Matcher originPixelMatcher = PIXEL_COORDINATES.matcher(regionOrigin);
        if (originPercentageMatcher.matches()) {
            try {
                position = Float.parseFloat((String)Assertions.checkNotNull((Object)originPercentageMatcher.group(1))) / 100.0f;
                line = Float.parseFloat((String)Assertions.checkNotNull((Object)originPercentageMatcher.group(2))) / 100.0f;
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Ignoring region with malformed origin: " + regionOrigin));
                return null;
            }
        }
        if (!originPixelMatcher.matches()) {
            Log.w((String)TAG, (String)("Ignoring region with unsupported origin: " + regionOrigin));
            return null;
        }
        if (ttsExtent == null) {
            Log.w((String)TAG, (String)("Ignoring region with missing tts:extent: " + regionOrigin));
            return null;
        }
        try {
            int width2 = Integer.parseInt((String)Assertions.checkNotNull((Object)originPixelMatcher.group(1)));
            int height2 = Integer.parseInt((String)Assertions.checkNotNull((Object)originPixelMatcher.group(2)));
            position = (float)width2 / (float)ttsExtent.width;
            line = (float)height2 / (float)ttsExtent.height;
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Ignoring region with malformed origin: " + regionOrigin));
            return null;
        }
        String regionExtent = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)"extent");
        if (regionExtent == null) {
            Log.w((String)TAG, (String)"Ignoring region without an extent");
            return null;
        }
        Matcher extentPercentageMatcher = PERCENTAGE_COORDINATES.matcher(regionExtent);
        Matcher extentPixelMatcher = PIXEL_COORDINATES.matcher(regionExtent);
        if (extentPercentageMatcher.matches()) {
            try {
                width = Float.parseFloat((String)Assertions.checkNotNull((Object)extentPercentageMatcher.group(1))) / 100.0f;
                height = Float.parseFloat((String)Assertions.checkNotNull((Object)extentPercentageMatcher.group(2))) / 100.0f;
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Ignoring region with malformed extent: " + regionOrigin));
                return null;
            }
        }
        if (!extentPixelMatcher.matches()) {
            Log.w((String)TAG, (String)("Ignoring region with unsupported extent: " + regionOrigin));
            return null;
        }
        if (ttsExtent == null) {
            Log.w((String)TAG, (String)("Ignoring region with missing tts:extent: " + regionOrigin));
            return null;
        }
        try {
            int extentWidth = Integer.parseInt((String)Assertions.checkNotNull((Object)extentPixelMatcher.group(1)));
            int extentHeight = Integer.parseInt((String)Assertions.checkNotNull((Object)extentPixelMatcher.group(2)));
            width = (float)extentWidth / (float)ttsExtent.width;
            height = (float)extentHeight / (float)ttsExtent.height;
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Ignoring region with malformed extent: " + regionOrigin));
            return null;
        }
        int lineAnchor = 0;
        String displayAlign = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)"displayAlign");
        if (displayAlign != null) {
            switch (Ascii.toLowerCase((String)displayAlign)) {
                case "center": {
                    lineAnchor = 1;
                    line += height / 2.0f;
                    break;
                }
                case "after": {
                    lineAnchor = 2;
                    line += height;
                    break;
                }
            }
        }
        float regionTextHeight = 1.0f / (float)cellResolution.rows;
        int verticalType = Integer.MIN_VALUE;
        String writingDirection = XmlPullParserUtil.getAttributeValue((XmlPullParser)xmlParser, (String)"writingMode");
        if (writingDirection == null) return new TtmlRegion(regionId, position, line, 0, lineAnchor, width, height, 1, regionTextHeight, verticalType);
        switch (Ascii.toLowerCase((String)writingDirection)) {
            case "tb": 
            case "tblr": {
                verticalType = 2;
                return new TtmlRegion(regionId, position, line, 0, lineAnchor, width, height, 1, regionTextHeight, verticalType);
            }
            case "tbrl": {
                verticalType = 1;
                return new TtmlRegion(regionId, position, line, 0, lineAnchor, width, height, 1, regionTextHeight, verticalType);
            }
        }
        return new TtmlRegion(regionId, position, line, 0, lineAnchor, width, height, 1, regionTextHeight, verticalType);
    }

    private static String[] parseStyleIds(String parentStyleIds) {
        return (parentStyleIds = parentStyleIds.trim()).isEmpty() ? new String[]{} : Util.split((String)parentStyleIds, (String)"\\s+");
    }

    private static @PolyNull TtmlStyle parseStyleAttributes(XmlPullParser parser, @PolyNull TtmlStyle style) {
        int attributeCount = parser.getAttributeCount();
        block82: for (int i = 0; i < attributeCount; ++i) {
            String attributeValue = parser.getAttributeValue(i);
            switch (parser.getAttributeName(i)) {
                case "id": {
                    if (!ATTR_STYLE.equals(parser.getName())) continue block82;
                    style = TtmlDecoder.createIfNull(style).setId(attributeValue);
                    continue block82;
                }
                case "backgroundColor": {
                    style = TtmlDecoder.createIfNull(style);
                    try {
                        style.setBackgroundColor(ColorParser.parseTtmlColor((String)attributeValue));
                    }
                    catch (IllegalArgumentException e) {
                        Log.w((String)TAG, (String)("Failed parsing background value: " + attributeValue));
                    }
                    continue block82;
                }
                case "color": {
                    style = TtmlDecoder.createIfNull(style);
                    try {
                        style.setFontColor(ColorParser.parseTtmlColor((String)attributeValue));
                    }
                    catch (IllegalArgumentException e) {
                        Log.w((String)TAG, (String)("Failed parsing color value: " + attributeValue));
                    }
                    continue block82;
                }
                case "fontFamily": {
                    style = TtmlDecoder.createIfNull(style).setFontFamily(attributeValue);
                    continue block82;
                }
                case "fontSize": {
                    try {
                        style = TtmlDecoder.createIfNull(style);
                        TtmlDecoder.parseFontSize(attributeValue, style);
                    }
                    catch (SubtitleDecoderException e) {
                        Log.w((String)TAG, (String)("Failed parsing fontSize value: " + attributeValue));
                    }
                    continue block82;
                }
                case "fontWeight": {
                    style = TtmlDecoder.createIfNull(style).setBold("bold".equalsIgnoreCase(attributeValue));
                    continue block82;
                }
                case "fontStyle": {
                    style = TtmlDecoder.createIfNull(style).setItalic("italic".equalsIgnoreCase(attributeValue));
                    continue block82;
                }
                case "textAlign": {
                    style = TtmlDecoder.createIfNull(style).setTextAlign(TtmlDecoder.parseAlignment(attributeValue));
                    continue block82;
                }
                case "multiRowAlign": {
                    style = TtmlDecoder.createIfNull(style).setMultiRowAlign(TtmlDecoder.parseAlignment(attributeValue));
                    continue block82;
                }
                case "textCombine": {
                    switch (Ascii.toLowerCase((String)attributeValue)) {
                        case "none": {
                            style = TtmlDecoder.createIfNull(style).setTextCombine(false);
                            continue block82;
                        }
                        case "all": {
                            style = TtmlDecoder.createIfNull(style).setTextCombine(true);
                            continue block82;
                        }
                    }
                    continue block82;
                }
                case "ruby": {
                    switch (Ascii.toLowerCase((String)attributeValue)) {
                        case "container": {
                            style = TtmlDecoder.createIfNull(style).setRubyType(1);
                            continue block82;
                        }
                        case "base": 
                        case "baseContainer": {
                            style = TtmlDecoder.createIfNull(style).setRubyType(2);
                            continue block82;
                        }
                        case "text": 
                        case "textContainer": {
                            style = TtmlDecoder.createIfNull(style).setRubyType(3);
                            continue block82;
                        }
                        case "delimiter": {
                            style = TtmlDecoder.createIfNull(style).setRubyType(4);
                            continue block82;
                        }
                    }
                    continue block82;
                }
                case "rubyPosition": {
                    switch (Ascii.toLowerCase((String)attributeValue)) {
                        case "before": {
                            style = TtmlDecoder.createIfNull(style).setRubyPosition(1);
                            continue block82;
                        }
                        case "after": {
                            style = TtmlDecoder.createIfNull(style).setRubyPosition(2);
                            continue block82;
                        }
                    }
                    continue block82;
                }
                case "textDecoration": {
                    switch (Ascii.toLowerCase((String)attributeValue)) {
                        case "linethrough": {
                            style = TtmlDecoder.createIfNull(style).setLinethrough(true);
                            break;
                        }
                        case "nolinethrough": {
                            style = TtmlDecoder.createIfNull(style).setLinethrough(false);
                            break;
                        }
                        case "underline": {
                            style = TtmlDecoder.createIfNull(style).setUnderline(true);
                            break;
                        }
                        case "nounderline": {
                            style = TtmlDecoder.createIfNull(style).setUnderline(false);
                        }
                    }
                    continue block82;
                }
                case "textEmphasis": {
                    style = TtmlDecoder.createIfNull(style).setTextEmphasis(TextEmphasis.parse(attributeValue));
                    continue block82;
                }
                case "shear": {
                    style = TtmlDecoder.createIfNull(style).setShearPercentage(TtmlDecoder.parseShear(attributeValue));
                    continue block82;
                }
            }
        }
        return style;
    }

    private static TtmlStyle createIfNull(@Nullable TtmlStyle style) {
        return style == null ? new TtmlStyle() : style;
    }

    @Nullable
    private static Layout.Alignment parseAlignment(String alignment) {
        switch (Ascii.toLowerCase((String)alignment)) {
            case "left": 
            case "start": {
                return Layout.Alignment.ALIGN_NORMAL;
            }
            case "right": 
            case "end": {
                return Layout.Alignment.ALIGN_OPPOSITE;
            }
            case "center": {
                return Layout.Alignment.ALIGN_CENTER;
            }
        }
        return null;
    }

    private static TtmlNode parseNode(XmlPullParser parser, @Nullable TtmlNode parent, Map<String, TtmlRegion> regionMap, FrameAndTickRate frameAndTickRate) throws SubtitleDecoderException {
        long duration = -9223372036854775807L;
        long startTime = -9223372036854775807L;
        long endTime = -9223372036854775807L;
        String regionId = "";
        String imageId = null;
        String[] styleIds = null;
        int attributeCount = parser.getAttributeCount();
        TtmlStyle style = TtmlDecoder.parseStyleAttributes(parser, null);
        block16: for (int i = 0; i < attributeCount; ++i) {
            String attr = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            switch (attr) {
                case "begin": {
                    startTime = TtmlDecoder.parseTimeExpression(value, frameAndTickRate);
                    continue block16;
                }
                case "end": {
                    endTime = TtmlDecoder.parseTimeExpression(value, frameAndTickRate);
                    continue block16;
                }
                case "dur": {
                    duration = TtmlDecoder.parseTimeExpression(value, frameAndTickRate);
                    continue block16;
                }
                case "style": {
                    String[] ids = TtmlDecoder.parseStyleIds(value);
                    if (ids.length <= 0) continue block16;
                    styleIds = ids;
                    continue block16;
                }
                case "region": {
                    if (!regionMap.containsKey(value)) continue block16;
                    regionId = value;
                    continue block16;
                }
                case "backgroundImage": {
                    if (!value.startsWith("#")) continue block16;
                    imageId = value.substring(1);
                    continue block16;
                }
            }
        }
        if (parent != null && parent.startTimeUs != -9223372036854775807L) {
            if (startTime != -9223372036854775807L) {
                startTime += parent.startTimeUs;
            }
            if (endTime != -9223372036854775807L) {
                endTime += parent.startTimeUs;
            }
        }
        if (endTime == -9223372036854775807L) {
            if (duration != -9223372036854775807L) {
                endTime = startTime + duration;
            } else if (parent != null && parent.endTimeUs != -9223372036854775807L) {
                endTime = parent.endTimeUs;
            }
        }
        return TtmlNode.buildNode(parser.getName(), startTime, endTime, style, styleIds, regionId, imageId, parent);
    }

    private static boolean isSupportedTag(String tag) {
        return tag.equals("tt") || tag.equals("head") || tag.equals("body") || tag.equals("div") || tag.equals("p") || tag.equals("span") || tag.equals("br") || tag.equals(ATTR_STYLE) || tag.equals("styling") || tag.equals("layout") || tag.equals(ATTR_REGION) || tag.equals("metadata") || tag.equals("image") || tag.equals("data") || tag.equals("information");
    }

    private static void parseFontSize(String expression, TtmlStyle out) throws SubtitleDecoderException {
        Matcher matcher;
        String[] expressions = Util.split((String)expression, (String)"\\s+");
        if (expressions.length == 1) {
            matcher = FONT_SIZE.matcher(expression);
        } else if (expressions.length == 2) {
            matcher = FONT_SIZE.matcher(expressions[1]);
            Log.w((String)TAG, (String)"Multiple values in fontSize attribute. Picking the second value for vertical font size and ignoring the first.");
        } else {
            throw new SubtitleDecoderException("Invalid number of entries for fontSize: " + expressions.length + ".");
        }
        if (matcher.matches()) {
            String unit;
            switch (unit = (String)Assertions.checkNotNull((Object)matcher.group(3))) {
                case "px": {
                    out.setFontSizeUnit(1);
                    break;
                }
                case "em": {
                    out.setFontSizeUnit(2);
                    break;
                }
                case "%": {
                    out.setFontSizeUnit(3);
                    break;
                }
                default: {
                    throw new SubtitleDecoderException("Invalid unit for fontSize: '" + unit + "'.");
                }
            }
        } else {
            throw new SubtitleDecoderException("Invalid expression for fontSize: '" + expression + "'.");
        }
        out.setFontSize(Float.parseFloat((String)Assertions.checkNotNull((Object)matcher.group(1))));
    }

    private static float parseShear(String expression) {
        Matcher matcher = SIGNED_PERCENTAGE.matcher(expression);
        if (!matcher.matches()) {
            Log.w((String)TAG, (String)("Invalid value for shear: " + expression));
            return Float.MAX_VALUE;
        }
        try {
            String percentage = (String)Assertions.checkNotNull((Object)matcher.group(1));
            float value = Float.parseFloat(percentage);
            value = Math.max(-100.0f, value);
            value = Math.min(100.0f, value);
            return value;
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Failed to parse shear: " + expression), (Throwable)e);
            return Float.MAX_VALUE;
        }
    }

    private static long parseTimeExpression(String time, FrameAndTickRate frameAndTickRate) throws SubtitleDecoderException {
        Matcher matcher = CLOCK_TIME.matcher(time);
        if (matcher.matches()) {
            String hours = (String)Assertions.checkNotNull((Object)matcher.group(1));
            double durationSeconds = Long.parseLong(hours) * 3600L;
            String minutes = (String)Assertions.checkNotNull((Object)matcher.group(2));
            durationSeconds += (double)(Long.parseLong(minutes) * 60L);
            String seconds = (String)Assertions.checkNotNull((Object)matcher.group(3));
            durationSeconds += (double)Long.parseLong(seconds);
            String fraction = matcher.group(4);
            durationSeconds += fraction != null ? Double.parseDouble(fraction) : 0.0;
            String frames = matcher.group(5);
            durationSeconds += frames != null ? (double)((float)Long.parseLong(frames) / frameAndTickRate.effectiveFrameRate) : 0.0;
            String subframes = matcher.group(6);
            return (long)((durationSeconds += subframes != null ? (double)Long.parseLong(subframes) / (double)frameAndTickRate.subFrameRate / (double)frameAndTickRate.effectiveFrameRate : 0.0) * 1000000.0);
        }
        matcher = OFFSET_TIME.matcher(time);
        if (matcher.matches()) {
            String unit;
            String timeValue = (String)Assertions.checkNotNull((Object)matcher.group(1));
            double offsetSeconds = Double.parseDouble(timeValue);
            switch (unit = (String)Assertions.checkNotNull((Object)matcher.group(2))) {
                case "h": {
                    offsetSeconds *= 3600.0;
                    break;
                }
                case "m": {
                    offsetSeconds *= 60.0;
                    break;
                }
                case "s": {
                    break;
                }
                case "ms": {
                    offsetSeconds /= 1000.0;
                    break;
                }
                case "f": {
                    offsetSeconds /= (double)frameAndTickRate.effectiveFrameRate;
                    break;
                }
                case "t": {
                    offsetSeconds /= (double)frameAndTickRate.tickRate;
                }
            }
            return (long)(offsetSeconds * 1000000.0);
        }
        throw new SubtitleDecoderException("Malformed time expression: " + time);
    }

    private static final class TtsExtent {
        final int width;
        final int height;

        TtsExtent(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    private static final class CellResolution {
        final int columns;
        final int rows;

        CellResolution(int columns, int rows) {
            this.columns = columns;
            this.rows = rows;
        }
    }

    private static final class FrameAndTickRate {
        final float effectiveFrameRate;
        final int subFrameRate;
        final int tickRate;

        FrameAndTickRate(float effectiveFrameRate, int subFrameRate, int tickRate) {
            this.effectiveFrameRate = effectiveFrameRate;
            this.subFrameRate = subFrameRate;
            this.tickRate = tickRate;
        }
    }
}

