/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.ttml;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@Deprecated
final class TextEmphasis {
    public static final int MARK_SHAPE_AUTO = -1;
    public static final int POSITION_OUTSIDE = -2;
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final ImmutableSet<String> SINGLE_STYLE_VALUES = ImmutableSet.of((Object)"auto", (Object)"none");
    private static final ImmutableSet<String> MARK_SHAPE_VALUES = ImmutableSet.of((Object)"dot", (Object)"sesame", (Object)"circle");
    private static final ImmutableSet<String> MARK_FILL_VALUES = ImmutableSet.of((Object)"filled", (Object)"open");
    private static final ImmutableSet<String> POSITION_VALUES = ImmutableSet.of((Object)"after", (Object)"before", (Object)"outside");
    public final int markShape;
    public final int markFill;
    public final int position;

    private TextEmphasis(int markShape, int markFill, int position) {
        this.markShape = markShape;
        this.markFill = markFill;
        this.position = position;
    }

    @Nullable
    public static TextEmphasis parse(@Nullable String value) {
        if (value == null) {
            return null;
        }
        String parsingValue = Ascii.toLowerCase((String)value.trim());
        if (parsingValue.isEmpty()) {
            return null;
        }
        return TextEmphasis.parseWords((ImmutableSet<String>)ImmutableSet.copyOf((Object[])TextUtils.split((String)parsingValue, (Pattern)WHITESPACE_PATTERN)));
    }

    private static TextEmphasis parseWords(ImmutableSet<String> nodes) {
        int markShape;
        int markFill;
        int position;
        Sets.SetView matchingPositions = Sets.intersection(POSITION_VALUES, nodes);
        switch ((String)Iterables.getFirst((Iterable)matchingPositions, (Object)"outside")) {
            case "after": {
                position = 2;
                break;
            }
            case "outside": {
                position = -2;
                break;
            }
            default: {
                position = 1;
            }
        }
        Sets.SetView matchingSingleStyles = Sets.intersection(SINGLE_STYLE_VALUES, nodes);
        if (!matchingSingleStyles.isEmpty()) {
            int markShape2;
            switch ((String)matchingSingleStyles.iterator().next()) {
                case "none": {
                    markShape2 = 0;
                    break;
                }
                default: {
                    markShape2 = -1;
                }
            }
            return new TextEmphasis(markShape2, 0, position);
        }
        Sets.SetView matchingFills = Sets.intersection(MARK_FILL_VALUES, nodes);
        Sets.SetView matchingShapes = Sets.intersection(MARK_SHAPE_VALUES, nodes);
        if (matchingFills.isEmpty() && matchingShapes.isEmpty()) {
            return new TextEmphasis(-1, 0, position);
        }
        switch ((String)Iterables.getFirst((Iterable)matchingFills, (Object)"filled")) {
            case "open": {
                markFill = 2;
                break;
            }
            default: {
                markFill = 1;
            }
        }
        switch ((String)Iterables.getFirst((Iterable)matchingShapes, (Object)"circle")) {
            case "dot": {
                markShape = 2;
                break;
            }
            case "sesame": {
                markShape = 3;
                break;
            }
            default: {
                markShape = 1;
            }
        }
        return new TextEmphasis(markShape, markFill, position);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Position {
    }
}

