/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.VorbisUtil;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

@Deprecated
final class VorbisReader
extends StreamReader {
    @Nullable
    private VorbisSetup vorbisSetup;
    private int previousPacketBlockSize;
    private boolean seenFirstAudioPacket;
    @Nullable
    private VorbisUtil.VorbisIdHeader vorbisIdHeader;
    @Nullable
    private VorbisUtil.CommentHeader commentHeader;

    VorbisReader() {
    }

    public static boolean verifyBitstreamType(ParsableByteArray data) {
        try {
            return VorbisUtil.verifyVorbisHeaderCapturePattern(1, data, true);
        }
        catch (ParserException e) {
            return false;
        }
    }

    @Override
    protected void reset(boolean headerData) {
        super.reset(headerData);
        if (headerData) {
            this.vorbisSetup = null;
            this.vorbisIdHeader = null;
            this.commentHeader = null;
        }
        this.previousPacketBlockSize = 0;
        this.seenFirstAudioPacket = false;
    }

    @Override
    protected void onSeekEnd(long currentGranule) {
        super.onSeekEnd(currentGranule);
        this.seenFirstAudioPacket = currentGranule != 0L;
        this.previousPacketBlockSize = this.vorbisIdHeader != null ? this.vorbisIdHeader.blockSize0 : 0;
    }

    @Override
    protected long preparePayload(ParsableByteArray packet) {
        if ((packet.getData()[0] & 1) == 1) {
            return -1L;
        }
        int packetBlockSize = VorbisReader.decodeBlockSize(packet.getData()[0], (VorbisSetup)Assertions.checkStateNotNull((Object)this.vorbisSetup));
        int samplesInPacket = this.seenFirstAudioPacket ? (packetBlockSize + this.previousPacketBlockSize) / 4 : 0;
        VorbisReader.appendNumberOfSamples(packet, samplesInPacket);
        this.seenFirstAudioPacket = true;
        this.previousPacketBlockSize = packetBlockSize;
        return samplesInPacket;
    }

    @Override
    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected boolean readHeaders(ParsableByteArray packet, long position, StreamReader.SetupData setupData) throws IOException {
        if (this.vorbisSetup != null) {
            Assertions.checkNotNull((Object)setupData.format);
            return false;
        }
        this.vorbisSetup = this.readSetupHeaders(packet);
        if (this.vorbisSetup == null) {
            return true;
        }
        VorbisSetup vorbisSetup = this.vorbisSetup;
        VorbisUtil.VorbisIdHeader idHeader = vorbisSetup.idHeader;
        ArrayList<byte[]> codecInitializationData = new ArrayList<byte[]>();
        codecInitializationData.add(idHeader.data);
        codecInitializationData.add(vorbisSetup.setupHeaderData);
        Metadata metadata = VorbisUtil.parseVorbisComments((List<String>)ImmutableList.copyOf((Object[])vorbisSetup.commentHeader.comments));
        setupData.format = new Format.Builder().setSampleMimeType("audio/vorbis").setAverageBitrate(idHeader.bitrateNominal).setPeakBitrate(idHeader.bitrateMaximum).setChannelCount(idHeader.channels).setSampleRate(idHeader.sampleRate).setInitializationData(codecInitializationData).setMetadata(metadata).build();
        return true;
    }

    @VisibleForTesting
    @Nullable
    VorbisSetup readSetupHeaders(ParsableByteArray scratch) throws IOException {
        if (this.vorbisIdHeader == null) {
            this.vorbisIdHeader = VorbisUtil.readVorbisIdentificationHeader(scratch);
            return null;
        }
        if (this.commentHeader == null) {
            this.commentHeader = VorbisUtil.readVorbisCommentHeader(scratch);
            return null;
        }
        VorbisUtil.VorbisIdHeader vorbisIdHeader = this.vorbisIdHeader;
        VorbisUtil.CommentHeader commentHeader = this.commentHeader;
        byte[] setupHeaderData = new byte[scratch.limit()];
        System.arraycopy(scratch.getData(), 0, setupHeaderData, 0, scratch.limit());
        VorbisUtil.Mode[] modes = VorbisUtil.readVorbisModes(scratch, vorbisIdHeader.channels);
        int iLogModes = VorbisUtil.iLog(modes.length - 1);
        return new VorbisSetup(vorbisIdHeader, commentHeader, setupHeaderData, modes, iLogModes);
    }

    @VisibleForTesting
    static int readBits(byte src, int length, int leastSignificantBitIndex) {
        return src >> leastSignificantBitIndex & 255 >>> 8 - length;
    }

    @VisibleForTesting
    static void appendNumberOfSamples(ParsableByteArray buffer, long packetSampleCount) {
        if (buffer.capacity() < buffer.limit() + 4) {
            buffer.reset(Arrays.copyOf(buffer.getData(), buffer.limit() + 4));
        } else {
            buffer.setLimit(buffer.limit() + 4);
        }
        byte[] data = buffer.getData();
        data[buffer.limit() - 4] = (byte)(packetSampleCount & 0xFFL);
        data[buffer.limit() - 3] = (byte)(packetSampleCount >>> 8 & 0xFFL);
        data[buffer.limit() - 2] = (byte)(packetSampleCount >>> 16 & 0xFFL);
        data[buffer.limit() - 1] = (byte)(packetSampleCount >>> 24 & 0xFFL);
    }

    private static int decodeBlockSize(byte firstByteOfAudioPacket, VorbisSetup vorbisSetup) {
        int modeNumber = VorbisReader.readBits(firstByteOfAudioPacket, vorbisSetup.iLogModes, 1);
        int currentBlockSize = !vorbisSetup.modes[modeNumber].blockFlag ? vorbisSetup.idHeader.blockSize0 : vorbisSetup.idHeader.blockSize1;
        return currentBlockSize;
    }

    static final class VorbisSetup {
        public final VorbisUtil.VorbisIdHeader idHeader;
        public final VorbisUtil.CommentHeader commentHeader;
        public final byte[] setupHeaderData;
        public final VorbisUtil.Mode[] modes;
        public final int iLogModes;

        public VorbisSetup(VorbisUtil.VorbisIdHeader idHeader, VorbisUtil.CommentHeader commentHeader, byte[] setupHeaderData, VorbisUtil.Mode[] modes, int iLogModes) {
            this.idHeader = idHeader;
            this.commentHeader = commentHeader;
            this.setupHeaderData = setupHeaderData;
            this.modes = modes;
            this.iLogModes = iLogModes;
        }
    }
}

