/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.flv;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.AacUtil;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.flv.TagPayloadReader;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Collections;

@Deprecated
final class AudioTagPayloadReader
extends TagPayloadReader {
    private static final int AUDIO_FORMAT_MP3 = 2;
    private static final int AUDIO_FORMAT_ALAW = 7;
    private static final int AUDIO_FORMAT_ULAW = 8;
    private static final int AUDIO_FORMAT_AAC = 10;
    private static final int AAC_PACKET_TYPE_SEQUENCE_HEADER = 0;
    private static final int AAC_PACKET_TYPE_AAC_RAW = 1;
    private static final int[] AUDIO_SAMPLING_RATE_TABLE = new int[]{5512, 11025, 22050, 44100};
    private boolean hasParsedAudioDataHeader;
    private boolean hasOutputFormat;
    private int audioFormat;

    public AudioTagPayloadReader(TrackOutput output) {
        super(output);
    }

    @Override
    public void seek() {
    }

    @Override
    protected boolean parseHeader(ParsableByteArray data) throws TagPayloadReader.UnsupportedFormatException {
        if (!this.hasParsedAudioDataHeader) {
            int header = data.readUnsignedByte();
            this.audioFormat = header >> 4 & 0xF;
            if (this.audioFormat == 2) {
                int sampleRateIndex = header >> 2 & 3;
                int sampleRate = AUDIO_SAMPLING_RATE_TABLE[sampleRateIndex];
                Format format = new Format.Builder().setSampleMimeType("audio/mpeg").setChannelCount(1).setSampleRate(sampleRate).build();
                this.output.format(format);
                this.hasOutputFormat = true;
            } else if (this.audioFormat == 7 || this.audioFormat == 8) {
                String mimeType = this.audioFormat == 7 ? "audio/g711-alaw" : "audio/g711-mlaw";
                Format format = new Format.Builder().setSampleMimeType(mimeType).setChannelCount(1).setSampleRate(8000).build();
                this.output.format(format);
                this.hasOutputFormat = true;
            } else if (this.audioFormat != 10) {
                throw new TagPayloadReader.UnsupportedFormatException("Audio format not supported: " + this.audioFormat);
            }
            this.hasParsedAudioDataHeader = true;
        } else {
            data.skipBytes(1);
        }
        return true;
    }

    @Override
    protected boolean parsePayload(ParsableByteArray data, long timeUs) throws ParserException {
        if (this.audioFormat == 2) {
            int sampleSize = data.bytesLeft();
            this.output.sampleData(data, sampleSize);
            this.output.sampleMetadata(timeUs, 1, sampleSize, 0, null);
            return true;
        }
        int packetType = data.readUnsignedByte();
        if (packetType == 0 && !this.hasOutputFormat) {
            byte[] audioSpecificConfig = new byte[data.bytesLeft()];
            data.readBytes(audioSpecificConfig, 0, audioSpecificConfig.length);
            AacUtil.Config aacConfig = AacUtil.parseAudioSpecificConfig(audioSpecificConfig);
            Format format = new Format.Builder().setSampleMimeType("audio/mp4a-latm").setCodecs(aacConfig.codecs).setChannelCount(aacConfig.channelCount).setSampleRate(aacConfig.sampleRateHz).setInitializationData(Collections.singletonList(audioSpecificConfig)).build();
            this.output.format(format);
            this.hasOutputFormat = true;
            return false;
        }
        if (this.audioFormat != 10 || packetType == 1) {
            int sampleSize = data.bytesLeft();
            this.output.sampleData(data, sampleSize);
            this.output.sampleMetadata(timeUs, 1, sampleSize, 0, null);
            return true;
        }
        return false;
    }
}

