/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.webvtt.WebvttCssStyle;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ColorParser;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class WebvttCssParser {
    private static final String TAG = "WebvttCssParser";
    private static final String RULE_START = "{";
    private static final String RULE_END = "}";
    private static final String PROPERTY_COLOR = "color";
    private static final String PROPERTY_BGCOLOR = "background-color";
    private static final String PROPERTY_FONT_FAMILY = "font-family";
    private static final String PROPERTY_FONT_WEIGHT = "font-weight";
    private static final String PROPERTY_FONT_SIZE = "font-size";
    private static final String PROPERTY_RUBY_POSITION = "ruby-position";
    private static final String VALUE_OVER = "over";
    private static final String VALUE_UNDER = "under";
    private static final String PROPERTY_TEXT_COMBINE_UPRIGHT = "text-combine-upright";
    private static final String VALUE_ALL = "all";
    private static final String VALUE_DIGITS = "digits";
    private static final String PROPERTY_TEXT_DECORATION = "text-decoration";
    private static final String VALUE_BOLD = "bold";
    private static final String VALUE_UNDERLINE = "underline";
    private static final String PROPERTY_FONT_STYLE = "font-style";
    private static final String VALUE_ITALIC = "italic";
    private static final Pattern VOICE_NAME_PATTERN = Pattern.compile("\\[voice=\"([^\"]*)\"\\]");
    private static final Pattern FONT_SIZE_PATTERN = Pattern.compile("^((?:[0-9]*\\.)?[0-9]+)(px|em|%)$");
    private final ParsableByteArray styleInput = new ParsableByteArray();
    private final StringBuilder stringBuilder = new StringBuilder();

    public List<WebvttCssStyle> parseBlock(ParsableByteArray input) {
        String selector;
        this.stringBuilder.setLength(0);
        int initialInputPosition = input.getPosition();
        WebvttCssParser.skipStyleBlock(input);
        this.styleInput.reset(input.getData(), input.getPosition());
        this.styleInput.setPosition(initialInputPosition);
        ArrayList<WebvttCssStyle> styles = new ArrayList<WebvttCssStyle>();
        while ((selector = WebvttCssParser.parseSelector(this.styleInput, this.stringBuilder)) != null) {
            if (!RULE_START.equals(WebvttCssParser.parseNextToken(this.styleInput, this.stringBuilder))) {
                return styles;
            }
            WebvttCssStyle style = new WebvttCssStyle();
            this.applySelectorToStyle(style, selector);
            String token = null;
            boolean blockEndFound = false;
            while (!blockEndFound) {
                int position = this.styleInput.getPosition();
                token = WebvttCssParser.parseNextToken(this.styleInput, this.stringBuilder);
                blockEndFound = token == null || RULE_END.equals(token);
                if (blockEndFound) continue;
                this.styleInput.setPosition(position);
                WebvttCssParser.parseStyleDeclaration(this.styleInput, style, this.stringBuilder);
            }
            if (!RULE_END.equals(token)) continue;
            styles.add(style);
        }
        return styles;
    }

    @Nullable
    private static String parseSelector(ParsableByteArray input, StringBuilder stringBuilder) {
        WebvttCssParser.skipWhitespaceAndComments(input);
        if (input.bytesLeft() < 5) {
            return null;
        }
        String cueSelector = input.readString(5);
        if (!"::cue".equals(cueSelector)) {
            return null;
        }
        int position = input.getPosition();
        String token = WebvttCssParser.parseNextToken(input, stringBuilder);
        if (token == null) {
            return null;
        }
        if (RULE_START.equals(token)) {
            input.setPosition(position);
            return "";
        }
        String target = null;
        if ("(".equals(token)) {
            target = WebvttCssParser.readCueTarget(input);
        }
        if (!")".equals(token = WebvttCssParser.parseNextToken(input, stringBuilder))) {
            return null;
        }
        return target;
    }

    private static String readCueTarget(ParsableByteArray input) {
        int position = input.getPosition();
        int limit = input.limit();
        boolean cueTargetEndFound = false;
        while (position < limit && !cueTargetEndFound) {
            char c = (char)input.getData()[position++];
            cueTargetEndFound = c == ')';
        }
        return input.readString(--position - input.getPosition()).trim();
    }

    private static void parseStyleDeclaration(ParsableByteArray input, WebvttCssStyle style, StringBuilder stringBuilder) {
        WebvttCssParser.skipWhitespaceAndComments(input);
        String property = WebvttCssParser.parseIdentifier(input, stringBuilder);
        if ("".equals(property)) {
            return;
        }
        if (!":".equals(WebvttCssParser.parseNextToken(input, stringBuilder))) {
            return;
        }
        WebvttCssParser.skipWhitespaceAndComments(input);
        String value = WebvttCssParser.parsePropertyValue(input, stringBuilder);
        if (value == null || "".equals(value)) {
            return;
        }
        int position = input.getPosition();
        String token = WebvttCssParser.parseNextToken(input, stringBuilder);
        if (!";".equals(token)) {
            if (RULE_END.equals(token)) {
                input.setPosition(position);
            } else {
                return;
            }
        }
        if (PROPERTY_COLOR.equals(property)) {
            style.setFontColor(ColorParser.parseCssColor((String)value));
        } else if (PROPERTY_BGCOLOR.equals(property)) {
            style.setBackgroundColor(ColorParser.parseCssColor((String)value));
        } else if (PROPERTY_RUBY_POSITION.equals(property)) {
            if (VALUE_OVER.equals(value)) {
                style.setRubyPosition(1);
            } else if (VALUE_UNDER.equals(value)) {
                style.setRubyPosition(2);
            }
        } else if (PROPERTY_TEXT_COMBINE_UPRIGHT.equals(property)) {
            style.setCombineUpright(VALUE_ALL.equals(value) || value.startsWith(VALUE_DIGITS));
        } else if (PROPERTY_TEXT_DECORATION.equals(property)) {
            if (VALUE_UNDERLINE.equals(value)) {
                style.setUnderline(true);
            }
        } else if (PROPERTY_FONT_FAMILY.equals(property)) {
            style.setFontFamily(value);
        } else if (PROPERTY_FONT_WEIGHT.equals(property)) {
            if (VALUE_BOLD.equals(value)) {
                style.setBold(true);
            }
        } else if (PROPERTY_FONT_STYLE.equals(property)) {
            if (VALUE_ITALIC.equals(value)) {
                style.setItalic(true);
            }
        } else if (PROPERTY_FONT_SIZE.equals(property)) {
            WebvttCssParser.parseFontSize(value, style);
        }
    }

    static void skipWhitespaceAndComments(ParsableByteArray input) {
        boolean skipping = true;
        while (input.bytesLeft() > 0 && skipping) {
            skipping = WebvttCssParser.maybeSkipWhitespace(input) || WebvttCssParser.maybeSkipComment(input);
        }
    }

    @Nullable
    static String parseNextToken(ParsableByteArray input, StringBuilder stringBuilder) {
        WebvttCssParser.skipWhitespaceAndComments(input);
        if (input.bytesLeft() == 0) {
            return null;
        }
        String identifier = WebvttCssParser.parseIdentifier(input, stringBuilder);
        if (!"".equals(identifier)) {
            return identifier;
        }
        return "" + (char)input.readUnsignedByte();
    }

    private static boolean maybeSkipWhitespace(ParsableByteArray input) {
        switch (WebvttCssParser.peekCharAtPosition(input, input.getPosition())) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                input.skipBytes(1);
                return true;
            }
        }
        return false;
    }

    static void skipStyleBlock(ParsableByteArray input) {
        String line;
        while (!TextUtils.isEmpty((CharSequence)(line = input.readLine()))) {
        }
    }

    private static char peekCharAtPosition(ParsableByteArray input, int position) {
        return (char)input.getData()[position];
    }

    @Nullable
    private static String parsePropertyValue(ParsableByteArray input, StringBuilder stringBuilder) {
        StringBuilder expressionBuilder = new StringBuilder();
        boolean expressionEndFound = false;
        while (!expressionEndFound) {
            int position = input.getPosition();
            String token = WebvttCssParser.parseNextToken(input, stringBuilder);
            if (token == null) {
                return null;
            }
            if (RULE_END.equals(token) || ";".equals(token)) {
                input.setPosition(position);
                expressionEndFound = true;
                continue;
            }
            expressionBuilder.append(token);
        }
        return expressionBuilder.toString();
    }

    private static boolean maybeSkipComment(ParsableByteArray input) {
        int position = input.getPosition();
        int limit = input.limit();
        byte[] data = input.getData();
        if (position + 2 <= limit && data[position++] == 47 && data[position++] == 42) {
            while (position + 1 < limit) {
                char skippedChar;
                if ((skippedChar = (char)data[position++]) != '*' || (char)data[position] != '/') continue;
                limit = ++position;
            }
            input.skipBytes(limit - input.getPosition());
            return true;
        }
        return false;
    }

    private static String parseIdentifier(ParsableByteArray input, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        int position = input.getPosition();
        int limit = input.limit();
        boolean identifierEndFound = false;
        while (position < limit && !identifierEndFound) {
            char c = (char)input.getData()[position];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '#' || c == '-' || c == '.' || c == '_') {
                ++position;
                stringBuilder.append(c);
                continue;
            }
            identifierEndFound = true;
        }
        input.skipBytes(position - input.getPosition());
        return stringBuilder.toString();
    }

    private static void parseFontSize(String fontSize, WebvttCssStyle style) {
        String unit;
        Matcher matcher = FONT_SIZE_PATTERN.matcher(Ascii.toLowerCase((String)fontSize));
        if (!matcher.matches()) {
            Log.w((String)TAG, (String)("Invalid font-size: '" + fontSize + "'."));
            return;
        }
        switch (unit = (String)Assertions.checkNotNull((Object)matcher.group(2))) {
            case "px": {
                style.setFontSizeUnit(1);
                break;
            }
            case "em": {
                style.setFontSizeUnit(2);
                break;
            }
            case "%": {
                style.setFontSizeUnit(3);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        style.setFontSize(Float.parseFloat((String)Assertions.checkNotNull((Object)matcher.group(1))));
    }

    private void applySelectorToStyle(WebvttCssStyle style, String selector) {
        Object[] classDivision;
        String tagAndIdDivision;
        int idPrefixIndex;
        if ("".equals(selector)) {
            return;
        }
        int voiceStartIndex = selector.indexOf(91);
        if (voiceStartIndex != -1) {
            Matcher matcher = VOICE_NAME_PATTERN.matcher(selector.substring(voiceStartIndex));
            if (matcher.matches()) {
                style.setTargetVoice((String)Assertions.checkNotNull((Object)matcher.group(1)));
            }
            selector = selector.substring(0, voiceStartIndex);
        }
        if ((idPrefixIndex = (tagAndIdDivision = (classDivision = Util.split((String)selector, (String)"\\."))[0]).indexOf(35)) != -1) {
            style.setTargetTagName(tagAndIdDivision.substring(0, idPrefixIndex));
            style.setTargetId(tagAndIdDivision.substring(idPrefixIndex + 1));
        } else {
            style.setTargetTagName(tagAndIdDivision);
        }
        if (classDivision.length > 1) {
            style.setTargetClasses((String[])Util.nullSafeArrayCopyOfRange((Object[])classDivision, (int)1, (int)classDivision.length));
        }
    }
}

