/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.SimpleSubtitleDecoder;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.webvtt.Mp4WebvttSubtitle;
import com.google.android.exoplayer2.text.webvtt.WebvttCueParser;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;

public final class Mp4WebvttDecoder
extends SimpleSubtitleDecoder {
    private static final int BOX_HEADER_SIZE = 8;
    private static final int TYPE_payl = 1885436268;
    private static final int TYPE_sttg = 1937011815;
    private static final int TYPE_vttc = 1987343459;
    private final ParsableByteArray sampleData = new ParsableByteArray();

    public Mp4WebvttDecoder() {
        super("Mp4WebvttDecoder");
    }

    @Override
    protected Subtitle decode(byte[] data, int length, boolean reset) throws SubtitleDecoderException {
        this.sampleData.reset(data, length);
        ArrayList<Cue> resultingCueList = new ArrayList<Cue>();
        while (this.sampleData.bytesLeft() > 0) {
            if (this.sampleData.bytesLeft() < 8) {
                throw new SubtitleDecoderException("Incomplete Mp4Webvtt Top Level box header found.");
            }
            int boxSize = this.sampleData.readInt();
            int boxType = this.sampleData.readInt();
            if (boxType == 1987343459) {
                resultingCueList.add(Mp4WebvttDecoder.parseVttCueBox(this.sampleData, boxSize - 8));
                continue;
            }
            this.sampleData.skipBytes(boxSize - 8);
        }
        return new Mp4WebvttSubtitle(resultingCueList);
    }

    private static Cue parseVttCueBox(ParsableByteArray sampleData, int remainingCueBoxBytes) throws SubtitleDecoderException {
        Cue.Builder cueBuilder = null;
        String cueText = null;
        while (remainingCueBoxBytes > 0) {
            if (remainingCueBoxBytes < 8) {
                throw new SubtitleDecoderException("Incomplete vtt cue box header found.");
            }
            int boxSize = sampleData.readInt();
            int boxType = sampleData.readInt();
            remainingCueBoxBytes -= 8;
            int payloadLength = boxSize - 8;
            String boxPayload = Util.fromUtf8Bytes((byte[])sampleData.getData(), (int)sampleData.getPosition(), (int)payloadLength);
            sampleData.skipBytes(payloadLength);
            remainingCueBoxBytes -= payloadLength;
            if (boxType == 1937011815) {
                cueBuilder = WebvttCueParser.parseCueSettingsList(boxPayload);
                continue;
            }
            if (boxType != 1885436268) continue;
            cueText = WebvttCueParser.parseCueText(null, boxPayload.trim(), Collections.emptyList());
        }
        if (cueText == null) {
            cueText = "";
        }
        return cueBuilder != null ? cueBuilder.setText((CharSequence)cueText).build() : WebvttCueParser.newCueForText(cueText);
    }
}

