/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.ttml;

import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.ttml.TtmlNode;
import com.google.android.exoplayer2.text.ttml.TtmlRegion;
import com.google.android.exoplayer2.text.ttml.TtmlStyle;
import com.google.android.exoplayer2.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class TtmlSubtitle
implements Subtitle {
    private final TtmlNode root;
    private final long[] eventTimesUs;
    private final Map<String, TtmlStyle> globalStyles;
    private final Map<String, TtmlRegion> regionMap;
    private final Map<String, String> imageMap;

    public TtmlSubtitle(TtmlNode root, Map<String, TtmlStyle> globalStyles, Map<String, TtmlRegion> regionMap, Map<String, String> imageMap) {
        this.root = root;
        this.regionMap = regionMap;
        this.imageMap = imageMap;
        this.globalStyles = globalStyles != null ? Collections.unmodifiableMap(globalStyles) : Collections.emptyMap();
        this.eventTimesUs = root.getEventTimesUs();
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil((long[])this.eventTimesUs, (long)timeUs, (boolean)false, (boolean)false);
        return index < this.eventTimesUs.length ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.eventTimesUs.length;
    }

    @Override
    public long getEventTime(int index) {
        return this.eventTimesUs[index];
    }

    @VisibleForTesting
    TtmlNode getRoot() {
        return this.root;
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return this.root.getCues(timeUs, this.globalStyles, this.regionMap, this.imageMap);
    }

    @VisibleForTesting
    Map<String, TtmlStyle> getGlobalStyles() {
        return this.globalStyles;
    }
}

