/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.flac;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.FlacFrameReader;
import com.google.android.exoplayer2.extractor.FlacMetadataReader;
import com.google.android.exoplayer2.extractor.FlacSeekTableSeekMap;
import com.google.android.exoplayer2.extractor.FlacStreamMetadata;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.flac.FlacBinarySearchSeeker;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class FlacExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new FlacExtractor()};
    public static final int FLAG_DISABLE_ID3_METADATA = 1;
    private static final int STATE_READ_ID3_METADATA = 0;
    private static final int STATE_GET_STREAM_MARKER_AND_INFO_BLOCK_BYTES = 1;
    private static final int STATE_READ_STREAM_MARKER = 2;
    private static final int STATE_READ_METADATA_BLOCKS = 3;
    private static final int STATE_GET_FRAME_START_MARKER = 4;
    private static final int STATE_READ_FRAMES = 5;
    private static final int BUFFER_LENGTH = 32768;
    private static final int SAMPLE_NUMBER_UNKNOWN = -1;
    private final byte[] streamMarkerAndInfoBlock = new byte[42];
    private final ParsableByteArray buffer = new ParsableByteArray(new byte[32768], 0);
    private final boolean id3MetadataDisabled;
    private final FlacFrameReader.SampleNumberHolder sampleNumberHolder;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int state;
    @Nullable
    private Metadata id3Metadata;
    private @MonotonicNonNull FlacStreamMetadata flacStreamMetadata;
    private int minFrameSize;
    private int frameStartMarker;
    private @MonotonicNonNull FlacBinarySearchSeeker binarySearchSeeker;
    private int currentFrameBytesWritten;
    private long currentFrameFirstSampleNumber;

    public FlacExtractor() {
        this(0);
    }

    public FlacExtractor(int flags) {
        this.id3MetadataDisabled = (flags & 1) != 0;
        this.sampleNumberHolder = new FlacFrameReader.SampleNumberHolder();
        this.state = 0;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        FlacMetadataReader.peekId3Metadata(input, false);
        return FlacMetadataReader.checkAndPeekStreamMarker(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.trackOutput = output.track(0, 1);
        output.endTracks();
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        switch (this.state) {
            case 0: {
                this.readId3Metadata(input);
                return 0;
            }
            case 1: {
                this.getStreamMarkerAndInfoBlockBytes(input);
                return 0;
            }
            case 2: {
                this.readStreamMarker(input);
                return 0;
            }
            case 3: {
                this.readMetadataBlocks(input);
                return 0;
            }
            case 4: {
                this.getFrameStartMarker(input);
                return 0;
            }
            case 5: {
                return this.readFrames(input, seekPosition);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void seek(long position, long timeUs) {
        if (position == 0L) {
            this.state = 0;
        } else if (this.binarySearchSeeker != null) {
            this.binarySearchSeeker.setSeekTargetUs(timeUs);
        }
        this.currentFrameFirstSampleNumber = timeUs == 0L ? 0L : -1L;
        this.currentFrameBytesWritten = 0;
        this.buffer.reset(0);
    }

    @Override
    public void release() {
    }

    private void readId3Metadata(ExtractorInput input) throws IOException {
        this.id3Metadata = FlacMetadataReader.readId3Metadata(input, !this.id3MetadataDisabled);
        this.state = 1;
    }

    private void getStreamMarkerAndInfoBlockBytes(ExtractorInput input) throws IOException {
        input.peekFully(this.streamMarkerAndInfoBlock, 0, this.streamMarkerAndInfoBlock.length);
        input.resetPeekPosition();
        this.state = 2;
    }

    private void readStreamMarker(ExtractorInput input) throws IOException {
        FlacMetadataReader.readStreamMarker(input);
        this.state = 3;
    }

    private void readMetadataBlocks(ExtractorInput input) throws IOException {
        boolean isLastMetadataBlock = false;
        FlacMetadataReader.FlacStreamMetadataHolder metadataHolder = new FlacMetadataReader.FlacStreamMetadataHolder(this.flacStreamMetadata);
        while (!isLastMetadataBlock) {
            isLastMetadataBlock = FlacMetadataReader.readMetadataBlock(input, metadataHolder);
            this.flacStreamMetadata = (FlacStreamMetadata)Util.castNonNull((Object)metadataHolder.flacStreamMetadata);
        }
        Assertions.checkNotNull((Object)this.flacStreamMetadata);
        this.minFrameSize = Math.max(this.flacStreamMetadata.minFrameSize, 6);
        ((TrackOutput)Util.castNonNull((Object)this.trackOutput)).format(this.flacStreamMetadata.getFormat(this.streamMarkerAndInfoBlock, this.id3Metadata));
        this.state = 4;
    }

    private void getFrameStartMarker(ExtractorInput input) throws IOException {
        this.frameStartMarker = FlacMetadataReader.getFrameStartMarker(input);
        ((ExtractorOutput)Util.castNonNull((Object)this.extractorOutput)).seekMap(this.getSeekMap(input.getPosition(), input.getLength()));
        this.state = 5;
    }

    private int readFrames(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        Assertions.checkNotNull((Object)this.trackOutput);
        Assertions.checkNotNull((Object)this.flacStreamMetadata);
        if (this.binarySearchSeeker != null && this.binarySearchSeeker.isSeeking()) {
            return this.binarySearchSeeker.handlePendingSeek(input, seekPosition);
        }
        if (this.currentFrameFirstSampleNumber == -1L) {
            this.currentFrameFirstSampleNumber = FlacFrameReader.getFirstSampleNumber(input, this.flacStreamMetadata);
            return 0;
        }
        int currentLimit = this.buffer.limit();
        boolean foundEndOfInput = false;
        if (currentLimit < 32768) {
            int bytesRead = input.read(this.buffer.getData(), currentLimit, 32768 - currentLimit);
            boolean bl = foundEndOfInput = bytesRead == -1;
            if (!foundEndOfInput) {
                this.buffer.setLimit(currentLimit + bytesRead);
            } else if (this.buffer.bytesLeft() == 0) {
                this.outputSampleMetadata();
                return -1;
            }
        }
        int positionBeforeFindingAFrame = this.buffer.getPosition();
        if (this.currentFrameBytesWritten < this.minFrameSize) {
            this.buffer.skipBytes(Math.min(this.minFrameSize - this.currentFrameBytesWritten, this.buffer.bytesLeft()));
        }
        long nextFrameFirstSampleNumber = this.findFrame(this.buffer, foundEndOfInput);
        int numberOfFrameBytes = this.buffer.getPosition() - positionBeforeFindingAFrame;
        this.buffer.setPosition(positionBeforeFindingAFrame);
        this.trackOutput.sampleData(this.buffer, numberOfFrameBytes);
        this.currentFrameBytesWritten += numberOfFrameBytes;
        if (nextFrameFirstSampleNumber != -1L) {
            this.outputSampleMetadata();
            this.currentFrameBytesWritten = 0;
            this.currentFrameFirstSampleNumber = nextFrameFirstSampleNumber;
        }
        if (this.buffer.bytesLeft() < 16) {
            int bytesLeft = this.buffer.bytesLeft();
            System.arraycopy(this.buffer.getData(), this.buffer.getPosition(), this.buffer.getData(), 0, bytesLeft);
            this.buffer.setPosition(0);
            this.buffer.setLimit(bytesLeft);
        }
        return 0;
    }

    private SeekMap getSeekMap(long firstFramePosition, long streamLength) {
        Assertions.checkNotNull((Object)this.flacStreamMetadata);
        if (this.flacStreamMetadata.seekTable != null) {
            return new FlacSeekTableSeekMap(this.flacStreamMetadata, firstFramePosition);
        }
        if (streamLength != -1L && this.flacStreamMetadata.totalSamples > 0L) {
            this.binarySearchSeeker = new FlacBinarySearchSeeker(this.flacStreamMetadata, this.frameStartMarker, firstFramePosition, streamLength);
            return this.binarySearchSeeker.getSeekMap();
        }
        return new SeekMap.Unseekable(this.flacStreamMetadata.getDurationUs());
    }

    private long findFrame(ParsableByteArray data, boolean foundEndOfInput) {
        int frameOffset;
        Assertions.checkNotNull((Object)this.flacStreamMetadata);
        for (frameOffset = data.getPosition(); frameOffset <= data.limit() - 16; ++frameOffset) {
            data.setPosition(frameOffset);
            if (!FlacFrameReader.checkAndReadFrameHeader(data, this.flacStreamMetadata, this.frameStartMarker, this.sampleNumberHolder)) continue;
            data.setPosition(frameOffset);
            return this.sampleNumberHolder.sampleNumber;
        }
        if (foundEndOfInput) {
            while (frameOffset <= data.limit() - this.minFrameSize) {
                boolean frameFound;
                data.setPosition(frameOffset);
                try {
                    frameFound = FlacFrameReader.checkAndReadFrameHeader(data, this.flacStreamMetadata, this.frameStartMarker, this.sampleNumberHolder);
                }
                catch (IndexOutOfBoundsException e) {
                    frameFound = false;
                }
                if (data.getPosition() > data.limit()) {
                    frameFound = false;
                }
                if (frameFound) {
                    data.setPosition(frameOffset);
                    return this.sampleNumberHolder.sampleNumber;
                }
                ++frameOffset;
            }
            data.setPosition(data.limit());
        } else {
            data.setPosition(frameOffset);
        }
        return -1L;
    }

    private void outputSampleMetadata() {
        long timeUs = this.currentFrameFirstSampleNumber * 1000000L / (long)((FlacStreamMetadata)Util.castNonNull((Object)this.flacStreamMetadata)).sampleRate;
        ((TrackOutput)Util.castNonNull((Object)this.trackOutput)).sampleMetadata(timeUs, 1, this.currentFrameBytesWritten, 0, null);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

