/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;

public final class TrueHdSampleRechunker {
    private final byte[] syncframePrefix = new byte[10];
    private boolean foundSyncframe;
    private int chunkSampleCount;
    private long chunkTimeUs;
    private int chunkFlags;
    private int chunkSize;
    private int chunkOffset;

    public void reset() {
        this.foundSyncframe = false;
        this.chunkSampleCount = 0;
    }

    public void startSample(ExtractorInput input) throws IOException {
        if (this.foundSyncframe) {
            return;
        }
        input.peekFully(this.syncframePrefix, 0, 10);
        input.resetPeekPosition();
        if (Ac3Util.parseTrueHdSyncframeAudioSampleCount(this.syncframePrefix) == 0) {
            return;
        }
        this.foundSyncframe = true;
    }

    public void sampleMetadata(TrackOutput trackOutput, long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData cryptoData) {
        Assertions.checkState((this.chunkOffset <= size + offset ? 1 : 0) != 0, (Object)"TrueHD chunk samples must be contiguous in the sample queue.");
        if (!this.foundSyncframe) {
            return;
        }
        if (this.chunkSampleCount++ == 0) {
            this.chunkTimeUs = timeUs;
            this.chunkFlags = flags;
            this.chunkSize = 0;
        }
        this.chunkSize += size;
        this.chunkOffset = offset;
        if (this.chunkSampleCount >= 16) {
            this.outputPendingSampleMetadata(trackOutput, cryptoData);
        }
    }

    public void outputPendingSampleMetadata(TrackOutput trackOutput, @Nullable TrackOutput.CryptoData cryptoData) {
        if (this.chunkSampleCount > 0) {
            trackOutput.sampleMetadata(this.chunkTimeUs, this.chunkFlags, this.chunkSize, this.chunkOffset, cryptoData);
            this.chunkSampleCount = 0;
        }
    }
}

