/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.id3;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class TextInformationFrame
extends Id3Frame {
    @Nullable
    public final String description;
    public final String value;
    public static final Parcelable.Creator<TextInformationFrame> CREATOR = new Parcelable.Creator<TextInformationFrame>(){

        public TextInformationFrame createFromParcel(Parcel in) {
            return new TextInformationFrame(in);
        }

        public TextInformationFrame[] newArray(int size) {
            return new TextInformationFrame[size];
        }
    };

    public TextInformationFrame(String id, @Nullable String description, String value) {
        super(id);
        this.description = description;
        this.value = value;
    }

    TextInformationFrame(Parcel in) {
        super((String)Util.castNonNull((Object)in.readString()));
        this.description = in.readString();
        this.value = (String)Util.castNonNull((Object)in.readString());
    }

    public void populateMediaMetadata(MediaMetadata.Builder builder) {
        block27 : switch (this.id) {
            case "TT2": 
            case "TIT2": {
                builder.setTitle((CharSequence)this.value);
                break;
            }
            case "TP1": 
            case "TPE1": {
                builder.setArtist((CharSequence)this.value);
                break;
            }
            case "TP2": 
            case "TPE2": {
                builder.setAlbumArtist((CharSequence)this.value);
                break;
            }
            case "TAL": 
            case "TALB": {
                builder.setAlbumTitle((CharSequence)this.value);
                break;
            }
            case "TRK": 
            case "TRCK": {
                String[] trackNumbers = Util.split((String)this.value, (String)"/");
                try {
                    int trackNumber = Integer.parseInt(trackNumbers[0]);
                    Integer totalTrackCount = trackNumbers.length > 1 ? Integer.valueOf(Integer.parseInt(trackNumbers[1])) : null;
                    builder.setTrackNumber(Integer.valueOf(trackNumber)).setTotalTrackCount(totalTrackCount);
                }
                catch (NumberFormatException trackNumber) {}
                break;
            }
            case "TYE": 
            case "TYER": {
                try {
                    builder.setRecordingYear(Integer.valueOf(Integer.parseInt(this.value)));
                }
                catch (NumberFormatException trackNumber) {}
                break;
            }
            case "TDA": 
            case "TDAT": {
                try {
                    int month = Integer.parseInt(this.value.substring(2, 4));
                    int day = Integer.parseInt(this.value.substring(0, 2));
                    builder.setRecordingMonth(Integer.valueOf(month)).setRecordingDay(Integer.valueOf(day));
                }
                catch (NumberFormatException | StringIndexOutOfBoundsException month) {}
                break;
            }
            case "TDRC": {
                List<Integer> recordingDate = TextInformationFrame.parseId3v2point4TimestampFrameForDate(this.value);
                switch (recordingDate.size()) {
                    case 3: {
                        builder.setRecordingDay(recordingDate.get(2));
                    }
                    case 2: {
                        builder.setRecordingMonth(recordingDate.get(1));
                    }
                    case 1: {
                        builder.setRecordingYear(recordingDate.get(0));
                        break block27;
                    }
                }
                break;
            }
            case "TDRL": {
                List<Integer> releaseDate = TextInformationFrame.parseId3v2point4TimestampFrameForDate(this.value);
                switch (releaseDate.size()) {
                    case 3: {
                        builder.setReleaseDay(releaseDate.get(2));
                    }
                    case 2: {
                        builder.setReleaseMonth(releaseDate.get(1));
                    }
                    case 1: {
                        builder.setReleaseYear(releaseDate.get(0));
                        break block27;
                    }
                }
                break;
            }
            case "TCM": 
            case "TCOM": {
                builder.setComposer((CharSequence)this.value);
                break;
            }
            case "TP3": 
            case "TPE3": {
                builder.setConductor((CharSequence)this.value);
                break;
            }
            case "TXT": 
            case "TEXT": {
                builder.setWriter((CharSequence)this.value);
                break;
            }
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextInformationFrame other = (TextInformationFrame)obj;
        return Util.areEqual((Object)this.id, (Object)other.id) && Util.areEqual((Object)this.description, (Object)other.description) && Util.areEqual((Object)this.value, (Object)other.value);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        String string = this.id;
        String string2 = this.description;
        String string3 = this.value;
        return new StringBuilder(22 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(": description=").append(string2).append(": value=").append(string3).toString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.description);
        dest.writeString(this.value);
    }

    private static List<Integer> parseId3v2point4TimestampFrameForDate(String value) {
        ArrayList<Integer> dates = new ArrayList<Integer>();
        try {
            if (value.length() >= 10) {
                dates.add(Integer.parseInt(value.substring(0, 4)));
                dates.add(Integer.parseInt(value.substring(5, 7)));
                dates.add(Integer.parseInt(value.substring(8, 10)));
            } else if (value.length() >= 7) {
                dates.add(Integer.parseInt(value.substring(0, 4)));
                dates.add(Integer.parseInt(value.substring(5, 7)));
            } else if (value.length() >= 4) {
                dates.add(Integer.parseInt(value.substring(0, 4)));
            }
        }
        catch (NumberFormatException e) {
            return new ArrayList<Integer>();
        }
        return dates;
    }
}

