/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;

public interface TrackOutput {
    public static final int SAMPLE_DATA_PART_MAIN = 0;
    public static final int SAMPLE_DATA_PART_ENCRYPTION = 1;
    public static final int SAMPLE_DATA_PART_SUPPLEMENTAL = 2;

    public void format(Format var1);

    default public int sampleData(DataReader input, int length, boolean allowEndOfInput) throws IOException {
        return this.sampleData(input, length, allowEndOfInput, 0);
    }

    default public void sampleData(ParsableByteArray data, int length) {
        this.sampleData(data, length, 0);
    }

    public int sampleData(DataReader var1, int var2, boolean var3, int var4) throws IOException;

    public void sampleData(ParsableByteArray var1, int var2, int var3);

    public void sampleMetadata(long var1, int var3, int var4, int var5, @Nullable CryptoData var6);

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface SampleDataPart {
    }

    public static final class CryptoData {
        public final int cryptoMode;
        public final byte[] encryptionKey;
        public final int encryptedBlocks;
        public final int clearBlocks;

        public CryptoData(int cryptoMode, byte[] encryptionKey, int encryptedBlocks, int clearBlocks) {
            this.cryptoMode = cryptoMode;
            this.encryptionKey = encryptionKey;
            this.encryptedBlocks = encryptedBlocks;
            this.clearBlocks = clearBlocks;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CryptoData other = (CryptoData)obj;
            return this.cryptoMode == other.cryptoMode && this.encryptedBlocks == other.encryptedBlocks && this.clearBlocks == other.clearBlocks && Arrays.equals(this.encryptionKey, other.encryptionKey);
        }

        public int hashCode() {
            int result = this.cryptoMode;
            result = 31 * result + Arrays.hashCode(this.encryptionKey);
            result = 31 * result + this.encryptedBlocks;
            result = 31 * result + this.clearBlocks;
            return result;
        }
    }
}

