/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.SectionPayloadReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class PassthroughSectionPayloadReader
implements SectionPayloadReader {
    private Format format;
    private @MonotonicNonNull TimestampAdjuster timestampAdjuster;
    private @MonotonicNonNull TrackOutput output;

    public PassthroughSectionPayloadReader(String mimeType) {
        this.format = new Format.Builder().setSampleMimeType(mimeType).build();
    }

    @Override
    public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        this.timestampAdjuster = timestampAdjuster;
        idGenerator.generateNewId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 5);
        this.output.format(this.format);
    }

    @Override
    public void consume(ParsableByteArray sectionData) {
        this.assertInitialized();
        long subsampleOffsetUs = this.timestampAdjuster.getTimestampOffsetUs();
        if (subsampleOffsetUs == -9223372036854775807L) {
            return;
        }
        if (subsampleOffsetUs != this.format.subsampleOffsetUs) {
            this.format = this.format.buildUpon().setSubsampleOffsetUs(subsampleOffsetUs).build();
            this.output.format(this.format);
        }
        int sampleSize = sectionData.bytesLeft();
        this.output.sampleData(sectionData, sampleSize);
        this.output.sampleMetadata(this.timestampAdjuster.getLastAdjustedTimestampUs(), 1, sampleSize, 0, null);
    }

    @EnsuresNonNull(value={"timestampAdjuster", "output"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.timestampAdjuster);
        Util.castNonNull((Object)this.output);
    }
}

