/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.jpeg;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.mp4.MotionPhotoMetadata;
import java.util.List;

final class MotionPhotoDescription {
    public final long photoPresentationTimestampUs;
    public final List<ContainerItem> items;

    public MotionPhotoDescription(long photoPresentationTimestampUs, List<ContainerItem> items) {
        this.photoPresentationTimestampUs = photoPresentationTimestampUs;
        this.items = items;
    }

    @Nullable
    public MotionPhotoMetadata getMotionPhotoMetadata(long motionPhotoLength) {
        if (this.items.size() < 2) {
            return null;
        }
        long photoStartPosition = -1L;
        long photoLength = -1L;
        long mp4StartPosition = -1L;
        long mp4Length = -1L;
        boolean itemContainsMp4 = false;
        long itemStartPosition = motionPhotoLength;
        long itemEndPosition = motionPhotoLength;
        for (int i = this.items.size() - 1; i >= 0; --i) {
            ContainerItem item = this.items.get(i);
            itemContainsMp4 |= "video/mp4".equals(item.mime);
            itemEndPosition = itemStartPosition;
            if (i == 0) {
                itemStartPosition = 0L;
                itemEndPosition -= item.padding;
            } else {
                itemStartPosition -= item.length;
            }
            if (itemContainsMp4 && itemStartPosition != itemEndPosition) {
                mp4StartPosition = itemStartPosition;
                mp4Length = itemEndPosition - itemStartPosition;
                itemContainsMp4 = false;
            }
            if (i != 0) continue;
            photoStartPosition = itemStartPosition;
            photoLength = itemEndPosition;
        }
        if (mp4StartPosition == -1L || mp4Length == -1L || photoStartPosition == -1L || photoLength == -1L) {
            return null;
        }
        return new MotionPhotoMetadata(photoStartPosition, photoLength, this.photoPresentationTimestampUs, mp4StartPosition, mp4Length);
    }

    public static final class ContainerItem {
        public final String mime;
        public final String semantic;
        public final long length;
        public final long padding;

        public ContainerItem(String mime, String semantic, long length, long padding) {
            this.mime = mime;
            this.semantic = semantic;
            this.length = length;
            this.padding = padding;
        }
    }
}

