/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.mp4.Atom;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.ApicFrame;
import com.google.android.exoplayer2.metadata.id3.CommentFrame;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.metadata.id3.InternalFrame;
import com.google.android.exoplayer2.metadata.id3.TextInformationFrame;
import com.google.android.exoplayer2.metadata.mp4.MdtaMetadataEntry;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;

final class MetadataUtil {
    private static final String TAG = "MetadataUtil";
    private static final int SHORT_TYPE_NAME_1 = 7233901;
    private static final int SHORT_TYPE_NAME_2 = 7631467;
    private static final int SHORT_TYPE_COMMENT = 6516084;
    private static final int SHORT_TYPE_YEAR = 6578553;
    private static final int SHORT_TYPE_ARTIST = 4280916;
    private static final int SHORT_TYPE_ENCODER = 7630703;
    private static final int SHORT_TYPE_ALBUM = 6384738;
    private static final int SHORT_TYPE_COMPOSER_1 = 6516589;
    private static final int SHORT_TYPE_COMPOSER_2 = 0x777274;
    private static final int SHORT_TYPE_LYRICS = 7108978;
    private static final int SHORT_TYPE_GENRE = 6776174;
    private static final int TYPE_COVER_ART = 1668249202;
    private static final int TYPE_GENRE = 1735291493;
    private static final int TYPE_GROUPING = 6779504;
    private static final int TYPE_DISK_NUMBER = 1684632427;
    private static final int TYPE_TRACK_NUMBER = 1953655662;
    private static final int TYPE_TEMPO = 1953329263;
    private static final int TYPE_COMPILATION = 1668311404;
    private static final int TYPE_ALBUM_ARTIST = 1631670868;
    private static final int TYPE_SORT_TRACK_NAME = 1936682605;
    private static final int TYPE_SORT_ALBUM = 1936679276;
    private static final int TYPE_SORT_ARTIST = 1936679282;
    private static final int TYPE_SORT_ALBUM_ARTIST = 1936679265;
    private static final int TYPE_SORT_COMPOSER = 1936679791;
    private static final int TYPE_RATING = 1920233063;
    private static final int TYPE_GAPLESS_ALBUM = 1885823344;
    private static final int TYPE_TV_SORT_SHOW = 1936683886;
    private static final int TYPE_TV_SHOW = 1953919848;
    private static final int TYPE_INTERNAL = 0x2D2D2D2D;
    private static final int PICTURE_TYPE_FRONT_COVER = 3;
    @VisibleForTesting
    static final String[] STANDARD_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Afro-Punk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "Jpop", "Synthpop", "Abstract", "Art Rock", "Baroque", "Bhangra", "Big beat", "Breakbeat", "Chillout", "Downtempo", "Dub", "EBM", "Eclectic", "Electro", "Electroclash", "Emo", "Experimental", "Garage", "Global", "IDM", "Illbient", "Industro-Goth", "Jam Band", "Krautrock", "Leftfield", "Lounge", "Math Rock", "New Romantic", "Nu-Breakz", "Post-Punk", "Post-Rock", "Psytrance", "Shoegaze", "Space Rock", "Trop Rock", "World Music", "Neoclassical", "Audiobook", "Audio theatre", "Neue Deutsche Welle", "Podcast", "Indie-Rock", "G-Funk", "Dubstep", "Garage Rock", "Psybient"};
    private static final String LANGUAGE_UNDEFINED = "und";
    private static final int TYPE_TOP_BYTE_COPYRIGHT = 169;
    private static final int TYPE_TOP_BYTE_REPLACEMENT = 253;

    private MetadataUtil() {
    }

    public static void setFormatMetadata(int trackType, @Nullable Metadata udtaMetaMetadata, @Nullable Metadata mdtaMetadata, Format.Builder formatBuilder, Metadata ... additionalMetadata) {
        Metadata formatMetadata;
        block5: {
            block4: {
                formatMetadata = new Metadata(new Metadata.Entry[0]);
                if (trackType != 1) break block4;
                if (udtaMetaMetadata == null) break block5;
                formatMetadata = udtaMetaMetadata;
                break block5;
            }
            if (trackType == 2 && mdtaMetadata != null) {
                for (int i = 0; i < mdtaMetadata.length(); ++i) {
                    Metadata.Entry entry = mdtaMetadata.get(i);
                    if (!(entry instanceof MdtaMetadataEntry)) continue;
                    MdtaMetadataEntry mdtaMetadataEntry = (MdtaMetadataEntry)entry;
                    if (!"com.android.capture.fps".equals(mdtaMetadataEntry.key)) continue;
                    formatMetadata = new Metadata(new Metadata.Entry[]{mdtaMetadataEntry});
                    break;
                }
            }
        }
        for (Metadata metadata : additionalMetadata) {
            formatMetadata = formatMetadata.copyWithAppendedEntriesFrom(metadata);
        }
        if (formatMetadata.length() > 0) {
            formatBuilder.setMetadata(formatMetadata);
        }
    }

    public static void setFormatGaplessInfo(int trackType, GaplessInfoHolder gaplessInfoHolder, Format.Builder formatBuilder) {
        if (trackType == 1 && gaplessInfoHolder.hasGaplessInfo()) {
            formatBuilder.setEncoderDelay(gaplessInfoHolder.encoderDelay).setEncoderPadding(gaplessInfoHolder.encoderPadding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Metadata.Entry parseIlstElement(ParsableByteArray ilst) {
        int position = ilst.getPosition();
        int endPosition = position + ilst.readInt();
        int type = ilst.readInt();
        int typeTopByte = type >> 24 & 0xFF;
        try {
            if (typeTopByte == 169 || typeTopByte == 253) {
                int shortType = type & 0xFFFFFF;
                if (shortType == 6516084) {
                    CommentFrame commentFrame = MetadataUtil.parseCommentAttribute(type, ilst);
                    return commentFrame;
                }
                if (shortType == 7233901 || shortType == 7631467) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TIT2", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6516589 || shortType == 0x777274) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TCOM", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6578553) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TDRC", ilst);
                    return textInformationFrame;
                }
                if (shortType == 4280916) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TPE1", ilst);
                    return textInformationFrame;
                }
                if (shortType == 7630703) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSSE", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6384738) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TALB", ilst);
                    return textInformationFrame;
                }
                if (shortType == 7108978) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "USLT", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6776174) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TCON", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6779504) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TIT1", ilst);
                    return textInformationFrame;
                }
            } else {
                if (type == 1735291493) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseStandardGenreAttribute(ilst);
                    return textInformationFrame;
                }
                if (type == 1684632427) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseIndexAndCountAttribute(type, "TPOS", ilst);
                    return textInformationFrame;
                }
                if (type == 1953655662) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseIndexAndCountAttribute(type, "TRCK", ilst);
                    return textInformationFrame;
                }
                if (type == 1953329263) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "TBPM", ilst, true, false);
                    return id3Frame;
                }
                if (type == 1668311404) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "TCMP", ilst, true, true);
                    return id3Frame;
                }
                if (type == 1668249202) {
                    ApicFrame apicFrame = MetadataUtil.parseCoverArt(ilst);
                    return apicFrame;
                }
                if (type == 1631670868) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TPE2", ilst);
                    return textInformationFrame;
                }
                if (type == 1936682605) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOT", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679276) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSO2", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679282) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOA", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679265) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOP", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679791) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOC", ilst);
                    return textInformationFrame;
                }
                if (type == 1920233063) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "ITUNESADVISORY", ilst, false, false);
                    return id3Frame;
                }
                if (type == 1885823344) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "ITUNESGAPLESS", ilst, false, true);
                    return id3Frame;
                }
                if (type == 1936683886) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TVSHOWSORT", ilst);
                    return textInformationFrame;
                }
                if (type == 1953919848) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TVSHOW", ilst);
                    return textInformationFrame;
                }
                if (type == 0x2D2D2D2D) {
                    Id3Frame id3Frame = MetadataUtil.parseInternalAttribute(ilst, endPosition);
                    return id3Frame;
                }
            }
            String string = String.valueOf(Atom.getAtomTypeString(type));
            Log.d((String)TAG, (String)(string.length() != 0 ? "Skipped unknown metadata entry: ".concat(string) : new String("Skipped unknown metadata entry: ")));
            Metadata.Entry entry = null;
            return entry;
        }
        finally {
            ilst.setPosition(endPosition);
        }
    }

    @Nullable
    public static MdtaMetadataEntry parseMdtaMetadataEntryFromIlst(ParsableByteArray ilst, int endPosition, String key) {
        int atomPosition;
        while ((atomPosition = ilst.getPosition()) < endPosition) {
            int atomSize = ilst.readInt();
            int atomType = ilst.readInt();
            if (atomType == 1684108385) {
                int typeIndicator = ilst.readInt();
                int localeIndicator = ilst.readInt();
                int dataSize = atomSize - 16;
                byte[] value = new byte[dataSize];
                ilst.readBytes(value, 0, dataSize);
                return new MdtaMetadataEntry(key, value, localeIndicator, typeIndicator);
            }
            ilst.setPosition(atomPosition + atomSize);
        }
        return null;
    }

    @Nullable
    private static TextInformationFrame parseTextAttribute(int type, String id, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            data.skipBytes(8);
            String value = data.readNullTerminatedString(atomSize - 16);
            return new TextInformationFrame(id, null, value);
        }
        String string = String.valueOf(Atom.getAtomTypeString(type));
        Log.w((String)TAG, (String)(string.length() != 0 ? "Failed to parse text attribute: ".concat(string) : new String("Failed to parse text attribute: ")));
        return null;
    }

    @Nullable
    private static CommentFrame parseCommentAttribute(int type, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            data.skipBytes(8);
            String value = data.readNullTerminatedString(atomSize - 16);
            return new CommentFrame(LANGUAGE_UNDEFINED, value, value);
        }
        String string = String.valueOf(Atom.getAtomTypeString(type));
        Log.w((String)TAG, (String)(string.length() != 0 ? "Failed to parse comment attribute: ".concat(string) : new String("Failed to parse comment attribute: ")));
        return null;
    }

    @Nullable
    private static Id3Frame parseUint8Attribute(int type, String id, ParsableByteArray data, boolean isTextInformationFrame, boolean isBoolean) {
        int value = MetadataUtil.parseUint8AttributeValue(data);
        if (isBoolean) {
            value = Math.min(1, value);
        }
        if (value >= 0) {
            return isTextInformationFrame ? new TextInformationFrame(id, null, Integer.toString(value)) : new CommentFrame(LANGUAGE_UNDEFINED, id, Integer.toString(value));
        }
        String string = String.valueOf(Atom.getAtomTypeString(type));
        Log.w((String)TAG, (String)(string.length() != 0 ? "Failed to parse uint8 attribute: ".concat(string) : new String("Failed to parse uint8 attribute: ")));
        return null;
    }

    @Nullable
    private static TextInformationFrame parseIndexAndCountAttribute(int type, String attributeName, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385 && atomSize >= 22) {
            data.skipBytes(10);
            int index = data.readUnsignedShort();
            if (index > 0) {
                String value = new StringBuilder(11).append(index).toString();
                int count = data.readUnsignedShort();
                if (count > 0) {
                    String string = String.valueOf(value);
                    value = new StringBuilder(12 + String.valueOf(string).length()).append(string).append("/").append(count).toString();
                }
                return new TextInformationFrame(attributeName, null, value);
            }
        }
        String string = String.valueOf(Atom.getAtomTypeString(type));
        Log.w((String)TAG, (String)(string.length() != 0 ? "Failed to parse index/count attribute: ".concat(string) : new String("Failed to parse index/count attribute: ")));
        return null;
    }

    @Nullable
    private static TextInformationFrame parseStandardGenreAttribute(ParsableByteArray data) {
        String genreString;
        int genreCode = MetadataUtil.parseUint8AttributeValue(data);
        String string = genreString = 0 < genreCode && genreCode <= STANDARD_GENRES.length ? STANDARD_GENRES[genreCode - 1] : null;
        if (genreString != null) {
            return new TextInformationFrame("TCON", null, genreString);
        }
        Log.w((String)TAG, (String)"Failed to parse standard genre code");
        return null;
    }

    @Nullable
    private static ApicFrame parseCoverArt(ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            String mimeType;
            int fullVersionInt = data.readInt();
            int flags = Atom.parseFullAtomFlags(fullVersionInt);
            String string = flags == 13 ? "image/jpeg" : (mimeType = flags == 14 ? "image/png" : null);
            if (mimeType == null) {
                Log.w((String)TAG, (String)new StringBuilder(41).append("Unrecognized cover art flags: ").append(flags).toString());
                return null;
            }
            data.skipBytes(4);
            byte[] pictureData = new byte[atomSize - 16];
            data.readBytes(pictureData, 0, pictureData.length);
            return new ApicFrame(mimeType, null, 3, pictureData);
        }
        Log.w((String)TAG, (String)"Failed to parse cover art attribute");
        return null;
    }

    @Nullable
    private static Id3Frame parseInternalAttribute(ParsableByteArray data, int endPosition) {
        String domain = null;
        String name = null;
        int dataAtomPosition = -1;
        int dataAtomSize = -1;
        while (data.getPosition() < endPosition) {
            int atomPosition = data.getPosition();
            int atomSize = data.readInt();
            int atomType = data.readInt();
            data.skipBytes(4);
            if (atomType == 1835360622) {
                domain = data.readNullTerminatedString(atomSize - 12);
                continue;
            }
            if (atomType == 1851878757) {
                name = data.readNullTerminatedString(atomSize - 12);
                continue;
            }
            if (atomType == 1684108385) {
                dataAtomPosition = atomPosition;
                dataAtomSize = atomSize;
            }
            data.skipBytes(atomSize - 12);
        }
        if (domain == null || name == null || dataAtomPosition == -1) {
            return null;
        }
        data.setPosition(dataAtomPosition);
        data.skipBytes(16);
        String value = data.readNullTerminatedString(dataAtomSize - 16);
        return new InternalFrame(domain, name, value);
    }

    private static int parseUint8AttributeValue(ParsableByteArray data) {
        data.skipBytes(4);
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            data.skipBytes(8);
            return data.readUnsignedByte();
        }
        Log.w((String)TAG, (String)"Failed to parse uint8 attribute value");
        return -1;
    }
}

