/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.exoplayer2.upstream.DataSourceUtil;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.ContentMetadata;
import java.io.IOException;
import java.io.InterruptedIOException;

public final class CacheWriter {
    public static final int DEFAULT_BUFFER_SIZE_BYTES = 131072;
    private final CacheDataSource dataSource;
    private final Cache cache;
    private final DataSpec dataSpec;
    private final String cacheKey;
    private final byte[] temporaryBuffer;
    @Nullable
    private final ProgressListener progressListener;
    private long nextPosition;
    private long endPosition;
    private long bytesCached;
    private volatile boolean isCanceled;

    public CacheWriter(CacheDataSource dataSource, DataSpec dataSpec, @Nullable byte[] temporaryBuffer, @Nullable ProgressListener progressListener) {
        this.dataSource = dataSource;
        this.cache = dataSource.getCache();
        this.dataSpec = dataSpec;
        this.temporaryBuffer = temporaryBuffer == null ? new byte[131072] : temporaryBuffer;
        this.progressListener = progressListener;
        this.cacheKey = dataSource.getCacheKeyFactory().buildCacheKey(dataSpec);
        this.nextPosition = dataSpec.position;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    @WorkerThread
    public void cache() throws IOException {
        this.throwIfCanceled();
        this.bytesCached = this.cache.getCachedBytes(this.cacheKey, this.dataSpec.position, this.dataSpec.length);
        if (this.dataSpec.length != -1L) {
            this.endPosition = this.dataSpec.position + this.dataSpec.length;
        } else {
            long contentLength = ContentMetadata.getContentLength(this.cache.getContentMetadata(this.cacheKey));
            long l = this.endPosition = contentLength == -1L ? -1L : contentLength;
        }
        if (this.progressListener != null) {
            this.progressListener.onProgress(this.getLength(), this.bytesCached, 0L);
        }
        while (this.endPosition == -1L || this.nextPosition < this.endPosition) {
            this.throwIfCanceled();
            long maxRemainingLength = this.endPosition == -1L ? Long.MAX_VALUE : this.endPosition - this.nextPosition;
            long blockLength = this.cache.getCachedLength(this.cacheKey, this.nextPosition, maxRemainingLength);
            if (blockLength > 0L) {
                this.nextPosition += blockLength;
                continue;
            }
            long nextRequestLength = (blockLength = -blockLength) == Long.MAX_VALUE ? -1L : blockLength;
            this.nextPosition += this.readBlockToCache(this.nextPosition, nextRequestLength);
        }
    }

    private long readBlockToCache(long position, long length) throws IOException {
        boolean isLastBlock = position + length == this.endPosition || length == -1L;
        long resolvedLength = -1L;
        boolean isDataSourceOpen = false;
        if (length != -1L) {
            DataSpec boundedDataSpec = this.dataSpec.buildUpon().setPosition(position).setLength(length).build();
            try {
                resolvedLength = this.dataSource.open(boundedDataSpec);
                isDataSourceOpen = true;
            }
            catch (IOException e) {
                DataSourceUtil.closeQuietly(this.dataSource);
            }
        }
        if (!isDataSourceOpen) {
            this.throwIfCanceled();
            DataSpec unboundedDataSpec = this.dataSpec.buildUpon().setPosition(position).setLength(-1L).build();
            try {
                resolvedLength = this.dataSource.open(unboundedDataSpec);
            }
            catch (IOException e) {
                DataSourceUtil.closeQuietly(this.dataSource);
                throw e;
            }
        }
        int totalBytesRead = 0;
        try {
            if (isLastBlock && resolvedLength != -1L) {
                this.onRequestEndPosition(position + resolvedLength);
            }
            int bytesRead = 0;
            while (bytesRead != -1) {
                this.throwIfCanceled();
                bytesRead = this.dataSource.read(this.temporaryBuffer, 0, this.temporaryBuffer.length);
                if (bytesRead == -1) continue;
                this.onNewBytesCached(bytesRead);
                totalBytesRead += bytesRead;
            }
            if (isLastBlock) {
                this.onRequestEndPosition(position + (long)totalBytesRead);
            }
        }
        catch (IOException e) {
            DataSourceUtil.closeQuietly(this.dataSource);
            throw e;
        }
        this.dataSource.close();
        return totalBytesRead;
    }

    private void onRequestEndPosition(long endPosition) {
        if (this.endPosition == endPosition) {
            return;
        }
        this.endPosition = endPosition;
        if (this.progressListener != null) {
            this.progressListener.onProgress(this.getLength(), this.bytesCached, 0L);
        }
    }

    private void onNewBytesCached(long newBytesCached) {
        this.bytesCached += newBytesCached;
        if (this.progressListener != null) {
            this.progressListener.onProgress(this.getLength(), this.bytesCached, newBytesCached);
        }
    }

    private long getLength() {
        return this.endPosition == -1L ? -1L : this.endPosition - this.dataSpec.position;
    }

    private void throwIfCanceled() throws InterruptedIOException {
        if (this.isCanceled) {
            throw new InterruptedIOException();
        }
    }

    public static interface ProgressListener {
        public void onProgress(long var1, long var3, long var5);
    }
}

