/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;

public final class DashWrappingSegmentIndex
implements DashSegmentIndex {
    private final ChunkIndex chunkIndex;

    public DashWrappingSegmentIndex(ChunkIndex chunkIndex) {
        this.chunkIndex = chunkIndex;
    }

    @Override
    public int getFirstSegmentNum() {
        return 0;
    }

    @Override
    public int getSegmentCount(long periodDurationUs) {
        return this.chunkIndex.length;
    }

    @Override
    public long getTimeUs(int segmentNum) {
        return this.chunkIndex.timesUs[segmentNum];
    }

    @Override
    public long getDurationUs(int segmentNum, long periodDurationUs) {
        return this.chunkIndex.durationsUs[segmentNum];
    }

    @Override
    public RangedUri getSegmentUrl(int segmentNum) {
        return new RangedUri(null, this.chunkIndex.offsets[segmentNum], this.chunkIndex.sizes[segmentNum]);
    }

    @Override
    public int getSegmentNum(long timeUs, long periodDurationUs) {
        return this.chunkIndex.getChunkIndex(timeUs);
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

