/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.support.annotation.Nullable;
import android.util.Pair;
import android.util.SparseIntArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.EmptySampleStream;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.ChunkSampleStream;
import com.google.android.exoplayer2.source.chunk.ChunkSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.EventSampleStream;
import com.google.android.exoplayer2.source.dash.PlayerEmsgHandler;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Descriptor;
import com.google.android.exoplayer2.source.dash.manifest.EventStream;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;

final class DashMediaPeriod
implements MediaPeriod,
SequenceableLoader.Callback<ChunkSampleStream<DashChunkSource>>,
ChunkSampleStream.ReleaseCallback<DashChunkSource> {
    final int id;
    private final DashChunkSource.Factory chunkSourceFactory;
    @Nullable
    private final TransferListener transferListener;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final long elapsedRealtimeOffset;
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final Allocator allocator;
    private final TrackGroupArray trackGroups;
    private final TrackGroupInfo[] trackGroupInfos;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final PlayerEmsgHandler playerEmsgHandler;
    private final IdentityHashMap<ChunkSampleStream<DashChunkSource>, PlayerEmsgHandler.PlayerTrackEmsgHandler> trackEmsgHandlerBySampleStream;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    @Nullable
    private MediaPeriod.Callback callback;
    private ChunkSampleStream<DashChunkSource>[] sampleStreams;
    private EventSampleStream[] eventSampleStreams;
    private SequenceableLoader compositeSequenceableLoader;
    private DashManifest manifest;
    private int periodIndex;
    private List<EventStream> eventStreams;
    private boolean notifiedReadingStarted;

    public DashMediaPeriod(int id, DashManifest manifest, int periodIndex, DashChunkSource.Factory chunkSourceFactory, @Nullable TransferListener transferListener, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher, long elapsedRealtimeOffset, LoaderErrorThrower manifestLoaderErrorThrower, Allocator allocator, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, PlayerEmsgHandler.PlayerEmsgCallback playerEmsgCallback) {
        this.id = id;
        this.manifest = manifest;
        this.periodIndex = periodIndex;
        this.chunkSourceFactory = chunkSourceFactory;
        this.transferListener = transferListener;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.eventDispatcher = eventDispatcher;
        this.elapsedRealtimeOffset = elapsedRealtimeOffset;
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.allocator = allocator;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.playerEmsgHandler = new PlayerEmsgHandler(manifest, playerEmsgCallback, allocator);
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(0);
        this.eventSampleStreams = new EventSampleStream[0];
        this.trackEmsgHandlerBySampleStream = new IdentityHashMap();
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        Period period = manifest.getPeriod(periodIndex);
        this.eventStreams = period.eventStreams;
        Pair<TrackGroupArray, TrackGroupInfo[]> result = DashMediaPeriod.buildTrackGroups(period.adaptationSets, this.eventStreams);
        this.trackGroups = (TrackGroupArray)result.first;
        this.trackGroupInfos = (TrackGroupInfo[])result.second;
        eventDispatcher.mediaPeriodCreated();
    }

    public void updateManifest(DashManifest manifest, int periodIndex) {
        this.manifest = manifest;
        this.periodIndex = periodIndex;
        this.playerEmsgHandler.updateManifest(manifest);
        if (this.sampleStreams != null) {
            for (ChunkSampleStream<DashChunkSource> chunkSampleStream : this.sampleStreams) {
                ((DashChunkSource)chunkSampleStream.getChunkSource()).updateManifest(manifest, periodIndex);
            }
            this.callback.onContinueLoadingRequested((SequenceableLoader)this);
        }
        this.eventStreams = manifest.getPeriod((int)periodIndex).eventStreams;
        block1: for (EventSampleStream eventSampleStream : this.eventSampleStreams) {
            for (EventStream eventStream : this.eventStreams) {
                if (!eventStream.id().equals(eventSampleStream.eventStreamId())) continue;
                int lastPeriodIndex = manifest.getPeriodCount() - 1;
                eventSampleStream.updateEventStream(eventStream, manifest.dynamic && periodIndex == lastPeriodIndex);
                continue block1;
            }
        }
    }

    public void release() {
        this.playerEmsgHandler.release();
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.release((ChunkSampleStream.ReleaseCallback)this);
        }
        this.callback = null;
        this.eventDispatcher.mediaPeriodReleased();
    }

    public synchronized void onSampleStreamReleased(ChunkSampleStream<DashChunkSource> stream) {
        PlayerEmsgHandler.PlayerTrackEmsgHandler trackEmsgHandler = this.trackEmsgHandlerBySampleStream.remove(stream);
        if (trackEmsgHandler != null) {
            trackEmsgHandler.release();
        }
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        callback.onPrepared((MediaPeriod)this);
    }

    public void maybeThrowPrepareError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int[] streamIndexToTrackGroupIndex = this.getStreamIndexToTrackGroupIndex(selections);
        this.releaseDisabledStreams(selections, mayRetainStreamFlags, streams);
        this.releaseOrphanEmbeddedStreams(selections, streams, streamIndexToTrackGroupIndex);
        this.selectNewStreams(selections, streams, streamResetFlags, positionUs, streamIndexToTrackGroupIndex);
        ArrayList<ChunkSampleStream> sampleStreamList = new ArrayList<ChunkSampleStream>();
        ArrayList<EventSampleStream> eventSampleStreamList = new ArrayList<EventSampleStream>();
        for (SampleStream sampleStream : streams) {
            if (sampleStream instanceof ChunkSampleStream) {
                ChunkSampleStream stream = (ChunkSampleStream)sampleStream;
                sampleStreamList.add(stream);
                continue;
            }
            if (!(sampleStream instanceof EventSampleStream)) continue;
            eventSampleStreamList.add((EventSampleStream)sampleStream);
        }
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(sampleStreamList.size());
        sampleStreamList.toArray(this.sampleStreams);
        this.eventSampleStreams = new EventSampleStream[eventSampleStreamList.size()];
        eventSampleStreamList.toArray(this.eventSampleStreams);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        return positionUs;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.discardBuffer(positionUs, toKeyframe);
        }
    }

    public void reevaluateBuffer(long positionUs) {
        this.compositeSequenceableLoader.reevaluateBuffer(positionUs);
    }

    public boolean continueLoading(long positionUs) {
        return this.compositeSequenceableLoader.continueLoading(positionUs);
    }

    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        if (!this.notifiedReadingStarted) {
            this.eventDispatcher.readingStarted();
            this.notifiedReadingStarted = true;
        }
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    public long seekToUs(long positionUs) {
        for (ChunkSampleStream<DashChunkSource> chunkSampleStream : this.sampleStreams) {
            chunkSampleStream.seekToUs(positionUs);
        }
        for (EventSampleStream eventSampleStream : this.eventSampleStreams) {
            eventSampleStream.seekToUs(positionUs);
        }
        return positionUs;
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            if (sampleStream.primaryTrackType != 2) continue;
            return sampleStream.getAdjustedSeekPositionUs(positionUs, seekParameters);
        }
        return positionUs;
    }

    public void onContinueLoadingRequested(ChunkSampleStream<DashChunkSource> sampleStream) {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    private int[] getStreamIndexToTrackGroupIndex(TrackSelection[] selections) {
        int[] streamIndexToTrackGroupIndex = new int[selections.length];
        for (int i = 0; i < selections.length; ++i) {
            streamIndexToTrackGroupIndex[i] = selections[i] != null ? this.trackGroups.indexOf(selections[i].getTrackGroup()) : -1;
        }
        return streamIndexToTrackGroupIndex;
    }

    private void releaseDisabledStreams(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams) {
        for (int i = 0; i < selections.length; ++i) {
            if (selections[i] != null && mayRetainStreamFlags[i]) continue;
            if (streams[i] instanceof ChunkSampleStream) {
                ChunkSampleStream stream = (ChunkSampleStream)streams[i];
                stream.release((ChunkSampleStream.ReleaseCallback)this);
            } else if (streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream) {
                ((ChunkSampleStream.EmbeddedSampleStream)streams[i]).release();
            }
            streams[i] = null;
        }
    }

    private void releaseOrphanEmbeddedStreams(TrackSelection[] selections, SampleStream[] streams, int[] streamIndexToTrackGroupIndex) {
        for (int i = 0; i < selections.length; ++i) {
            boolean mayRetainStream;
            if (!(streams[i] instanceof EmptySampleStream) && !(streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream)) continue;
            int primaryStreamIndex = this.getPrimaryStreamIndex(i, streamIndexToTrackGroupIndex);
            if (primaryStreamIndex == -1) {
                mayRetainStream = streams[i] instanceof EmptySampleStream;
            } else {
                boolean bl = mayRetainStream = streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream && ((ChunkSampleStream.EmbeddedSampleStream)streams[i]).parent == streams[primaryStreamIndex];
            }
            if (mayRetainStream) continue;
            if (streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream) {
                ((ChunkSampleStream.EmbeddedSampleStream)streams[i]).release();
            }
            streams[i] = null;
        }
    }

    private void selectNewStreams(TrackSelection[] selections, SampleStream[] streams, boolean[] streamResetFlags, long positionUs, int[] streamIndexToTrackGroupIndex) {
        TrackGroupInfo trackGroupInfo;
        int trackGroupIndex;
        int i;
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            streamResetFlags[i] = true;
            trackGroupIndex = streamIndexToTrackGroupIndex[i];
            trackGroupInfo = this.trackGroupInfos[trackGroupIndex];
            if (trackGroupInfo.trackGroupCategory == 0) {
                streams[i] = this.buildSampleStream(trackGroupInfo, selections[i], positionUs);
                continue;
            }
            if (trackGroupInfo.trackGroupCategory != 2) continue;
            EventStream eventStream = this.eventStreams.get(trackGroupInfo.eventStreamGroupIndex);
            Format format = selections[i].getTrackGroup().getFormat(0);
            streams[i] = new EventSampleStream(eventStream, format, this.manifest.dynamic);
        }
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            trackGroupIndex = streamIndexToTrackGroupIndex[i];
            trackGroupInfo = this.trackGroupInfos[trackGroupIndex];
            if (trackGroupInfo.trackGroupCategory != 1) continue;
            int primaryStreamIndex = this.getPrimaryStreamIndex(i, streamIndexToTrackGroupIndex);
            streams[i] = primaryStreamIndex == -1 ? new EmptySampleStream() : ((ChunkSampleStream)streams[primaryStreamIndex]).selectEmbeddedTrack(positionUs, trackGroupInfo.trackType);
        }
    }

    private int getPrimaryStreamIndex(int embeddedStreamIndex, int[] streamIndexToTrackGroupIndex) {
        int embeddedTrackGroupIndex = streamIndexToTrackGroupIndex[embeddedStreamIndex];
        if (embeddedTrackGroupIndex == -1) {
            return -1;
        }
        int primaryTrackGroupIndex = this.trackGroupInfos[embeddedTrackGroupIndex].primaryTrackGroupIndex;
        for (int i = 0; i < streamIndexToTrackGroupIndex.length; ++i) {
            int trackGroupIndex = streamIndexToTrackGroupIndex[i];
            if (trackGroupIndex != primaryTrackGroupIndex || this.trackGroupInfos[trackGroupIndex].trackGroupCategory != 0) continue;
            return i;
        }
        return -1;
    }

    private static Pair<TrackGroupArray, TrackGroupInfo[]> buildTrackGroups(List<AdaptationSet> adaptationSets, List<EventStream> eventStreams) {
        int[][] groupedAdaptationSetIndices = DashMediaPeriod.getGroupedAdaptationSetIndices(adaptationSets);
        int primaryGroupCount = groupedAdaptationSetIndices.length;
        boolean[] primaryGroupHasEventMessageTrackFlags = new boolean[primaryGroupCount];
        boolean[] primaryGroupHasCea608TrackFlags = new boolean[primaryGroupCount];
        int totalEmbeddedTrackGroupCount = DashMediaPeriod.identifyEmbeddedTracks(primaryGroupCount, adaptationSets, groupedAdaptationSetIndices, primaryGroupHasEventMessageTrackFlags, primaryGroupHasCea608TrackFlags);
        int totalGroupCount = primaryGroupCount + totalEmbeddedTrackGroupCount + eventStreams.size();
        TrackGroup[] trackGroups = new TrackGroup[totalGroupCount];
        TrackGroupInfo[] trackGroupInfos = new TrackGroupInfo[totalGroupCount];
        int trackGroupCount = DashMediaPeriod.buildPrimaryAndEmbeddedTrackGroupInfos(adaptationSets, groupedAdaptationSetIndices, primaryGroupCount, primaryGroupHasEventMessageTrackFlags, primaryGroupHasCea608TrackFlags, trackGroups, trackGroupInfos);
        DashMediaPeriod.buildManifestEventTrackGroupInfos(eventStreams, trackGroups, trackGroupInfos, trackGroupCount);
        return Pair.create((Object)new TrackGroupArray(trackGroups), (Object)trackGroupInfos);
    }

    private static int[][] getGroupedAdaptationSetIndices(List<AdaptationSet> adaptationSets) {
        int adaptationSetCount = adaptationSets.size();
        SparseIntArray idToIndexMap = new SparseIntArray(adaptationSetCount);
        for (int i = 0; i < adaptationSetCount; ++i) {
            idToIndexMap.put(adaptationSets.get((int)i).id, i);
        }
        int[][] groupedAdaptationSetIndices = new int[adaptationSetCount][];
        boolean[] adaptationSetUsedFlags = new boolean[adaptationSetCount];
        int groupCount = 0;
        for (int i = 0; i < adaptationSetCount; ++i) {
            if (adaptationSetUsedFlags[i]) continue;
            adaptationSetUsedFlags[i] = true;
            Descriptor adaptationSetSwitchingProperty = DashMediaPeriod.findAdaptationSetSwitchingProperty(adaptationSets.get((int)i).supplementalProperties);
            if (adaptationSetSwitchingProperty == null) {
                groupedAdaptationSetIndices[groupCount++] = new int[]{i};
                continue;
            }
            String[] extraAdaptationSetIds = adaptationSetSwitchingProperty.value.split(",");
            int[] adaptationSetIndices = new int[1 + extraAdaptationSetIds.length];
            adaptationSetIndices[0] = i;
            for (int j = 0; j < extraAdaptationSetIds.length; ++j) {
                int extraIndex = idToIndexMap.get(Integer.parseInt(extraAdaptationSetIds[j]));
                adaptationSetUsedFlags[extraIndex] = true;
                adaptationSetIndices[1 + j] = extraIndex;
            }
            groupedAdaptationSetIndices[groupCount++] = adaptationSetIndices;
        }
        return groupCount < adaptationSetCount ? (Object)((int[][])Arrays.copyOf(groupedAdaptationSetIndices, groupCount)) : groupedAdaptationSetIndices;
    }

    private static int identifyEmbeddedTracks(int primaryGroupCount, List<AdaptationSet> adaptationSets, int[][] groupedAdaptationSetIndices, boolean[] primaryGroupHasEventMessageTrackFlags, boolean[] primaryGroupHasCea608TrackFlags) {
        int numEmbeddedTrack = 0;
        for (int i = 0; i < primaryGroupCount; ++i) {
            if (DashMediaPeriod.hasEventMessageTrack(adaptationSets, groupedAdaptationSetIndices[i])) {
                primaryGroupHasEventMessageTrackFlags[i] = true;
                ++numEmbeddedTrack;
            }
            if (!DashMediaPeriod.hasCea608Track(adaptationSets, groupedAdaptationSetIndices[i])) continue;
            primaryGroupHasCea608TrackFlags[i] = true;
            ++numEmbeddedTrack;
        }
        return numEmbeddedTrack;
    }

    private static int buildPrimaryAndEmbeddedTrackGroupInfos(List<AdaptationSet> adaptationSets, int[][] groupedAdaptationSetIndices, int primaryGroupCount, boolean[] primaryGroupHasEventMessageTrackFlags, boolean[] primaryGroupHasCea608TrackFlags, TrackGroup[] trackGroups, TrackGroupInfo[] trackGroupInfos) {
        int trackGroupCount = 0;
        for (int i = 0; i < primaryGroupCount; ++i) {
            Format format;
            int[] adaptationSetIndices = groupedAdaptationSetIndices[i];
            ArrayList<Representation> representations = new ArrayList<Representation>();
            for (int adaptationSetIndex : adaptationSetIndices) {
                representations.addAll(adaptationSets.get((int)adaptationSetIndex).representations);
            }
            Format[] formats = new Format[representations.size()];
            for (int j = 0; j < formats.length; ++j) {
                formats[j] = ((Representation)representations.get((int)j)).format;
            }
            AdaptationSet firstAdaptationSet = adaptationSets.get(adaptationSetIndices[0]);
            int primaryTrackGroupIndex = trackGroupCount++;
            int eventMessageTrackGroupIndex = primaryGroupHasEventMessageTrackFlags[i] ? trackGroupCount++ : -1;
            int cea608TrackGroupIndex = primaryGroupHasCea608TrackFlags[i] ? trackGroupCount++ : -1;
            trackGroups[primaryTrackGroupIndex] = new TrackGroup(formats);
            trackGroupInfos[primaryTrackGroupIndex] = TrackGroupInfo.primaryTrack(firstAdaptationSet.type, adaptationSetIndices, primaryTrackGroupIndex, eventMessageTrackGroupIndex, cea608TrackGroupIndex);
            if (eventMessageTrackGroupIndex != -1) {
                format = Format.createSampleFormat((String)(firstAdaptationSet.id + ":emsg"), (String)"application/x-emsg", null, (int)-1, null);
                trackGroups[eventMessageTrackGroupIndex] = new TrackGroup(new Format[]{format});
                trackGroupInfos[eventMessageTrackGroupIndex] = TrackGroupInfo.embeddedEmsgTrack(adaptationSetIndices, primaryTrackGroupIndex);
            }
            if (cea608TrackGroupIndex == -1) continue;
            format = Format.createTextSampleFormat((String)(firstAdaptationSet.id + ":cea608"), (String)"application/cea-608", (int)0, null);
            trackGroups[cea608TrackGroupIndex] = new TrackGroup(new Format[]{format});
            trackGroupInfos[cea608TrackGroupIndex] = TrackGroupInfo.embeddedCea608Track(adaptationSetIndices, primaryTrackGroupIndex);
        }
        return trackGroupCount;
    }

    private static void buildManifestEventTrackGroupInfos(List<EventStream> eventStreams, TrackGroup[] trackGroups, TrackGroupInfo[] trackGroupInfos, int existingTrackGroupCount) {
        for (int i = 0; i < eventStreams.size(); ++i) {
            EventStream eventStream = eventStreams.get(i);
            Format format = Format.createSampleFormat((String)eventStream.id(), (String)"application/x-emsg", null, (int)-1, null);
            trackGroups[existingTrackGroupCount] = new TrackGroup(new Format[]{format});
            trackGroupInfos[existingTrackGroupCount++] = TrackGroupInfo.mpdEventTrack(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkSampleStream<DashChunkSource> buildSampleStream(TrackGroupInfo trackGroupInfo, TrackSelection selection, long positionUs) {
        boolean enableCea608Track;
        boolean enableEventMessageTrack;
        int embeddedTrackCount = 0;
        int[] embeddedTrackTypes = new int[2];
        Format[] embeddedTrackFormats = new Format[2];
        boolean bl = enableEventMessageTrack = trackGroupInfo.embeddedEventMessageTrackGroupIndex != -1;
        if (enableEventMessageTrack) {
            embeddedTrackFormats[embeddedTrackCount] = this.trackGroups.get(trackGroupInfo.embeddedEventMessageTrackGroupIndex).getFormat(0);
            embeddedTrackTypes[embeddedTrackCount++] = 4;
        }
        boolean bl2 = enableCea608Track = trackGroupInfo.embeddedCea608TrackGroupIndex != -1;
        if (enableCea608Track) {
            embeddedTrackFormats[embeddedTrackCount] = this.trackGroups.get(trackGroupInfo.embeddedCea608TrackGroupIndex).getFormat(0);
            embeddedTrackTypes[embeddedTrackCount++] = 3;
        }
        if (embeddedTrackCount < embeddedTrackTypes.length) {
            embeddedTrackFormats = Arrays.copyOf(embeddedTrackFormats, embeddedTrackCount);
            embeddedTrackTypes = Arrays.copyOf(embeddedTrackTypes, embeddedTrackCount);
        }
        PlayerEmsgHandler.PlayerTrackEmsgHandler trackPlayerEmsgHandler = this.manifest.dynamic && enableEventMessageTrack ? this.playerEmsgHandler.newPlayerTrackEmsgHandler() : null;
        DashChunkSource chunkSource = this.chunkSourceFactory.createDashChunkSource(this.manifestLoaderErrorThrower, this.manifest, this.periodIndex, trackGroupInfo.adaptationSetIndices, selection, trackGroupInfo.trackType, this.elapsedRealtimeOffset, enableEventMessageTrack, enableCea608Track, trackPlayerEmsgHandler, this.transferListener);
        ChunkSampleStream stream = new ChunkSampleStream(trackGroupInfo.trackType, embeddedTrackTypes, embeddedTrackFormats, (ChunkSource)chunkSource, (SequenceableLoader.Callback)this, this.allocator, positionUs, this.loadErrorHandlingPolicy, this.eventDispatcher);
        DashMediaPeriod dashMediaPeriod = this;
        synchronized (dashMediaPeriod) {
            this.trackEmsgHandlerBySampleStream.put((ChunkSampleStream<DashChunkSource>)stream, trackPlayerEmsgHandler);
        }
        return stream;
    }

    private static Descriptor findAdaptationSetSwitchingProperty(List<Descriptor> descriptors) {
        for (int i = 0; i < descriptors.size(); ++i) {
            Descriptor descriptor = descriptors.get(i);
            if (!"urn:mpeg:dash:adaptation-set-switching:2016".equals(descriptor.schemeIdUri)) continue;
            return descriptor;
        }
        return null;
    }

    private static boolean hasEventMessageTrack(List<AdaptationSet> adaptationSets, int[] adaptationSetIndices) {
        for (int i : adaptationSetIndices) {
            List<Representation> representations = adaptationSets.get((int)i).representations;
            for (int j = 0; j < representations.size(); ++j) {
                Representation representation = representations.get(j);
                if (representation.inbandEventStreams.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasCea608Track(List<AdaptationSet> adaptationSets, int[] adaptationSetIndices) {
        for (int i : adaptationSetIndices) {
            List<Descriptor> descriptors = adaptationSets.get((int)i).accessibilityDescriptors;
            for (int j = 0; j < descriptors.size(); ++j) {
                Descriptor descriptor = descriptors.get(j);
                if (!"urn:scte:dash:cc:cea-608:2015".equals(descriptor.schemeIdUri)) continue;
                return true;
            }
        }
        return false;
    }

    private static ChunkSampleStream<DashChunkSource>[] newSampleStreamArray(int length) {
        return new ChunkSampleStream[length];
    }

    private static final class TrackGroupInfo {
        private static final int CATEGORY_PRIMARY = 0;
        private static final int CATEGORY_EMBEDDED = 1;
        private static final int CATEGORY_MANIFEST_EVENTS = 2;
        public final int[] adaptationSetIndices;
        public final int trackType;
        public final int trackGroupCategory;
        public final int eventStreamGroupIndex;
        public final int primaryTrackGroupIndex;
        public final int embeddedEventMessageTrackGroupIndex;
        public final int embeddedCea608TrackGroupIndex;

        public static TrackGroupInfo primaryTrack(int trackType, int[] adaptationSetIndices, int primaryTrackGroupIndex, int embeddedEventMessageTrackGroupIndex, int embeddedCea608TrackGroupIndex) {
            return new TrackGroupInfo(trackType, 0, adaptationSetIndices, primaryTrackGroupIndex, embeddedEventMessageTrackGroupIndex, embeddedCea608TrackGroupIndex, -1);
        }

        public static TrackGroupInfo embeddedEmsgTrack(int[] adaptationSetIndices, int primaryTrackGroupIndex) {
            return new TrackGroupInfo(4, 1, adaptationSetIndices, primaryTrackGroupIndex, -1, -1, -1);
        }

        public static TrackGroupInfo embeddedCea608Track(int[] adaptationSetIndices, int primaryTrackGroupIndex) {
            return new TrackGroupInfo(3, 1, adaptationSetIndices, primaryTrackGroupIndex, -1, -1, -1);
        }

        public static TrackGroupInfo mpdEventTrack(int eventStreamIndex) {
            return new TrackGroupInfo(4, 2, null, -1, -1, -1, eventStreamIndex);
        }

        private TrackGroupInfo(int trackType, int trackGroupCategory, int[] adaptationSetIndices, int primaryTrackGroupIndex, int embeddedEventMessageTrackGroupIndex, int embeddedCea608TrackGroupIndex, int eventStreamGroupIndex) {
            this.trackType = trackType;
            this.adaptationSetIndices = adaptationSetIndices;
            this.trackGroupCategory = trackGroupCategory;
            this.primaryTrackGroupIndex = primaryTrackGroupIndex;
            this.embeddedEventMessageTrackGroupIndex = embeddedEventMessageTrackGroupIndex;
            this.embeddedCea608TrackGroupIndex = embeddedCea608TrackGroupIndex;
            this.eventStreamGroupIndex = eventStreamGroupIndex;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TrackGroupCategory {
        }
    }
}

