/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.offline;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.offline.DownloadHelper;
import com.google.android.exoplayer2.offline.TrackKey;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.DashManifestParser;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.RepresentationKey;
import com.google.android.exoplayer2.source.dash.offline.DashDownloadAction;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class DashDownloadHelper
extends DownloadHelper {
    private final Uri uri;
    private final DataSource.Factory manifestDataSourceFactory;
    @MonotonicNonNull
    private DashManifest manifest;

    public DashDownloadHelper(Uri uri, DataSource.Factory manifestDataSourceFactory) {
        this.uri = uri;
        this.manifestDataSourceFactory = manifestDataSourceFactory;
    }

    protected void prepareInternal() throws IOException {
        this.manifest = (DashManifest)ParsingLoadable.load((DataSource)this.manifestDataSourceFactory.createDataSource(), (ParsingLoadable.Parser)new DashManifestParser(), (Uri)this.uri);
    }

    public int getPeriodCount() {
        Assertions.checkNotNull((Object)this.manifest);
        return this.manifest.getPeriodCount();
    }

    public TrackGroupArray getTrackGroups(int periodIndex) {
        Assertions.checkNotNull((Object)this.manifest);
        List<AdaptationSet> adaptationSets = this.manifest.getPeriod((int)periodIndex).adaptationSets;
        TrackGroup[] trackGroups = new TrackGroup[adaptationSets.size()];
        for (int i = 0; i < trackGroups.length; ++i) {
            List<Representation> representations = adaptationSets.get((int)i).representations;
            Format[] formats = new Format[representations.size()];
            int representationsCount = representations.size();
            for (int j = 0; j < representationsCount; ++j) {
                formats[j] = representations.get((int)j).format;
            }
            trackGroups[i] = new TrackGroup(formats);
        }
        return new TrackGroupArray(trackGroups);
    }

    public DashDownloadAction getDownloadAction(@Nullable byte[] data, List<TrackKey> trackKeys) {
        return new DashDownloadAction(this.uri, false, data, DashDownloadHelper.toRepresentationKeys(trackKeys));
    }

    public DashDownloadAction getRemoveAction(@Nullable byte[] data) {
        return new DashDownloadAction(this.uri, true, data, Collections.emptyList());
    }

    private static List<RepresentationKey> toRepresentationKeys(List<TrackKey> trackKeys) {
        ArrayList<RepresentationKey> representationKeys = new ArrayList<RepresentationKey>(trackKeys.size());
        for (int i = 0; i < trackKeys.size(); ++i) {
            TrackKey trackKey = trackKeys.get(i);
            representationKeys.add(new RepresentationKey(trackKey.periodIndex, trackKey.groupIndex, trackKey.trackIndex));
        }
        return representationKeys;
    }
}

