/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.offline;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.offline.DownloadAction;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.SegmentDownloadAction;
import com.google.android.exoplayer2.source.dash.manifest.RepresentationKey;
import com.google.android.exoplayer2.source.dash.offline.DashDownloader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public final class DashDownloadAction
extends SegmentDownloadAction<RepresentationKey> {
    private static final String TYPE = "dash";
    private static final int VERSION = 0;
    public static final DownloadAction.Deserializer DESERIALIZER = new SegmentDownloadAction.SegmentDownloadActionDeserializer<RepresentationKey>("dash", 0){

        protected RepresentationKey readKey(DataInputStream input) throws IOException {
            return new RepresentationKey(input.readInt(), input.readInt(), input.readInt());
        }

        protected DownloadAction createDownloadAction(Uri uri, boolean isRemoveAction, byte[] data, List<RepresentationKey> keys) {
            return new DashDownloadAction(uri, isRemoveAction, data, keys);
        }
    };

    public DashDownloadAction(Uri uri, boolean isRemoveAction, @Nullable byte[] data, List<RepresentationKey> keys) {
        super(TYPE, 0, uri, isRemoveAction, data, keys);
    }

    protected DashDownloader createDownloader(DownloaderConstructorHelper constructorHelper) {
        return new DashDownloader(this.uri, this.keys, constructorHelper);
    }

    protected void writeKey(DataOutputStream output, RepresentationKey key) throws IOException {
        output.writeInt(key.periodIndex);
        output.writeInt(key.adaptationSetIndex);
        output.writeInt(key.representationIndex);
    }
}

