/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public final class RepresentationKey
implements Comparable<RepresentationKey> {
    public final int periodIndex;
    public final int adaptationSetIndex;
    public final int representationIndex;

    public RepresentationKey(int periodIndex, int adaptationSetIndex, int representationIndex) {
        this.periodIndex = periodIndex;
        this.adaptationSetIndex = adaptationSetIndex;
        this.representationIndex = representationIndex;
    }

    public String toString() {
        return this.periodIndex + "." + this.adaptationSetIndex + "." + this.representationIndex;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepresentationKey that = (RepresentationKey)o;
        return this.periodIndex == that.periodIndex && this.adaptationSetIndex == that.adaptationSetIndex && this.representationIndex == that.representationIndex;
    }

    public int hashCode() {
        int result = this.periodIndex;
        result = 31 * result + this.adaptationSetIndex;
        result = 31 * result + this.representationIndex;
        return result;
    }

    @Override
    public int compareTo(@NonNull RepresentationKey o) {
        int result = this.periodIndex - o.periodIndex;
        if (result == 0 && (result = this.adaptationSetIndex - o.adaptationSetIndex) == 0) {
            result = this.representationIndex - o.representationIndex;
        }
        return result;
    }
}

