/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.offline;

import android.net.Uri;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.offline.DownloadException;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.DashUtil;
import com.google.android.exoplayer2.source.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.RepresentationKey;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DashDownloader
extends SegmentDownloader<DashManifest, RepresentationKey> {
    public DashDownloader(Uri manifestUri, DownloaderConstructorHelper constructorHelper) {
        super(manifestUri, constructorHelper);
    }

    public DashManifest getManifest(DataSource dataSource, Uri uri) throws IOException {
        return DashUtil.loadManifest(dataSource, uri);
    }

    protected List<SegmentDownloader.Segment> getAllSegments(DataSource dataSource, DashManifest manifest, boolean allowIndexLoadErrors) throws InterruptedException, IOException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (int periodIndex = 0; periodIndex < manifest.getPeriodCount(); ++periodIndex) {
            List<AdaptationSet> adaptationSets = manifest.getPeriod((int)periodIndex).adaptationSets;
            for (int adaptationIndex = 0; adaptationIndex < adaptationSets.size(); ++adaptationIndex) {
                AdaptationSet adaptationSet = adaptationSets.get(adaptationIndex);
                RepresentationKey[] keys = new RepresentationKey[adaptationSet.representations.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = new RepresentationKey(periodIndex, adaptationIndex, i);
                }
                segments.addAll(this.getSegments(dataSource, manifest, keys, allowIndexLoadErrors));
            }
        }
        return segments;
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, DashManifest manifest, RepresentationKey[] keys, boolean allowIndexLoadErrors) throws InterruptedException, IOException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (RepresentationKey key : keys) {
            RangedUri indexUri;
            DashSegmentIndex index;
            try {
                index = this.getSegmentIndex(dataSource, manifest, key);
                if (index == null) {
                    throw new DownloadException("No index for representation: " + key);
                }
            }
            catch (IOException e) {
                if (allowIndexLoadErrors) continue;
                throw e;
            }
            int segmentCount = index.getSegmentCount(-9223372036854775807L);
            if (segmentCount == -1) {
                throw new DownloadException("Unbounded index for representation: " + key);
            }
            Period period = manifest.getPeriod(key.periodIndex);
            Representation representation = period.adaptationSets.get((int)key.adaptationSetIndex).representations.get(key.representationIndex);
            long startUs = C.msToUs((long)period.startMs);
            String baseUrl = representation.baseUrl;
            RangedUri initializationUri = representation.getInitializationUri();
            if (initializationUri != null) {
                DashDownloader.addSegment(segments, startUs, baseUrl, initializationUri);
            }
            if ((indexUri = representation.getIndexUri()) != null) {
                DashDownloader.addSegment(segments, startUs, baseUrl, indexUri);
            }
            int firstSegmentNum = index.getFirstSegmentNum();
            int lastSegmentNum = firstSegmentNum + segmentCount - 1;
            for (int j = firstSegmentNum; j <= lastSegmentNum; ++j) {
                DashDownloader.addSegment(segments, startUs + index.getTimeUs(j), baseUrl, index.getSegmentUrl(j));
            }
        }
        return segments;
    }

    private DashSegmentIndex getSegmentIndex(DataSource dataSource, DashManifest manifest, RepresentationKey key) throws IOException, InterruptedException {
        AdaptationSet adaptationSet = manifest.getPeriod((int)key.periodIndex).adaptationSets.get(key.adaptationSetIndex);
        Representation representation = adaptationSet.representations.get(key.representationIndex);
        DashSegmentIndex index = representation.getIndex();
        if (index != null) {
            return index;
        }
        ChunkIndex seekMap = DashUtil.loadChunkIndex(dataSource, adaptationSet.type, representation);
        return seekMap == null ? null : new DashWrappingSegmentIndex(seekMap);
    }

    private static void addSegment(ArrayList<SegmentDownloader.Segment> segments, long startTimeUs, String baseUrl, RangedUri rangedUri) {
        DataSpec dataSpec = new DataSpec(rangedUri.resolveUri(baseUrl), rangedUri.start, rangedUri.length, null);
        segments.add(new SegmentDownloader.Segment(startTimeUs, dataSpec));
    }
}

