/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaPeriod;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.DashManifestParser;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DashMediaSource
implements MediaSource {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_PREFER_MANIFEST_MS = -1L;
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_FIXED_MS = 30000L;
    private static final int NOTIFY_MANIFEST_INTERVAL_MS = 5000;
    private static final long MIN_LIVE_DEFAULT_START_POSITION_US = 5000000L;
    private static final String TAG = "DashMediaSource";
    private final boolean sideloadedManifest;
    private final DataSource.Factory manifestDataSourceFactory;
    private final DashChunkSource.Factory chunkSourceFactory;
    private final int minLoadableRetryCount;
    private final long livePresentationDelayMs;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final ParsingLoadable.Parser<? extends DashManifest> manifestParser;
    private final ManifestCallback manifestCallback;
    private final Object manifestUriLock;
    private final SparseArray<DashMediaPeriod> periodsById;
    private final Runnable refreshManifestRunnable;
    private final Runnable simulateManifestRefreshRunnable;
    private MediaSource.Listener sourceListener;
    private DataSource dataSource;
    private Loader loader;
    private LoaderErrorThrower loaderErrorThrower;
    private Uri manifestUri;
    private long manifestLoadStartTimestamp;
    private long manifestLoadEndTimestamp;
    private DashManifest manifest;
    private Handler handler;
    private long elapsedRealtimeOffsetMs;
    private int firstPeriodId;

    @Deprecated
    public DashMediaSource(DashManifest manifest, DashChunkSource.Factory chunkSourceFactory, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifest, chunkSourceFactory, 3, eventHandler, eventListener);
    }

    @Deprecated
    public DashMediaSource(DashManifest manifest, DashChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifest, null, null, null, chunkSourceFactory, minLoadableRetryCount, -1L, eventHandler, eventListener);
    }

    @Deprecated
    public DashMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, DashChunkSource.Factory chunkSourceFactory, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, chunkSourceFactory, 3, -1L, eventHandler, eventListener);
    }

    @Deprecated
    public DashMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, DashChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, new DashManifestParser(), chunkSourceFactory, minLoadableRetryCount, livePresentationDelayMs, eventHandler, eventListener);
    }

    @Deprecated
    public DashMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, ParsingLoadable.Parser<? extends DashManifest> manifestParser, DashChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(null, manifestUri, manifestDataSourceFactory, manifestParser, chunkSourceFactory, minLoadableRetryCount, livePresentationDelayMs, eventHandler, eventListener);
    }

    private DashMediaSource(DashManifest manifest, Uri manifestUri, DataSource.Factory manifestDataSourceFactory, ParsingLoadable.Parser<? extends DashManifest> manifestParser, DashChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, MediaSourceEventListener eventListener) {
        this.manifest = manifest;
        this.manifestUri = manifestUri;
        this.manifestDataSourceFactory = manifestDataSourceFactory;
        this.manifestParser = manifestParser;
        this.chunkSourceFactory = chunkSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.livePresentationDelayMs = livePresentationDelayMs;
        this.sideloadedManifest = manifest != null;
        this.eventDispatcher = new MediaSourceEventListener.EventDispatcher(eventHandler, eventListener);
        this.manifestUriLock = new Object();
        this.periodsById = new SparseArray();
        if (this.sideloadedManifest) {
            Assertions.checkState((!manifest.dynamic ? 1 : 0) != 0);
            this.manifestCallback = null;
            this.refreshManifestRunnable = null;
            this.simulateManifestRefreshRunnable = null;
        } else {
            this.manifestCallback = new ManifestCallback();
            this.refreshManifestRunnable = new Runnable(){

                @Override
                public void run() {
                    DashMediaSource.this.startLoadingManifest();
                }
            };
            this.simulateManifestRefreshRunnable = new Runnable(){

                @Override
                public void run() {
                    DashMediaSource.this.processManifest(false);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceManifestUri(Uri manifestUri) {
        Object object = this.manifestUriLock;
        synchronized (object) {
            this.manifestUri = manifestUri;
        }
    }

    public void prepareSource(ExoPlayer player, boolean isTopLevelSource, MediaSource.Listener listener) {
        this.sourceListener = listener;
        if (this.sideloadedManifest) {
            this.loaderErrorThrower = new LoaderErrorThrower.Dummy();
            this.processManifest(false);
        } else {
            this.dataSource = this.manifestDataSourceFactory.createDataSource();
            this.loader = new Loader("Loader:DashMediaSource");
            this.loaderErrorThrower = this.loader;
            this.handler = new Handler();
            this.startLoadingManifest();
        }
    }

    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.loaderErrorThrower.maybeThrowError();
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId periodId, Allocator allocator) {
        int periodIndex = periodId.periodIndex;
        MediaSourceEventListener.EventDispatcher periodEventDispatcher = this.eventDispatcher.copyWithMediaTimeOffsetMs(this.manifest.getPeriod((int)periodIndex).startMs);
        DashMediaPeriod mediaPeriod = new DashMediaPeriod(this.firstPeriodId + periodIndex, this.manifest, periodIndex, this.chunkSourceFactory, this.minLoadableRetryCount, periodEventDispatcher, this.elapsedRealtimeOffsetMs, this.loaderErrorThrower, allocator);
        this.periodsById.put(mediaPeriod.id, (Object)mediaPeriod);
        return mediaPeriod;
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        DashMediaPeriod dashMediaPeriod = (DashMediaPeriod)mediaPeriod;
        dashMediaPeriod.release();
        this.periodsById.remove(dashMediaPeriod.id);
    }

    public void releaseSource() {
        this.dataSource = null;
        this.loaderErrorThrower = null;
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
        this.manifestLoadStartTimestamp = 0L;
        this.manifestLoadEndTimestamp = 0L;
        this.manifest = null;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
        this.elapsedRealtimeOffsetMs = 0L;
        this.periodsById.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onManifestLoadCompleted(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        int removedPeriodCount;
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        DashManifest newManifest = (DashManifest)loadable.getResult();
        int periodCount = this.manifest == null ? 0 : this.manifest.getPeriodCount();
        long newFirstPeriodStartTimeMs = newManifest.getPeriod((int)0).startMs;
        for (removedPeriodCount = 0; removedPeriodCount < periodCount && this.manifest.getPeriod((int)removedPeriodCount).startMs < newFirstPeriodStartTimeMs; ++removedPeriodCount) {
        }
        if (periodCount - removedPeriodCount > newManifest.getPeriodCount()) {
            Log.w((String)TAG, (String)"Out of sync manifest");
            this.scheduleManifestRefresh();
            return;
        }
        this.manifest = newManifest;
        this.manifestLoadStartTimestamp = elapsedRealtimeMs - loadDurationMs;
        this.manifestLoadEndTimestamp = elapsedRealtimeMs;
        if (this.manifest.location != null) {
            Object object = this.manifestUriLock;
            synchronized (object) {
                if (loadable.dataSpec.uri == this.manifestUri) {
                    this.manifestUri = this.manifest.location;
                }
            }
        }
        if (periodCount == 0) {
            if (this.manifest.utcTiming != null) {
                this.resolveUtcTimingElement(this.manifest.utcTiming);
            } else {
                this.processManifest(true);
            }
        } else {
            this.firstPeriodId += removedPeriodCount;
            this.processManifest(true);
        }
    }

    int onManifestLoadError(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        boolean isFatal = error instanceof ParserException;
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, isFatal);
        return isFatal ? 3 : 0;
    }

    void onUtcTimestampLoadCompleted(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.onUtcTimestampResolved((Long)loadable.getResult() - elapsedRealtimeMs);
    }

    int onUtcTimestampLoadError(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, true);
        this.onUtcTimestampResolutionError(error);
        return 2;
    }

    void onLoadCanceled(ParsingLoadable<?> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingManifest() {
        Uri manifestUri;
        Object object = this.manifestUriLock;
        synchronized (object) {
            manifestUri = this.manifestUri;
        }
        this.startLoading(new ParsingLoadable(this.dataSource, manifestUri, 4, this.manifestParser), this.manifestCallback, this.minLoadableRetryCount);
    }

    private void resolveUtcTimingElement(UtcTimingElement timingElement) {
        String scheme = timingElement.schemeIdUri;
        if (Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:direct:2014") || Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:direct:2012")) {
            this.resolveUtcTimingElementDirect(timingElement);
        } else if (Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-iso:2014") || Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-iso:2012")) {
            this.resolveUtcTimingElementHttp(timingElement, new Iso8601Parser());
        } else if (Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-xsdate:2014") || Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-xsdate:2012")) {
            this.resolveUtcTimingElementHttp(timingElement, new XsDateTimeParser());
        } else {
            this.onUtcTimestampResolutionError(new IOException("Unsupported UTC timing scheme"));
        }
    }

    private void resolveUtcTimingElementDirect(UtcTimingElement timingElement) {
        try {
            long utcTimestamp = Util.parseXsDateTime((String)timingElement.value);
            this.onUtcTimestampResolved(utcTimestamp - this.manifestLoadEndTimestamp);
        }
        catch (ParserException e) {
            this.onUtcTimestampResolutionError((IOException)((Object)e));
        }
    }

    private void resolveUtcTimingElementHttp(UtcTimingElement timingElement, ParsingLoadable.Parser<Long> parser) {
        this.startLoading(new ParsingLoadable(this.dataSource, Uri.parse((String)timingElement.value), 5, parser), new UtcTimestampCallback(), 1);
    }

    private void onUtcTimestampResolved(long elapsedRealtimeOffsetMs) {
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        this.processManifest(true);
    }

    private void onUtcTimestampResolutionError(IOException error) {
        Log.e((String)TAG, (String)"Failed to resolve UtcTiming element.", (Throwable)error);
        this.processManifest(true);
    }

    private void processManifest(boolean scheduleRefresh) {
        for (int i = 0; i < this.periodsById.size(); ++i) {
            int id = this.periodsById.keyAt(i);
            if (id < this.firstPeriodId) continue;
            ((DashMediaPeriod)this.periodsById.valueAt(i)).updateManifest(this.manifest, id - this.firstPeriodId);
        }
        boolean windowChangingImplicitly = false;
        int lastPeriodIndex = this.manifest.getPeriodCount() - 1;
        PeriodSeekInfo firstPeriodSeekInfo = PeriodSeekInfo.createPeriodSeekInfo(this.manifest.getPeriod(0), this.manifest.getPeriodDurationUs(0));
        PeriodSeekInfo lastPeriodSeekInfo = PeriodSeekInfo.createPeriodSeekInfo(this.manifest.getPeriod(lastPeriodIndex), this.manifest.getPeriodDurationUs(lastPeriodIndex));
        long currentStartTimeUs = firstPeriodSeekInfo.availableStartTimeUs;
        long currentEndTimeUs = lastPeriodSeekInfo.availableEndTimeUs;
        if (this.manifest.dynamic && !lastPeriodSeekInfo.isIndexExplicit) {
            long liveStreamDurationUs = this.getNowUnixTimeUs() - C.msToUs((long)this.manifest.availabilityStartTimeMs);
            long liveStreamEndPositionInLastPeriodUs = liveStreamDurationUs - C.msToUs((long)this.manifest.getPeriod((int)lastPeriodIndex).startMs);
            currentEndTimeUs = Math.min(liveStreamEndPositionInLastPeriodUs, currentEndTimeUs);
            if (this.manifest.timeShiftBufferDepthMs != -9223372036854775807L) {
                long offsetInPeriodUs;
                long timeShiftBufferDepthUs = C.msToUs((long)this.manifest.timeShiftBufferDepthMs);
                int periodIndex = lastPeriodIndex;
                for (offsetInPeriodUs = currentEndTimeUs - timeShiftBufferDepthUs; offsetInPeriodUs < 0L && periodIndex > 0; offsetInPeriodUs += this.manifest.getPeriodDurationUs(--periodIndex)) {
                }
                currentStartTimeUs = periodIndex == 0 ? Math.max(currentStartTimeUs, offsetInPeriodUs) : this.manifest.getPeriodDurationUs(0);
            }
            windowChangingImplicitly = true;
        }
        long windowDurationUs = currentEndTimeUs - currentStartTimeUs;
        for (int i = 0; i < this.manifest.getPeriodCount() - 1; ++i) {
            windowDurationUs += this.manifest.getPeriodDurationUs(i);
        }
        long windowDefaultStartPositionUs = 0L;
        if (this.manifest.dynamic) {
            long presentationDelayForManifestMs = this.livePresentationDelayMs;
            if (presentationDelayForManifestMs == -1L) {
                long l = presentationDelayForManifestMs = this.manifest.suggestedPresentationDelayMs != -9223372036854775807L ? this.manifest.suggestedPresentationDelayMs : 30000L;
            }
            if ((windowDefaultStartPositionUs = windowDurationUs - C.msToUs((long)presentationDelayForManifestMs)) < 5000000L) {
                windowDefaultStartPositionUs = Math.min(5000000L, windowDurationUs / 2L);
            }
        }
        long windowStartTimeMs = this.manifest.availabilityStartTimeMs + this.manifest.getPeriod((int)0).startMs + C.usToMs((long)currentStartTimeUs);
        DashTimeline timeline = new DashTimeline(this.manifest.availabilityStartTimeMs, windowStartTimeMs, this.firstPeriodId, currentStartTimeUs, windowDurationUs, windowDefaultStartPositionUs, this.manifest);
        this.sourceListener.onSourceInfoRefreshed((MediaSource)this, (Timeline)timeline, (Object)this.manifest);
        if (!this.sideloadedManifest) {
            this.handler.removeCallbacks(this.simulateManifestRefreshRunnable);
            if (windowChangingImplicitly) {
                this.handler.postDelayed(this.simulateManifestRefreshRunnable, 5000L);
            }
            if (scheduleRefresh) {
                this.scheduleManifestRefresh();
            }
        }
    }

    private void scheduleManifestRefresh() {
        if (!this.manifest.dynamic) {
            return;
        }
        long minUpdatePeriodMs = this.manifest.minUpdatePeriodMs;
        if (minUpdatePeriodMs == 0L) {
            minUpdatePeriodMs = 5000L;
        }
        long nextLoadTimestamp = this.manifestLoadStartTimestamp + minUpdatePeriodMs;
        long delayUntilNextLoad = Math.max(0L, nextLoadTimestamp - SystemClock.elapsedRealtime());
        this.handler.postDelayed(this.refreshManifestRunnable, delayUntilNextLoad);
    }

    private <T> void startLoading(ParsingLoadable<T> loadable, Loader.Callback<ParsingLoadable<T>> callback, int minRetryCount) {
        long elapsedRealtimeMs = this.loader.startLoading(loadable, callback, minRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, elapsedRealtimeMs);
    }

    private long getNowUnixTimeUs() {
        if (this.elapsedRealtimeOffsetMs != 0L) {
            return C.msToUs((long)(SystemClock.elapsedRealtime() + this.elapsedRealtimeOffsetMs));
        }
        return C.msToUs((long)System.currentTimeMillis());
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.dash");
    }

    static final class Iso8601Parser
    implements ParsingLoadable.Parser<Long> {
        private static final Pattern TIMESTAMP_WITH_TIMEZONE_PATTERN = Pattern.compile("(.+?)(Z|((\\+|-|\u2212)(\\d\\d)(:?(\\d\\d))?))");

        Iso8601Parser() {
        }

        public Long parse(Uri uri, InputStream inputStream) throws IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            try {
                Matcher matcher = TIMESTAMP_WITH_TIMEZONE_PATTERN.matcher(firstLine);
                if (!matcher.matches()) {
                    throw new ParserException("Couldn't parse timestamp: " + firstLine);
                }
                String timestampWithoutTimezone = matcher.group(1);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                long timestampMs = format.parse(timestampWithoutTimezone).getTime();
                String timezone = matcher.group(2);
                if (!"Z".equals(timezone)) {
                    long sign = "+".equals(matcher.group(4)) ? 1L : -1L;
                    long hours = Long.parseLong(matcher.group(5));
                    String minutesString = matcher.group(7);
                    long minutes = TextUtils.isEmpty((CharSequence)minutesString) ? 0L : Long.parseLong(minutesString);
                    long timestampOffsetMs = sign * ((hours * 60L + minutes) * 60L * 1000L);
                    timestampMs -= timestampOffsetMs;
                }
                return timestampMs;
            }
            catch (ParseException e) {
                throw new ParserException((Throwable)e);
            }
        }
    }

    private static final class XsDateTimeParser
    implements ParsingLoadable.Parser<Long> {
        private XsDateTimeParser() {
        }

        public Long parse(Uri uri, InputStream inputStream) throws IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            return Util.parseXsDateTime((String)firstLine);
        }
    }

    private final class UtcTimestampCallback
    implements Loader.Callback<ParsingLoadable<Long>> {
        private UtcTimestampCallback() {
        }

        public void onLoadCompleted(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            DashMediaSource.this.onUtcTimestampLoadCompleted(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public void onLoadCanceled(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            DashMediaSource.this.onLoadCanceled(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public int onLoadError(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
            return DashMediaSource.this.onUtcTimestampLoadError(loadable, elapsedRealtimeMs, loadDurationMs, error);
        }
    }

    private final class ManifestCallback
    implements Loader.Callback<ParsingLoadable<DashManifest>> {
        private ManifestCallback() {
        }

        public void onLoadCompleted(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            DashMediaSource.this.onManifestLoadCompleted(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public void onLoadCanceled(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            DashMediaSource.this.onLoadCanceled(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public int onLoadError(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
            return DashMediaSource.this.onManifestLoadError(loadable, elapsedRealtimeMs, loadDurationMs, error);
        }
    }

    private static final class DashTimeline
    extends Timeline {
        private final long presentationStartTimeMs;
        private final long windowStartTimeMs;
        private final int firstPeriodId;
        private final long offsetInFirstPeriodUs;
        private final long windowDurationUs;
        private final long windowDefaultStartPositionUs;
        private final DashManifest manifest;

        public DashTimeline(long presentationStartTimeMs, long windowStartTimeMs, int firstPeriodId, long offsetInFirstPeriodUs, long windowDurationUs, long windowDefaultStartPositionUs, DashManifest manifest) {
            this.presentationStartTimeMs = presentationStartTimeMs;
            this.windowStartTimeMs = windowStartTimeMs;
            this.firstPeriodId = firstPeriodId;
            this.offsetInFirstPeriodUs = offsetInFirstPeriodUs;
            this.windowDurationUs = windowDurationUs;
            this.windowDefaultStartPositionUs = windowDefaultStartPositionUs;
            this.manifest = manifest;
        }

        public int getPeriodCount() {
            return this.manifest.getPeriodCount();
        }

        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIdentifiers) {
            Assertions.checkIndex((int)periodIndex, (int)0, (int)this.manifest.getPeriodCount());
            String id = setIdentifiers ? this.manifest.getPeriod((int)periodIndex).id : null;
            Integer uid = setIdentifiers ? Integer.valueOf(this.firstPeriodId + Assertions.checkIndex((int)periodIndex, (int)0, (int)this.manifest.getPeriodCount())) : null;
            return period.set((Object)id, (Object)uid, 0, this.manifest.getPeriodDurationUs(periodIndex), C.msToUs((long)(this.manifest.getPeriod((int)periodIndex).startMs - this.manifest.getPeriod((int)0).startMs)) - this.offsetInFirstPeriodUs);
        }

        public int getWindowCount() {
            return 1;
        }

        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, boolean setIdentifier, long defaultPositionProjectionUs) {
            Assertions.checkIndex((int)windowIndex, (int)0, (int)1);
            long windowDefaultStartPositionUs = this.getAdjustedWindowDefaultStartPositionUs(defaultPositionProjectionUs);
            return window.set(null, this.presentationStartTimeMs, this.windowStartTimeMs, true, this.manifest.dynamic, windowDefaultStartPositionUs, this.windowDurationUs, 0, this.manifest.getPeriodCount() - 1, this.offsetInFirstPeriodUs);
        }

        public int getIndexOfPeriod(Object uid) {
            if (!(uid instanceof Integer)) {
                return -1;
            }
            int periodId = (Integer)uid;
            return periodId < this.firstPeriodId || periodId >= this.firstPeriodId + this.getPeriodCount() ? -1 : periodId - this.firstPeriodId;
        }

        private long getAdjustedWindowDefaultStartPositionUs(long defaultPositionProjectionUs) {
            long defaultStartPositionInPeriodUs;
            long windowDefaultStartPositionUs = this.windowDefaultStartPositionUs;
            if (!this.manifest.dynamic) {
                return windowDefaultStartPositionUs;
            }
            if (defaultPositionProjectionUs > 0L && (windowDefaultStartPositionUs += defaultPositionProjectionUs) > this.windowDurationUs) {
                return -9223372036854775807L;
            }
            int periodIndex = 0;
            long periodDurationUs = this.manifest.getPeriodDurationUs(periodIndex);
            for (defaultStartPositionInPeriodUs = this.offsetInFirstPeriodUs + windowDefaultStartPositionUs; periodIndex < this.manifest.getPeriodCount() - 1 && defaultStartPositionInPeriodUs >= periodDurationUs; defaultStartPositionInPeriodUs -= periodDurationUs) {
                periodDurationUs = this.manifest.getPeriodDurationUs(++periodIndex);
            }
            Period period = this.manifest.getPeriod(periodIndex);
            int videoAdaptationSetIndex = period.getAdaptationSetIndex(2);
            if (videoAdaptationSetIndex == -1) {
                return windowDefaultStartPositionUs;
            }
            DashSegmentIndex snapIndex = period.adaptationSets.get((int)videoAdaptationSetIndex).representations.get(0).getIndex();
            if (snapIndex == null || snapIndex.getSegmentCount(periodDurationUs) == 0) {
                return windowDefaultStartPositionUs;
            }
            int segmentNum = snapIndex.getSegmentNum(defaultStartPositionInPeriodUs, periodDurationUs);
            return windowDefaultStartPositionUs + snapIndex.getTimeUs(segmentNum) - defaultStartPositionInPeriodUs;
        }
    }

    private static final class PeriodSeekInfo {
        public final boolean isIndexExplicit;
        public final long availableStartTimeUs;
        public final long availableEndTimeUs;

        public static PeriodSeekInfo createPeriodSeekInfo(Period period, long durationUs) {
            int adaptationSetCount = period.adaptationSets.size();
            long availableStartTimeUs = 0L;
            long availableEndTimeUs = Long.MAX_VALUE;
            boolean isIndexExplicit = false;
            boolean seenEmptyIndex = false;
            for (int i = 0; i < adaptationSetCount; ++i) {
                DashSegmentIndex index = period.adaptationSets.get((int)i).representations.get(0).getIndex();
                if (index == null) {
                    return new PeriodSeekInfo(true, 0L, durationUs);
                }
                isIndexExplicit |= index.isExplicit();
                int segmentCount = index.getSegmentCount(durationUs);
                if (segmentCount == 0) {
                    seenEmptyIndex = true;
                    availableStartTimeUs = 0L;
                    availableEndTimeUs = 0L;
                    continue;
                }
                if (seenEmptyIndex) continue;
                int firstSegmentNum = index.getFirstSegmentNum();
                long adaptationSetAvailableStartTimeUs = index.getTimeUs(firstSegmentNum);
                availableStartTimeUs = Math.max(availableStartTimeUs, adaptationSetAvailableStartTimeUs);
                if (segmentCount == -1) continue;
                int lastSegmentNum = firstSegmentNum + segmentCount - 1;
                long adaptationSetAvailableEndTimeUs = index.getTimeUs(lastSegmentNum) + index.getDurationUs(lastSegmentNum, durationUs);
                availableEndTimeUs = Math.min(availableEndTimeUs, adaptationSetAvailableEndTimeUs);
            }
            return new PeriodSeekInfo(isIndexExplicit, availableStartTimeUs, availableEndTimeUs);
        }

        private PeriodSeekInfo(boolean isIndexExplicit, long availableStartTimeUs, long availableEndTimeUs) {
            this.isIndexExplicit = isIndexExplicit;
            this.availableStartTimeUs = availableStartTimeUs;
            this.availableEndTimeUs = availableEndTimeUs;
        }
    }

    public static final class Factory
    implements AdsMediaSource.MediaSourceFactory {
        private final DashChunkSource.Factory chunkSourceFactory;
        @Nullable
        private final DataSource.Factory manifestDataSourceFactory;
        @Nullable
        private ParsingLoadable.Parser<? extends DashManifest> manifestParser;
        private int minLoadableRetryCount;
        private long livePresentationDelayMs;
        private boolean isCreateCalled;

        public Factory(DashChunkSource.Factory chunkSourceFactory, @Nullable DataSource.Factory manifestDataSourceFactory) {
            this.chunkSourceFactory = (DashChunkSource.Factory)Assertions.checkNotNull((Object)chunkSourceFactory);
            this.manifestDataSourceFactory = manifestDataSourceFactory;
            this.minLoadableRetryCount = 3;
            this.livePresentationDelayMs = -1L;
        }

        public Factory setMinLoadableRetryCount(int minLoadableRetryCount) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.minLoadableRetryCount = minLoadableRetryCount;
            return this;
        }

        public Factory setLivePresentationDelayMs(long livePresentationDelayMs) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.livePresentationDelayMs = livePresentationDelayMs;
            return this;
        }

        public Factory setManifestParser(ParsingLoadable.Parser<? extends DashManifest> manifestParser) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.manifestParser = (ParsingLoadable.Parser)Assertions.checkNotNull(manifestParser);
            return this;
        }

        public DashMediaSource createMediaSource(DashManifest manifest, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            Assertions.checkArgument((!manifest.dynamic ? 1 : 0) != 0);
            this.isCreateCalled = true;
            return new DashMediaSource(manifest, null, null, null, this.chunkSourceFactory, this.minLoadableRetryCount, this.livePresentationDelayMs, eventHandler, eventListener);
        }

        public DashMediaSource createMediaSource(Uri manifestUri) {
            return this.createMediaSource(manifestUri, null, null);
        }

        public DashMediaSource createMediaSource(Uri manifestUri, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            this.isCreateCalled = true;
            if (this.manifestParser == null) {
                this.manifestParser = new DashManifestParser();
            }
            return new DashMediaSource(null, (Uri)Assertions.checkNotNull((Object)manifestUri), this.manifestDataSourceFactory, this.manifestParser, this.chunkSourceFactory, this.minLoadableRetryCount, this.livePresentationDelayMs, eventHandler, eventListener);
        }

        public int[] getSupportedTypes() {
            return new int[]{0};
        }
    }
}

