/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.util.Pair;
import android.util.SparseIntArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.CompositeSequenceableLoader;
import com.google.android.exoplayer2.source.EmptySampleStream;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.ChunkSampleStream;
import com.google.android.exoplayer2.source.chunk.ChunkSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Descriptor;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

final class DashMediaPeriod
implements MediaPeriod,
SequenceableLoader.Callback<ChunkSampleStream<DashChunkSource>> {
    final int id;
    private final DashChunkSource.Factory chunkSourceFactory;
    private final int minLoadableRetryCount;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final long elapsedRealtimeOffset;
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final Allocator allocator;
    private final TrackGroupArray trackGroups;
    private final TrackGroupInfo[] trackGroupInfos;
    private MediaPeriod.Callback callback;
    private ChunkSampleStream<DashChunkSource>[] sampleStreams;
    private CompositeSequenceableLoader sequenceableLoader;
    private DashManifest manifest;
    private int periodIndex;

    public DashMediaPeriod(int id, DashManifest manifest, int periodIndex, DashChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, MediaSourceEventListener.EventDispatcher eventDispatcher, long elapsedRealtimeOffset, LoaderErrorThrower manifestLoaderErrorThrower, Allocator allocator) {
        this.id = id;
        this.manifest = manifest;
        this.periodIndex = periodIndex;
        this.chunkSourceFactory = chunkSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.elapsedRealtimeOffset = elapsedRealtimeOffset;
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.allocator = allocator;
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(0);
        this.sequenceableLoader = new CompositeSequenceableLoader(this.sampleStreams);
        Pair<TrackGroupArray, TrackGroupInfo[]> result = DashMediaPeriod.buildTrackGroups(manifest.getPeriod((int)periodIndex).adaptationSets);
        this.trackGroups = (TrackGroupArray)result.first;
        this.trackGroupInfos = (TrackGroupInfo[])result.second;
    }

    public void updateManifest(DashManifest manifest, int periodIndex) {
        this.manifest = manifest;
        this.periodIndex = periodIndex;
        if (this.sampleStreams != null) {
            for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
                ((DashChunkSource)sampleStream.getChunkSource()).updateManifest(manifest, periodIndex);
            }
            this.callback.onContinueLoadingRequested((SequenceableLoader)this);
        }
    }

    public void release() {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.release();
        }
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        callback.onPrepared((MediaPeriod)this);
    }

    public void maybeThrowPrepareError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int i;
        HashMap<Integer, Object> primarySampleStreams = new HashMap<Integer, Object>();
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] instanceof ChunkSampleStream) {
                ChunkSampleStream stream = (ChunkSampleStream)streams[i];
                if (selections[i] == null || !mayRetainStreamFlags[i]) {
                    stream.release();
                    streams[i] = null;
                } else {
                    int trackGroupIndex = this.trackGroups.indexOf(selections[i].getTrackGroup());
                    primarySampleStreams.put(trackGroupIndex, stream);
                }
            }
            if (streams[i] != null || selections[i] == null) continue;
            int trackGroupIndex = this.trackGroups.indexOf(selections[i].getTrackGroup());
            TrackGroupInfo trackGroupInfo = this.trackGroupInfos[trackGroupIndex];
            if (!trackGroupInfo.isPrimary) continue;
            ChunkSampleStream<DashChunkSource> stream = this.buildSampleStream(trackGroupInfo, selections[i], positionUs);
            primarySampleStreams.put(trackGroupIndex, stream);
            streams[i] = stream;
            streamResetFlags[i] = true;
        }
        for (i = 0; i < selections.length; ++i) {
            boolean mayRetainStream;
            if (!(!(streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream) && !(streams[i] instanceof EmptySampleStream) || selections[i] != null && mayRetainStreamFlags[i])) {
                DashMediaPeriod.releaseIfEmbeddedSampleStream(streams[i]);
                streams[i] = null;
            }
            if (selections[i] == null) continue;
            int trackGroupIndex = this.trackGroups.indexOf(selections[i].getTrackGroup());
            TrackGroupInfo trackGroupInfo = this.trackGroupInfos[trackGroupIndex];
            if (trackGroupInfo.isPrimary) continue;
            ChunkSampleStream primaryStream = (ChunkSampleStream)primarySampleStreams.get(trackGroupInfo.primaryTrackGroupIndex);
            SampleStream stream = streams[i];
            boolean bl = primaryStream == null ? stream instanceof EmptySampleStream : (mayRetainStream = stream instanceof ChunkSampleStream.EmbeddedSampleStream && ((ChunkSampleStream.EmbeddedSampleStream)stream).parent == primaryStream);
            if (mayRetainStream) continue;
            DashMediaPeriod.releaseIfEmbeddedSampleStream(stream);
            streams[i] = primaryStream == null ? new EmptySampleStream() : primaryStream.selectEmbeddedTrack(positionUs, trackGroupInfo.trackType);
            streamResetFlags[i] = true;
        }
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(primarySampleStreams.size());
        primarySampleStreams.values().toArray(this.sampleStreams);
        this.sequenceableLoader = new CompositeSequenceableLoader(this.sampleStreams);
        return positionUs;
    }

    public void discardBuffer(long positionUs) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.discardEmbeddedTracksTo(positionUs);
        }
    }

    public boolean continueLoading(long positionUs) {
        return this.sequenceableLoader.continueLoading(positionUs);
    }

    public long getNextLoadPositionUs() {
        return this.sequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        return this.sequenceableLoader.getBufferedPositionUs();
    }

    public long seekToUs(long positionUs) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.seekToUs(positionUs);
        }
        return positionUs;
    }

    public void onContinueLoadingRequested(ChunkSampleStream<DashChunkSource> sampleStream) {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    private static Pair<TrackGroupArray, TrackGroupInfo[]> buildTrackGroups(List<AdaptationSet> adaptationSets) {
        int[][] groupedAdaptationSetIndices = DashMediaPeriod.getGroupedAdaptationSetIndices(adaptationSets);
        int primaryGroupCount = groupedAdaptationSetIndices.length;
        boolean[] primaryGroupHasEventMessageTrackFlags = new boolean[primaryGroupCount];
        boolean[] primaryGroupHasCea608TrackFlags = new boolean[primaryGroupCount];
        int totalGroupCount = primaryGroupCount;
        for (int i = 0; i < primaryGroupCount; ++i) {
            if (DashMediaPeriod.hasEventMessageTrack(adaptationSets, groupedAdaptationSetIndices[i])) {
                primaryGroupHasEventMessageTrackFlags[i] = true;
                ++totalGroupCount;
            }
            if (!DashMediaPeriod.hasCea608Track(adaptationSets, groupedAdaptationSetIndices[i])) continue;
            primaryGroupHasCea608TrackFlags[i] = true;
            ++totalGroupCount;
        }
        TrackGroup[] trackGroups = new TrackGroup[totalGroupCount];
        TrackGroupInfo[] trackGroupInfos = new TrackGroupInfo[totalGroupCount];
        int trackGroupCount = 0;
        for (int i = 0; i < primaryGroupCount; ++i) {
            Format format;
            int[] adaptationSetIndices = groupedAdaptationSetIndices[i];
            ArrayList<Representation> representations = new ArrayList<Representation>();
            for (int adaptationSetIndex : adaptationSetIndices) {
                representations.addAll(adaptationSets.get((int)adaptationSetIndex).representations);
            }
            Format[] formats = new Format[representations.size()];
            for (int j = 0; j < formats.length; ++j) {
                formats[j] = ((Representation)representations.get((int)j)).format;
            }
            AdaptationSet firstAdaptationSet = adaptationSets.get(adaptationSetIndices[0]);
            int primaryTrackGroupIndex = trackGroupCount;
            boolean hasEventMessageTrack = primaryGroupHasEventMessageTrackFlags[i];
            boolean hasCea608Track = primaryGroupHasCea608TrackFlags[i];
            trackGroups[trackGroupCount] = new TrackGroup(formats);
            trackGroupInfos[trackGroupCount++] = new TrackGroupInfo(firstAdaptationSet.type, adaptationSetIndices, primaryTrackGroupIndex, true, hasEventMessageTrack, hasCea608Track);
            if (hasEventMessageTrack) {
                format = Format.createSampleFormat((String)(firstAdaptationSet.id + ":emsg"), (String)"application/x-emsg", null, (int)-1, null);
                trackGroups[trackGroupCount] = new TrackGroup(new Format[]{format});
                trackGroupInfos[trackGroupCount++] = new TrackGroupInfo(4, adaptationSetIndices, primaryTrackGroupIndex, false, false, false);
            }
            if (!hasCea608Track) continue;
            format = Format.createTextSampleFormat((String)(firstAdaptationSet.id + ":cea608"), (String)"application/cea-608", (int)0, null);
            trackGroups[trackGroupCount] = new TrackGroup(new Format[]{format});
            trackGroupInfos[trackGroupCount++] = new TrackGroupInfo(3, adaptationSetIndices, primaryTrackGroupIndex, false, false, false);
        }
        return Pair.create((Object)new TrackGroupArray(trackGroups), (Object)trackGroupInfos);
    }

    private static int[][] getGroupedAdaptationSetIndices(List<AdaptationSet> adaptationSets) {
        int adaptationSetCount = adaptationSets.size();
        SparseIntArray idToIndexMap = new SparseIntArray(adaptationSetCount);
        for (int i = 0; i < adaptationSetCount; ++i) {
            idToIndexMap.put(adaptationSets.get((int)i).id, i);
        }
        int[][] groupedAdaptationSetIndices = new int[adaptationSetCount][];
        boolean[] adaptationSetUsedFlags = new boolean[adaptationSetCount];
        int groupCount = 0;
        for (int i = 0; i < adaptationSetCount; ++i) {
            if (adaptationSetUsedFlags[i]) continue;
            adaptationSetUsedFlags[i] = true;
            Descriptor adaptationSetSwitchingProperty = DashMediaPeriod.findAdaptationSetSwitchingProperty(adaptationSets.get((int)i).supplementalProperties);
            if (adaptationSetSwitchingProperty == null) {
                groupedAdaptationSetIndices[groupCount++] = new int[]{i};
                continue;
            }
            String[] extraAdaptationSetIds = adaptationSetSwitchingProperty.value.split(",");
            int[] adaptationSetIndices = new int[1 + extraAdaptationSetIds.length];
            adaptationSetIndices[0] = i;
            for (int j = 0; j < extraAdaptationSetIds.length; ++j) {
                int extraIndex = idToIndexMap.get(Integer.parseInt(extraAdaptationSetIds[j]));
                adaptationSetUsedFlags[extraIndex] = true;
                adaptationSetIndices[1 + j] = extraIndex;
            }
            groupedAdaptationSetIndices[groupCount++] = adaptationSetIndices;
        }
        return groupCount < adaptationSetCount ? (Object)((int[][])Arrays.copyOf(groupedAdaptationSetIndices, groupCount)) : groupedAdaptationSetIndices;
    }

    private ChunkSampleStream<DashChunkSource> buildSampleStream(TrackGroupInfo trackGroupInfo, TrackSelection selection, long positionUs) {
        boolean enableCea608Track;
        int embeddedTrackCount = 0;
        int[] embeddedTrackTypes = new int[2];
        boolean enableEventMessageTrack = trackGroupInfo.hasEmbeddedEventMessageTrack;
        if (enableEventMessageTrack) {
            embeddedTrackTypes[embeddedTrackCount++] = 4;
        }
        if (enableCea608Track = trackGroupInfo.hasEmbeddedCea608Track) {
            embeddedTrackTypes[embeddedTrackCount++] = 3;
        }
        if (embeddedTrackCount < embeddedTrackTypes.length) {
            embeddedTrackTypes = Arrays.copyOf(embeddedTrackTypes, embeddedTrackCount);
        }
        DashChunkSource chunkSource = this.chunkSourceFactory.createDashChunkSource(this.manifestLoaderErrorThrower, this.manifest, this.periodIndex, trackGroupInfo.adaptationSetIndices, selection, trackGroupInfo.trackType, this.elapsedRealtimeOffset, enableEventMessageTrack, enableCea608Track);
        ChunkSampleStream stream = new ChunkSampleStream(trackGroupInfo.trackType, embeddedTrackTypes, (ChunkSource)chunkSource, (SequenceableLoader.Callback)this, this.allocator, positionUs, this.minLoadableRetryCount, this.eventDispatcher);
        return stream;
    }

    private static Descriptor findAdaptationSetSwitchingProperty(List<Descriptor> descriptors) {
        for (int i = 0; i < descriptors.size(); ++i) {
            Descriptor descriptor = descriptors.get(i);
            if (!"urn:mpeg:dash:adaptation-set-switching:2016".equals(descriptor.schemeIdUri)) continue;
            return descriptor;
        }
        return null;
    }

    private static boolean hasEventMessageTrack(List<AdaptationSet> adaptationSets, int[] adaptationSetIndices) {
        for (int i : adaptationSetIndices) {
            List<Representation> representations = adaptationSets.get((int)i).representations;
            for (int j = 0; j < representations.size(); ++j) {
                Representation representation = representations.get(j);
                if (representation.inbandEventStreams.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasCea608Track(List<AdaptationSet> adaptationSets, int[] adaptationSetIndices) {
        for (int i : adaptationSetIndices) {
            List<Descriptor> descriptors = adaptationSets.get((int)i).accessibilityDescriptors;
            for (int j = 0; j < descriptors.size(); ++j) {
                Descriptor descriptor = descriptors.get(j);
                if (!"urn:scte:dash:cc:cea-608:2015".equals(descriptor.schemeIdUri)) continue;
                return true;
            }
        }
        return false;
    }

    private static ChunkSampleStream<DashChunkSource>[] newSampleStreamArray(int length) {
        return new ChunkSampleStream[length];
    }

    private static void releaseIfEmbeddedSampleStream(SampleStream sampleStream) {
        if (sampleStream instanceof ChunkSampleStream.EmbeddedSampleStream) {
            ((ChunkSampleStream.EmbeddedSampleStream)sampleStream).release();
        }
    }

    private static final class TrackGroupInfo {
        public final int[] adaptationSetIndices;
        public final int trackType;
        public final boolean isPrimary;
        public final int primaryTrackGroupIndex;
        public final boolean hasEmbeddedEventMessageTrack;
        public final boolean hasEmbeddedCea608Track;

        public TrackGroupInfo(int trackType, int[] adaptationSetIndices, int primaryTrackGroupIndex, boolean isPrimary, boolean hasEmbeddedEventMessageTrack, boolean hasEmbeddedCea608Track) {
            this.trackType = trackType;
            this.adaptationSetIndices = adaptationSetIndices;
            this.primaryTrackGroupIndex = primaryTrackGroupIndex;
            this.isPrimary = isPrimary;
            this.hasEmbeddedEventMessageTrack = hasEmbeddedEventMessageTrack;
            this.hasEmbeddedCea608Track = hasEmbeddedCea608Track;
        }
    }
}

