/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.BaseUrl;
import com.google.android.exoplayer2.source.dash.manifest.Descriptor;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.SegmentBase;
import com.google.android.exoplayer2.source.dash.manifest.SingleSegmentIndex;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

@Deprecated
public abstract class Representation {
    public static final long REVISION_ID_DEFAULT = -1L;
    public final long revisionId;
    public final Format format;
    public final ImmutableList<BaseUrl> baseUrls;
    public final long presentationTimeOffsetUs;
    public final List<Descriptor> inbandEventStreams;
    public final List<Descriptor> essentialProperties;
    public final List<Descriptor> supplementalProperties;
    private final RangedUri initializationUri;

    public static Representation newInstance(long revisionId, Format format, List<BaseUrl> baseUrls, SegmentBase segmentBase) {
        return Representation.newInstance(revisionId, format, baseUrls, segmentBase, null, (List<Descriptor>)ImmutableList.of(), (List<Descriptor>)ImmutableList.of(), null);
    }

    public static Representation newInstance(long revisionId, Format format, List<BaseUrl> baseUrls, SegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties, @Nullable String cacheKey) {
        if (segmentBase instanceof SegmentBase.SingleSegmentBase) {
            return new SingleSegmentRepresentation(revisionId, format, baseUrls, (SegmentBase.SingleSegmentBase)segmentBase, inbandEventStreams, essentialProperties, supplementalProperties, cacheKey, -1L);
        }
        if (segmentBase instanceof SegmentBase.MultiSegmentBase) {
            return new MultiSegmentRepresentation(revisionId, format, baseUrls, (SegmentBase.MultiSegmentBase)segmentBase, inbandEventStreams, essentialProperties, supplementalProperties);
        }
        throw new IllegalArgumentException("segmentBase must be of type SingleSegmentBase or MultiSegmentBase");
    }

    private Representation(long revisionId, Format format, List<BaseUrl> baseUrls, SegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties) {
        Assertions.checkArgument((!baseUrls.isEmpty() ? 1 : 0) != 0);
        this.revisionId = revisionId;
        this.format = format;
        this.baseUrls = ImmutableList.copyOf(baseUrls);
        this.inbandEventStreams = inbandEventStreams == null ? Collections.emptyList() : Collections.unmodifiableList(inbandEventStreams);
        this.essentialProperties = essentialProperties;
        this.supplementalProperties = supplementalProperties;
        this.initializationUri = segmentBase.getInitialization(this);
        this.presentationTimeOffsetUs = segmentBase.getPresentationTimeOffsetUs();
    }

    @Nullable
    public RangedUri getInitializationUri() {
        return this.initializationUri;
    }

    @Nullable
    public abstract RangedUri getIndexUri();

    @Nullable
    public abstract DashSegmentIndex getIndex();

    @Nullable
    public abstract String getCacheKey();

    public static class SingleSegmentRepresentation
    extends Representation {
        public final Uri uri;
        public final long contentLength;
        @Nullable
        private final String cacheKey;
        @Nullable
        private final RangedUri indexUri;
        @Nullable
        private final SingleSegmentIndex segmentIndex;

        public static SingleSegmentRepresentation newInstance(long revisionId, Format format, String uri, long initializationStart, long initializationEnd, long indexStart, long indexEnd, List<Descriptor> inbandEventStreams, @Nullable String cacheKey, long contentLength) {
            RangedUri rangedUri = new RangedUri(null, initializationStart, initializationEnd - initializationStart + 1L);
            SegmentBase.SingleSegmentBase segmentBase = new SegmentBase.SingleSegmentBase(rangedUri, 1L, 0L, indexStart, indexEnd - indexStart + 1L);
            ImmutableList baseUrls = ImmutableList.of((Object)new BaseUrl(uri));
            return new SingleSegmentRepresentation(revisionId, format, (List<BaseUrl>)baseUrls, segmentBase, inbandEventStreams, (List<Descriptor>)ImmutableList.of(), (List<Descriptor>)ImmutableList.of(), cacheKey, contentLength);
        }

        public SingleSegmentRepresentation(long revisionId, Format format, List<BaseUrl> baseUrls, SegmentBase.SingleSegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties, @Nullable String cacheKey, long contentLength) {
            super(revisionId, format, baseUrls, segmentBase, inbandEventStreams, essentialProperties, supplementalProperties);
            this.uri = Uri.parse((String)baseUrls.get((int)0).url);
            this.indexUri = segmentBase.getIndex();
            this.cacheKey = cacheKey;
            this.contentLength = contentLength;
            this.segmentIndex = this.indexUri != null ? null : new SingleSegmentIndex(new RangedUri(null, 0L, contentLength));
        }

        @Override
        @Nullable
        public RangedUri getIndexUri() {
            return this.indexUri;
        }

        @Override
        @Nullable
        public DashSegmentIndex getIndex() {
            return this.segmentIndex;
        }

        @Override
        @Nullable
        public String getCacheKey() {
            return this.cacheKey;
        }
    }

    public static class MultiSegmentRepresentation
    extends Representation
    implements DashSegmentIndex {
        @VisibleForTesting
        final SegmentBase.MultiSegmentBase segmentBase;

        public MultiSegmentRepresentation(long revisionId, Format format, List<BaseUrl> baseUrls, SegmentBase.MultiSegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties) {
            super(revisionId, format, baseUrls, segmentBase, inbandEventStreams, essentialProperties, supplementalProperties);
            this.segmentBase = segmentBase;
        }

        @Override
        @Nullable
        public RangedUri getIndexUri() {
            return null;
        }

        @Override
        public DashSegmentIndex getIndex() {
            return this;
        }

        @Override
        @Nullable
        public String getCacheKey() {
            return null;
        }

        @Override
        public RangedUri getSegmentUrl(long segmentNum) {
            return this.segmentBase.getSegmentUrl(this, segmentNum);
        }

        @Override
        public long getSegmentNum(long timeUs, long periodDurationUs) {
            return this.segmentBase.getSegmentNum(timeUs, periodDurationUs);
        }

        @Override
        public long getTimeUs(long segmentNum) {
            return this.segmentBase.getSegmentTimeUs(segmentNum);
        }

        @Override
        public long getDurationUs(long segmentNum, long periodDurationUs) {
            return this.segmentBase.getSegmentDurationUs(segmentNum, periodDurationUs);
        }

        @Override
        public long getFirstSegmentNum() {
            return this.segmentBase.getFirstSegmentNum();
        }

        @Override
        public long getFirstAvailableSegmentNum(long periodDurationUs, long nowUnixTimeUs) {
            return this.segmentBase.getFirstAvailableSegmentNum(periodDurationUs, nowUnixTimeUs);
        }

        @Override
        public long getSegmentCount(long periodDurationUs) {
            return this.segmentBase.getSegmentCount(periodDurationUs);
        }

        @Override
        public long getAvailableSegmentCount(long periodDurationUs, long nowUnixTimeUs) {
            return this.segmentBase.getAvailableSegmentCount(periodDurationUs, nowUnixTimeUs);
        }

        @Override
        public long getNextSegmentAvailableTimeUs(long periodDurationUs, long nowUnixTimeUs) {
            return this.segmentBase.getNextSegmentAvailableTimeUs(periodDurationUs, nowUnixTimeUs);
        }

        @Override
        public boolean isExplicit() {
            return this.segmentBase.isExplicit();
        }
    }
}

