/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.os.SystemClock;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunkIterator;
import com.google.android.exoplayer2.source.chunk.BundledChunkExtractor;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.ChunkExtractor;
import com.google.android.exoplayer2.source.chunk.ChunkHolder;
import com.google.android.exoplayer2.source.chunk.ContainerMediaChunk;
import com.google.android.exoplayer2.source.chunk.InitializationChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.source.chunk.SingleSampleMediaChunk;
import com.google.android.exoplayer2.source.dash.BaseUrlExclusionList;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.DashUtil;
import com.google.android.exoplayer2.source.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer2.source.dash.PlayerEmsgHandler;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.BaseUrl;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.CmcdConfiguration;
import com.google.android.exoplayer2.upstream.CmcdLog;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
public class DefaultDashChunkSource
implements DashChunkSource {
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final BaseUrlExclusionList baseUrlExclusionList;
    private final int[] adaptationSetIndices;
    private final int trackType;
    private final DataSource dataSource;
    private final long elapsedRealtimeOffsetMs;
    private final int maxSegmentsPerLoad;
    @Nullable
    private final PlayerEmsgHandler.PlayerTrackEmsgHandler playerTrackEmsgHandler;
    @Nullable
    private final CmcdConfiguration cmcdConfiguration;
    protected final RepresentationHolder[] representationHolders;
    private ExoTrackSelection trackSelection;
    private DashManifest manifest;
    private int periodIndex;
    @Nullable
    private IOException fatalError;
    private boolean missingLastSegment;

    public DefaultDashChunkSource(ChunkExtractor.Factory chunkExtractorFactory, LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, BaseUrlExclusionList baseUrlExclusionList, int periodIndex, int[] adaptationSetIndices, ExoTrackSelection trackSelection, int trackType, DataSource dataSource, long elapsedRealtimeOffsetMs, int maxSegmentsPerLoad, boolean enableEventMessageTrack, List<Format> closedCaptionFormats, @Nullable PlayerEmsgHandler.PlayerTrackEmsgHandler playerTrackEmsgHandler, PlayerId playerId, @Nullable CmcdConfiguration cmcdConfiguration) {
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.manifest = manifest;
        this.baseUrlExclusionList = baseUrlExclusionList;
        this.adaptationSetIndices = adaptationSetIndices;
        this.trackSelection = trackSelection;
        this.trackType = trackType;
        this.dataSource = dataSource;
        this.periodIndex = periodIndex;
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        this.maxSegmentsPerLoad = maxSegmentsPerLoad;
        this.playerTrackEmsgHandler = playerTrackEmsgHandler;
        this.cmcdConfiguration = cmcdConfiguration;
        long periodDurationUs = manifest.getPeriodDurationUs(periodIndex);
        ArrayList<Representation> representations = this.getRepresentations();
        this.representationHolders = new RepresentationHolder[trackSelection.length()];
        for (int i = 0; i < this.representationHolders.length; ++i) {
            Representation representation = (Representation)representations.get(trackSelection.getIndexInTrackGroup(i));
            BaseUrl selectedBaseUrl = baseUrlExclusionList.selectBaseUrl((List<BaseUrl>)representation.baseUrls);
            this.representationHolders[i] = new RepresentationHolder(periodDurationUs, representation, selectedBaseUrl != null ? selectedBaseUrl : (BaseUrl)representation.baseUrls.get(0), chunkExtractorFactory.createProgressiveMediaExtractor(trackType, representation.format, enableEventMessageTrack, closedCaptionFormats, (TrackOutput)playerTrackEmsgHandler, playerId), 0L, representation.getIndex());
        }
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        for (RepresentationHolder representationHolder : this.representationHolders) {
            long segmentCount;
            if (representationHolder.segmentIndex == null || (segmentCount = representationHolder.getSegmentCount()) == 0L) continue;
            long segmentNum = representationHolder.getSegmentNum(positionUs);
            long firstSyncUs = representationHolder.getSegmentStartTimeUs(segmentNum);
            long secondSyncUs = firstSyncUs < positionUs && (segmentCount == -1L || segmentNum < representationHolder.getFirstSegmentNum() + segmentCount - 1L) ? representationHolder.getSegmentStartTimeUs(segmentNum + 1L) : firstSyncUs;
            return seekParameters.resolveSeekPositionUs(positionUs, firstSyncUs, secondSyncUs);
        }
        return positionUs;
    }

    @Override
    public void updateManifest(DashManifest newManifest, int newPeriodIndex) {
        try {
            this.manifest = newManifest;
            this.periodIndex = newPeriodIndex;
            long periodDurationUs = this.manifest.getPeriodDurationUs(this.periodIndex);
            ArrayList<Representation> representations = this.getRepresentations();
            for (int i = 0; i < this.representationHolders.length; ++i) {
                Representation representation = (Representation)representations.get(this.trackSelection.getIndexInTrackGroup(i));
                this.representationHolders[i] = this.representationHolders[i].copyWithNewRepresentation(periodDurationUs, representation);
            }
        }
        catch (BehindLiveWindowException e) {
            this.fatalError = e;
        }
    }

    @Override
    public void updateTrackSelection(ExoTrackSelection trackSelection) {
        this.trackSelection = trackSelection;
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public int getPreferredQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (this.fatalError != null || this.trackSelection.length() < 2) {
            return queue.size();
        }
        return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
    }

    public boolean shouldCancelLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        if (this.fatalError != null) {
            return false;
        }
        return this.trackSelection.shouldCancelChunkLoad(playbackPositionUs, loadingChunk, queue);
    }

    public void getNextChunk(long playbackPositionUs, long loadPositionUs, List<? extends MediaChunk> queue, ChunkHolder out) {
        int maxSegmentCount;
        long lastAvailableSegmentNum;
        long periodDurationUs;
        boolean periodEnded;
        if (this.fatalError != null) {
            return;
        }
        long bufferedDurationUs = loadPositionUs - playbackPositionUs;
        long presentationPositionUs = Util.msToUs((long)this.manifest.availabilityStartTimeMs) + Util.msToUs((long)this.manifest.getPeriod((int)this.periodIndex).startMs) + loadPositionUs;
        if (this.playerTrackEmsgHandler != null && this.playerTrackEmsgHandler.maybeRefreshManifestBeforeLoadingNextChunk(presentationPositionUs)) {
            return;
        }
        long nowUnixTimeUs = Util.msToUs((long)Util.getNowUnixTimeMs((long)this.elapsedRealtimeOffsetMs));
        long nowPeriodTimeUs = this.getNowPeriodTimeUs(nowUnixTimeUs);
        MediaChunk previous = queue.isEmpty() ? null : queue.get(queue.size() - 1);
        MediaChunkIterator[] chunkIterators = new MediaChunkIterator[this.trackSelection.length()];
        for (int i = 0; i < chunkIterators.length; ++i) {
            long lastAvailableSegmentNum2;
            RepresentationHolder representationHolder = this.representationHolders[i];
            if (representationHolder.segmentIndex == null) {
                chunkIterators[i] = MediaChunkIterator.EMPTY;
                continue;
            }
            long firstAvailableSegmentNum = representationHolder.getFirstAvailableSegmentNum(nowUnixTimeUs);
            long segmentNum = this.getSegmentNum(representationHolder, previous, loadPositionUs, firstAvailableSegmentNum, lastAvailableSegmentNum2 = representationHolder.getLastAvailableSegmentNum(nowUnixTimeUs));
            if (segmentNum < firstAvailableSegmentNum) {
                chunkIterators[i] = MediaChunkIterator.EMPTY;
                continue;
            }
            representationHolder = this.updateSelectedBaseUrl(i);
            chunkIterators[i] = new RepresentationSegmentIterator(representationHolder, segmentNum, lastAvailableSegmentNum2, nowPeriodTimeUs);
        }
        long availableLiveDurationUs = this.getAvailableLiveDurationUs(nowUnixTimeUs, playbackPositionUs);
        this.trackSelection.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, availableLiveDurationUs, queue, chunkIterators);
        RepresentationHolder representationHolder = this.updateSelectedBaseUrl(this.trackSelection.getSelectedIndex());
        if (representationHolder.chunkExtractor != null) {
            Representation selectedRepresentation = representationHolder.representation;
            RangedUri pendingInitializationUri = null;
            RangedUri pendingIndexUri = null;
            if (representationHolder.chunkExtractor.getSampleFormats() == null) {
                pendingInitializationUri = selectedRepresentation.getInitializationUri();
            }
            if (representationHolder.segmentIndex == null) {
                pendingIndexUri = selectedRepresentation.getIndexUri();
            }
            if (pendingInitializationUri != null || pendingIndexUri != null) {
                out.chunk = this.newInitializationChunk(representationHolder, this.dataSource, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), pendingInitializationUri, pendingIndexUri);
                return;
            }
        }
        boolean bl = periodEnded = (periodDurationUs = representationHolder.periodDurationUs) != -9223372036854775807L;
        if (representationHolder.getSegmentCount() == 0L) {
            out.endOfStream = periodEnded;
            return;
        }
        long firstAvailableSegmentNum = representationHolder.getFirstAvailableSegmentNum(nowUnixTimeUs);
        long segmentNum = this.getSegmentNum(representationHolder, previous, loadPositionUs, firstAvailableSegmentNum, lastAvailableSegmentNum = representationHolder.getLastAvailableSegmentNum(nowUnixTimeUs));
        if (segmentNum < firstAvailableSegmentNum) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        if (segmentNum > lastAvailableSegmentNum || this.missingLastSegment && segmentNum >= lastAvailableSegmentNum) {
            out.endOfStream = periodEnded;
            return;
        }
        if (periodEnded && representationHolder.getSegmentStartTimeUs(segmentNum) >= periodDurationUs) {
            out.endOfStream = true;
            return;
        }
        if (periodDurationUs != -9223372036854775807L) {
            for (maxSegmentCount = (int)Math.min((long)this.maxSegmentsPerLoad, lastAvailableSegmentNum - segmentNum + 1L); maxSegmentCount > 1 && representationHolder.getSegmentStartTimeUs(segmentNum + (long)maxSegmentCount - 1L) >= periodDurationUs; --maxSegmentCount) {
            }
        }
        CmcdLog cmcdLog = this.cmcdConfiguration == null ? null : CmcdLog.createInstance((CmcdConfiguration)this.cmcdConfiguration, (ExoTrackSelection)this.trackSelection, (long)playbackPositionUs, (long)loadPositionUs);
        long seekTimeUs = queue.isEmpty() ? loadPositionUs : -9223372036854775807L;
        out.chunk = this.newMediaChunk(representationHolder, this.dataSource, this.trackType, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), segmentNum, maxSegmentCount, seekTimeUs, nowPeriodTimeUs, cmcdLog);
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof InitializationChunk) {
            ChunkIndex chunkIndex;
            InitializationChunk initializationChunk = (InitializationChunk)chunk;
            int trackIndex = this.trackSelection.indexOf(initializationChunk.trackFormat);
            RepresentationHolder representationHolder = this.representationHolders[trackIndex];
            if (representationHolder.segmentIndex == null && (chunkIndex = representationHolder.chunkExtractor.getChunkIndex()) != null) {
                this.representationHolders[trackIndex] = representationHolder.copyWithNewSegmentIndex(new DashWrappingSegmentIndex(chunkIndex, representationHolder.representation.presentationTimeOffsetUs));
            }
        }
        if (this.playerTrackEmsgHandler != null) {
            this.playerTrackEmsgHandler.onChunkLoadCompleted(chunk);
        }
    }

    public boolean onChunkLoadError(Chunk chunk, boolean cancelable, LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo, LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        RepresentationHolder representationHolder;
        long segmentCount;
        if (!cancelable) {
            return false;
        }
        if (this.playerTrackEmsgHandler != null && this.playerTrackEmsgHandler.onChunkLoadError(chunk)) {
            return true;
        }
        if (!this.manifest.dynamic && chunk instanceof MediaChunk && loadErrorInfo.exception instanceof HttpDataSource.InvalidResponseCodeException && ((HttpDataSource.InvalidResponseCodeException)loadErrorInfo.exception).responseCode == 404 && (segmentCount = (representationHolder = this.representationHolders[this.trackSelection.indexOf(chunk.trackFormat)]).getSegmentCount()) != -1L && segmentCount != 0L) {
            long lastAvailableSegmentNum = representationHolder.getFirstSegmentNum() + segmentCount - 1L;
            if (((MediaChunk)chunk).getNextChunkIndex() > lastAvailableSegmentNum) {
                this.missingLastSegment = true;
                return true;
            }
        }
        int trackIndex = this.trackSelection.indexOf(chunk.trackFormat);
        RepresentationHolder representationHolder2 = this.representationHolders[trackIndex];
        BaseUrl newBaseUrl = this.baseUrlExclusionList.selectBaseUrl((List<BaseUrl>)representationHolder2.representation.baseUrls);
        if (newBaseUrl != null && !representationHolder2.selectedBaseUrl.equals(newBaseUrl)) {
            return true;
        }
        LoadErrorHandlingPolicy.FallbackOptions fallbackOptions = this.createFallbackOptions(this.trackSelection, (List<BaseUrl>)representationHolder2.representation.baseUrls);
        if (!fallbackOptions.isFallbackAvailable(2) && !fallbackOptions.isFallbackAvailable(1)) {
            return false;
        }
        LoadErrorHandlingPolicy.FallbackSelection fallbackSelection = loadErrorHandlingPolicy.getFallbackSelectionFor(fallbackOptions, loadErrorInfo);
        if (fallbackSelection == null || !fallbackOptions.isFallbackAvailable(fallbackSelection.type)) {
            return false;
        }
        boolean cancelLoad = false;
        if (fallbackSelection.type == 2) {
            cancelLoad = this.trackSelection.excludeTrack(this.trackSelection.indexOf(chunk.trackFormat), fallbackSelection.exclusionDurationMs);
        } else if (fallbackSelection.type == 1) {
            this.baseUrlExclusionList.exclude(representationHolder2.selectedBaseUrl, fallbackSelection.exclusionDurationMs);
            cancelLoad = true;
        }
        return cancelLoad;
    }

    public void release() {
        for (RepresentationHolder representationHolder : this.representationHolders) {
            ChunkExtractor chunkExtractor = representationHolder.chunkExtractor;
            if (chunkExtractor == null) continue;
            chunkExtractor.release();
        }
    }

    private LoadErrorHandlingPolicy.FallbackOptions createFallbackOptions(ExoTrackSelection trackSelection, List<BaseUrl> baseUrls) {
        long nowMs = SystemClock.elapsedRealtime();
        int numberOfTracks = trackSelection.length();
        int numberOfExcludedTracks = 0;
        for (int i = 0; i < numberOfTracks; ++i) {
            if (!trackSelection.isTrackExcluded(i, nowMs)) continue;
            ++numberOfExcludedTracks;
        }
        int priorityCount = BaseUrlExclusionList.getPriorityCount(baseUrls);
        return new LoadErrorHandlingPolicy.FallbackOptions(priorityCount, priorityCount - this.baseUrlExclusionList.getPriorityCountAfterExclusion(baseUrls), numberOfTracks, numberOfExcludedTracks);
    }

    private long getSegmentNum(RepresentationHolder representationHolder, @Nullable MediaChunk previousChunk, long loadPositionUs, long firstAvailableSegmentNum, long lastAvailableSegmentNum) {
        return previousChunk != null ? previousChunk.getNextChunkIndex() : Util.constrainValue((long)representationHolder.getSegmentNum(loadPositionUs), (long)firstAvailableSegmentNum, (long)lastAvailableSegmentNum);
    }

    private ArrayList<Representation> getRepresentations() {
        List<AdaptationSet> manifestAdaptationSets = this.manifest.getPeriod((int)this.periodIndex).adaptationSets;
        ArrayList<Representation> representations = new ArrayList<Representation>();
        for (int adaptationSetIndex : this.adaptationSetIndices) {
            representations.addAll(manifestAdaptationSets.get((int)adaptationSetIndex).representations);
        }
        return representations;
    }

    private long getAvailableLiveDurationUs(long nowUnixTimeUs, long playbackPositionUs) {
        if (!this.manifest.dynamic || this.representationHolders[0].getSegmentCount() == 0L) {
            return -9223372036854775807L;
        }
        long lastSegmentNum = this.representationHolders[0].getLastAvailableSegmentNum(nowUnixTimeUs);
        long lastSegmentEndTimeUs = this.representationHolders[0].getSegmentEndTimeUs(lastSegmentNum);
        long nowPeriodTimeUs = this.getNowPeriodTimeUs(nowUnixTimeUs);
        long availabilityEndTimeUs = Math.min(nowPeriodTimeUs, lastSegmentEndTimeUs);
        return Math.max(0L, availabilityEndTimeUs - playbackPositionUs);
    }

    private long getNowPeriodTimeUs(long nowUnixTimeUs) {
        return this.manifest.availabilityStartTimeMs == -9223372036854775807L ? -9223372036854775807L : nowUnixTimeUs - Util.msToUs((long)(this.manifest.availabilityStartTimeMs + this.manifest.getPeriod((int)this.periodIndex).startMs));
    }

    protected Chunk newInitializationChunk(RepresentationHolder representationHolder, DataSource dataSource, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, @Nullable RangedUri initializationUri, @Nullable RangedUri indexUri) {
        RangedUri requestUri;
        Representation representation = representationHolder.representation;
        if (initializationUri != null) {
            requestUri = initializationUri.attemptMerge(indexUri, representationHolder.selectedBaseUrl.url);
            if (requestUri == null) {
                requestUri = initializationUri;
            }
        } else {
            requestUri = indexUri;
        }
        DataSpec dataSpec = DashUtil.buildDataSpec(representation, representationHolder.selectedBaseUrl.url, requestUri, 0);
        return new InitializationChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, representationHolder.chunkExtractor);
    }

    protected Chunk newMediaChunk(RepresentationHolder representationHolder, DataSource dataSource, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long firstSegmentNum, int maxSegmentCount, long seekTimeUs, long nowPeriodTimeUs, @Nullable CmcdLog cmcdLog) {
        RangedUri nextSegmentUri;
        RangedUri mergedSegmentUri;
        ImmutableMap httpRequestHeaders;
        Representation representation = representationHolder.representation;
        long startTimeUs = representationHolder.getSegmentStartTimeUs(firstSegmentNum);
        RangedUri segmentUri = representationHolder.getSegmentUrl(firstSegmentNum);
        ImmutableMap immutableMap = httpRequestHeaders = cmcdLog == null ? ImmutableMap.of() : cmcdLog.getHttpRequestHeaders();
        if (representationHolder.chunkExtractor == null) {
            long endTimeUs = representationHolder.getSegmentEndTimeUs(firstSegmentNum);
            int flags = representationHolder.isSegmentAvailableAtFullNetworkSpeed(firstSegmentNum, nowPeriodTimeUs) ? 0 : 8;
            DataSpec dataSpec = DashUtil.buildDataSpec(representation, representationHolder.selectedBaseUrl.url, segmentUri, flags);
            dataSpec = dataSpec.buildUpon().setHttpRequestHeaders((Map)httpRequestHeaders).build();
            return new SingleSampleMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, firstSegmentNum, trackType, trackFormat);
        }
        int segmentCount = 1;
        for (int i = 1; i < maxSegmentCount && (mergedSegmentUri = segmentUri.attemptMerge(nextSegmentUri = representationHolder.getSegmentUrl(firstSegmentNum + (long)i), representationHolder.selectedBaseUrl.url)) != null; ++i) {
            segmentUri = mergedSegmentUri;
            ++segmentCount;
        }
        long segmentNum = firstSegmentNum + (long)segmentCount - 1L;
        long endTimeUs = representationHolder.getSegmentEndTimeUs(segmentNum);
        long periodDurationUs = representationHolder.periodDurationUs;
        long clippedEndTimeUs = periodDurationUs != -9223372036854775807L && periodDurationUs <= endTimeUs ? periodDurationUs : -9223372036854775807L;
        int flags = representationHolder.isSegmentAvailableAtFullNetworkSpeed(segmentNum, nowPeriodTimeUs) ? 0 : 8;
        DataSpec dataSpec = DashUtil.buildDataSpec(representation, representationHolder.selectedBaseUrl.url, segmentUri, flags);
        dataSpec = dataSpec.buildUpon().setHttpRequestHeaders((Map)httpRequestHeaders).build();
        long sampleOffsetUs = -representation.presentationTimeOffsetUs;
        return new ContainerMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, seekTimeUs, clippedEndTimeUs, firstSegmentNum, segmentCount, sampleOffsetUs, representationHolder.chunkExtractor);
    }

    private RepresentationHolder updateSelectedBaseUrl(int trackIndex) {
        RepresentationHolder representationHolder = this.representationHolders[trackIndex];
        BaseUrl selectedBaseUrl = this.baseUrlExclusionList.selectBaseUrl((List<BaseUrl>)representationHolder.representation.baseUrls);
        if (selectedBaseUrl != null && !selectedBaseUrl.equals(representationHolder.selectedBaseUrl)) {
            this.representationHolders[trackIndex] = representationHolder = representationHolder.copyWithNewSelectedBaseUrl(selectedBaseUrl);
        }
        return representationHolder;
    }

    protected static final class RepresentationHolder {
        @Nullable
        final ChunkExtractor chunkExtractor;
        public final Representation representation;
        public final BaseUrl selectedBaseUrl;
        @Nullable
        public final DashSegmentIndex segmentIndex;
        private final long periodDurationUs;
        private final long segmentNumShift;

        RepresentationHolder(long periodDurationUs, Representation representation, BaseUrl selectedBaseUrl, @Nullable ChunkExtractor chunkExtractor, long segmentNumShift, @Nullable DashSegmentIndex segmentIndex) {
            this.periodDurationUs = periodDurationUs;
            this.representation = representation;
            this.selectedBaseUrl = selectedBaseUrl;
            this.segmentNumShift = segmentNumShift;
            this.chunkExtractor = chunkExtractor;
            this.segmentIndex = segmentIndex;
        }

        @CheckResult
        RepresentationHolder copyWithNewRepresentation(long newPeriodDurationUs, Representation newRepresentation) throws BehindLiveWindowException {
            DashSegmentIndex oldIndex = this.representation.getIndex();
            DashSegmentIndex newIndex = newRepresentation.getIndex();
            if (oldIndex == null) {
                return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.selectedBaseUrl, this.chunkExtractor, this.segmentNumShift, oldIndex);
            }
            if (!oldIndex.isExplicit()) {
                return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.selectedBaseUrl, this.chunkExtractor, this.segmentNumShift, newIndex);
            }
            long oldIndexSegmentCount = oldIndex.getSegmentCount(newPeriodDurationUs);
            if (oldIndexSegmentCount == 0L) {
                return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.selectedBaseUrl, this.chunkExtractor, this.segmentNumShift, newIndex);
            }
            long oldIndexFirstSegmentNum = oldIndex.getFirstSegmentNum();
            long oldIndexStartTimeUs = oldIndex.getTimeUs(oldIndexFirstSegmentNum);
            long oldIndexLastSegmentNum = oldIndexFirstSegmentNum + oldIndexSegmentCount - 1L;
            long oldIndexEndTimeUs = oldIndex.getTimeUs(oldIndexLastSegmentNum) + oldIndex.getDurationUs(oldIndexLastSegmentNum, newPeriodDurationUs);
            long newIndexFirstSegmentNum = newIndex.getFirstSegmentNum();
            long newIndexStartTimeUs = newIndex.getTimeUs(newIndexFirstSegmentNum);
            long newSegmentNumShift = this.segmentNumShift;
            if (oldIndexEndTimeUs == newIndexStartTimeUs) {
                newSegmentNumShift += oldIndexLastSegmentNum + 1L - newIndexFirstSegmentNum;
            } else {
                if (oldIndexEndTimeUs < newIndexStartTimeUs) {
                    throw new BehindLiveWindowException();
                }
                newSegmentNumShift = newIndexStartTimeUs < oldIndexStartTimeUs ? (newSegmentNumShift -= newIndex.getSegmentNum(oldIndexStartTimeUs, newPeriodDurationUs) - oldIndexFirstSegmentNum) : (newSegmentNumShift += oldIndex.getSegmentNum(newIndexStartTimeUs, newPeriodDurationUs) - newIndexFirstSegmentNum);
            }
            return new RepresentationHolder(newPeriodDurationUs, newRepresentation, this.selectedBaseUrl, this.chunkExtractor, newSegmentNumShift, newIndex);
        }

        @CheckResult
        RepresentationHolder copyWithNewSegmentIndex(DashSegmentIndex segmentIndex) {
            return new RepresentationHolder(this.periodDurationUs, this.representation, this.selectedBaseUrl, this.chunkExtractor, this.segmentNumShift, segmentIndex);
        }

        @CheckResult
        RepresentationHolder copyWithNewSelectedBaseUrl(BaseUrl selectedBaseUrl) {
            return new RepresentationHolder(this.periodDurationUs, this.representation, selectedBaseUrl, this.chunkExtractor, this.segmentNumShift, this.segmentIndex);
        }

        public long getFirstSegmentNum() {
            return this.segmentIndex.getFirstSegmentNum() + this.segmentNumShift;
        }

        public long getFirstAvailableSegmentNum(long nowUnixTimeUs) {
            return this.segmentIndex.getFirstAvailableSegmentNum(this.periodDurationUs, nowUnixTimeUs) + this.segmentNumShift;
        }

        public long getSegmentCount() {
            return this.segmentIndex.getSegmentCount(this.periodDurationUs);
        }

        public long getSegmentStartTimeUs(long segmentNum) {
            return this.segmentIndex.getTimeUs(segmentNum - this.segmentNumShift);
        }

        public long getSegmentEndTimeUs(long segmentNum) {
            return this.getSegmentStartTimeUs(segmentNum) + this.segmentIndex.getDurationUs(segmentNum - this.segmentNumShift, this.periodDurationUs);
        }

        public long getSegmentNum(long positionUs) {
            return this.segmentIndex.getSegmentNum(positionUs, this.periodDurationUs) + this.segmentNumShift;
        }

        public RangedUri getSegmentUrl(long segmentNum) {
            return this.segmentIndex.getSegmentUrl(segmentNum - this.segmentNumShift);
        }

        public long getLastAvailableSegmentNum(long nowUnixTimeUs) {
            return this.getFirstAvailableSegmentNum(nowUnixTimeUs) + this.segmentIndex.getAvailableSegmentCount(this.periodDurationUs, nowUnixTimeUs) - 1L;
        }

        public boolean isSegmentAvailableAtFullNetworkSpeed(long segmentNum, long nowPeriodTimeUs) {
            if (this.segmentIndex.isExplicit()) {
                return true;
            }
            return nowPeriodTimeUs == -9223372036854775807L || this.getSegmentEndTimeUs(segmentNum) <= nowPeriodTimeUs;
        }
    }

    protected static final class RepresentationSegmentIterator
    extends BaseMediaChunkIterator {
        private final RepresentationHolder representationHolder;
        private final long nowPeriodTimeUs;

        public RepresentationSegmentIterator(RepresentationHolder representation, long firstAvailableSegmentNum, long lastAvailableSegmentNum, long nowPeriodTimeUs) {
            super(firstAvailableSegmentNum, lastAvailableSegmentNum);
            this.representationHolder = representation;
            this.nowPeriodTimeUs = nowPeriodTimeUs;
        }

        public DataSpec getDataSpec() {
            this.checkInBounds();
            long currentIndex = this.getCurrentIndex();
            RangedUri segmentUri = this.representationHolder.getSegmentUrl(currentIndex);
            int flags = this.representationHolder.isSegmentAvailableAtFullNetworkSpeed(currentIndex, this.nowPeriodTimeUs) ? 0 : 8;
            return DashUtil.buildDataSpec(this.representationHolder.representation, this.representationHolder.selectedBaseUrl.url, segmentUri, flags);
        }

        public long getChunkStartTimeUs() {
            this.checkInBounds();
            return this.representationHolder.getSegmentStartTimeUs(this.getCurrentIndex());
        }

        public long getChunkEndTimeUs() {
            this.checkInBounds();
            return this.representationHolder.getSegmentEndTimeUs(this.getCurrentIndex());
        }
    }

    public static final class Factory
    implements DashChunkSource.Factory {
        private final DataSource.Factory dataSourceFactory;
        private final int maxSegmentsPerLoad;
        private final ChunkExtractor.Factory chunkExtractorFactory;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(dataSourceFactory, 1);
        }

        public Factory(DataSource.Factory dataSourceFactory, int maxSegmentsPerLoad) {
            this(BundledChunkExtractor.FACTORY, dataSourceFactory, maxSegmentsPerLoad);
        }

        public Factory(ChunkExtractor.Factory chunkExtractorFactory, DataSource.Factory dataSourceFactory, int maxSegmentsPerLoad) {
            this.chunkExtractorFactory = chunkExtractorFactory;
            this.dataSourceFactory = dataSourceFactory;
            this.maxSegmentsPerLoad = maxSegmentsPerLoad;
        }

        @Override
        public DashChunkSource createDashChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, BaseUrlExclusionList baseUrlExclusionList, int periodIndex, int[] adaptationSetIndices, ExoTrackSelection trackSelection, int trackType, long elapsedRealtimeOffsetMs, boolean enableEventMessageTrack, List<Format> closedCaptionFormats, @Nullable PlayerEmsgHandler.PlayerTrackEmsgHandler playerEmsgHandler, @Nullable TransferListener transferListener, PlayerId playerId, @Nullable CmcdConfiguration cmcdConfiguration) {
            DataSource dataSource = this.dataSourceFactory.createDataSource();
            if (transferListener != null) {
                dataSource.addTransferListener(transferListener);
            }
            return new DefaultDashChunkSource(this.chunkExtractorFactory, manifestLoaderErrorThrower, manifest, baseUrlExclusionList, periodIndex, adaptationSetIndices, trackSelection, trackType, dataSource, elapsedRealtimeOffsetMs, this.maxSegmentsPerLoad, enableEventMessageTrack, closedCaptionFormats, playerEmsgHandler, playerId, cmcdConfiguration);
        }
    }
}

