/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import android.util.Xml;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Descriptor;
import com.google.android.exoplayer2.source.dash.manifest.EventStream;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.ProgramInformation;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.SegmentBase;
import com.google.android.exoplayer2.source.dash.manifest.ServiceDescriptionElement;
import com.google.android.exoplayer2.source.dash.manifest.UrlTemplate;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.util.XmlPullParserUtil;
import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class DashManifestParser
extends DefaultHandler
implements ParsingLoadable.Parser<DashManifest> {
    private static final String TAG = "MpdParser";
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("(\\d+)(?:/(\\d+))?");
    private static final Pattern CEA_608_ACCESSIBILITY_PATTERN = Pattern.compile("CC([1-4])=.*");
    private static final Pattern CEA_708_ACCESSIBILITY_PATTERN = Pattern.compile("([1-9]|[1-5][0-9]|6[0-3])=.*");
    private static final int[] MPEG_CHANNEL_CONFIGURATION_MAPPING = new int[]{-1, 1, 2, 3, 4, 5, 6, 8, 2, 3, 4, 7, 8, 24, 8, 12, 10, 12, 14, 12, 14};
    private final XmlPullParserFactory xmlParserFactory;

    public DashManifestParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    public DashManifest parse(Uri uri, InputStream inputStream) throws IOException {
        try {
            XmlPullParser xpp = this.xmlParserFactory.newPullParser();
            xpp.setInput(inputStream, null);
            int eventType = xpp.next();
            if (eventType != 2 || !"MPD".equals(xpp.getName())) {
                throw new ParserException("inputStream does not contain a valid media presentation description");
            }
            return this.parseMediaPresentationDescription(xpp, uri.toString());
        }
        catch (XmlPullParserException e) {
            throw new ParserException((Throwable)e);
        }
    }

    protected DashManifest parseMediaPresentationDescription(XmlPullParser xpp, String baseUrl) throws XmlPullParserException, IOException {
        long availabilityStartTime = DashManifestParser.parseDateTime(xpp, "availabilityStartTime", -9223372036854775807L);
        long durationMs = DashManifestParser.parseDuration(xpp, "mediaPresentationDuration", -9223372036854775807L);
        long minBufferTimeMs = DashManifestParser.parseDuration(xpp, "minBufferTime", -9223372036854775807L);
        String typeString = xpp.getAttributeValue(null, "type");
        boolean dynamic = "dynamic".equals(typeString);
        long minUpdateTimeMs = dynamic ? DashManifestParser.parseDuration(xpp, "minimumUpdatePeriod", -9223372036854775807L) : -9223372036854775807L;
        long timeShiftBufferDepthMs = dynamic ? DashManifestParser.parseDuration(xpp, "timeShiftBufferDepth", -9223372036854775807L) : -9223372036854775807L;
        long suggestedPresentationDelayMs = dynamic ? DashManifestParser.parseDuration(xpp, "suggestedPresentationDelay", -9223372036854775807L) : -9223372036854775807L;
        long publishTimeMs = DashManifestParser.parseDateTime(xpp, "publishTime", -9223372036854775807L);
        ProgramInformation programInformation = null;
        UtcTimingElement utcTiming = null;
        Uri location = null;
        ServiceDescriptionElement serviceDescription = null;
        long baseUrlAvailabilityTimeOffsetUs = dynamic ? 0L : -9223372036854775807L;
        ArrayList<Period> periods = new ArrayList<Period>();
        long nextPeriodStartMs = dynamic ? -9223372036854775807L : 0L;
        boolean seenEarlyAccessPeriod = false;
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrlAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, baseUrlAvailabilityTimeOffsetUs);
                baseUrl = this.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ProgramInformation")) {
                programInformation = this.parseProgramInformation(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"UTCTiming")) {
                utcTiming = this.parseUtcTiming(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Location")) {
                location = Uri.parse((String)xpp.nextText());
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ServiceDescription")) {
                serviceDescription = this.parseServiceDescription(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Period") && !seenEarlyAccessPeriod) {
                Pair<Period, Long> periodWithDurationMs = this.parsePeriod(xpp, baseUrl, nextPeriodStartMs, baseUrlAvailabilityTimeOffsetUs, availabilityStartTime, timeShiftBufferDepthMs);
                Period period = (Period)periodWithDurationMs.first;
                if (period.startMs == -9223372036854775807L) {
                    if (dynamic) {
                        seenEarlyAccessPeriod = true;
                        continue;
                    }
                    int n = periods.size();
                    throw new ParserException(new StringBuilder(47).append("Unable to determine start of period ").append(n).toString());
                }
                long periodDurationMs = (Long)periodWithDurationMs.second;
                nextPeriodStartMs = periodDurationMs == -9223372036854775807L ? -9223372036854775807L : period.startMs + periodDurationMs;
                periods.add(period);
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"MPD"));
        if (durationMs == -9223372036854775807L) {
            if (nextPeriodStartMs != -9223372036854775807L) {
                durationMs = nextPeriodStartMs;
            } else if (!dynamic) {
                throw new ParserException("Unable to determine duration of static manifest.");
            }
        }
        if (periods.isEmpty()) {
            throw new ParserException("No periods found.");
        }
        return this.buildMediaPresentationDescription(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, suggestedPresentationDelayMs, publishTimeMs, programInformation, utcTiming, serviceDescription, location, periods);
    }

    protected DashManifest buildMediaPresentationDescription(long availabilityStartTime, long durationMs, long minBufferTimeMs, boolean dynamic, long minUpdateTimeMs, long timeShiftBufferDepthMs, long suggestedPresentationDelayMs, long publishTimeMs, @Nullable ProgramInformation programInformation, @Nullable UtcTimingElement utcTiming, @Nullable ServiceDescriptionElement serviceDescription, @Nullable Uri location, List<Period> periods) {
        return new DashManifest(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, suggestedPresentationDelayMs, publishTimeMs, programInformation, utcTiming, serviceDescription, location, periods);
    }

    protected UtcTimingElement parseUtcTiming(XmlPullParser xpp) {
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        String value = xpp.getAttributeValue(null, "value");
        return this.buildUtcTimingElement(schemeIdUri, value);
    }

    protected UtcTimingElement buildUtcTimingElement(String schemeIdUri, String value) {
        return new UtcTimingElement(schemeIdUri, value);
    }

    protected ServiceDescriptionElement parseServiceDescription(XmlPullParser xpp) throws XmlPullParserException, IOException {
        long targetOffsetMs = -9223372036854775807L;
        long minOffsetMs = -9223372036854775807L;
        long maxOffsetMs = -9223372036854775807L;
        float minPlaybackSpeed = -3.4028235E38f;
        float maxPlaybackSpeed = -3.4028235E38f;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Latency")) {
                targetOffsetMs = DashManifestParser.parseLong(xpp, "target", -9223372036854775807L);
                minOffsetMs = DashManifestParser.parseLong(xpp, "min", -9223372036854775807L);
                maxOffsetMs = DashManifestParser.parseLong(xpp, "max", -9223372036854775807L);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"PlaybackRate")) continue;
            minPlaybackSpeed = DashManifestParser.parseFloat(xpp, "min", -3.4028235E38f);
            maxPlaybackSpeed = DashManifestParser.parseFloat(xpp, "max", -3.4028235E38f);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"ServiceDescription"));
        return new ServiceDescriptionElement(targetOffsetMs, minOffsetMs, maxOffsetMs, minPlaybackSpeed, maxPlaybackSpeed);
    }

    protected Pair<Period, Long> parsePeriod(XmlPullParser xpp, String baseUrl, long defaultStartMs, long baseUrlAvailabilityTimeOffsetUs, long availabilityStartTimeMs, long timeShiftBufferDepthMs) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        long startMs = DashManifestParser.parseDuration(xpp, "start", defaultStartMs);
        long periodStartUnixTimeMs = availabilityStartTimeMs != -9223372036854775807L ? availabilityStartTimeMs + startMs : -9223372036854775807L;
        long durationMs = DashManifestParser.parseDuration(xpp, "duration", -9223372036854775807L);
        SegmentBase segmentBase = null;
        Descriptor assetIdentifier = null;
        ArrayList<AdaptationSet> adaptationSets = new ArrayList<AdaptationSet>();
        ArrayList<EventStream> eventStreams = new ArrayList<EventStream>();
        boolean seenFirstBaseUrl = false;
        long segmentBaseAvailabilityTimeOffsetUs = -9223372036854775807L;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrlAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, baseUrlAvailabilityTimeOffsetUs);
                baseUrl = this.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"AdaptationSet")) {
                adaptationSets.add(this.parseAdaptationSet(xpp, baseUrl, segmentBase, durationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, periodStartUnixTimeMs, timeShiftBufferDepthMs));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"EventStream")) {
                eventStreams.add(this.parseEventStream(xpp));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, null);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentList")) {
                segmentBaseAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, -9223372036854775807L);
                segmentBase = this.parseSegmentList(xpp, null, periodStartUnixTimeMs, durationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, timeShiftBufferDepthMs);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTemplate")) {
                segmentBaseAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, -9223372036854775807L);
                segmentBase = this.parseSegmentTemplate(xpp, null, (List<Descriptor>)ImmutableList.of(), periodStartUnixTimeMs, durationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, timeShiftBufferDepthMs);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"AssetIdentifier")) {
                assetIdentifier = DashManifestParser.parseDescriptor(xpp, "AssetIdentifier");
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"Period"));
        return Pair.create((Object)this.buildPeriod(id, startMs, adaptationSets, eventStreams, assetIdentifier), (Object)durationMs);
    }

    protected Period buildPeriod(@Nullable String id, long startMs, List<AdaptationSet> adaptationSets, List<EventStream> eventStreams, @Nullable Descriptor assetIdentifier) {
        return new Period(id, startMs, adaptationSets, eventStreams, assetIdentifier);
    }

    protected AdaptationSet parseAdaptationSet(XmlPullParser xpp, String baseUrl, @Nullable SegmentBase segmentBase, long periodDurationMs, long baseUrlAvailabilityTimeOffsetUs, long segmentBaseAvailabilityTimeOffsetUs, long periodStartUnixTimeMs, long timeShiftBufferDepthMs) throws XmlPullParserException, IOException {
        int id = DashManifestParser.parseInt(xpp, "id", -1);
        int contentType = this.parseContentType(xpp);
        String mimeType = xpp.getAttributeValue(null, "mimeType");
        String codecs = xpp.getAttributeValue(null, "codecs");
        int width = DashManifestParser.parseInt(xpp, "width", -1);
        int height = DashManifestParser.parseInt(xpp, "height", -1);
        float frameRate = DashManifestParser.parseFrameRate(xpp, -1.0f);
        int audioChannels = -1;
        int audioSamplingRate = DashManifestParser.parseInt(xpp, "audioSamplingRate", -1);
        String language = xpp.getAttributeValue(null, "lang");
        String label = xpp.getAttributeValue(null, "label");
        String drmSchemeType = null;
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = new ArrayList<DrmInitData.SchemeData>();
        ArrayList<Descriptor> inbandEventStreams = new ArrayList<Descriptor>();
        ArrayList<Descriptor> accessibilityDescriptors = new ArrayList<Descriptor>();
        ArrayList<Descriptor> roleDescriptors = new ArrayList<Descriptor>();
        ArrayList<Descriptor> essentialProperties = new ArrayList<Descriptor>();
        ArrayList<Descriptor> supplementalProperties = new ArrayList<Descriptor>();
        ArrayList<RepresentationInfo> representationInfos = new ArrayList<RepresentationInfo>();
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrlAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, baseUrlAvailabilityTimeOffsetUs);
                baseUrl = this.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ContentProtection")) {
                Pair<String, DrmInitData.SchemeData> contentProtection = this.parseContentProtection(xpp);
                if (contentProtection.first != null) {
                    drmSchemeType = (String)contentProtection.first;
                }
                if (contentProtection.second == null) continue;
                drmSchemeDatas.add((DrmInitData.SchemeData)contentProtection.second);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ContentComponent")) {
                language = DashManifestParser.checkLanguageConsistency(language, xpp.getAttributeValue(null, "lang"));
                contentType = DashManifestParser.checkContentTypeConsistency(contentType, this.parseContentType(xpp));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Role")) {
                roleDescriptors.add(DashManifestParser.parseDescriptor(xpp, "Role"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Accessibility")) {
                accessibilityDescriptors.add(DashManifestParser.parseDescriptor(xpp, "Accessibility"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"EssentialProperty")) {
                essentialProperties.add(DashManifestParser.parseDescriptor(xpp, "EssentialProperty"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SupplementalProperty")) {
                supplementalProperties.add(DashManifestParser.parseDescriptor(xpp, "SupplementalProperty"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Representation")) {
                RepresentationInfo representationInfo = this.parseRepresentation(xpp, baseUrl, mimeType, codecs, width, height, frameRate, audioChannels, audioSamplingRate, language, roleDescriptors, accessibilityDescriptors, essentialProperties, supplementalProperties, segmentBase, periodStartUnixTimeMs, periodDurationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, timeShiftBufferDepthMs);
                contentType = DashManifestParser.checkContentTypeConsistency(contentType, MimeTypes.getTrackType((String)representationInfo.format.sampleMimeType));
                representationInfos.add(representationInfo);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentList")) {
                segmentBaseAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, segmentBaseAvailabilityTimeOffsetUs);
                segmentBase = this.parseSegmentList(xpp, (SegmentBase.SegmentList)segmentBase, periodStartUnixTimeMs, periodDurationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, timeShiftBufferDepthMs);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTemplate")) {
                segmentBaseAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, segmentBaseAvailabilityTimeOffsetUs);
                segmentBase = this.parseSegmentTemplate(xpp, (SegmentBase.SegmentTemplate)segmentBase, supplementalProperties, periodStartUnixTimeMs, periodDurationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, timeShiftBufferDepthMs);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"InbandEventStream")) {
                inbandEventStreams.add(DashManifestParser.parseDescriptor(xpp, "InbandEventStream"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Label")) {
                label = this.parseLabel(xpp);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp)) continue;
            this.parseAdaptationSetChild(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"AdaptationSet"));
        ArrayList<Representation> representations = new ArrayList<Representation>(representationInfos.size());
        for (int i = 0; i < representationInfos.size(); ++i) {
            representations.add(this.buildRepresentation((RepresentationInfo)representationInfos.get(i), label, drmSchemeType, drmSchemeDatas, inbandEventStreams));
        }
        return this.buildAdaptationSet(id, contentType, representations, accessibilityDescriptors, essentialProperties, supplementalProperties);
    }

    protected AdaptationSet buildAdaptationSet(int id, int contentType, List<Representation> representations, List<Descriptor> accessibilityDescriptors, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties) {
        return new AdaptationSet(id, contentType, representations, accessibilityDescriptors, essentialProperties, supplementalProperties);
    }

    protected int parseContentType(XmlPullParser xpp) {
        String contentType = xpp.getAttributeValue(null, "contentType");
        return TextUtils.isEmpty((CharSequence)contentType) ? -1 : ("audio".equals(contentType) ? 1 : ("video".equals(contentType) ? 2 : ("text".equals(contentType) ? 3 : -1)));
    }

    protected Pair<@NullableType String, // Could not load outer class - annotation placement on inner may be incorrect
    @NullableType DrmInitData.SchemeData> parseContentProtection(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeType = null;
        String licenseServerUrl = null;
        byte[] data = null;
        UUID uuid = null;
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        if (schemeIdUri != null) {
            switch (Ascii.toLowerCase((String)schemeIdUri)) {
                case "urn:mpeg:dash:mp4protection:2011": {
                    schemeType = xpp.getAttributeValue(null, "value");
                    String defaultKid = XmlPullParserUtil.getAttributeValueIgnorePrefix((XmlPullParser)xpp, (String)"default_KID");
                    if (TextUtils.isEmpty((CharSequence)defaultKid) || "00000000-0000-0000-0000-000000000000".equals(defaultKid)) break;
                    String[] defaultKidStrings = defaultKid.split("\\s+");
                    UUID[] defaultKids = new UUID[defaultKidStrings.length];
                    for (int i = 0; i < defaultKidStrings.length; ++i) {
                        defaultKids[i] = UUID.fromString(defaultKidStrings[i]);
                    }
                    data = PsshAtomUtil.buildPsshAtom((UUID)C.COMMON_PSSH_UUID, (UUID[])defaultKids, null);
                    uuid = C.COMMON_PSSH_UUID;
                    break;
                }
                case "urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95": {
                    uuid = C.PLAYREADY_UUID;
                    break;
                }
                case "urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed": {
                    uuid = C.WIDEVINE_UUID;
                    break;
                }
            }
        }
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ms:laurl")) {
                licenseServerUrl = xpp.getAttributeValue(null, "licenseUrl");
                continue;
            }
            if (data == null && XmlPullParserUtil.isStartTagIgnorePrefix((XmlPullParser)xpp, (String)"pssh") && xpp.next() == 4) {
                data = Base64.decode((String)xpp.getText(), (int)0);
                uuid = PsshAtomUtil.parseUuid((byte[])data);
                if (uuid != null) continue;
                Log.w((String)TAG, (String)"Skipping malformed cenc:pssh data");
                data = null;
                continue;
            }
            if (data == null && C.PLAYREADY_UUID.equals(uuid) && XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"mspr:pro") && xpp.next() == 4) {
                data = PsshAtomUtil.buildPsshAtom((UUID)C.PLAYREADY_UUID, (byte[])Base64.decode((String)xpp.getText(), (int)0));
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"ContentProtection"));
        DrmInitData.SchemeData schemeData = uuid != null ? new DrmInitData.SchemeData(uuid, licenseServerUrl, "video/mp4", data) : null;
        return Pair.create((Object)schemeType, (Object)schemeData);
    }

    protected void parseAdaptationSetChild(XmlPullParser xpp) throws XmlPullParserException, IOException {
        DashManifestParser.maybeSkipTag(xpp);
    }

    protected RepresentationInfo parseRepresentation(XmlPullParser xpp, String baseUrl, @Nullable String adaptationSetMimeType, @Nullable String adaptationSetCodecs, int adaptationSetWidth, int adaptationSetHeight, float adaptationSetFrameRate, int adaptationSetAudioChannels, int adaptationSetAudioSamplingRate, @Nullable String adaptationSetLanguage, List<Descriptor> adaptationSetRoleDescriptors, List<Descriptor> adaptationSetAccessibilityDescriptors, List<Descriptor> adaptationSetEssentialProperties, List<Descriptor> adaptationSetSupplementalProperties, @Nullable SegmentBase segmentBase, long periodStartUnixTimeMs, long periodDurationMs, long baseUrlAvailabilityTimeOffsetUs, long segmentBaseAvailabilityTimeOffsetUs, long timeShiftBufferDepthMs) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        int bandwidth = DashManifestParser.parseInt(xpp, "bandwidth", -1);
        String mimeType = DashManifestParser.parseString(xpp, "mimeType", adaptationSetMimeType);
        String codecs = DashManifestParser.parseString(xpp, "codecs", adaptationSetCodecs);
        int width = DashManifestParser.parseInt(xpp, "width", adaptationSetWidth);
        int height = DashManifestParser.parseInt(xpp, "height", adaptationSetHeight);
        float frameRate = DashManifestParser.parseFrameRate(xpp, adaptationSetFrameRate);
        int audioChannels = adaptationSetAudioChannels;
        int audioSamplingRate = DashManifestParser.parseInt(xpp, "audioSamplingRate", adaptationSetAudioSamplingRate);
        String drmSchemeType = null;
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = new ArrayList<DrmInitData.SchemeData>();
        ArrayList<Descriptor> inbandEventStreams = new ArrayList<Descriptor>();
        ArrayList<Descriptor> essentialProperties = new ArrayList<Descriptor>(adaptationSetEssentialProperties);
        ArrayList<Descriptor> supplementalProperties = new ArrayList<Descriptor>(adaptationSetSupplementalProperties);
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrlAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, baseUrlAvailabilityTimeOffsetUs);
                baseUrl = this.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentList")) {
                segmentBaseAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, segmentBaseAvailabilityTimeOffsetUs);
                segmentBase = this.parseSegmentList(xpp, (SegmentBase.SegmentList)segmentBase, periodStartUnixTimeMs, periodDurationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, timeShiftBufferDepthMs);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTemplate")) {
                segmentBaseAvailabilityTimeOffsetUs = this.parseAvailabilityTimeOffsetUs(xpp, segmentBaseAvailabilityTimeOffsetUs);
                segmentBase = this.parseSegmentTemplate(xpp, (SegmentBase.SegmentTemplate)segmentBase, adaptationSetSupplementalProperties, periodStartUnixTimeMs, periodDurationMs, baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs, timeShiftBufferDepthMs);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ContentProtection")) {
                Pair<String, DrmInitData.SchemeData> contentProtection = this.parseContentProtection(xpp);
                if (contentProtection.first != null) {
                    drmSchemeType = (String)contentProtection.first;
                }
                if (contentProtection.second == null) continue;
                drmSchemeDatas.add((DrmInitData.SchemeData)contentProtection.second);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"InbandEventStream")) {
                inbandEventStreams.add(DashManifestParser.parseDescriptor(xpp, "InbandEventStream"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"EssentialProperty")) {
                essentialProperties.add(DashManifestParser.parseDescriptor(xpp, "EssentialProperty"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SupplementalProperty")) {
                supplementalProperties.add(DashManifestParser.parseDescriptor(xpp, "SupplementalProperty"));
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"Representation"));
        Format format = this.buildFormat(id, mimeType, width, height, frameRate, audioChannels, audioSamplingRate, bandwidth, adaptationSetLanguage, adaptationSetRoleDescriptors, adaptationSetAccessibilityDescriptors, codecs, essentialProperties, supplementalProperties);
        segmentBase = segmentBase != null ? segmentBase : new SegmentBase.SingleSegmentBase();
        return new RepresentationInfo(format, baseUrl, segmentBase, drmSchemeType, drmSchemeDatas, inbandEventStreams, -1L);
    }

    protected Format buildFormat(@Nullable String id, @Nullable String containerMimeType, int width, int height, float frameRate, int audioChannels, int audioSamplingRate, int bitrate, @Nullable String language, List<Descriptor> roleDescriptors, List<Descriptor> accessibilityDescriptors, @Nullable String codecs, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties) {
        String sampleMimeType = DashManifestParser.getSampleMimeType(containerMimeType, codecs);
        if ("audio/eac3".equals(sampleMimeType) && "audio/eac3-joc".equals(sampleMimeType = DashManifestParser.parseEac3SupplementalProperties(supplementalProperties))) {
            codecs = "ec+3";
        }
        int selectionFlags = this.parseSelectionFlagsFromRoleDescriptors(roleDescriptors);
        int roleFlags = this.parseRoleFlagsFromRoleDescriptors(roleDescriptors);
        roleFlags |= this.parseRoleFlagsFromAccessibilityDescriptors(accessibilityDescriptors);
        roleFlags |= this.parseRoleFlagsFromProperties(essentialProperties);
        Format.Builder formatBuilder = new Format.Builder().setId(id).setContainerMimeType(containerMimeType).setSampleMimeType(sampleMimeType).setCodecs(codecs).setPeakBitrate(bitrate).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags |= this.parseRoleFlagsFromProperties(supplementalProperties)).setLanguage(language);
        if (MimeTypes.isVideo((String)sampleMimeType)) {
            formatBuilder.setWidth(width).setHeight(height).setFrameRate(frameRate);
        } else if (MimeTypes.isAudio((String)sampleMimeType)) {
            formatBuilder.setChannelCount(audioChannels).setSampleRate(audioSamplingRate);
        } else if (MimeTypes.isText((String)sampleMimeType)) {
            int accessibilityChannel = -1;
            if ("application/cea-608".equals(sampleMimeType)) {
                accessibilityChannel = DashManifestParser.parseCea608AccessibilityChannel(accessibilityDescriptors);
            } else if ("application/cea-708".equals(sampleMimeType)) {
                accessibilityChannel = DashManifestParser.parseCea708AccessibilityChannel(accessibilityDescriptors);
            }
            formatBuilder.setAccessibilityChannel(accessibilityChannel);
        }
        return formatBuilder.build();
    }

    protected Representation buildRepresentation(RepresentationInfo representationInfo, @Nullable String label, @Nullable String extraDrmSchemeType, ArrayList<DrmInitData.SchemeData> extraDrmSchemeDatas, ArrayList<Descriptor> extraInbandEventStreams) {
        String drmSchemeType;
        Format.Builder formatBuilder = representationInfo.format.buildUpon();
        if (label != null) {
            formatBuilder.setLabel(label);
        }
        if ((drmSchemeType = representationInfo.drmSchemeType) == null) {
            drmSchemeType = extraDrmSchemeType;
        }
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = representationInfo.drmSchemeDatas;
        drmSchemeDatas.addAll(extraDrmSchemeDatas);
        if (!drmSchemeDatas.isEmpty()) {
            DashManifestParser.filterRedundantIncompleteSchemeDatas(drmSchemeDatas);
            formatBuilder.setDrmInitData(new DrmInitData(drmSchemeType, drmSchemeDatas));
        }
        ArrayList<Descriptor> inbandEventStreams = representationInfo.inbandEventStreams;
        inbandEventStreams.addAll(extraInbandEventStreams);
        return Representation.newInstance(representationInfo.revisionId, formatBuilder.build(), representationInfo.baseUrl, representationInfo.segmentBase, inbandEventStreams);
    }

    protected SegmentBase.SingleSegmentBase parseSegmentBase(XmlPullParser xpp, @Nullable SegmentBase.SingleSegmentBase parent) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long indexStart = parent != null ? parent.indexStart : 0L;
        long indexLength = parent != null ? parent.indexLength : 0L;
        String indexRangeText = xpp.getAttributeValue(null, "indexRange");
        if (indexRangeText != null) {
            String[] indexRange = indexRangeText.split("-");
            indexStart = Long.parseLong(indexRange[0]);
            indexLength = Long.parseLong(indexRange[1]) - indexStart + 1L;
        }
        RangedUri initialization = parent != null ? parent.initialization : null;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Initialization")) {
                initialization = this.parseInitialization(xpp);
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentBase"));
        return this.buildSingleSegmentBase(initialization, timescale, presentationTimeOffset, indexStart, indexLength);
    }

    protected SegmentBase.SingleSegmentBase buildSingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, long indexStart, long indexLength) {
        return new SegmentBase.SingleSegmentBase(initialization, timescale, presentationTimeOffset, indexStart, indexLength);
    }

    protected SegmentBase.SegmentList parseSegmentList(XmlPullParser xpp, @Nullable SegmentBase.SegmentList parent, long periodStartUnixTimeMs, long periodDurationMs, long baseUrlAvailabilityTimeOffsetUs, long segmentBaseAvailabilityTimeOffsetUs, long timeShiftBufferDepthMs) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", parent != null ? parent.duration : -9223372036854775807L);
        long startNumber = DashManifestParser.parseLong(xpp, "startNumber", parent != null ? parent.startNumber : 1L);
        long availabilityTimeOffsetUs = DashManifestParser.getFinalAvailabilityTimeOffset(baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs);
        RangedUri initialization = null;
        List timeline = null;
        ArrayList<RangedUri> segments = null;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Initialization")) {
                initialization = this.parseInitialization(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTimeline")) {
                timeline = this.parseSegmentTimeline(xpp, timescale, periodDurationMs);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentURL")) {
                if (segments == null) {
                    segments = new ArrayList<RangedUri>();
                }
                segments.add(this.parseSegmentUrl(xpp));
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentList"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
            segments = segments != null ? segments : parent.mediaSegments;
        }
        return this.buildSegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, availabilityTimeOffsetUs, segments, timeShiftBufferDepthMs, periodStartUnixTimeMs);
    }

    protected SegmentBase.SegmentList buildSegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, @Nullable List<SegmentBase.SegmentTimelineElement> timeline, long availabilityTimeOffsetUs, @Nullable List<RangedUri> segments, long timeShiftBufferDepthMs, long periodStartUnixTimeMs) {
        return new SegmentBase.SegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, availabilityTimeOffsetUs, segments, C.msToUs((long)timeShiftBufferDepthMs), C.msToUs((long)periodStartUnixTimeMs));
    }

    protected SegmentBase.SegmentTemplate parseSegmentTemplate(XmlPullParser xpp, @Nullable SegmentBase.SegmentTemplate parent, List<Descriptor> adaptationSetSupplementalProperties, long periodStartUnixTimeMs, long periodDurationMs, long baseUrlAvailabilityTimeOffsetUs, long segmentBaseAvailabilityTimeOffsetUs, long timeShiftBufferDepthMs) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", parent != null ? parent.duration : -9223372036854775807L);
        long startNumber = DashManifestParser.parseLong(xpp, "startNumber", parent != null ? parent.startNumber : 1L);
        long endNumber = DashManifestParser.parseLastSegmentNumberSupplementalProperty(adaptationSetSupplementalProperties);
        long availabilityTimeOffsetUs = DashManifestParser.getFinalAvailabilityTimeOffset(baseUrlAvailabilityTimeOffsetUs, segmentBaseAvailabilityTimeOffsetUs);
        UrlTemplate mediaTemplate = this.parseUrlTemplate(xpp, "media", parent != null ? parent.mediaTemplate : null);
        UrlTemplate initializationTemplate = this.parseUrlTemplate(xpp, "initialization", parent != null ? parent.initializationTemplate : null);
        RangedUri initialization = null;
        List timeline = null;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Initialization")) {
                initialization = this.parseInitialization(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTimeline")) {
                timeline = this.parseSegmentTimeline(xpp, timescale, periodDurationMs);
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentTemplate"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
        }
        return this.buildSegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, endNumber, duration, timeline, availabilityTimeOffsetUs, initializationTemplate, mediaTemplate, timeShiftBufferDepthMs, periodStartUnixTimeMs);
    }

    protected SegmentBase.SegmentTemplate buildSegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long endNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, long availabilityTimeOffsetUs, @Nullable UrlTemplate initializationTemplate, @Nullable UrlTemplate mediaTemplate, long timeShiftBufferDepthMs, long periodStartUnixTimeMs) {
        return new SegmentBase.SegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, endNumber, duration, timeline, availabilityTimeOffsetUs, initializationTemplate, mediaTemplate, C.msToUs((long)timeShiftBufferDepthMs), C.msToUs((long)periodStartUnixTimeMs));
    }

    protected EventStream parseEventStream(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", "");
        String value = DashManifestParser.parseString(xpp, "value", "");
        long timescale = DashManifestParser.parseLong(xpp, "timescale", 1L);
        ArrayList<Pair<Long, EventMessage>> eventMessages = new ArrayList<Pair<Long, EventMessage>>();
        ByteArrayOutputStream scratchOutputStream = new ByteArrayOutputStream(512);
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Event")) {
                Pair<Long, EventMessage> event = this.parseEvent(xpp, schemeIdUri, value, timescale, scratchOutputStream);
                eventMessages.add(event);
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"EventStream"));
        long[] presentationTimesUs = new long[eventMessages.size()];
        EventMessage[] events = new EventMessage[eventMessages.size()];
        for (int i = 0; i < eventMessages.size(); ++i) {
            Pair event = (Pair)eventMessages.get(i);
            presentationTimesUs[i] = (Long)event.first;
            events[i] = (EventMessage)event.second;
        }
        return this.buildEventStream(schemeIdUri, value, timescale, presentationTimesUs, events);
    }

    protected EventStream buildEventStream(String schemeIdUri, String value, long timescale, long[] presentationTimesUs, EventMessage[] events) {
        return new EventStream(schemeIdUri, value, timescale, presentationTimesUs, events);
    }

    protected Pair<Long, EventMessage> parseEvent(XmlPullParser xpp, String schemeIdUri, String value, long timescale, ByteArrayOutputStream scratchOutputStream) throws IOException, XmlPullParserException {
        long id = DashManifestParser.parseLong(xpp, "id", 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", -9223372036854775807L);
        long presentationTime = DashManifestParser.parseLong(xpp, "presentationTime", 0L);
        long durationMs = Util.scaleLargeTimestamp((long)duration, (long)1000L, (long)timescale);
        long presentationTimesUs = Util.scaleLargeTimestamp((long)presentationTime, (long)1000000L, (long)timescale);
        String messageData = DashManifestParser.parseString(xpp, "messageData", null);
        byte[] eventObject = this.parseEventObject(xpp, scratchOutputStream);
        return Pair.create((Object)presentationTimesUs, (Object)this.buildEvent(schemeIdUri, value, id, durationMs, messageData == null ? eventObject : Util.getUtf8Bytes((String)messageData)));
    }

    protected byte[] parseEventObject(XmlPullParser xpp, ByteArrayOutputStream scratchOutputStream) throws XmlPullParserException, IOException {
        scratchOutputStream.reset();
        XmlSerializer xmlSerializer = Xml.newSerializer();
        xmlSerializer.setOutput((OutputStream)scratchOutputStream, Charsets.UTF_8.name());
        xpp.nextToken();
        while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"Event")) {
            switch (xpp.getEventType()) {
                case 0: {
                    xmlSerializer.startDocument(null, Boolean.valueOf(false));
                    break;
                }
                case 1: {
                    xmlSerializer.endDocument();
                    break;
                }
                case 2: {
                    xmlSerializer.startTag(xpp.getNamespace(), xpp.getName());
                    for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                        xmlSerializer.attribute(xpp.getAttributeNamespace(i), xpp.getAttributeName(i), xpp.getAttributeValue(i));
                    }
                    break;
                }
                case 3: {
                    xmlSerializer.endTag(xpp.getNamespace(), xpp.getName());
                    break;
                }
                case 4: {
                    xmlSerializer.text(xpp.getText());
                    break;
                }
                case 5: {
                    xmlSerializer.cdsect(xpp.getText());
                    break;
                }
                case 6: {
                    xmlSerializer.entityRef(xpp.getText());
                    break;
                }
                case 7: {
                    xmlSerializer.ignorableWhitespace(xpp.getText());
                    break;
                }
                case 8: {
                    xmlSerializer.processingInstruction(xpp.getText());
                    break;
                }
                case 9: {
                    xmlSerializer.comment(xpp.getText());
                    break;
                }
                case 10: {
                    xmlSerializer.docdecl(xpp.getText());
                    break;
                }
            }
            xpp.nextToken();
        }
        xmlSerializer.flush();
        return scratchOutputStream.toByteArray();
    }

    protected EventMessage buildEvent(String schemeIdUri, String value, long id, long durationMs, byte[] messageData) {
        return new EventMessage(schemeIdUri, value, durationMs, id, messageData);
    }

    protected List<SegmentBase.SegmentTimelineElement> parseSegmentTimeline(XmlPullParser xpp, long timescale, long periodDurationMs) throws XmlPullParserException, IOException {
        ArrayList<SegmentBase.SegmentTimelineElement> segmentTimeline = new ArrayList<SegmentBase.SegmentTimelineElement>();
        long startTime = 0L;
        long elementDuration = -9223372036854775807L;
        int elementRepeatCount = 0;
        boolean havePreviousTimelineElement = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"S")) {
                long newStartTime = DashManifestParser.parseLong(xpp, "t", -9223372036854775807L);
                if (havePreviousTimelineElement) {
                    startTime = this.addSegmentTimelineElementsToList(segmentTimeline, startTime, elementDuration, elementRepeatCount, newStartTime);
                }
                if (newStartTime != -9223372036854775807L) {
                    startTime = newStartTime;
                }
                elementDuration = DashManifestParser.parseLong(xpp, "d", -9223372036854775807L);
                elementRepeatCount = DashManifestParser.parseInt(xpp, "r", 0);
                havePreviousTimelineElement = true;
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentTimeline"));
        if (havePreviousTimelineElement) {
            long periodDuration = Util.scaleLargeTimestamp((long)periodDurationMs, (long)timescale, (long)1000L);
            this.addSegmentTimelineElementsToList(segmentTimeline, startTime, elementDuration, elementRepeatCount, periodDuration);
        }
        return segmentTimeline;
    }

    private long addSegmentTimelineElementsToList(List<SegmentBase.SegmentTimelineElement> segmentTimeline, long startTime, long elementDuration, int elementRepeatCount, long endTime) {
        int count = elementRepeatCount >= 0 ? 1 + elementRepeatCount : (int)Util.ceilDivide((long)(endTime - startTime), (long)elementDuration);
        for (int i = 0; i < count; ++i) {
            segmentTimeline.add(this.buildSegmentTimelineElement(startTime, elementDuration));
            startTime += elementDuration;
        }
        return startTime;
    }

    protected SegmentBase.SegmentTimelineElement buildSegmentTimelineElement(long startTime, long duration) {
        return new SegmentBase.SegmentTimelineElement(startTime, duration);
    }

    @Nullable
    protected UrlTemplate parseUrlTemplate(XmlPullParser xpp, String name, @Nullable UrlTemplate defaultValue) {
        String valueString = xpp.getAttributeValue(null, name);
        if (valueString != null) {
            return UrlTemplate.compile(valueString);
        }
        return defaultValue;
    }

    protected RangedUri parseInitialization(XmlPullParser xpp) {
        return this.parseRangedUrl(xpp, "sourceURL", "range");
    }

    protected RangedUri parseSegmentUrl(XmlPullParser xpp) {
        return this.parseRangedUrl(xpp, "media", "mediaRange");
    }

    protected RangedUri parseRangedUrl(XmlPullParser xpp, String urlAttribute, String rangeAttribute) {
        String urlText = xpp.getAttributeValue(null, urlAttribute);
        long rangeStart = 0L;
        long rangeLength = -1L;
        String rangeText = xpp.getAttributeValue(null, rangeAttribute);
        if (rangeText != null) {
            String[] rangeTextArray = rangeText.split("-");
            rangeStart = Long.parseLong(rangeTextArray[0]);
            if (rangeTextArray.length == 2) {
                rangeLength = Long.parseLong(rangeTextArray[1]) - rangeStart + 1L;
            }
        }
        return this.buildRangedUri(urlText, rangeStart, rangeLength);
    }

    protected RangedUri buildRangedUri(String urlText, long rangeStart, long rangeLength) {
        return new RangedUri(urlText, rangeStart, rangeLength);
    }

    protected ProgramInformation parseProgramInformation(XmlPullParser xpp) throws IOException, XmlPullParserException {
        String title = null;
        String source = null;
        String copyright = null;
        String moreInformationURL = DashManifestParser.parseString(xpp, "moreInformationURL", null);
        String lang = DashManifestParser.parseString(xpp, "lang", null);
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Title")) {
                title = xpp.nextText();
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Source")) {
                source = xpp.nextText();
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Copyright")) {
                copyright = xpp.nextText();
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"ProgramInformation"));
        return new ProgramInformation(title, source, copyright, moreInformationURL, lang);
    }

    protected String parseLabel(XmlPullParser xpp) throws XmlPullParserException, IOException {
        return DashManifestParser.parseText(xpp, "Label");
    }

    protected String parseBaseUrl(XmlPullParser xpp, String parentBaseUrl) throws XmlPullParserException, IOException {
        return UriUtil.resolve((String)parentBaseUrl, (String)DashManifestParser.parseText(xpp, "BaseURL"));
    }

    protected long parseAvailabilityTimeOffsetUs(XmlPullParser xpp, long parentAvailabilityTimeOffsetUs) {
        String value = xpp.getAttributeValue(null, "availabilityTimeOffset");
        if (value == null) {
            return parentAvailabilityTimeOffsetUs;
        }
        if ("INF".equals(value)) {
            return Long.MAX_VALUE;
        }
        return (long)(Float.parseFloat(value) * 1000000.0f);
    }

    protected int parseAudioChannelConfiguration(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int audioChannels;
        String schemeIdUri;
        switch (schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", null)) {
            case "urn:mpeg:dash:23003:3:audio_channel_configuration:2011": {
                audioChannels = DashManifestParser.parseInt(xpp, "value", -1);
                break;
            }
            case "urn:mpeg:mpegB:cicp:ChannelConfiguration": {
                audioChannels = DashManifestParser.parseMpegChannelConfiguration(xpp);
                break;
            }
            case "tag:dolby.com,2014:dash:audio_channel_configuration:2011": 
            case "urn:dolby:dash:audio_channel_configuration:2011": {
                audioChannels = DashManifestParser.parseDolbyChannelConfiguration(xpp);
                break;
            }
            default: {
                audioChannels = -1;
            }
        }
        do {
            xpp.next();
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"AudioChannelConfiguration"));
        return audioChannels;
    }

    protected int parseSelectionFlagsFromRoleDescriptors(List<Descriptor> roleDescriptors) {
        int result = 0;
        for (int i = 0; i < roleDescriptors.size(); ++i) {
            Descriptor descriptor = roleDescriptors.get(i);
            if (!Ascii.equalsIgnoreCase((CharSequence)"urn:mpeg:dash:role:2011", (CharSequence)descriptor.schemeIdUri)) continue;
            result |= this.parseSelectionFlagsFromDashRoleScheme(descriptor.value);
        }
        return result;
    }

    protected int parseSelectionFlagsFromDashRoleScheme(@Nullable String value) {
        if (value == null) {
            return 0;
        }
        switch (value) {
            case "main": {
                return 1;
            }
            case "forced_subtitle": {
                return 2;
            }
        }
        return 0;
    }

    protected int parseRoleFlagsFromRoleDescriptors(List<Descriptor> roleDescriptors) {
        int result = 0;
        for (int i = 0; i < roleDescriptors.size(); ++i) {
            Descriptor descriptor = roleDescriptors.get(i);
            if (!Ascii.equalsIgnoreCase((CharSequence)"urn:mpeg:dash:role:2011", (CharSequence)descriptor.schemeIdUri)) continue;
            result |= this.parseRoleFlagsFromDashRoleScheme(descriptor.value);
        }
        return result;
    }

    protected int parseRoleFlagsFromAccessibilityDescriptors(List<Descriptor> accessibilityDescriptors) {
        int result = 0;
        for (int i = 0; i < accessibilityDescriptors.size(); ++i) {
            Descriptor descriptor = accessibilityDescriptors.get(i);
            if (Ascii.equalsIgnoreCase((CharSequence)"urn:mpeg:dash:role:2011", (CharSequence)descriptor.schemeIdUri)) {
                result |= this.parseRoleFlagsFromDashRoleScheme(descriptor.value);
                continue;
            }
            if (!Ascii.equalsIgnoreCase((CharSequence)"urn:tva:metadata:cs:AudioPurposeCS:2007", (CharSequence)descriptor.schemeIdUri)) continue;
            result |= this.parseTvaAudioPurposeCsValue(descriptor.value);
        }
        return result;
    }

    protected int parseRoleFlagsFromProperties(List<Descriptor> accessibilityDescriptors) {
        int result = 0;
        for (int i = 0; i < accessibilityDescriptors.size(); ++i) {
            Descriptor descriptor = accessibilityDescriptors.get(i);
            if (!Ascii.equalsIgnoreCase((CharSequence)"http://dashif.org/guidelines/trickmode", (CharSequence)descriptor.schemeIdUri)) continue;
            result |= 0x4000;
        }
        return result;
    }

    protected int parseRoleFlagsFromDashRoleScheme(@Nullable String value) {
        if (value == null) {
            return 0;
        }
        switch (value) {
            case "main": {
                return 1;
            }
            case "alternate": {
                return 2;
            }
            case "supplementary": {
                return 4;
            }
            case "commentary": {
                return 8;
            }
            case "dub": {
                return 16;
            }
            case "emergency": {
                return 32;
            }
            case "caption": {
                return 64;
            }
            case "forced_subtitle": 
            case "subtitle": {
                return 128;
            }
            case "sign": {
                return 256;
            }
            case "description": {
                return 512;
            }
            case "enhanced-audio-intelligibility": {
                return 2048;
            }
        }
        return 0;
    }

    protected int parseTvaAudioPurposeCsValue(@Nullable String value) {
        if (value == null) {
            return 0;
        }
        switch (value) {
            case "1": {
                return 512;
            }
            case "2": {
                return 2048;
            }
            case "3": {
                return 4;
            }
            case "4": {
                return 8;
            }
            case "6": {
                return 1;
            }
        }
        return 0;
    }

    public static void maybeSkipTag(XmlPullParser xpp) throws IOException, XmlPullParserException {
        if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp)) {
            return;
        }
        int depth = 1;
        while (depth != 0) {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp)) {
                ++depth;
                continue;
            }
            if (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp)) continue;
            --depth;
        }
    }

    private static void filterRedundantIncompleteSchemeDatas(ArrayList<DrmInitData.SchemeData> schemeDatas) {
        block0: for (int i = schemeDatas.size() - 1; i >= 0; --i) {
            DrmInitData.SchemeData schemeData = schemeDatas.get(i);
            if (schemeData.hasData()) continue;
            for (int j = 0; j < schemeDatas.size(); ++j) {
                if (!schemeDatas.get(j).canReplace(schemeData)) continue;
                schemeDatas.remove(i);
                continue block0;
            }
        }
    }

    @Nullable
    private static String getSampleMimeType(@Nullable String containerMimeType, @Nullable String codecs) {
        if (MimeTypes.isAudio((String)containerMimeType)) {
            return MimeTypes.getAudioMediaMimeType((String)codecs);
        }
        if (MimeTypes.isVideo((String)containerMimeType)) {
            return MimeTypes.getVideoMediaMimeType((String)codecs);
        }
        if (MimeTypes.isText((String)containerMimeType)) {
            if ("application/x-rawcc".equals(containerMimeType)) {
                return MimeTypes.getTextMediaMimeType((String)codecs);
            }
            return containerMimeType;
        }
        if ("application/mp4".equals(containerMimeType)) {
            String mimeType = MimeTypes.getMediaMimeType((String)codecs);
            return "text/vtt".equals(mimeType) ? "application/x-mp4-vtt" : mimeType;
        }
        return null;
    }

    @Nullable
    private static String checkLanguageConsistency(@Nullable String firstLanguage, @Nullable String secondLanguage) {
        if (firstLanguage == null) {
            return secondLanguage;
        }
        if (secondLanguage == null) {
            return firstLanguage;
        }
        Assertions.checkState((boolean)firstLanguage.equals(secondLanguage));
        return firstLanguage;
    }

    private static int checkContentTypeConsistency(int firstType, int secondType) {
        if (firstType == -1) {
            return secondType;
        }
        if (secondType == -1) {
            return firstType;
        }
        Assertions.checkState((firstType == secondType ? 1 : 0) != 0);
        return firstType;
    }

    protected static Descriptor parseDescriptor(XmlPullParser xpp, String tag) throws XmlPullParserException, IOException {
        String schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", "");
        String value = DashManifestParser.parseString(xpp, "value", null);
        String id = DashManifestParser.parseString(xpp, "id", null);
        do {
            xpp.next();
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)tag));
        return new Descriptor(schemeIdUri, value, id);
    }

    protected static int parseCea608AccessibilityChannel(List<Descriptor> accessibilityDescriptors) {
        for (int i = 0; i < accessibilityDescriptors.size(); ++i) {
            Descriptor descriptor = accessibilityDescriptors.get(i);
            if (!"urn:scte:dash:cc:cea-608:2015".equals(descriptor.schemeIdUri) || descriptor.value == null) continue;
            Matcher accessibilityValueMatcher = CEA_608_ACCESSIBILITY_PATTERN.matcher(descriptor.value);
            if (accessibilityValueMatcher.matches()) {
                return Integer.parseInt(accessibilityValueMatcher.group(1));
            }
            String string = String.valueOf(descriptor.value);
            Log.w((String)TAG, (String)(string.length() != 0 ? "Unable to parse CEA-608 channel number from: ".concat(string) : new String("Unable to parse CEA-608 channel number from: ")));
        }
        return -1;
    }

    protected static int parseCea708AccessibilityChannel(List<Descriptor> accessibilityDescriptors) {
        for (int i = 0; i < accessibilityDescriptors.size(); ++i) {
            Descriptor descriptor = accessibilityDescriptors.get(i);
            if (!"urn:scte:dash:cc:cea-708:2015".equals(descriptor.schemeIdUri) || descriptor.value == null) continue;
            Matcher accessibilityValueMatcher = CEA_708_ACCESSIBILITY_PATTERN.matcher(descriptor.value);
            if (accessibilityValueMatcher.matches()) {
                return Integer.parseInt(accessibilityValueMatcher.group(1));
            }
            String string = String.valueOf(descriptor.value);
            Log.w((String)TAG, (String)(string.length() != 0 ? "Unable to parse CEA-708 service block number from: ".concat(string) : new String("Unable to parse CEA-708 service block number from: ")));
        }
        return -1;
    }

    protected static String parseEac3SupplementalProperties(List<Descriptor> supplementalProperties) {
        for (int i = 0; i < supplementalProperties.size(); ++i) {
            Descriptor descriptor = supplementalProperties.get(i);
            String schemeIdUri = descriptor.schemeIdUri;
            if ((!"tag:dolby.com,2018:dash:EC3_ExtensionType:2018".equals(schemeIdUri) || !"JOC".equals(descriptor.value)) && (!"tag:dolby.com,2014:dash:DolbyDigitalPlusExtensionType:2014".equals(schemeIdUri) || !"ec+3".equals(descriptor.value))) continue;
            return "audio/eac3-joc";
        }
        return "audio/eac3";
    }

    protected static float parseFrameRate(XmlPullParser xpp, float defaultValue) {
        Matcher frameRateMatcher;
        float frameRate = defaultValue;
        String frameRateAttribute = xpp.getAttributeValue(null, "frameRate");
        if (frameRateAttribute != null && (frameRateMatcher = FRAME_RATE_PATTERN.matcher(frameRateAttribute)).matches()) {
            int numerator = Integer.parseInt(frameRateMatcher.group(1));
            String denominatorString = frameRateMatcher.group(2);
            frameRate = !TextUtils.isEmpty((CharSequence)denominatorString) ? (float)numerator / (float)Integer.parseInt(denominatorString) : (float)numerator;
        }
        return frameRate;
    }

    protected static long parseDuration(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDuration((String)value);
    }

    protected static long parseDateTime(XmlPullParser xpp, String name, long defaultValue) throws ParserException {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDateTime((String)value);
    }

    protected static String parseText(XmlPullParser xpp, String label) throws XmlPullParserException, IOException {
        String text = "";
        do {
            xpp.next();
            if (xpp.getEventType() == 4) {
                text = xpp.getText();
                continue;
            }
            DashManifestParser.maybeSkipTag(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)label));
        return text;
    }

    protected static int parseInt(XmlPullParser xpp, String name, int defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    protected static long parseLong(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    protected static float parseFloat(XmlPullParser xpp, String name, float defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    protected static String parseString(XmlPullParser xpp, String name, String defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : value;
    }

    protected static int parseMpegChannelConfiguration(XmlPullParser xpp) {
        int index = DashManifestParser.parseInt(xpp, "value", -1);
        return 0 <= index && index < MPEG_CHANNEL_CONFIGURATION_MAPPING.length ? MPEG_CHANNEL_CONFIGURATION_MAPPING[index] : -1;
    }

    protected static int parseDolbyChannelConfiguration(XmlPullParser xpp) {
        String value = xpp.getAttributeValue(null, "value");
        if (value == null) {
            return -1;
        }
        switch (Ascii.toLowerCase((String)value)) {
            case "4000": {
                return 1;
            }
            case "a000": {
                return 2;
            }
            case "f801": {
                return 6;
            }
            case "fa01": {
                return 8;
            }
        }
        return -1;
    }

    protected static long parseLastSegmentNumberSupplementalProperty(List<Descriptor> supplementalProperties) {
        for (int i = 0; i < supplementalProperties.size(); ++i) {
            Descriptor descriptor = supplementalProperties.get(i);
            if (!Ascii.equalsIgnoreCase((CharSequence)"http://dashif.org/guidelines/last-segment-number", (CharSequence)descriptor.schemeIdUri)) continue;
            return Long.parseLong(descriptor.value);
        }
        return -1L;
    }

    private static long getFinalAvailabilityTimeOffset(long baseUrlAvailabilityTimeOffsetUs, long segmentBaseAvailabilityTimeOffsetUs) {
        long availabilityTimeOffsetUs = segmentBaseAvailabilityTimeOffsetUs;
        if (availabilityTimeOffsetUs == -9223372036854775807L) {
            availabilityTimeOffsetUs = baseUrlAvailabilityTimeOffsetUs;
        }
        if (availabilityTimeOffsetUs == Long.MAX_VALUE) {
            availabilityTimeOffsetUs = -9223372036854775807L;
        }
        return availabilityTimeOffsetUs;
    }

    protected static final class RepresentationInfo {
        public final Format format;
        public final String baseUrl;
        public final SegmentBase segmentBase;
        @Nullable
        public final String drmSchemeType;
        public final ArrayList<DrmInitData.SchemeData> drmSchemeDatas;
        public final ArrayList<Descriptor> inbandEventStreams;
        public final long revisionId;

        public RepresentationInfo(Format format, String baseUrl, SegmentBase segmentBase, @Nullable String drmSchemeType, ArrayList<DrmInitData.SchemeData> drmSchemeDatas, ArrayList<Descriptor> inbandEventStreams, long revisionId) {
            this.format = format;
            this.baseUrl = baseUrl;
            this.segmentBase = segmentBase;
            this.drmSchemeType = drmSchemeType;
            this.drmSchemeDatas = drmSchemeDatas;
            this.inbandEventStreams = inbandEventStreams;
            this.revisionId = revisionId;
        }
    }
}

