/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;

public final class TrackSelectionOverride
implements Bundleable {
    public final TrackGroup mediaTrackGroup;
    public final ImmutableList<Integer> trackIndices;
    private static final int FIELD_TRACK_GROUP = 0;
    private static final int FIELD_TRACKS = 1;
    public static final Bundleable.Creator<TrackSelectionOverride> CREATOR = bundle -> {
        Bundle trackGroupBundle = Assertions.checkNotNull(bundle.getBundle(TrackSelectionOverride.keyForField(0)));
        TrackGroup mediaTrackGroup = TrackGroup.CREATOR.fromBundle(trackGroupBundle);
        int[] tracks = Assertions.checkNotNull(bundle.getIntArray(TrackSelectionOverride.keyForField(1)));
        return new TrackSelectionOverride(mediaTrackGroup, Ints.asList((int[])tracks));
    };

    public TrackSelectionOverride(TrackGroup mediaTrackGroup, int trackIndex) {
        this(mediaTrackGroup, (List<Integer>)ImmutableList.of((Object)trackIndex));
    }

    public TrackSelectionOverride(TrackGroup mediaTrackGroup, List<Integer> trackIndices) {
        if (!(trackIndices.isEmpty() || Collections.min(trackIndices) >= 0 && Collections.max(trackIndices) < mediaTrackGroup.length)) {
            throw new IndexOutOfBoundsException();
        }
        this.mediaTrackGroup = mediaTrackGroup;
        this.trackIndices = ImmutableList.copyOf(trackIndices);
    }

    public int getType() {
        return this.mediaTrackGroup.type;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionOverride that = (TrackSelectionOverride)obj;
        return this.mediaTrackGroup.equals(that.mediaTrackGroup) && this.trackIndices.equals(that.trackIndices);
    }

    public int hashCode() {
        return this.mediaTrackGroup.hashCode() + 31 * this.trackIndices.hashCode();
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putBundle(TrackSelectionOverride.keyForField(0), this.mediaTrackGroup.toBundle());
        bundle.putIntArray(TrackSelectionOverride.keyForField(1), Ints.toArray(this.trackIndices));
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

