/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.UnknownNull;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class RunnableFutureTask<R, E extends Exception>
implements RunnableFuture<R> {
    private final ConditionVariable started = new ConditionVariable();
    private final ConditionVariable finished = new ConditionVariable();
    private final Object cancelLock = new Object();
    @Nullable
    private Exception exception;
    @Nullable
    private R result;
    @Nullable
    private Thread workThread;
    private boolean canceled;

    protected RunnableFutureTask() {
    }

    public final void blockUntilStarted() {
        this.started.blockUninterruptible();
    }

    public final void blockUntilFinished() {
        this.finished.blockUninterruptible();
    }

    @Override
    @UnknownNull
    public final R get() throws ExecutionException, InterruptedException {
        this.finished.block();
        return this.getResult();
    }

    @Override
    @UnknownNull
    public final R get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        long timeoutMs = TimeUnit.MILLISECONDS.convert(timeout, unit);
        if (!this.finished.block(timeoutMs)) {
            throw new TimeoutException();
        }
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean cancel(boolean interruptIfRunning) {
        Object object = this.cancelLock;
        synchronized (object) {
            if (this.canceled || this.finished.isOpen()) {
                return false;
            }
            this.canceled = true;
            this.cancelWork();
            Thread workThread = this.workThread;
            if (workThread != null) {
                if (interruptIfRunning) {
                    workThread.interrupt();
                }
            } else {
                this.started.open();
                this.finished.open();
            }
            return true;
        }
    }

    @Override
    public final boolean isDone() {
        return this.finished.isOpen();
    }

    @Override
    public final boolean isCancelled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (this.canceled) {
                return;
            }
            this.workThread = Thread.currentThread();
        }
        this.started.open();
        try {
            this.result = this.doWork();
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            Object object2 = this.cancelLock;
            synchronized (object2) {
                this.finished.open();
                this.workThread = null;
                Thread.interrupted();
            }
        }
    }

    @UnknownNull
    protected abstract R doWork() throws E;

    protected void cancelWork() {
    }

    @UnknownNull
    private R getResult() throws ExecutionException {
        if (this.canceled) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }
}

