/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.app.Activity;
import android.app.UiModeManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.SystemClock;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseLongArray;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.LongArray;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.PolyNull;

public final class Util {
    public static final int SDK_INT = "S".equals(Build.VERSION.CODENAME) ? 31 : ("R".equals(Build.VERSION.CODENAME) ? 30 : Build.VERSION.SDK_INT);
    public static final String DEVICE = Build.DEVICE;
    public static final String MANUFACTURER = Build.MANUFACTURER;
    public static final String MODEL = Build.MODEL;
    public static final String DEVICE_DEBUG_INFO;
    public static final byte[] EMPTY_BYTE_ARRAY;
    private static final String TAG = "Util";
    private static final Pattern XS_DATE_TIME_PATTERN;
    private static final Pattern XS_DURATION_PATTERN;
    private static final Pattern ESCAPED_CHARACTER_PATTERN;
    private static final Pattern ISM_URL_PATTERN;
    private static final String ISM_HLS_FORMAT_EXTENSION = "format=m3u8-aapl";
    private static final String ISM_DASH_FORMAT_EXTENSION = "format=mpd-time-csf";
    @Nullable
    private static HashMap<String, String> languageTagReplacementMap;
    private static final String[] additionalIsoLanguageReplacements;
    private static final String[] isoLegacyTagReplacements;
    private static final int[] CRC32_BYTES_MSBF;
    private static final int[] CRC8_BYTES_MSBF;

    private Util() {
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        return outputStream.toByteArray();
    }

    @Nullable
    public static ComponentName startForegroundService(Context context, Intent intent) {
        if (SDK_INT >= 26) {
            return context.startForegroundService(intent);
        }
        return context.startService(intent);
    }

    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, Uri ... uris) {
        if (SDK_INT < 23) {
            return false;
        }
        for (Uri uri : uris) {
            if (!Util.isLocalFileUri(uri)) continue;
            return Util.requestExternalStoragePermission(activity);
        }
        return false;
    }

    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, MediaItem ... mediaItems) {
        if (SDK_INT < 23) {
            return false;
        }
        for (MediaItem mediaItem : mediaItems) {
            if (mediaItem.playbackProperties == null) continue;
            if (Util.isLocalFileUri(mediaItem.playbackProperties.uri)) {
                return Util.requestExternalStoragePermission(activity);
            }
            for (int i = 0; i < mediaItem.playbackProperties.subtitles.size(); ++i) {
                if (!Util.isLocalFileUri(mediaItem.playbackProperties.subtitles.get((int)i).uri)) continue;
                return Util.requestExternalStoragePermission(activity);
            }
        }
        return false;
    }

    public static boolean checkCleartextTrafficPermitted(MediaItem ... mediaItems) {
        if (SDK_INT < 24) {
            return true;
        }
        for (MediaItem mediaItem : mediaItems) {
            if (mediaItem.playbackProperties == null) continue;
            if (Util.isTrafficRestricted(mediaItem.playbackProperties.uri)) {
                return false;
            }
            for (int i = 0; i < mediaItem.playbackProperties.subtitles.size(); ++i) {
                if (!Util.isTrafficRestricted(mediaItem.playbackProperties.subtitles.get((int)i).uri)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLocalFileUri(Uri uri) {
        String scheme = uri.getScheme();
        return TextUtils.isEmpty((CharSequence)scheme) || "file".equals(scheme);
    }

    public static boolean areEqual(@Nullable Object o1, @Nullable Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static boolean contains(@NullableType Object[] items, @Nullable Object item) {
        for (Object arrayItem : items) {
            if (!Util.areEqual(arrayItem, item)) continue;
            return true;
        }
        return false;
    }

    public static <T> void removeRange(List<T> list, int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > list.size() || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex != toIndex) {
            list.subList(fromIndex, toIndex).clear();
        }
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T castNonNull(@Nullable T value) {
        return value;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[] castNonNullTypeArray(@NullableType T[] value) {
        return value;
    }

    public static <T> T[] nullSafeArrayCopy(T[] input, int length) {
        Assertions.checkArgument(length <= input.length);
        return Arrays.copyOf(input, length);
    }

    public static <T> T[] nullSafeArrayCopyOfRange(T[] input, int from, int to) {
        Assertions.checkArgument(0 <= from);
        Assertions.checkArgument(to <= input.length);
        return Arrays.copyOfRange(input, from, to);
    }

    public static <T> T[] nullSafeArrayAppend(T[] original, T newElement) {
        @NullableType T[] result = Arrays.copyOf(original, original.length + 1);
        result[original.length] = newElement;
        return Util.castNonNullTypeArray(result);
    }

    public static <T> T[] nullSafeArrayConcatenation(T[] first, T[] second) {
        T[] concatenation = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, concatenation, first.length, second.length);
        return concatenation;
    }

    public static <T> void nullSafeListToArray(List<T> list, T[] array) {
        Assertions.checkState(list.size() == array.length);
        list.toArray(array);
    }

    public static Handler createHandlerForCurrentLooper() {
        return Util.createHandlerForCurrentLooper(null);
    }

    public static Handler createHandlerForCurrentLooper(@Nullable // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownInitialization Handler.Callback callback) {
        return Util.createHandler(Assertions.checkStateNotNull(Looper.myLooper()), callback);
    }

    public static Handler createHandlerForCurrentOrMainLooper() {
        return Util.createHandlerForCurrentOrMainLooper(null);
    }

    public static Handler createHandlerForCurrentOrMainLooper(@Nullable // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownInitialization Handler.Callback callback) {
        return Util.createHandler(Util.getCurrentOrMainLooper(), callback);
    }

    public static Handler createHandler(Looper looper, @Nullable // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownInitialization Handler.Callback callback) {
        return new Handler(looper, callback);
    }

    public static boolean postOrRun(Handler handler, Runnable runnable) {
        Looper looper = handler.getLooper();
        if (!looper.getThread().isAlive()) {
            return false;
        }
        if (handler.getLooper() == Looper.myLooper()) {
            runnable.run();
            return true;
        }
        return handler.post(runnable);
    }

    public static Looper getCurrentOrMainLooper() {
        Looper myLooper = Looper.myLooper();
        return myLooper != null ? myLooper : Looper.getMainLooper();
    }

    public static ExecutorService newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor((Runnable runnable) -> new Thread(runnable, threadName));
    }

    public static byte[] readToEnd(DataSource dataSource) throws IOException {
        byte[] data = new byte[1024];
        int position = 0;
        int bytesRead = 0;
        while (bytesRead != -1) {
            if (position == data.length) {
                data = Arrays.copyOf(data, data.length * 2);
            }
            if ((bytesRead = dataSource.read(data, position, data.length - position)) == -1) continue;
            position += bytesRead;
        }
        return Arrays.copyOf(data, position);
    }

    public static byte[] readExactly(DataSource dataSource, int length) throws IOException {
        int bytesRead;
        byte[] data = new byte[length];
        for (int position = 0; position < length; position += bytesRead) {
            bytesRead = dataSource.read(data, position, data.length - position);
            if (bytesRead != -1) continue;
            int n = position;
            throw new IllegalStateException(new StringBuilder(56).append("Not enough data could be read: ").append(n).append(" < ").append(length).toString());
        }
        return data;
    }

    public static void closeQuietly(@Nullable DataSource dataSource) {
        try {
            if (dataSource != null) {
                dataSource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean readBoolean(Parcel parcel) {
        return parcel.readInt() != 0;
    }

    public static void writeBoolean(Parcel parcel, boolean value) {
        parcel.writeInt(value ? 1 : 0);
    }

    public static String getLocaleLanguageTag(Locale locale) {
        return SDK_INT >= 21 ? Util.getLocaleLanguageTagV21(locale) : locale.toString();
    }

    public static @PolyNull String normalizeLanguageCode(@PolyNull String language) {
        String replacedLanguage;
        if (language == null) {
            return null;
        }
        String normalizedTag = language.replace('_', '-');
        if (normalizedTag.isEmpty() || normalizedTag.equals("und")) {
            normalizedTag = language;
        }
        normalizedTag = Ascii.toLowerCase((String)normalizedTag);
        String mainLanguage = Util.splitAtFirst(normalizedTag, "-")[0];
        if (languageTagReplacementMap == null) {
            languageTagReplacementMap = Util.createIsoLanguageReplacementMap();
        }
        if ((replacedLanguage = languageTagReplacementMap.get(mainLanguage)) != null) {
            String string = String.valueOf(replacedLanguage);
            String string2 = String.valueOf(normalizedTag.substring(mainLanguage.length()));
            normalizedTag = string2.length() != 0 ? string.concat(string2) : new String(string);
            mainLanguage = replacedLanguage;
        }
        if ("no".equals(mainLanguage) || "i".equals(mainLanguage) || "zh".equals(mainLanguage)) {
            normalizedTag = Util.maybeReplaceLegacyLanguageTags(normalizedTag);
        }
        return normalizedTag;
    }

    public static String fromUtf8Bytes(byte[] bytes) {
        return new String(bytes, Charsets.UTF_8);
    }

    public static String fromUtf8Bytes(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, Charsets.UTF_8);
    }

    public static byte[] getUtf8Bytes(String value) {
        return value.getBytes(Charsets.UTF_8);
    }

    public static String[] split(String value, String regex) {
        return value.split(regex, -1);
    }

    public static String[] splitAtFirst(String value, String regex) {
        return value.split(regex, 2);
    }

    public static boolean isLinebreak(int c) {
        return c == 10 || c == 13;
    }

    public static String formatInvariant(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public static int ceilDivide(int numerator, int denominator) {
        return (numerator + denominator - 1) / denominator;
    }

    public static long ceilDivide(long numerator, long denominator) {
        return (numerator + denominator - 1L) / denominator;
    }

    public static int constrainValue(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    public static long constrainValue(long value, long min, long max) {
        return Math.max(min, Math.min(value, max));
    }

    public static float constrainValue(float value, float min, float max) {
        return Math.max(min, Math.min(value, max));
    }

    public static long addWithOverflowDefault(long x, long y, long overflowResult) {
        long result = x + y;
        if (((x ^ result) & (y ^ result)) < 0L) {
            return overflowResult;
        }
        return result;
    }

    public static long subtractWithOverflowDefault(long x, long y, long overflowResult) {
        long result = x - y;
        if (((x ^ y) & (x ^ result)) < 0L) {
            return overflowResult;
        }
        return result;
    }

    public static int linearSearch(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int linearSearch(long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int binarySearchFloor(int[] array, int value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index = -(index + 2);
        } else {
            while (--index >= 0 && array[index] == value) {
            }
            if (inclusive) {
                ++index;
            }
        }
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static int binarySearchFloor(long[] array, long value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index = -(index + 2);
        } else {
            while (--index >= 0 && array[index] == value) {
            }
            if (inclusive) {
                ++index;
            }
        }
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static <T extends Comparable<? super T>> int binarySearchFloor(List<? extends Comparable<? super T>> list, T value, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, value);
        if (index < 0) {
            index = -(index + 2);
        } else {
            while (--index >= 0 && list.get(index).compareTo(value) == 0) {
            }
            if (inclusive) {
                ++index;
            }
        }
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static int binarySearchFloor(LongArray longArray, long value, boolean inclusive, boolean stayInBounds) {
        int lowIndex = 0;
        int highIndex = longArray.size() - 1;
        while (lowIndex <= highIndex) {
            int midIndex = lowIndex + highIndex >>> 1;
            if (longArray.get(midIndex) < value) {
                lowIndex = midIndex + 1;
                continue;
            }
            highIndex = midIndex - 1;
        }
        if (inclusive && highIndex + 1 < longArray.size() && longArray.get(highIndex + 1) == value) {
            ++highIndex;
        } else if (stayInBounds && highIndex == -1) {
            highIndex = 0;
        }
        return highIndex;
    }

    public static int binarySearchCeil(int[] array, int value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        } else {
            while (++index < array.length && array[index] == value) {
            }
            if (inclusive) {
                --index;
            }
        }
        return stayInBounds ? Math.min(array.length - 1, index) : index;
    }

    public static int binarySearchCeil(long[] array, long value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        } else {
            while (++index < array.length && array[index] == value) {
            }
            if (inclusive) {
                --index;
            }
        }
        return stayInBounds ? Math.min(array.length - 1, index) : index;
    }

    public static <T extends Comparable<? super T>> int binarySearchCeil(List<? extends Comparable<? super T>> list, T value, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, value);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        } else {
            int listSize = list.size();
            while (++index < listSize && list.get(index).compareTo(value) == 0) {
            }
            if (inclusive) {
                --index;
            }
        }
        return stayInBounds ? Math.min(list.size() - 1, index) : index;
    }

    public static int compareLong(long left, long right) {
        return left < right ? -1 : (left == right ? 0 : 1);
    }

    @RequiresApi(value=18)
    public static long minValue(SparseLongArray sparseLongArray) {
        if (sparseLongArray.size() == 0) {
            throw new NoSuchElementException();
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < sparseLongArray.size(); ++i) {
            min = Math.min(min, sparseLongArray.valueAt(i));
        }
        return min;
    }

    public static long parseXsDuration(String value) {
        Matcher matcher = XS_DURATION_PATTERN.matcher(value);
        if (matcher.matches()) {
            boolean negated = !TextUtils.isEmpty((CharSequence)matcher.group(1));
            String years = matcher.group(3);
            double durationSeconds = years != null ? Double.parseDouble(years) * 3.1556908E7 : 0.0;
            String months = matcher.group(5);
            durationSeconds += months != null ? Double.parseDouble(months) * 2629739.0 : 0.0;
            String days = matcher.group(7);
            durationSeconds += days != null ? Double.parseDouble(days) * 86400.0 : 0.0;
            String hours = matcher.group(10);
            durationSeconds += hours != null ? Double.parseDouble(hours) * 3600.0 : 0.0;
            String minutes = matcher.group(12);
            durationSeconds += minutes != null ? Double.parseDouble(minutes) * 60.0 : 0.0;
            String seconds = matcher.group(14);
            long durationMillis = (long)((durationSeconds += seconds != null ? Double.parseDouble(seconds) : 0.0) * 1000.0);
            return negated ? -durationMillis : durationMillis;
        }
        return (long)(Double.parseDouble(value) * 3600.0 * 1000.0);
    }

    public static long parseXsDateTime(String value) throws ParserException {
        int timezoneShift;
        Matcher matcher = XS_DATE_TIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            String string = String.valueOf(value);
            throw ParserException.createForMalformedContainer(string.length() != 0 ? "Invalid date/time format: ".concat(string) : new String("Invalid date/time format: "), null);
        }
        if (matcher.group(9) == null) {
            timezoneShift = 0;
        } else if (matcher.group(9).equalsIgnoreCase("Z")) {
            timezoneShift = 0;
        } else {
            timezoneShift = Integer.parseInt(matcher.group(12)) * 60 + Integer.parseInt(matcher.group(13));
            if ("-".equals(matcher.group(11))) {
                timezoneShift *= -1;
            }
        }
        GregorianCalendar dateTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        dateTime.clear();
        dateTime.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
        if (!TextUtils.isEmpty((CharSequence)matcher.group(8))) {
            String string = String.valueOf(matcher.group(8));
            BigDecimal bd = new BigDecimal(string.length() != 0 ? "0.".concat(string) : new String("0."));
            dateTime.set(14, bd.movePointRight(3).intValue());
        }
        long time = dateTime.getTimeInMillis();
        if (timezoneShift != 0) {
            time -= (long)(timezoneShift * 60000);
        }
        return time;
    }

    public static long scaleLargeTimestamp(long timestamp, long multiplier, long divisor) {
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            return timestamp / divisionFactor;
        }
        if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            return timestamp * multiplicationFactor;
        }
        double multiplicationFactor = (double)multiplier / (double)divisor;
        return (long)((double)timestamp * multiplicationFactor);
    }

    public static long[] scaleLargeTimestamps(List<Long> timestamps, long multiplier, long divisor) {
        long[] scaledTimestamps = new long[timestamps.size()];
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = timestamps.get(i) / divisionFactor;
            }
        } else if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = timestamps.get(i) * multiplicationFactor;
            }
        } else {
            double multiplicationFactor = (double)multiplier / (double)divisor;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = (long)((double)timestamps.get(i).longValue() * multiplicationFactor);
            }
        }
        return scaledTimestamps;
    }

    public static void scaleLargeTimestampsInPlace(long[] timestamps, long multiplier, long divisor) {
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            int i = 0;
            while (i < timestamps.length) {
                int n = i++;
                timestamps[n] = timestamps[n] / divisionFactor;
            }
        } else if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            int i = 0;
            while (i < timestamps.length) {
                int n = i++;
                timestamps[n] = timestamps[n] * multiplicationFactor;
            }
        } else {
            double multiplicationFactor = (double)multiplier / (double)divisor;
            for (int i = 0; i < timestamps.length; ++i) {
                timestamps[i] = (long)((double)timestamps[i] * multiplicationFactor);
            }
        }
    }

    public static long getMediaDurationForPlayoutDuration(long playoutDuration, float speed) {
        if (speed == 1.0f) {
            return playoutDuration;
        }
        return Math.round((double)playoutDuration * (double)speed);
    }

    public static long getPlayoutDurationForMediaDuration(long mediaDuration, float speed) {
        if (speed == 1.0f) {
            return mediaDuration;
        }
        return Math.round((double)mediaDuration / (double)speed);
    }

    public static int getIntegerCodeForString(String string) {
        int length = string.length();
        Assertions.checkArgument(length <= 4);
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result |= string.charAt(i);
        }
        return result;
    }

    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static long toLong(int mostSignificantBits, int leastSignificantBits) {
        return Util.toUnsignedLong(mostSignificantBits) << 32 | Util.toUnsignedLong(leastSignificantBits);
    }

    public static CharSequence truncateAscii(CharSequence sequence, int maxLength) {
        return sequence.length() <= maxLength ? sequence : sequence.subSequence(0, maxLength);
    }

    public static byte[] getBytesFromHexString(String hexString) {
        byte[] data = new byte[hexString.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            int stringOffset = i * 2;
            data[i] = (byte)((Character.digit(hexString.charAt(stringOffset), 16) << 4) + Character.digit(hexString.charAt(stringOffset + 1), 16));
        }
        return data;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            result.append(Character.forDigit(bytes[i] >> 4 & 0xF, 16)).append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return result.toString();
    }

    public static String getCommaDelimitedSimpleClassNames(Object[] objects) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            stringBuilder.append(objects[i].getClass().getSimpleName());
            if (i >= objects.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String getUserAgent(Context context, String applicationName) {
        String versionName;
        try {
            String packageName = context.getPackageName();
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
            versionName = info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            versionName = "?";
        }
        String string = versionName;
        String string2 = Build.VERSION.RELEASE;
        return new StringBuilder(38 + String.valueOf(applicationName).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(applicationName).append("/").append(string).append(" (Linux;Android ").append(string2).append(") ").append("ExoPlayerLib/2.15.1").toString();
    }

    public static int getCodecCountOfType(@Nullable String codecs, int trackType) {
        String[] codecArray = Util.splitCodecs(codecs);
        int count = 0;
        for (String codec : codecArray) {
            if (trackType != MimeTypes.getTrackTypeOfCodec(codec)) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    public static String getCodecsOfType(@Nullable String codecs, int trackType) {
        String[] codecArray = Util.splitCodecs(codecs);
        if (codecArray.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String codec : codecArray) {
            if (trackType != MimeTypes.getTrackTypeOfCodec(codec)) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(codec);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public static String[] splitCodecs(@Nullable String codecs) {
        if (TextUtils.isEmpty((CharSequence)codecs)) {
            return new String[0];
        }
        return Util.split(codecs.trim(), "(\\s*,\\s*)");
    }

    public static Format getPcmFormat(int pcmEncoding, int channels, int sampleRate) {
        return new Format.Builder().setSampleMimeType("audio/raw").setChannelCount(channels).setSampleRate(sampleRate).setPcmEncoding(pcmEncoding).build();
    }

    public static int getPcmEncoding(int bitDepth) {
        switch (bitDepth) {
            case 8: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 24: {
                return 0x20000000;
            }
            case 32: {
                return 0x30000000;
            }
        }
        return 0;
    }

    public static boolean isEncodingLinearPcm(int encoding) {
        return encoding == 3 || encoding == 2 || encoding == 0x10000000 || encoding == 0x20000000 || encoding == 0x30000000 || encoding == 4;
    }

    public static boolean isEncodingHighResolutionPcm(int encoding) {
        return encoding == 0x20000000 || encoding == 0x30000000 || encoding == 4;
    }

    public static int getAudioTrackChannelConfig(int channelCount) {
        switch (channelCount) {
            case 1: {
                return 4;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 28;
            }
            case 4: {
                return 204;
            }
            case 5: {
                return 220;
            }
            case 6: {
                return 252;
            }
            case 7: {
                return 1276;
            }
            case 8: {
                if (SDK_INT >= 23) {
                    return 6396;
                }
                if (SDK_INT >= 21) {
                    return 6396;
                }
                return 0;
            }
        }
        return 0;
    }

    public static int getPcmFrameSize(int pcmEncoding, int channelCount) {
        switch (pcmEncoding) {
            case 3: {
                return channelCount;
            }
            case 2: 
            case 0x10000000: {
                return channelCount * 2;
            }
            case 0x20000000: {
                return channelCount * 3;
            }
            case 4: 
            case 0x30000000: {
                return channelCount * 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getAudioUsageForStreamType(int streamType) {
        switch (streamType) {
            case 4: {
                return 4;
            }
            case 8: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 1: {
                return 13;
            }
            case 0: {
                return 2;
            }
        }
        return 1;
    }

    public static int getAudioContentTypeForStreamType(int streamType) {
        switch (streamType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                return 4;
            }
            case 0: {
                return 1;
            }
        }
        return 2;
    }

    public static int getStreamTypeForAudioUsage(int usage) {
        switch (usage) {
            case 1: 
            case 12: 
            case 14: {
                return 3;
            }
            case 13: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 5;
            }
        }
        return 3;
    }

    @Nullable
    public static UUID getDrmUuid(String drmScheme) {
        switch (Ascii.toLowerCase((String)drmScheme)) {
            case "widevine": {
                return C.WIDEVINE_UUID;
            }
            case "playready": {
                return C.PLAYREADY_UUID;
            }
            case "clearkey": {
                return C.CLEARKEY_UUID;
            }
        }
        try {
            return UUID.fromString(drmScheme);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static int inferContentType(Uri uri, @Nullable String overrideExtension) {
        int n;
        if (TextUtils.isEmpty((CharSequence)overrideExtension)) {
            n = Util.inferContentType(uri);
        } else {
            String string = String.valueOf(overrideExtension);
            n = Util.inferContentType(string.length() != 0 ? ".".concat(string) : new String("."));
        }
        return n;
    }

    public static int inferContentType(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme != null && Ascii.equalsIgnoreCase((CharSequence)"rtsp", (CharSequence)scheme)) {
            return 3;
        }
        String path = uri.getPath();
        return path == null ? 4 : Util.inferContentType(path);
    }

    public static int inferContentType(String fileName) {
        if ((fileName = Ascii.toLowerCase((String)fileName)).endsWith(".mpd")) {
            return 0;
        }
        if (fileName.endsWith(".m3u8")) {
            return 2;
        }
        Matcher ismMatcher = ISM_URL_PATTERN.matcher(fileName);
        if (ismMatcher.matches()) {
            String extensions = ismMatcher.group(2);
            if (extensions != null) {
                if (extensions.contains(ISM_DASH_FORMAT_EXTENSION)) {
                    return 0;
                }
                if (extensions.contains(ISM_HLS_FORMAT_EXTENSION)) {
                    return 2;
                }
            }
            return 1;
        }
        return 4;
    }

    public static int inferContentTypeForUriAndMimeType(Uri uri, @Nullable String mimeType) {
        if (mimeType == null) {
            return Util.inferContentType(uri);
        }
        switch (mimeType) {
            case "application/dash+xml": {
                return 0;
            }
            case "application/x-mpegURL": {
                return 2;
            }
            case "application/vnd.ms-sstr+xml": {
                return 1;
            }
            case "application/x-rtsp": {
                return 3;
            }
        }
        return 4;
    }

    @Nullable
    public static String getAdaptiveMimeTypeForContentType(int contentType) {
        switch (contentType) {
            case 0: {
                return "application/dash+xml";
            }
            case 2: {
                return "application/x-mpegURL";
            }
            case 1: {
                return "application/vnd.ms-sstr+xml";
            }
        }
        return null;
    }

    public static Uri fixSmoothStreamingIsmManifestUri(Uri uri) {
        String path = uri.getPath();
        if (path == null) {
            return uri;
        }
        Matcher ismMatcher = ISM_URL_PATTERN.matcher(Ascii.toLowerCase((String)path));
        if (ismMatcher.matches() && ismMatcher.group(1) == null) {
            return Uri.withAppendedPath((Uri)uri, (String)"Manifest");
        }
        return uri;
    }

    public static String getStringForTime(StringBuilder builder, Formatter formatter, long timeMs) {
        if (timeMs == -9223372036854775807L) {
            timeMs = 0L;
        }
        String prefix = timeMs < 0L ? "-" : "";
        timeMs = Math.abs(timeMs);
        long totalSeconds = (timeMs + 500L) / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        builder.setLength(0);
        return hours > 0L ? formatter.format("%s%d:%02d:%02d", prefix, hours, minutes, seconds).toString() : formatter.format("%s%02d:%02d", prefix, minutes, seconds).toString();
    }

    public static String escapeFileName(String fileName) {
        int i;
        int length = fileName.length();
        int charactersToEscapeCount = 0;
        for (i = 0; i < length; ++i) {
            if (!Util.shouldEscapeCharacter(fileName.charAt(i))) continue;
            ++charactersToEscapeCount;
        }
        if (charactersToEscapeCount == 0) {
            return fileName;
        }
        i = 0;
        StringBuilder builder = new StringBuilder(length + charactersToEscapeCount * 2);
        while (charactersToEscapeCount > 0) {
            char c;
            if (Util.shouldEscapeCharacter(c = fileName.charAt(i++))) {
                builder.append('%').append(Integer.toHexString(c));
                --charactersToEscapeCount;
                continue;
            }
            builder.append(c);
        }
        if (i < length) {
            builder.append(fileName, i, length);
        }
        return builder.toString();
    }

    private static boolean shouldEscapeCharacter(char c) {
        switch (c) {
            case '\"': 
            case '%': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static String unescapeFileName(String fileName) {
        int length = fileName.length();
        int percentCharacterCount = 0;
        for (int i = 0; i < length; ++i) {
            if (fileName.charAt(i) != '%') continue;
            ++percentCharacterCount;
        }
        if (percentCharacterCount == 0) {
            return fileName;
        }
        int expectedLength = length - percentCharacterCount * 2;
        StringBuilder builder = new StringBuilder(expectedLength);
        Matcher matcher = ESCAPED_CHARACTER_PATTERN.matcher(fileName);
        int startOfNotEscaped = 0;
        while (percentCharacterCount > 0 && matcher.find()) {
            char unescapedCharacter = (char)Integer.parseInt(Assertions.checkNotNull(matcher.group(1)), 16);
            builder.append(fileName, startOfNotEscaped, matcher.start()).append(unescapedCharacter);
            startOfNotEscaped = matcher.end();
            --percentCharacterCount;
        }
        if (startOfNotEscaped < length) {
            builder.append(fileName, startOfNotEscaped, length);
        }
        if (builder.length() != expectedLength) {
            return null;
        }
        return builder.toString();
    }

    public static Uri getDataUriForString(String mimeType, String data) {
        String string = Base64.encodeToString((byte[])data.getBytes(), (int)2);
        return Uri.parse((String)new StringBuilder(13 + String.valueOf(mimeType).length() + String.valueOf(string).length()).append("data:").append(mimeType).append(";base64,").append(string).toString());
    }

    public static void sneakyThrow(Throwable t) {
        Util.sneakyThrowInternal(t);
    }

    private static <T extends Throwable> void sneakyThrowInternal(Throwable t) throws T {
        throw t;
    }

    public static void recursiveDelete(File fileOrDirectory) {
        File[] directoryFiles = fileOrDirectory.listFiles();
        if (directoryFiles != null) {
            for (File child : directoryFiles) {
                Util.recursiveDelete(child);
            }
        }
        fileOrDirectory.delete();
    }

    public static File createTempDirectory(Context context, String prefix) throws IOException {
        File tempFile = Util.createTempFile(context, prefix);
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    public static File createTempFile(Context context, String prefix) throws IOException {
        return File.createTempFile(prefix, null, Assertions.checkNotNull(context.getCacheDir()));
    }

    public static int crc32(byte[] bytes, int start, int end, int initialValue) {
        for (int i = start; i < end; ++i) {
            initialValue = initialValue << 8 ^ CRC32_BYTES_MSBF[(initialValue >>> 24 ^ bytes[i] & 0xFF) & 0xFF];
        }
        return initialValue;
    }

    public static int crc8(byte[] bytes, int start, int end, int initialValue) {
        for (int i = start; i < end; ++i) {
            initialValue = CRC8_BYTES_MSBF[initialValue ^ bytes[i] & 0xFF];
        }
        return initialValue;
    }

    public static byte[] gzip(byte[] input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (GZIPOutputStream os = new GZIPOutputStream(output);){
            os.write(input);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return output.toByteArray();
    }

    public static int getBigEndianInt(ByteBuffer buffer, int index) {
        int value = buffer.getInt(index);
        return buffer.order() == ByteOrder.BIG_ENDIAN ? value : Integer.reverseBytes(value);
    }

    public static String getCountryCode(@Nullable Context context) {
        String countryCode;
        TelephonyManager telephonyManager;
        if (context != null && (telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null && !TextUtils.isEmpty((CharSequence)(countryCode = telephonyManager.getNetworkCountryIso()))) {
            return Ascii.toUpperCase((String)countryCode);
        }
        return Ascii.toUpperCase((String)Locale.getDefault().getCountry());
    }

    public static String[] getSystemLanguageCodes() {
        String[] systemLocales = Util.getSystemLocales();
        for (int i = 0; i < systemLocales.length; ++i) {
            systemLocales[i] = Util.normalizeLanguageCode(systemLocales[i]);
        }
        return systemLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean inflate(ParsableByteArray input, ParsableByteArray output, @Nullable Inflater inflater) {
        if (input.bytesLeft() <= 0) {
            return false;
        }
        if (output.capacity() < input.bytesLeft()) {
            output.ensureCapacity(2 * input.bytesLeft());
        }
        if (inflater == null) {
            inflater = new Inflater();
        }
        inflater.setInput(input.getData(), input.getPosition(), input.bytesLeft());
        try {
            int outputSize = 0;
            while (true) {
                outputSize += inflater.inflate(output.getData(), outputSize, output.capacity() - outputSize);
                if (inflater.finished()) {
                    output.setLimit(outputSize);
                    boolean bl = true;
                    return bl;
                }
                if (inflater.needsDictionary() || inflater.needsInput()) {
                    boolean bl = false;
                    return bl;
                }
                if (outputSize != output.capacity()) continue;
                output.ensureCapacity(output.capacity() * 2);
                continue;
                break;
            }
        }
        catch (DataFormatException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            inflater.reset();
        }
    }

    public static boolean isTv(Context context) {
        UiModeManager uiModeManager = (UiModeManager)context.getApplicationContext().getSystemService("uimode");
        return uiModeManager != null && uiModeManager.getCurrentModeType() == 4;
    }

    public static Point getCurrentDisplayModeSize(Context context) {
        DisplayManager displayManager;
        Display defaultDisplay = null;
        if (SDK_INT >= 17 && (displayManager = (DisplayManager)context.getSystemService("display")) != null) {
            defaultDisplay = displayManager.getDisplay(0);
        }
        if (defaultDisplay == null) {
            WindowManager windowManager = Assertions.checkNotNull((WindowManager)context.getSystemService("window"));
            defaultDisplay = windowManager.getDefaultDisplay();
        }
        return Util.getCurrentDisplayModeSize(context, defaultDisplay);
    }

    public static Point getCurrentDisplayModeSize(Context context, Display display) {
        Object displaySize;
        if (display.getDisplayId() == 0 && Util.isTv(context)) {
            String string = displaySize = SDK_INT < 28 ? Util.getSystemProperty("sys.display-size") : Util.getSystemProperty("vendor.display-size");
            if (!TextUtils.isEmpty((CharSequence)displaySize)) {
                try {
                    String[] displaySizeParts = Util.split(((String)displaySize).trim(), "x");
                    if (displaySizeParts.length == 2) {
                        int width = Integer.parseInt(displaySizeParts[0]);
                        int height = Integer.parseInt(displaySizeParts[1]);
                        if (width > 0 && height > 0) {
                            return new Point(width, height);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String string2 = String.valueOf(displaySize);
                Log.e(TAG, string2.length() != 0 ? "Invalid display size: ".concat(string2) : new String("Invalid display size: "));
            }
            if ("Sony".equals(MANUFACTURER) && MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
                return new Point(3840, 2160);
            }
        }
        displaySize = new Point();
        if (SDK_INT >= 23) {
            Util.getDisplaySizeV23(display, (Point)displaySize);
        } else if (SDK_INT >= 17) {
            Util.getDisplaySizeV17(display, (Point)displaySize);
        } else {
            Util.getDisplaySizeV16(display, (Point)displaySize);
        }
        return displaySize;
    }

    public static String getTrackTypeString(int trackType) {
        switch (trackType) {
            case 1: {
                return "audio";
            }
            case 0: {
                return "default";
            }
            case 5: {
                return "metadata";
            }
            case 6: {
                return "camera motion";
            }
            case 7: {
                return "none";
            }
            case 3: {
                return "text";
            }
            case 2: {
                return "video";
            }
        }
        return trackType >= 10000 ? new StringBuilder(20).append("custom (").append(trackType).append(")").toString() : "?";
    }

    public static long getNowUnixTimeMs(long elapsedRealtimeEpochOffsetMs) {
        return elapsedRealtimeEpochOffsetMs == -9223372036854775807L ? System.currentTimeMillis() : SystemClock.elapsedRealtime() + elapsedRealtimeEpochOffsetMs;
    }

    public static <T> void moveItems(List<T> items, int fromIndex, int toIndex, int newFromIndex) {
        ArrayDeque<T> removedItems = new ArrayDeque<T>();
        int removedItemsLength = toIndex - fromIndex;
        for (int i = removedItemsLength - 1; i >= 0; --i) {
            removedItems.addFirst(items.remove(fromIndex + i));
        }
        items.addAll(Math.min(newFromIndex, items.size()), removedItems);
    }

    public static boolean tableExists(SQLiteDatabase database, String tableName) {
        long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)database, (String)"sqlite_master", (String)"tbl_name = ?", (String[])new String[]{tableName});
        return count > 0L;
    }

    public static int getErrorCodeFromPlatformDiagnosticsInfo(@Nullable String diagnosticsInfo) {
        if (diagnosticsInfo == null) {
            return 0;
        }
        String[] strings = Util.split(diagnosticsInfo, "_");
        int length = strings.length;
        if (length < 2) {
            return 0;
        }
        String digitsSection = strings[length - 1];
        boolean isNegative = length >= 3 && "neg".equals(strings[length - 2]);
        try {
            int errorCode = Integer.parseInt(Assertions.checkNotNull(digitsSection));
            return isNegative ? -errorCode : errorCode;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Nullable
    private static String getSystemProperty(String name) {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = systemProperties.getMethod("get", String.class);
            return (String)getMethod.invoke(systemProperties, name);
        }
        catch (Exception e) {
            String string = String.valueOf(name);
            Log.e(TAG, string.length() != 0 ? "Failed to read system property ".concat(string) : new String("Failed to read system property "), e);
            return null;
        }
    }

    @RequiresApi(value=23)
    private static void getDisplaySizeV23(Display display, Point outSize) {
        Display.Mode mode = display.getMode();
        outSize.x = mode.getPhysicalWidth();
        outSize.y = mode.getPhysicalHeight();
    }

    @RequiresApi(value=17)
    private static void getDisplaySizeV17(Display display, Point outSize) {
        display.getRealSize(outSize);
    }

    private static void getDisplaySizeV16(Display display, Point outSize) {
        display.getSize(outSize);
    }

    private static String[] getSystemLocales() {
        String[] stringArray;
        Configuration config = Resources.getSystem().getConfiguration();
        if (SDK_INT >= 24) {
            stringArray = Util.getSystemLocalesV24(config);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Util.getLocaleLanguageTag(config.locale);
        }
        return stringArray;
    }

    @RequiresApi(value=24)
    private static String[] getSystemLocalesV24(Configuration config) {
        return Util.split(config.getLocales().toLanguageTags(), ",");
    }

    @RequiresApi(value=21)
    private static String getLocaleLanguageTagV21(Locale locale) {
        return locale.toLanguageTag();
    }

    private static HashMap<String, String> createIsoLanguageReplacementMap() {
        String[] iso2Languages = Locale.getISOLanguages();
        HashMap<String, String> replacedLanguages = new HashMap<String, String>(iso2Languages.length + additionalIsoLanguageReplacements.length);
        for (String iso2 : iso2Languages) {
            try {
                String iso3 = new Locale(iso2).getISO3Language();
                if (TextUtils.isEmpty((CharSequence)iso3)) continue;
                replacedLanguages.put(iso3, iso2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        for (int i = 0; i < additionalIsoLanguageReplacements.length; i += 2) {
            replacedLanguages.put(additionalIsoLanguageReplacements[i], additionalIsoLanguageReplacements[i + 1]);
        }
        return replacedLanguages;
    }

    @RequiresApi(api=23)
    private static boolean requestExternalStoragePermission(Activity activity) {
        if (activity.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
            activity.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 0);
            return true;
        }
        return false;
    }

    @RequiresApi(api=24)
    private static boolean isTrafficRestricted(Uri uri) {
        return "http".equals(uri.getScheme()) && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(Assertions.checkNotNull(uri.getHost()));
    }

    private static String maybeReplaceLegacyLanguageTags(String languageTag) {
        for (int i = 0; i < isoLegacyTagReplacements.length; i += 2) {
            if (!languageTag.startsWith(isoLegacyTagReplacements[i])) continue;
            String string = String.valueOf(isoLegacyTagReplacements[i + 1]);
            String string2 = String.valueOf(languageTag.substring(isoLegacyTagReplacements[i].length()));
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        return languageTag;
    }

    static {
        String string = DEVICE;
        String string2 = MODEL;
        String string3 = MANUFACTURER;
        int n = SDK_INT;
        DEVICE_DEBUG_INFO = new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(", ").append(string2).append(", ").append(string3).append(", ").append(n).toString();
        EMPTY_BYTE_ARRAY = new byte[0];
        XS_DATE_TIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)([\\.,](\\d+))?([Zz]|((\\+|\\-)(\\d?\\d):?(\\d\\d)))?");
        XS_DURATION_PATTERN = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
        ESCAPED_CHARACTER_PATTERN = Pattern.compile("%([A-Fa-f0-9]{2})");
        ISM_URL_PATTERN = Pattern.compile(".*\\.isml?(?:/(manifest(.*))?)?");
        additionalIsoLanguageReplacements = new String[]{"alb", "sq", "arm", "hy", "baq", "eu", "bur", "my", "tib", "bo", "chi", "zh", "cze", "cs", "dut", "nl", "ger", "de", "gre", "el", "fre", "fr", "geo", "ka", "ice", "is", "mac", "mk", "mao", "mi", "may", "ms", "per", "fa", "rum", "ro", "scc", "hbs-srp", "slo", "sk", "wel", "cy", "id", "ms-ind", "iw", "he", "heb", "he", "ji", "yi", "in", "ms-ind", "ind", "ms-ind", "nb", "no-nob", "nob", "no-nob", "nn", "no-nno", "nno", "no-nno", "tw", "ak-twi", "twi", "ak-twi", "bs", "hbs-bos", "bos", "hbs-bos", "hr", "hbs-hrv", "hrv", "hbs-hrv", "sr", "hbs-srp", "srp", "hbs-srp", "cmn", "zh-cmn", "hak", "zh-hak", "nan", "zh-nan", "hsn", "zh-hsn"};
        isoLegacyTagReplacements = new String[]{"i-lux", "lb", "i-hak", "zh-hak", "i-navajo", "nv", "no-bok", "no-nob", "no-nyn", "no-nno", "zh-guoyu", "zh-cmn", "zh-hakka", "zh-hak", "zh-min-nan", "zh-nan", "zh-xiang", "zh-hsn"};
        CRC32_BYTES_MSBF = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
        CRC8_BYTES_MSBF = new int[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, 224, 231, 238, 233, 252, 251, 242, 245, 216, 223, 214, 209, 196, 195, 202, 205, 144, 151, 158, 153, 140, 139, 130, 133, 168, 175, 166, 161, 180, 179, 186, 189, 199, 192, 201, 206, 219, 220, 213, 210, 255, 248, 241, 246, 227, 228, 237, 234, 183, 176, 185, 190, 171, 172, 165, 162, 143, 136, 129, 134, 147, 148, 157, 154, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, 137, 142, 135, 128, 149, 146, 155, 156, 177, 182, 191, 184, 173, 170, 163, 164, 249, 254, 247, 240, 229, 226, 235, 236, 193, 198, 207, 200, 221, 218, 211, 212, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, 174, 169, 160, 167, 178, 181, 188, 187, 150, 145, 152, 159, 138, 141, 132, 131, 222, 217, 208, 215, 194, 197, 204, 203, 230, 225, 232, 239, 250, 253, 244, 243};
    }
}

