/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.drm.UnsupportedMediaCrypto;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;

public final class Format
implements Parcelable {
    public static final int NO_VALUE = -1;
    public static final long OFFSET_SAMPLE_RELATIVE = Long.MAX_VALUE;
    @Nullable
    public final String id;
    @Nullable
    public final String label;
    @Nullable
    public final String language;
    public final int selectionFlags;
    public final int roleFlags;
    public final int averageBitrate;
    public final int peakBitrate;
    public final int bitrate;
    @Nullable
    public final String codecs;
    @Nullable
    public final Metadata metadata;
    @Nullable
    public final String containerMimeType;
    @Nullable
    public final String sampleMimeType;
    public final int maxInputSize;
    public final List<byte[]> initializationData;
    @Nullable
    public final DrmInitData drmInitData;
    public final long subsampleOffsetUs;
    public final int width;
    public final int height;
    public final float frameRate;
    public final int rotationDegrees;
    public final float pixelWidthHeightRatio;
    @Nullable
    public final byte[] projectionData;
    public final int stereoMode;
    @Nullable
    public final ColorInfo colorInfo;
    public final int channelCount;
    public final int sampleRate;
    public final int pcmEncoding;
    public final int encoderDelay;
    public final int encoderPadding;
    public final int accessibilityChannel;
    @Nullable
    public final Class<? extends ExoMediaCrypto> exoMediaCryptoType;
    private int hashCode;
    public static final Parcelable.Creator<Format> CREATOR = new Parcelable.Creator<Format>(){

        public Format createFromParcel(Parcel in) {
            return new Format(in);
        }

        public Format[] newArray(int size) {
            return new Format[size];
        }
    };

    @Deprecated
    public static Format createVideoSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int width, int height, float frameRate, @Nullable List<byte[]> initializationData, @Nullable DrmInitData drmInitData) {
        return new Builder().setId(id).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setWidth(width).setHeight(height).setFrameRate(frameRate).build();
    }

    @Deprecated
    public static Format createVideoSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int width, int height, float frameRate, @Nullable List<byte[]> initializationData, int rotationDegrees, float pixelWidthHeightRatio, @Nullable DrmInitData drmInitData) {
        return new Builder().setId(id).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setWidth(width).setHeight(height).setFrameRate(frameRate).setRotationDegrees(rotationDegrees).setPixelWidthHeightRatio(pixelWidthHeightRatio).build();
    }

    @Deprecated
    public static Format createAudioSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int channelCount, int sampleRate, @Nullable List<byte[]> initializationData, @Nullable DrmInitData drmInitData, int selectionFlags, @Nullable String language) {
        return new Builder().setId(id).setLanguage(language).setSelectionFlags(selectionFlags).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setChannelCount(channelCount).setSampleRate(sampleRate).build();
    }

    @Deprecated
    public static Format createAudioSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int channelCount, int sampleRate, int pcmEncoding, @Nullable List<byte[]> initializationData, @Nullable DrmInitData drmInitData, int selectionFlags, @Nullable String language) {
        return new Builder().setId(id).setLanguage(language).setSelectionFlags(selectionFlags).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setChannelCount(channelCount).setSampleRate(sampleRate).setPcmEncoding(pcmEncoding).build();
    }

    @Deprecated
    public static Format createContainerFormat(@Nullable String id, @Nullable String label, @Nullable String containerMimeType, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int selectionFlags, int roleFlags, @Nullable String language) {
        return new Builder().setId(id).setLabel(label).setLanguage(language).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setContainerMimeType(containerMimeType).setSampleMimeType(sampleMimeType).build();
    }

    @Deprecated
    public static Format createSampleFormat(@Nullable String id, @Nullable String sampleMimeType) {
        return new Builder().setId(id).setSampleMimeType(sampleMimeType).build();
    }

    private Format(Builder builder) {
        this.id = builder.id;
        this.label = builder.label;
        this.language = Util.normalizeLanguageCode(builder.language);
        this.selectionFlags = builder.selectionFlags;
        this.roleFlags = builder.roleFlags;
        this.averageBitrate = builder.averageBitrate;
        this.peakBitrate = builder.peakBitrate;
        this.bitrate = this.peakBitrate != -1 ? this.peakBitrate : this.averageBitrate;
        this.codecs = builder.codecs;
        this.metadata = builder.metadata;
        this.containerMimeType = builder.containerMimeType;
        this.sampleMimeType = builder.sampleMimeType;
        this.maxInputSize = builder.maxInputSize;
        this.initializationData = builder.initializationData == null ? Collections.emptyList() : builder.initializationData;
        this.drmInitData = builder.drmInitData;
        this.subsampleOffsetUs = builder.subsampleOffsetUs;
        this.width = builder.width;
        this.height = builder.height;
        this.frameRate = builder.frameRate;
        this.rotationDegrees = builder.rotationDegrees == -1 ? 0 : builder.rotationDegrees;
        this.pixelWidthHeightRatio = builder.pixelWidthHeightRatio == -1.0f ? 1.0f : builder.pixelWidthHeightRatio;
        this.projectionData = builder.projectionData;
        this.stereoMode = builder.stereoMode;
        this.colorInfo = builder.colorInfo;
        this.channelCount = builder.channelCount;
        this.sampleRate = builder.sampleRate;
        this.pcmEncoding = builder.pcmEncoding;
        this.encoderDelay = builder.encoderDelay == -1 ? 0 : builder.encoderDelay;
        this.encoderPadding = builder.encoderPadding == -1 ? 0 : builder.encoderPadding;
        this.accessibilityChannel = builder.accessibilityChannel;
        this.exoMediaCryptoType = builder.exoMediaCryptoType == null && this.drmInitData != null ? UnsupportedMediaCrypto.class : builder.exoMediaCryptoType;
    }

    Format(Parcel in) {
        this.id = in.readString();
        this.label = in.readString();
        this.language = in.readString();
        this.selectionFlags = in.readInt();
        this.roleFlags = in.readInt();
        this.averageBitrate = in.readInt();
        this.peakBitrate = in.readInt();
        this.bitrate = this.peakBitrate != -1 ? this.peakBitrate : this.averageBitrate;
        this.codecs = in.readString();
        this.metadata = (Metadata)in.readParcelable(Metadata.class.getClassLoader());
        this.containerMimeType = in.readString();
        this.sampleMimeType = in.readString();
        this.maxInputSize = in.readInt();
        int initializationDataSize = in.readInt();
        this.initializationData = new ArrayList<byte[]>(initializationDataSize);
        for (int i = 0; i < initializationDataSize; ++i) {
            this.initializationData.add(Assertions.checkNotNull(in.createByteArray()));
        }
        this.drmInitData = (DrmInitData)in.readParcelable(DrmInitData.class.getClassLoader());
        this.subsampleOffsetUs = in.readLong();
        this.width = in.readInt();
        this.height = in.readInt();
        this.frameRate = in.readFloat();
        this.rotationDegrees = in.readInt();
        this.pixelWidthHeightRatio = in.readFloat();
        boolean hasProjectionData = Util.readBoolean(in);
        this.projectionData = hasProjectionData ? in.createByteArray() : null;
        this.stereoMode = in.readInt();
        this.colorInfo = (ColorInfo)in.readParcelable(ColorInfo.class.getClassLoader());
        this.channelCount = in.readInt();
        this.sampleRate = in.readInt();
        this.pcmEncoding = in.readInt();
        this.encoderDelay = in.readInt();
        this.encoderPadding = in.readInt();
        this.accessibilityChannel = in.readInt();
        this.exoMediaCryptoType = this.drmInitData != null ? UnsupportedMediaCrypto.class : null;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    @Deprecated
    public Format copyWithMaxInputSize(int maxInputSize) {
        return this.buildUpon().setMaxInputSize(maxInputSize).build();
    }

    @Deprecated
    public Format copyWithSubsampleOffsetUs(long subsampleOffsetUs) {
        return this.buildUpon().setSubsampleOffsetUs(subsampleOffsetUs).build();
    }

    @Deprecated
    public Format copyWithLabel(@Nullable String label) {
        return this.buildUpon().setLabel(label).build();
    }

    @Deprecated
    public Format copyWithManifestFormatInfo(Format manifestFormat) {
        return this.withManifestFormatInfo(manifestFormat);
    }

    public Format withManifestFormatInfo(Format manifestFormat) {
        String codecsOfType;
        if (this == manifestFormat) {
            return this;
        }
        int trackType = MimeTypes.getTrackType(this.sampleMimeType);
        String id = manifestFormat.id;
        String label = manifestFormat.label != null ? manifestFormat.label : this.label;
        String language = this.language;
        if ((trackType == 3 || trackType == 1) && manifestFormat.language != null) {
            language = manifestFormat.language;
        }
        int averageBitrate = this.averageBitrate == -1 ? manifestFormat.averageBitrate : this.averageBitrate;
        int peakBitrate = this.peakBitrate == -1 ? manifestFormat.peakBitrate : this.peakBitrate;
        String codecs = this.codecs;
        if (codecs == null && Util.splitCodecs(codecsOfType = Util.getCodecsOfType(manifestFormat.codecs, trackType)).length == 1) {
            codecs = codecsOfType;
        }
        Metadata metadata = this.metadata == null ? manifestFormat.metadata : this.metadata.copyWithAppendedEntriesFrom(manifestFormat.metadata);
        float frameRate = this.frameRate;
        if (frameRate == -1.0f && trackType == 2) {
            frameRate = manifestFormat.frameRate;
        }
        int selectionFlags = this.selectionFlags | manifestFormat.selectionFlags;
        int roleFlags = this.roleFlags | manifestFormat.roleFlags;
        DrmInitData drmInitData = DrmInitData.createSessionCreationData(manifestFormat.drmInitData, this.drmInitData);
        return this.buildUpon().setId(id).setLabel(label).setLanguage(language).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags).setAverageBitrate(averageBitrate).setPeakBitrate(peakBitrate).setCodecs(codecs).setMetadata(metadata).setDrmInitData(drmInitData).setFrameRate(frameRate).build();
    }

    @Deprecated
    public Format copyWithGaplessInfo(int encoderDelay, int encoderPadding) {
        return this.buildUpon().setEncoderDelay(encoderDelay).setEncoderPadding(encoderPadding).build();
    }

    @Deprecated
    public Format copyWithFrameRate(float frameRate) {
        return this.buildUpon().setFrameRate(frameRate).build();
    }

    @Deprecated
    public Format copyWithDrmInitData(@Nullable DrmInitData drmInitData) {
        return this.buildUpon().setDrmInitData(drmInitData).build();
    }

    @Deprecated
    public Format copyWithMetadata(@Nullable Metadata metadata) {
        return this.buildUpon().setMetadata(metadata).build();
    }

    @Deprecated
    public Format copyWithBitrate(int bitrate) {
        return this.buildUpon().setAverageBitrate(bitrate).setPeakBitrate(bitrate).build();
    }

    @Deprecated
    public Format copyWithVideoSize(int width, int height) {
        return this.buildUpon().setWidth(width).setHeight(height).build();
    }

    public Format copyWithExoMediaCryptoType(@Nullable Class<? extends ExoMediaCrypto> exoMediaCryptoType) {
        return this.buildUpon().setExoMediaCryptoType(exoMediaCryptoType).build();
    }

    public int getPixelCount() {
        return this.width == -1 || this.height == -1 ? -1 : this.width * this.height;
    }

    public String toString() {
        String string = this.id;
        String string2 = this.label;
        String string3 = this.containerMimeType;
        String string4 = this.sampleMimeType;
        String string5 = this.codecs;
        int n = this.bitrate;
        String string6 = this.language;
        int n2 = this.width;
        int n3 = this.height;
        float f = this.frameRate;
        int n4 = this.channelCount;
        int n5 = this.sampleRate;
        return new StringBuilder(104 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("Format(").append(string).append(", ").append(string2).append(", ").append(string3).append(", ").append(string4).append(", ").append(string5).append(", ").append(n).append(", ").append(string6).append(", [").append(n2).append(", ").append(n3).append(", ").append(f).append("], [").append(n4).append(", ").append(n5).append("])").toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + this.selectionFlags;
            result = 31 * result + this.roleFlags;
            result = 31 * result + this.averageBitrate;
            result = 31 * result + this.peakBitrate;
            result = 31 * result + (this.codecs == null ? 0 : this.codecs.hashCode());
            result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
            result = 31 * result + (this.containerMimeType == null ? 0 : this.containerMimeType.hashCode());
            result = 31 * result + (this.sampleMimeType == null ? 0 : this.sampleMimeType.hashCode());
            result = 31 * result + this.maxInputSize;
            result = 31 * result + (int)this.subsampleOffsetUs;
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + Float.floatToIntBits(this.frameRate);
            result = 31 * result + this.rotationDegrees;
            result = 31 * result + Float.floatToIntBits(this.pixelWidthHeightRatio);
            result = 31 * result + this.stereoMode;
            result = 31 * result + this.channelCount;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.pcmEncoding;
            result = 31 * result + this.encoderDelay;
            result = 31 * result + this.encoderPadding;
            result = 31 * result + this.accessibilityChannel;
            this.hashCode = result = 31 * result + (this.exoMediaCryptoType == null ? 0 : this.exoMediaCryptoType.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Format other = (Format)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        return this.selectionFlags == other.selectionFlags && this.roleFlags == other.roleFlags && this.averageBitrate == other.averageBitrate && this.peakBitrate == other.peakBitrate && this.maxInputSize == other.maxInputSize && this.subsampleOffsetUs == other.subsampleOffsetUs && this.width == other.width && this.height == other.height && this.rotationDegrees == other.rotationDegrees && this.stereoMode == other.stereoMode && this.channelCount == other.channelCount && this.sampleRate == other.sampleRate && this.pcmEncoding == other.pcmEncoding && this.encoderDelay == other.encoderDelay && this.encoderPadding == other.encoderPadding && this.accessibilityChannel == other.accessibilityChannel && Float.compare(this.frameRate, other.frameRate) == 0 && Float.compare(this.pixelWidthHeightRatio, other.pixelWidthHeightRatio) == 0 && Util.areEqual(this.exoMediaCryptoType, other.exoMediaCryptoType) && Util.areEqual(this.id, other.id) && Util.areEqual(this.label, other.label) && Util.areEqual(this.codecs, other.codecs) && Util.areEqual(this.containerMimeType, other.containerMimeType) && Util.areEqual(this.sampleMimeType, other.sampleMimeType) && Util.areEqual(this.language, other.language) && Arrays.equals(this.projectionData, other.projectionData) && Util.areEqual(this.metadata, other.metadata) && Util.areEqual(this.colorInfo, other.colorInfo) && Util.areEqual(this.drmInitData, other.drmInitData) && this.initializationDataEquals(other);
    }

    public boolean initializationDataEquals(Format other) {
        if (this.initializationData.size() != other.initializationData.size()) {
            return false;
        }
        for (int i = 0; i < this.initializationData.size(); ++i) {
            if (Arrays.equals(this.initializationData.get(i), other.initializationData.get(i))) continue;
            return false;
        }
        return true;
    }

    public static String toLogString(@Nullable Format format) {
        if (format == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("id=").append(format.id).append(", mimeType=").append(format.sampleMimeType);
        if (format.bitrate != -1) {
            builder.append(", bitrate=").append(format.bitrate);
        }
        if (format.codecs != null) {
            builder.append(", codecs=").append(format.codecs);
        }
        if (format.drmInitData != null) {
            LinkedHashSet<String> schemes = new LinkedHashSet<String>();
            for (int i = 0; i < format.drmInitData.schemeDataCount; ++i) {
                UUID schemeUuid = format.drmInitData.get((int)i).uuid;
                if (schemeUuid.equals(C.COMMON_PSSH_UUID)) {
                    schemes.add("cenc");
                    continue;
                }
                if (schemeUuid.equals(C.CLEARKEY_UUID)) {
                    schemes.add("clearkey");
                    continue;
                }
                if (schemeUuid.equals(C.PLAYREADY_UUID)) {
                    schemes.add("playready");
                    continue;
                }
                if (schemeUuid.equals(C.WIDEVINE_UUID)) {
                    schemes.add("widevine");
                    continue;
                }
                if (schemeUuid.equals(C.UUID_NIL)) {
                    schemes.add("universal");
                    continue;
                }
                String string = String.valueOf(schemeUuid);
                schemes.add(new StringBuilder(10 + String.valueOf(string).length()).append("unknown (").append(string).append(")").toString());
            }
            builder.append(", drm=[").append(Joiner.on((char)',').join(schemes)).append(']');
        }
        if (format.width != -1 && format.height != -1) {
            builder.append(", res=").append(format.width).append("x").append(format.height);
        }
        if (format.frameRate != -1.0f) {
            builder.append(", fps=").append(format.frameRate);
        }
        if (format.channelCount != -1) {
            builder.append(", channels=").append(format.channelCount);
        }
        if (format.sampleRate != -1) {
            builder.append(", sample_rate=").append(format.sampleRate);
        }
        if (format.language != null) {
            builder.append(", language=").append(format.language);
        }
        if (format.label != null) {
            builder.append(", label=").append(format.label);
        }
        if ((format.roleFlags & 0x4000) != 0) {
            builder.append(", trick-play-track");
        }
        return builder.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.label);
        dest.writeString(this.language);
        dest.writeInt(this.selectionFlags);
        dest.writeInt(this.roleFlags);
        dest.writeInt(this.averageBitrate);
        dest.writeInt(this.peakBitrate);
        dest.writeString(this.codecs);
        dest.writeParcelable((Parcelable)this.metadata, 0);
        dest.writeString(this.containerMimeType);
        dest.writeString(this.sampleMimeType);
        dest.writeInt(this.maxInputSize);
        int initializationDataSize = this.initializationData.size();
        dest.writeInt(initializationDataSize);
        for (int i = 0; i < initializationDataSize; ++i) {
            dest.writeByteArray(this.initializationData.get(i));
        }
        dest.writeParcelable((Parcelable)this.drmInitData, 0);
        dest.writeLong(this.subsampleOffsetUs);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeFloat(this.frameRate);
        dest.writeInt(this.rotationDegrees);
        dest.writeFloat(this.pixelWidthHeightRatio);
        Util.writeBoolean(dest, this.projectionData != null);
        if (this.projectionData != null) {
            dest.writeByteArray(this.projectionData);
        }
        dest.writeInt(this.stereoMode);
        dest.writeParcelable((Parcelable)this.colorInfo, flags);
        dest.writeInt(this.channelCount);
        dest.writeInt(this.sampleRate);
        dest.writeInt(this.pcmEncoding);
        dest.writeInt(this.encoderDelay);
        dest.writeInt(this.encoderPadding);
        dest.writeInt(this.accessibilityChannel);
    }

    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String label;
        @Nullable
        private String language;
        private int selectionFlags;
        private int roleFlags;
        private int averageBitrate;
        private int peakBitrate;
        @Nullable
        private String codecs;
        @Nullable
        private Metadata metadata;
        @Nullable
        private String containerMimeType;
        @Nullable
        private String sampleMimeType;
        private int maxInputSize;
        @Nullable
        private List<byte[]> initializationData;
        @Nullable
        private DrmInitData drmInitData;
        private long subsampleOffsetUs;
        private int width;
        private int height;
        private float frameRate;
        private int rotationDegrees;
        private float pixelWidthHeightRatio;
        @Nullable
        private byte[] projectionData;
        private int stereoMode;
        @Nullable
        private ColorInfo colorInfo;
        private int channelCount;
        private int sampleRate;
        private int pcmEncoding;
        private int encoderDelay;
        private int encoderPadding;
        private int accessibilityChannel;
        @Nullable
        private Class<? extends ExoMediaCrypto> exoMediaCryptoType;

        public Builder() {
            this.averageBitrate = -1;
            this.peakBitrate = -1;
            this.maxInputSize = -1;
            this.subsampleOffsetUs = Long.MAX_VALUE;
            this.width = -1;
            this.height = -1;
            this.frameRate = -1.0f;
            this.pixelWidthHeightRatio = 1.0f;
            this.stereoMode = -1;
            this.channelCount = -1;
            this.sampleRate = -1;
            this.pcmEncoding = -1;
            this.accessibilityChannel = -1;
        }

        private Builder(Format format) {
            this.id = format.id;
            this.label = format.label;
            this.language = format.language;
            this.selectionFlags = format.selectionFlags;
            this.roleFlags = format.roleFlags;
            this.averageBitrate = format.averageBitrate;
            this.peakBitrate = format.peakBitrate;
            this.codecs = format.codecs;
            this.metadata = format.metadata;
            this.containerMimeType = format.containerMimeType;
            this.sampleMimeType = format.sampleMimeType;
            this.maxInputSize = format.maxInputSize;
            this.initializationData = format.initializationData;
            this.drmInitData = format.drmInitData;
            this.subsampleOffsetUs = format.subsampleOffsetUs;
            this.width = format.width;
            this.height = format.height;
            this.frameRate = format.frameRate;
            this.rotationDegrees = format.rotationDegrees;
            this.pixelWidthHeightRatio = format.pixelWidthHeightRatio;
            this.projectionData = format.projectionData;
            this.stereoMode = format.stereoMode;
            this.colorInfo = format.colorInfo;
            this.channelCount = format.channelCount;
            this.sampleRate = format.sampleRate;
            this.pcmEncoding = format.pcmEncoding;
            this.encoderDelay = format.encoderDelay;
            this.encoderPadding = format.encoderPadding;
            this.accessibilityChannel = format.accessibilityChannel;
            this.exoMediaCryptoType = format.exoMediaCryptoType;
        }

        public Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public Builder setId(int id) {
            this.id = Integer.toString(id);
            return this;
        }

        public Builder setLabel(@Nullable String label) {
            this.label = label;
            return this;
        }

        public Builder setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public Builder setSelectionFlags(int selectionFlags) {
            this.selectionFlags = selectionFlags;
            return this;
        }

        public Builder setRoleFlags(int roleFlags) {
            this.roleFlags = roleFlags;
            return this;
        }

        public Builder setAverageBitrate(int averageBitrate) {
            this.averageBitrate = averageBitrate;
            return this;
        }

        public Builder setPeakBitrate(int peakBitrate) {
            this.peakBitrate = peakBitrate;
            return this;
        }

        public Builder setCodecs(@Nullable String codecs) {
            this.codecs = codecs;
            return this;
        }

        public Builder setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setContainerMimeType(@Nullable String containerMimeType) {
            this.containerMimeType = containerMimeType;
            return this;
        }

        public Builder setSampleMimeType(@Nullable String sampleMimeType) {
            this.sampleMimeType = sampleMimeType;
            return this;
        }

        public Builder setMaxInputSize(int maxInputSize) {
            this.maxInputSize = maxInputSize;
            return this;
        }

        public Builder setInitializationData(@Nullable List<byte[]> initializationData) {
            this.initializationData = initializationData;
            return this;
        }

        public Builder setDrmInitData(@Nullable DrmInitData drmInitData) {
            this.drmInitData = drmInitData;
            return this;
        }

        public Builder setSubsampleOffsetUs(long subsampleOffsetUs) {
            this.subsampleOffsetUs = subsampleOffsetUs;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setFrameRate(float frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public Builder setRotationDegrees(int rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        public Builder setPixelWidthHeightRatio(float pixelWidthHeightRatio) {
            this.pixelWidthHeightRatio = pixelWidthHeightRatio;
            return this;
        }

        public Builder setProjectionData(@Nullable byte[] projectionData) {
            this.projectionData = projectionData;
            return this;
        }

        public Builder setStereoMode(int stereoMode) {
            this.stereoMode = stereoMode;
            return this;
        }

        public Builder setColorInfo(@Nullable ColorInfo colorInfo) {
            this.colorInfo = colorInfo;
            return this;
        }

        public Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        public Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder setPcmEncoding(int pcmEncoding) {
            this.pcmEncoding = pcmEncoding;
            return this;
        }

        public Builder setEncoderDelay(int encoderDelay) {
            this.encoderDelay = encoderDelay;
            return this;
        }

        public Builder setEncoderPadding(int encoderPadding) {
            this.encoderPadding = encoderPadding;
            return this;
        }

        public Builder setAccessibilityChannel(int accessibilityChannel) {
            this.accessibilityChannel = accessibilityChannel;
            return this;
        }

        public Builder setExoMediaCryptoType(@Nullable Class<? extends ExoMediaCrypto> exoMediaCryptoType) {
            this.exoMediaCryptoType = exoMediaCryptoType;
            return this;
        }

        public Format build() {
            return new Format(this);
        }
    }
}

