/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.content.Context;
import android.graphics.Point;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Locale;

public class TrackSelectionParameters
implements Parcelable {
    public static final TrackSelectionParameters DEFAULT_WITHOUT_CONTEXT;
    @Deprecated
    public static final TrackSelectionParameters DEFAULT;
    public static final Parcelable.Creator<TrackSelectionParameters> CREATOR;
    public final int maxVideoWidth;
    public final int maxVideoHeight;
    public final int maxVideoFrameRate;
    public final int maxVideoBitrate;
    public final int minVideoWidth;
    public final int minVideoHeight;
    public final int minVideoFrameRate;
    public final int minVideoBitrate;
    public final int viewportWidth;
    public final int viewportHeight;
    public final boolean viewportOrientationMayChange;
    public final ImmutableList<String> preferredVideoMimeTypes;
    public final ImmutableList<String> preferredAudioLanguages;
    public final int preferredAudioRoleFlags;
    public final int maxAudioChannelCount;
    public final int maxAudioBitrate;
    public final ImmutableList<String> preferredAudioMimeTypes;
    public final ImmutableList<String> preferredTextLanguages;
    public final int preferredTextRoleFlags;
    public final boolean selectUndeterminedTextLanguage;
    public final boolean forceLowestBitrate;
    public final boolean forceHighestSupportedBitrate;

    public static TrackSelectionParameters getDefaults(Context context) {
        return new Builder(context).build();
    }

    protected TrackSelectionParameters(Builder builder) {
        this.maxVideoWidth = builder.maxVideoWidth;
        this.maxVideoHeight = builder.maxVideoHeight;
        this.maxVideoFrameRate = builder.maxVideoFrameRate;
        this.maxVideoBitrate = builder.maxVideoBitrate;
        this.minVideoWidth = builder.minVideoWidth;
        this.minVideoHeight = builder.minVideoHeight;
        this.minVideoFrameRate = builder.minVideoFrameRate;
        this.minVideoBitrate = builder.minVideoBitrate;
        this.viewportWidth = builder.viewportWidth;
        this.viewportHeight = builder.viewportHeight;
        this.viewportOrientationMayChange = builder.viewportOrientationMayChange;
        this.preferredVideoMimeTypes = builder.preferredVideoMimeTypes;
        this.preferredAudioLanguages = builder.preferredAudioLanguages;
        this.preferredAudioRoleFlags = builder.preferredAudioRoleFlags;
        this.maxAudioChannelCount = builder.maxAudioChannelCount;
        this.maxAudioBitrate = builder.maxAudioBitrate;
        this.preferredAudioMimeTypes = builder.preferredAudioMimeTypes;
        this.preferredTextLanguages = builder.preferredTextLanguages;
        this.preferredTextRoleFlags = builder.preferredTextRoleFlags;
        this.selectUndeterminedTextLanguage = builder.selectUndeterminedTextLanguage;
        this.forceLowestBitrate = builder.forceLowestBitrate;
        this.forceHighestSupportedBitrate = builder.forceHighestSupportedBitrate;
    }

    TrackSelectionParameters(Parcel in) {
        ArrayList preferredAudioLanguages = new ArrayList();
        in.readList(preferredAudioLanguages, null);
        this.preferredAudioLanguages = ImmutableList.copyOf(preferredAudioLanguages);
        this.preferredAudioRoleFlags = in.readInt();
        ArrayList preferredTextLanguages1 = new ArrayList();
        in.readList(preferredTextLanguages1, null);
        this.preferredTextLanguages = ImmutableList.copyOf(preferredTextLanguages1);
        this.preferredTextRoleFlags = in.readInt();
        this.selectUndeterminedTextLanguage = Util.readBoolean(in);
        this.maxVideoWidth = in.readInt();
        this.maxVideoHeight = in.readInt();
        this.maxVideoFrameRate = in.readInt();
        this.maxVideoBitrate = in.readInt();
        this.minVideoWidth = in.readInt();
        this.minVideoHeight = in.readInt();
        this.minVideoFrameRate = in.readInt();
        this.minVideoBitrate = in.readInt();
        this.viewportWidth = in.readInt();
        this.viewportHeight = in.readInt();
        this.viewportOrientationMayChange = Util.readBoolean(in);
        ArrayList preferredVideoMimeTypes = new ArrayList();
        in.readList(preferredVideoMimeTypes, null);
        this.preferredVideoMimeTypes = ImmutableList.copyOf(preferredVideoMimeTypes);
        this.maxAudioChannelCount = in.readInt();
        this.maxAudioBitrate = in.readInt();
        ArrayList preferredAudioMimeTypes = new ArrayList();
        in.readList(preferredAudioMimeTypes, null);
        this.preferredAudioMimeTypes = ImmutableList.copyOf(preferredAudioMimeTypes);
        this.forceLowestBitrate = Util.readBoolean(in);
        this.forceHighestSupportedBitrate = Util.readBoolean(in);
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionParameters other = (TrackSelectionParameters)obj;
        return this.maxVideoWidth == other.maxVideoWidth && this.maxVideoHeight == other.maxVideoHeight && this.maxVideoFrameRate == other.maxVideoFrameRate && this.maxVideoBitrate == other.maxVideoBitrate && this.minVideoWidth == other.minVideoWidth && this.minVideoHeight == other.minVideoHeight && this.minVideoFrameRate == other.minVideoFrameRate && this.minVideoBitrate == other.minVideoBitrate && this.viewportOrientationMayChange == other.viewportOrientationMayChange && this.viewportWidth == other.viewportWidth && this.viewportHeight == other.viewportHeight && this.preferredVideoMimeTypes.equals(other.preferredVideoMimeTypes) && this.preferredAudioLanguages.equals(other.preferredAudioLanguages) && this.preferredAudioRoleFlags == other.preferredAudioRoleFlags && this.maxAudioChannelCount == other.maxAudioChannelCount && this.maxAudioBitrate == other.maxAudioBitrate && this.preferredAudioMimeTypes.equals(other.preferredAudioMimeTypes) && this.preferredTextLanguages.equals(other.preferredTextLanguages) && this.preferredTextRoleFlags == other.preferredTextRoleFlags && this.selectUndeterminedTextLanguage == other.selectUndeterminedTextLanguage && this.forceLowestBitrate == other.forceLowestBitrate && this.forceHighestSupportedBitrate == other.forceHighestSupportedBitrate;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.maxVideoWidth;
        result = 31 * result + this.maxVideoHeight;
        result = 31 * result + this.maxVideoFrameRate;
        result = 31 * result + this.maxVideoBitrate;
        result = 31 * result + this.minVideoWidth;
        result = 31 * result + this.minVideoHeight;
        result = 31 * result + this.minVideoFrameRate;
        result = 31 * result + this.minVideoBitrate;
        result = 31 * result + (this.viewportOrientationMayChange ? 1 : 0);
        result = 31 * result + this.viewportWidth;
        result = 31 * result + this.viewportHeight;
        result = 31 * result + this.preferredVideoMimeTypes.hashCode();
        result = 31 * result + this.preferredAudioLanguages.hashCode();
        result = 31 * result + this.preferredAudioRoleFlags;
        result = 31 * result + this.maxAudioChannelCount;
        result = 31 * result + this.maxAudioBitrate;
        result = 31 * result + this.preferredAudioMimeTypes.hashCode();
        result = 31 * result + this.preferredTextLanguages.hashCode();
        result = 31 * result + this.preferredTextRoleFlags;
        result = 31 * result + (this.selectUndeterminedTextLanguage ? 1 : 0);
        result = 31 * result + (this.forceLowestBitrate ? 1 : 0);
        result = 31 * result + (this.forceHighestSupportedBitrate ? 1 : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.preferredAudioLanguages);
        dest.writeInt(this.preferredAudioRoleFlags);
        dest.writeList(this.preferredTextLanguages);
        dest.writeInt(this.preferredTextRoleFlags);
        Util.writeBoolean(dest, this.selectUndeterminedTextLanguage);
        dest.writeInt(this.maxVideoWidth);
        dest.writeInt(this.maxVideoHeight);
        dest.writeInt(this.maxVideoFrameRate);
        dest.writeInt(this.maxVideoBitrate);
        dest.writeInt(this.minVideoWidth);
        dest.writeInt(this.minVideoHeight);
        dest.writeInt(this.minVideoFrameRate);
        dest.writeInt(this.minVideoBitrate);
        dest.writeInt(this.viewportWidth);
        dest.writeInt(this.viewportHeight);
        Util.writeBoolean(dest, this.viewportOrientationMayChange);
        dest.writeList(this.preferredVideoMimeTypes);
        dest.writeInt(this.maxAudioChannelCount);
        dest.writeInt(this.maxAudioBitrate);
        dest.writeList(this.preferredAudioMimeTypes);
        Util.writeBoolean(dest, this.forceLowestBitrate);
        Util.writeBoolean(dest, this.forceHighestSupportedBitrate);
    }

    static {
        DEFAULT = DEFAULT_WITHOUT_CONTEXT = new Builder().build();
        CREATOR = new Parcelable.Creator<TrackSelectionParameters>(){

            public TrackSelectionParameters createFromParcel(Parcel in) {
                return new TrackSelectionParameters(in);
            }

            public TrackSelectionParameters[] newArray(int size) {
                return new TrackSelectionParameters[size];
            }
        };
    }

    public static class Builder {
        private int maxVideoWidth;
        private int maxVideoHeight;
        private int maxVideoFrameRate;
        private int maxVideoBitrate;
        private int minVideoWidth;
        private int minVideoHeight;
        private int minVideoFrameRate;
        private int minVideoBitrate;
        private int viewportWidth;
        private int viewportHeight;
        private boolean viewportOrientationMayChange;
        private ImmutableList<String> preferredVideoMimeTypes;
        private ImmutableList<String> preferredAudioLanguages;
        private int preferredAudioRoleFlags;
        private int maxAudioChannelCount;
        private int maxAudioBitrate;
        private ImmutableList<String> preferredAudioMimeTypes;
        private ImmutableList<String> preferredTextLanguages;
        private int preferredTextRoleFlags;
        private boolean selectUndeterminedTextLanguage;
        private boolean forceLowestBitrate;
        private boolean forceHighestSupportedBitrate;

        @Deprecated
        public Builder() {
            this.maxVideoWidth = Integer.MAX_VALUE;
            this.maxVideoHeight = Integer.MAX_VALUE;
            this.maxVideoFrameRate = Integer.MAX_VALUE;
            this.maxVideoBitrate = Integer.MAX_VALUE;
            this.viewportWidth = Integer.MAX_VALUE;
            this.viewportHeight = Integer.MAX_VALUE;
            this.viewportOrientationMayChange = true;
            this.preferredVideoMimeTypes = ImmutableList.of();
            this.preferredAudioLanguages = ImmutableList.of();
            this.preferredAudioRoleFlags = 0;
            this.maxAudioChannelCount = Integer.MAX_VALUE;
            this.maxAudioBitrate = Integer.MAX_VALUE;
            this.preferredAudioMimeTypes = ImmutableList.of();
            this.preferredTextLanguages = ImmutableList.of();
            this.preferredTextRoleFlags = 0;
            this.selectUndeterminedTextLanguage = false;
            this.forceLowestBitrate = false;
            this.forceHighestSupportedBitrate = false;
        }

        public Builder(Context context) {
            this();
            this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
            this.setViewportSizeToPhysicalDisplaySize(context, true);
        }

        protected Builder(TrackSelectionParameters initialValues) {
            this.maxVideoWidth = initialValues.maxVideoWidth;
            this.maxVideoHeight = initialValues.maxVideoHeight;
            this.maxVideoFrameRate = initialValues.maxVideoFrameRate;
            this.maxVideoBitrate = initialValues.maxVideoBitrate;
            this.minVideoWidth = initialValues.minVideoWidth;
            this.minVideoHeight = initialValues.minVideoHeight;
            this.minVideoFrameRate = initialValues.minVideoFrameRate;
            this.minVideoBitrate = initialValues.minVideoBitrate;
            this.viewportWidth = initialValues.viewportWidth;
            this.viewportHeight = initialValues.viewportHeight;
            this.viewportOrientationMayChange = initialValues.viewportOrientationMayChange;
            this.preferredVideoMimeTypes = initialValues.preferredVideoMimeTypes;
            this.preferredAudioLanguages = initialValues.preferredAudioLanguages;
            this.preferredAudioRoleFlags = initialValues.preferredAudioRoleFlags;
            this.maxAudioChannelCount = initialValues.maxAudioChannelCount;
            this.maxAudioBitrate = initialValues.maxAudioBitrate;
            this.preferredAudioMimeTypes = initialValues.preferredAudioMimeTypes;
            this.preferredTextLanguages = initialValues.preferredTextLanguages;
            this.preferredTextRoleFlags = initialValues.preferredTextRoleFlags;
            this.selectUndeterminedTextLanguage = initialValues.selectUndeterminedTextLanguage;
            this.forceLowestBitrate = initialValues.forceLowestBitrate;
            this.forceHighestSupportedBitrate = initialValues.forceHighestSupportedBitrate;
        }

        public Builder setMaxVideoSizeSd() {
            return this.setMaxVideoSize(1279, 719);
        }

        public Builder clearVideoSizeConstraints() {
            return this.setMaxVideoSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Builder setMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
            this.maxVideoWidth = maxVideoWidth;
            this.maxVideoHeight = maxVideoHeight;
            return this;
        }

        public Builder setMaxVideoFrameRate(int maxVideoFrameRate) {
            this.maxVideoFrameRate = maxVideoFrameRate;
            return this;
        }

        public Builder setMaxVideoBitrate(int maxVideoBitrate) {
            this.maxVideoBitrate = maxVideoBitrate;
            return this;
        }

        public Builder setMinVideoSize(int minVideoWidth, int minVideoHeight) {
            this.minVideoWidth = minVideoWidth;
            this.minVideoHeight = minVideoHeight;
            return this;
        }

        public Builder setMinVideoFrameRate(int minVideoFrameRate) {
            this.minVideoFrameRate = minVideoFrameRate;
            return this;
        }

        public Builder setMinVideoBitrate(int minVideoBitrate) {
            this.minVideoBitrate = minVideoBitrate;
            return this;
        }

        public Builder setViewportSizeToPhysicalDisplaySize(Context context, boolean viewportOrientationMayChange) {
            Point viewportSize = Util.getCurrentDisplayModeSize(context);
            return this.setViewportSize(viewportSize.x, viewportSize.y, viewportOrientationMayChange);
        }

        public Builder clearViewportSizeConstraints() {
            return this.setViewportSize(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        public Builder setViewportSize(int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
            this.viewportOrientationMayChange = viewportOrientationMayChange;
            return this;
        }

        public Builder setPreferredVideoMimeType(@Nullable String mimeType) {
            return mimeType == null ? this.setPreferredVideoMimeTypes(new String[0]) : this.setPreferredVideoMimeTypes(mimeType);
        }

        public Builder setPreferredVideoMimeTypes(String ... mimeTypes) {
            this.preferredVideoMimeTypes = ImmutableList.copyOf((Object[])mimeTypes);
            return this;
        }

        public Builder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            return preferredAudioLanguage == null ? this.setPreferredAudioLanguages(new String[0]) : this.setPreferredAudioLanguages(preferredAudioLanguage);
        }

        public Builder setPreferredAudioLanguages(String ... preferredAudioLanguages) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (String language : Assertions.checkNotNull(preferredAudioLanguages)) {
                listBuilder.add((Object)Util.normalizeLanguageCode(Assertions.checkNotNull(language)));
            }
            this.preferredAudioLanguages = listBuilder.build();
            return this;
        }

        public Builder setPreferredAudioRoleFlags(int preferredAudioRoleFlags) {
            this.preferredAudioRoleFlags = preferredAudioRoleFlags;
            return this;
        }

        public Builder setMaxAudioChannelCount(int maxAudioChannelCount) {
            this.maxAudioChannelCount = maxAudioChannelCount;
            return this;
        }

        public Builder setMaxAudioBitrate(int maxAudioBitrate) {
            this.maxAudioBitrate = maxAudioBitrate;
            return this;
        }

        public Builder setPreferredAudioMimeType(@Nullable String mimeType) {
            return mimeType == null ? this.setPreferredAudioMimeTypes(new String[0]) : this.setPreferredAudioMimeTypes(mimeType);
        }

        public Builder setPreferredAudioMimeTypes(String ... mimeTypes) {
            this.preferredAudioMimeTypes = ImmutableList.copyOf((Object[])mimeTypes);
            return this;
        }

        public Builder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            if (Util.SDK_INT >= 19) {
                this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(context);
            }
            return this;
        }

        public Builder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            return preferredTextLanguage == null ? this.setPreferredTextLanguages(new String[0]) : this.setPreferredTextLanguages(preferredTextLanguage);
        }

        public Builder setPreferredTextLanguages(String ... preferredTextLanguages) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (String language : Assertions.checkNotNull(preferredTextLanguages)) {
                listBuilder.add((Object)Util.normalizeLanguageCode(Assertions.checkNotNull(language)));
            }
            this.preferredTextLanguages = listBuilder.build();
            return this;
        }

        public Builder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            this.preferredTextRoleFlags = preferredTextRoleFlags;
            return this;
        }

        public Builder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
            return this;
        }

        public Builder setForceLowestBitrate(boolean forceLowestBitrate) {
            this.forceLowestBitrate = forceLowestBitrate;
            return this;
        }

        public Builder setForceHighestSupportedBitrate(boolean forceHighestSupportedBitrate) {
            this.forceHighestSupportedBitrate = forceHighestSupportedBitrate;
            return this;
        }

        public TrackSelectionParameters build() {
            return new TrackSelectionParameters(this);
        }

        @RequiresApi(value=19)
        private void setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(Context context) {
            if (Util.SDK_INT < 23 && Looper.myLooper() == null) {
                return;
            }
            CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
            if (captioningManager == null || !captioningManager.isEnabled()) {
                return;
            }
            this.preferredTextRoleFlags = 1088;
            Locale preferredLocale = captioningManager.getLocale();
            if (preferredLocale != null) {
                this.preferredTextLanguages = ImmutableList.of((Object)Util.getLocaleLanguageTag(preferredLocale));
            }
        }
    }
}

