/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Layout;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.dataflow.qual.Pure;

public final class Cue
implements Bundleable {
    public static final Cue EMPTY = new Builder().setText("").build();
    public static final float DIMEN_UNSET = -3.4028235E38f;
    public static final int TYPE_UNSET = Integer.MIN_VALUE;
    public static final int ANCHOR_TYPE_START = 0;
    public static final int ANCHOR_TYPE_MIDDLE = 1;
    public static final int ANCHOR_TYPE_END = 2;
    public static final int LINE_TYPE_FRACTION = 0;
    public static final int LINE_TYPE_NUMBER = 1;
    public static final int TEXT_SIZE_TYPE_FRACTIONAL = 0;
    public static final int TEXT_SIZE_TYPE_FRACTIONAL_IGNORE_PADDING = 1;
    public static final int TEXT_SIZE_TYPE_ABSOLUTE = 2;
    public static final int VERTICAL_TYPE_RL = 1;
    public static final int VERTICAL_TYPE_LR = 2;
    @Nullable
    public final CharSequence text;
    @Nullable
    public final Layout.Alignment textAlignment;
    @Nullable
    public final Layout.Alignment multiRowAlignment;
    @Nullable
    public final Bitmap bitmap;
    public final float line;
    public final int lineType;
    public final int lineAnchor;
    public final float position;
    public final int positionAnchor;
    public final float size;
    public final float bitmapHeight;
    public final boolean windowColorSet;
    public final int windowColor;
    public final int textSizeType;
    public final float textSize;
    public final int verticalType;
    public final float shearDegrees;
    private static final int FIELD_TEXT = 0;
    private static final int FIELD_TEXT_ALIGNMENT = 1;
    private static final int FIELD_MULTI_ROW_ALIGNMENT = 2;
    private static final int FIELD_BITMAP = 3;
    private static final int FIELD_LINE = 4;
    private static final int FIELD_LINE_TYPE = 5;
    private static final int FIELD_LINE_ANCHOR = 6;
    private static final int FIELD_POSITION = 7;
    private static final int FIELD_POSITION_ANCHOR = 8;
    private static final int FIELD_TEXT_SIZE_TYPE = 9;
    private static final int FIELD_TEXT_SIZE = 10;
    private static final int FIELD_SIZE = 11;
    private static final int FIELD_BITMAP_HEIGHT = 12;
    private static final int FIELD_WINDOW_COLOR = 13;
    private static final int FIELD_WINDOW_COLOR_SET = 14;
    private static final int FIELD_VERTICAL_TYPE = 15;
    private static final int FIELD_SHEAR_DEGREES = 16;
    public static final Bundleable.Creator<Cue> CREATOR = Cue::fromBundle;

    @Deprecated
    public Cue(CharSequence text) {
        this(text, null, -3.4028235E38f, Integer.MIN_VALUE, Integer.MIN_VALUE, -3.4028235E38f, Integer.MIN_VALUE, -3.4028235E38f);
    }

    @Deprecated
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size) {
        this(text, textAlignment, line, lineType, lineAnchor, position, positionAnchor, size, false, -16777216);
    }

    @Deprecated
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size, int textSizeType, float textSize) {
        this(text, textAlignment, null, null, line, lineType, lineAnchor, position, positionAnchor, textSizeType, textSize, size, -3.4028235E38f, false, -16777216, Integer.MIN_VALUE, 0.0f);
    }

    @Deprecated
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size, boolean windowColorSet, int windowColor) {
        this(text, textAlignment, null, null, line, lineType, lineAnchor, position, positionAnchor, Integer.MIN_VALUE, -3.4028235E38f, size, -3.4028235E38f, windowColorSet, windowColor, Integer.MIN_VALUE, 0.0f);
    }

    private Cue(@Nullable CharSequence text, @Nullable Layout.Alignment textAlignment, @Nullable Layout.Alignment multiRowAlignment, @Nullable Bitmap bitmap, float line, int lineType, int lineAnchor, float position, int positionAnchor, int textSizeType, float textSize, float size, float bitmapHeight, boolean windowColorSet, int windowColor, int verticalType, float shearDegrees) {
        if (text == null) {
            Assertions.checkNotNull(bitmap);
        } else {
            Assertions.checkArgument(bitmap == null);
        }
        this.text = text instanceof Spanned ? SpannedString.valueOf((CharSequence)text) : (text != null ? text.toString() : null);
        this.textAlignment = textAlignment;
        this.multiRowAlignment = multiRowAlignment;
        this.bitmap = bitmap;
        this.line = line;
        this.lineType = lineType;
        this.lineAnchor = lineAnchor;
        this.position = position;
        this.positionAnchor = positionAnchor;
        this.size = size;
        this.bitmapHeight = bitmapHeight;
        this.windowColorSet = windowColorSet;
        this.windowColor = windowColor;
        this.textSizeType = textSizeType;
        this.textSize = textSize;
        this.verticalType = verticalType;
        this.shearDegrees = shearDegrees;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cue that = (Cue)obj;
        return TextUtils.equals((CharSequence)this.text, (CharSequence)that.text) && this.textAlignment == that.textAlignment && this.multiRowAlignment == that.multiRowAlignment && (this.bitmap == null ? that.bitmap == null : that.bitmap != null && this.bitmap.sameAs(that.bitmap)) && this.line == that.line && this.lineType == that.lineType && this.lineAnchor == that.lineAnchor && this.position == that.position && this.positionAnchor == that.positionAnchor && this.size == that.size && this.bitmapHeight == that.bitmapHeight && this.windowColorSet == that.windowColorSet && this.windowColor == that.windowColor && this.textSizeType == that.textSizeType && this.textSize == that.textSize && this.verticalType == that.verticalType && this.shearDegrees == that.shearDegrees;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.text, this.textAlignment, this.multiRowAlignment, this.bitmap, Float.valueOf(this.line), this.lineType, this.lineAnchor, Float.valueOf(this.position), this.positionAnchor, Float.valueOf(this.size), Float.valueOf(this.bitmapHeight), this.windowColorSet, this.windowColor, this.textSizeType, Float.valueOf(this.textSize), this.verticalType, Float.valueOf(this.shearDegrees)});
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putCharSequence(Cue.keyForField(0), this.text);
        bundle.putSerializable(Cue.keyForField(1), (Serializable)this.textAlignment);
        bundle.putSerializable(Cue.keyForField(2), (Serializable)this.multiRowAlignment);
        bundle.putParcelable(Cue.keyForField(3), (Parcelable)this.bitmap);
        bundle.putFloat(Cue.keyForField(4), this.line);
        bundle.putInt(Cue.keyForField(5), this.lineType);
        bundle.putInt(Cue.keyForField(6), this.lineAnchor);
        bundle.putFloat(Cue.keyForField(7), this.position);
        bundle.putInt(Cue.keyForField(8), this.positionAnchor);
        bundle.putInt(Cue.keyForField(9), this.textSizeType);
        bundle.putFloat(Cue.keyForField(10), this.textSize);
        bundle.putFloat(Cue.keyForField(11), this.size);
        bundle.putFloat(Cue.keyForField(12), this.bitmapHeight);
        bundle.putBoolean(Cue.keyForField(14), this.windowColorSet);
        bundle.putInt(Cue.keyForField(13), this.windowColor);
        bundle.putInt(Cue.keyForField(15), this.verticalType);
        bundle.putFloat(Cue.keyForField(16), this.shearDegrees);
        return bundle;
    }

    private static final Cue fromBundle(Bundle bundle) {
        Bitmap bitmap;
        Layout.Alignment multiRowAlignment;
        Layout.Alignment textAlignment;
        Builder builder = new Builder();
        CharSequence text = bundle.getCharSequence(Cue.keyForField(0));
        if (text != null) {
            builder.setText(text);
        }
        if ((textAlignment = (Layout.Alignment)bundle.getSerializable(Cue.keyForField(1))) != null) {
            builder.setTextAlignment(textAlignment);
        }
        if ((multiRowAlignment = (Layout.Alignment)bundle.getSerializable(Cue.keyForField(2))) != null) {
            builder.setMultiRowAlignment(multiRowAlignment);
        }
        if ((bitmap = (Bitmap)bundle.getParcelable(Cue.keyForField(3))) != null) {
            builder.setBitmap(bitmap);
        }
        if (bundle.containsKey(Cue.keyForField(4)) && bundle.containsKey(Cue.keyForField(5))) {
            builder.setLine(bundle.getFloat(Cue.keyForField(4)), bundle.getInt(Cue.keyForField(5)));
        }
        if (bundle.containsKey(Cue.keyForField(6))) {
            builder.setLineAnchor(bundle.getInt(Cue.keyForField(6)));
        }
        if (bundle.containsKey(Cue.keyForField(7))) {
            builder.setPosition(bundle.getFloat(Cue.keyForField(7)));
        }
        if (bundle.containsKey(Cue.keyForField(8))) {
            builder.setPositionAnchor(bundle.getInt(Cue.keyForField(8)));
        }
        if (bundle.containsKey(Cue.keyForField(10)) && bundle.containsKey(Cue.keyForField(9))) {
            builder.setTextSize(bundle.getFloat(Cue.keyForField(10)), bundle.getInt(Cue.keyForField(9)));
        }
        if (bundle.containsKey(Cue.keyForField(11))) {
            builder.setSize(bundle.getFloat(Cue.keyForField(11)));
        }
        if (bundle.containsKey(Cue.keyForField(12))) {
            builder.setBitmapHeight(bundle.getFloat(Cue.keyForField(12)));
        }
        if (bundle.containsKey(Cue.keyForField(13))) {
            builder.setWindowColor(bundle.getInt(Cue.keyForField(13)));
        }
        if (!bundle.getBoolean(Cue.keyForField(14), false)) {
            builder.clearWindowColor();
        }
        if (bundle.containsKey(Cue.keyForField(15))) {
            builder.setVerticalType(bundle.getInt(Cue.keyForField(15)));
        }
        if (bundle.containsKey(Cue.keyForField(16))) {
            builder.setShearDegrees(bundle.getFloat(Cue.keyForField(16)));
        }
        return builder.build();
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    public static final class Builder {
        @Nullable
        private CharSequence text;
        @Nullable
        private Bitmap bitmap;
        @Nullable
        private Layout.Alignment textAlignment;
        @Nullable
        private Layout.Alignment multiRowAlignment;
        private float line;
        private int lineType;
        private int lineAnchor;
        private float position;
        private int positionAnchor;
        private int textSizeType;
        private float textSize;
        private float size;
        private float bitmapHeight;
        private boolean windowColorSet;
        @ColorInt
        private int windowColor;
        private int verticalType;
        private float shearDegrees;

        public Builder() {
            this.text = null;
            this.bitmap = null;
            this.textAlignment = null;
            this.multiRowAlignment = null;
            this.line = -3.4028235E38f;
            this.lineType = Integer.MIN_VALUE;
            this.lineAnchor = Integer.MIN_VALUE;
            this.position = -3.4028235E38f;
            this.positionAnchor = Integer.MIN_VALUE;
            this.textSizeType = Integer.MIN_VALUE;
            this.textSize = -3.4028235E38f;
            this.size = -3.4028235E38f;
            this.bitmapHeight = -3.4028235E38f;
            this.windowColorSet = false;
            this.windowColor = -16777216;
            this.verticalType = Integer.MIN_VALUE;
        }

        private Builder(Cue cue) {
            this.text = cue.text;
            this.bitmap = cue.bitmap;
            this.textAlignment = cue.textAlignment;
            this.multiRowAlignment = cue.multiRowAlignment;
            this.line = cue.line;
            this.lineType = cue.lineType;
            this.lineAnchor = cue.lineAnchor;
            this.position = cue.position;
            this.positionAnchor = cue.positionAnchor;
            this.textSizeType = cue.textSizeType;
            this.textSize = cue.textSize;
            this.size = cue.size;
            this.bitmapHeight = cue.bitmapHeight;
            this.windowColorSet = cue.windowColorSet;
            this.windowColor = cue.windowColor;
            this.verticalType = cue.verticalType;
            this.shearDegrees = cue.shearDegrees;
        }

        public Builder setText(CharSequence text) {
            this.text = text;
            return this;
        }

        @Pure
        @Nullable
        public CharSequence getText() {
            return this.text;
        }

        public Builder setBitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return this;
        }

        @Pure
        @Nullable
        public Bitmap getBitmap() {
            return this.bitmap;
        }

        public Builder setTextAlignment(@Nullable Layout.Alignment textAlignment) {
            this.textAlignment = textAlignment;
            return this;
        }

        @Pure
        @Nullable
        public Layout.Alignment getTextAlignment() {
            return this.textAlignment;
        }

        public Builder setMultiRowAlignment(@Nullable Layout.Alignment multiRowAlignment) {
            this.multiRowAlignment = multiRowAlignment;
            return this;
        }

        public Builder setLine(float line, int lineType) {
            this.line = line;
            this.lineType = lineType;
            return this;
        }

        @Pure
        public float getLine() {
            return this.line;
        }

        @Pure
        public int getLineType() {
            return this.lineType;
        }

        public Builder setLineAnchor(int lineAnchor) {
            this.lineAnchor = lineAnchor;
            return this;
        }

        @Pure
        public int getLineAnchor() {
            return this.lineAnchor;
        }

        public Builder setPosition(float position) {
            this.position = position;
            return this;
        }

        @Pure
        public float getPosition() {
            return this.position;
        }

        public Builder setPositionAnchor(int positionAnchor) {
            this.positionAnchor = positionAnchor;
            return this;
        }

        @Pure
        public int getPositionAnchor() {
            return this.positionAnchor;
        }

        public Builder setTextSize(float textSize, int textSizeType) {
            this.textSize = textSize;
            this.textSizeType = textSizeType;
            return this;
        }

        @Pure
        public int getTextSizeType() {
            return this.textSizeType;
        }

        @Pure
        public float getTextSize() {
            return this.textSize;
        }

        public Builder setSize(float size) {
            this.size = size;
            return this;
        }

        @Pure
        public float getSize() {
            return this.size;
        }

        public Builder setBitmapHeight(float bitmapHeight) {
            this.bitmapHeight = bitmapHeight;
            return this;
        }

        @Pure
        public float getBitmapHeight() {
            return this.bitmapHeight;
        }

        public Builder setWindowColor(@ColorInt int windowColor) {
            this.windowColor = windowColor;
            this.windowColorSet = true;
            return this;
        }

        public Builder clearWindowColor() {
            this.windowColorSet = false;
            return this;
        }

        public boolean isWindowColorSet() {
            return this.windowColorSet;
        }

        @Pure
        @ColorInt
        public int getWindowColor() {
            return this.windowColor;
        }

        public Builder setVerticalType(int verticalType) {
            this.verticalType = verticalType;
            return this;
        }

        public Builder setShearDegrees(float shearDegrees) {
            this.shearDegrees = shearDegrees;
            return this;
        }

        @Pure
        public int getVerticalType() {
            return this.verticalType;
        }

        public Cue build() {
            return new Cue(this.text, this.textAlignment, this.multiRowAlignment, this.bitmap, this.line, this.lineType, this.lineAnchor, this.position, this.positionAnchor, this.textSizeType, this.textSize, this.size, this.bitmapHeight, this.windowColorSet, this.windowColor, this.verticalType, this.shearDegrees);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerticalType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextSizeType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnchorType {
    }
}

