/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import androidx.annotation.GuardedBy;

public final class TimestampAdjuster {
    public static final long DO_NOT_OFFSET = Long.MAX_VALUE;
    private static final long MAX_PTS_PLUS_ONE = 0x200000000L;
    @GuardedBy(value="this")
    private boolean sharedInitializationStarted;
    @GuardedBy(value="this")
    private long firstSampleTimestampUs;
    @GuardedBy(value="this")
    private long timestampOffsetUs;
    @GuardedBy(value="this")
    private long lastSampleTimestampUs;

    public TimestampAdjuster(long firstSampleTimestampUs) {
        this.firstSampleTimestampUs = firstSampleTimestampUs;
        this.lastSampleTimestampUs = -9223372036854775807L;
    }

    public synchronized void sharedInitializeOrWait(boolean canInitialize, long startTimeUs) throws InterruptedException {
        if (canInitialize && !this.sharedInitializationStarted) {
            this.firstSampleTimestampUs = startTimeUs;
            this.sharedInitializationStarted = true;
        }
        if (!canInitialize || startTimeUs != this.firstSampleTimestampUs) {
            while (this.lastSampleTimestampUs == -9223372036854775807L) {
                this.wait();
            }
        }
    }

    public synchronized long getFirstSampleTimestampUs() {
        return this.firstSampleTimestampUs;
    }

    public synchronized long getLastAdjustedTimestampUs() {
        return this.lastSampleTimestampUs != -9223372036854775807L ? this.lastSampleTimestampUs + this.timestampOffsetUs : (this.firstSampleTimestampUs != Long.MAX_VALUE ? this.firstSampleTimestampUs : -9223372036854775807L);
    }

    public synchronized long getTimestampOffsetUs() {
        return this.firstSampleTimestampUs == Long.MAX_VALUE ? 0L : (this.lastSampleTimestampUs == -9223372036854775807L ? -9223372036854775807L : this.timestampOffsetUs);
    }

    public synchronized void reset(long firstSampleTimestampUs) {
        this.firstSampleTimestampUs = firstSampleTimestampUs;
        this.lastSampleTimestampUs = -9223372036854775807L;
        this.sharedInitializationStarted = false;
    }

    public synchronized long adjustTsTimestamp(long pts90Khz) {
        if (pts90Khz == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.lastSampleTimestampUs != -9223372036854775807L) {
            long lastPts = TimestampAdjuster.usToNonWrappedPts(this.lastSampleTimestampUs);
            long closestWrapCount = (lastPts + 0x100000000L) / 0x200000000L;
            long ptsWrapBelow = pts90Khz + 0x200000000L * (closestWrapCount - 1L);
            long ptsWrapAbove = pts90Khz + 0x200000000L * closestWrapCount;
            pts90Khz = Math.abs(ptsWrapBelow - lastPts) < Math.abs(ptsWrapAbove - lastPts) ? ptsWrapBelow : ptsWrapAbove;
        }
        return this.adjustSampleTimestamp(TimestampAdjuster.ptsToUs(pts90Khz));
    }

    public synchronized long adjustSampleTimestamp(long timeUs) {
        if (timeUs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.lastSampleTimestampUs != -9223372036854775807L) {
            this.lastSampleTimestampUs = timeUs;
        } else {
            if (this.firstSampleTimestampUs != Long.MAX_VALUE) {
                this.timestampOffsetUs = this.firstSampleTimestampUs - timeUs;
            }
            this.lastSampleTimestampUs = timeUs;
            this.notifyAll();
        }
        return timeUs + this.timestampOffsetUs;
    }

    public static long ptsToUs(long pts) {
        return pts * 1000000L / 90000L;
    }

    public static long usToWrappedPts(long us) {
        return TimestampAdjuster.usToNonWrappedPts(us) % 0x200000000L;
    }

    public static long usToNonWrappedPts(long us) {
        return us * 90000L / 1000000L;
    }
}

