/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.emsg;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;

public final class EventMessage
implements Metadata.Entry {
    @VisibleForTesting
    public static final String ID3_SCHEME_ID_AOM = "https://aomedia.org/emsg/ID3";
    private static final String ID3_SCHEME_ID_APPLE = "https://developer.apple.com/streaming/emsg-id3";
    @VisibleForTesting
    public static final String SCTE35_SCHEME_ID = "urn:scte:scte35:2014:bin";
    private static final Format ID3_FORMAT = new Format.Builder().setSampleMimeType("application/id3").build();
    private static final Format SCTE35_FORMAT = new Format.Builder().setSampleMimeType("application/x-scte35").build();
    public final String schemeIdUri;
    public final String value;
    public final long durationMs;
    public final long id;
    public final byte[] messageData;
    private int hashCode;
    public static final Parcelable.Creator<EventMessage> CREATOR = new Parcelable.Creator<EventMessage>(){

        public EventMessage createFromParcel(Parcel in) {
            return new EventMessage(in);
        }

        public EventMessage[] newArray(int size) {
            return new EventMessage[size];
        }
    };

    public EventMessage(String schemeIdUri, String value, long durationMs, long id, byte[] messageData) {
        this.schemeIdUri = schemeIdUri;
        this.value = value;
        this.durationMs = durationMs;
        this.id = id;
        this.messageData = messageData;
    }

    EventMessage(Parcel in) {
        this.schemeIdUri = Util.castNonNull(in.readString());
        this.value = Util.castNonNull(in.readString());
        this.durationMs = in.readLong();
        this.id = in.readLong();
        this.messageData = Util.castNonNull(in.createByteArray());
    }

    @Override
    @Nullable
    public Format getWrappedMetadataFormat() {
        switch (this.schemeIdUri) {
            case "https://aomedia.org/emsg/ID3": 
            case "https://developer.apple.com/streaming/emsg-id3": {
                return ID3_FORMAT;
            }
            case "urn:scte:scte35:2014:bin": {
                return SCTE35_FORMAT;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public byte[] getWrappedMetadataBytes() {
        return this.getWrappedMetadataFormat() != null ? this.messageData : null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (this.schemeIdUri != null ? this.schemeIdUri.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (int)(this.durationMs ^ this.durationMs >>> 32);
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            this.hashCode = result = 31 * result + Arrays.hashCode(this.messageData);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventMessage other = (EventMessage)obj;
        return this.durationMs == other.durationMs && this.id == other.id && Util.areEqual(this.schemeIdUri, other.schemeIdUri) && Util.areEqual(this.value, other.value) && Arrays.equals(this.messageData, other.messageData);
    }

    public String toString() {
        String string = this.schemeIdUri;
        long l = this.id;
        long l2 = this.durationMs;
        String string2 = this.value;
        return new StringBuilder(79 + String.valueOf(string).length() + String.valueOf(string2).length()).append("EMSG: scheme=").append(string).append(", id=").append(l).append(", durationMs=").append(l2).append(", value=").append(string2).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.schemeIdUri);
        dest.writeString(this.value);
        dest.writeLong(this.durationMs);
        dest.writeLong(this.id);
        dest.writeByteArray(this.messageData);
    }
}

