/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.flac;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;

public final class PictureFrame
implements Metadata.Entry {
    public final int pictureType;
    public final String mimeType;
    public final String description;
    public final int width;
    public final int height;
    public final int depth;
    public final int colors;
    public final byte[] pictureData;
    public static final Parcelable.Creator<PictureFrame> CREATOR = new Parcelable.Creator<PictureFrame>(){

        public PictureFrame createFromParcel(Parcel in) {
            return new PictureFrame(in);
        }

        public PictureFrame[] newArray(int size) {
            return new PictureFrame[size];
        }
    };

    public PictureFrame(int pictureType, String mimeType, String description, int width, int height, int depth, int colors, byte[] pictureData) {
        this.pictureType = pictureType;
        this.mimeType = mimeType;
        this.description = description;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.colors = colors;
        this.pictureData = pictureData;
    }

    PictureFrame(Parcel in) {
        this.pictureType = in.readInt();
        this.mimeType = Util.castNonNull(in.readString());
        this.description = Util.castNonNull(in.readString());
        this.width = in.readInt();
        this.height = in.readInt();
        this.depth = in.readInt();
        this.colors = in.readInt();
        this.pictureData = Util.castNonNull(in.createByteArray());
    }

    public String toString() {
        String string = this.mimeType;
        String string2 = this.description;
        return new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Picture: mimeType=").append(string).append(", description=").append(string2).toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PictureFrame other = (PictureFrame)obj;
        return this.pictureType == other.pictureType && this.mimeType.equals(other.mimeType) && this.description.equals(other.description) && this.width == other.width && this.height == other.height && this.depth == other.depth && this.colors == other.colors && Arrays.equals(this.pictureData, other.pictureData);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.pictureType;
        result = 31 * result + this.mimeType.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.depth;
        result = 31 * result + this.colors;
        result = 31 * result + Arrays.hashCode(this.pictureData);
        return result;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.pictureType);
        dest.writeString(this.mimeType);
        dest.writeString(this.description);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.depth);
        dest.writeInt(this.colors);
        dest.writeByteArray(this.pictureData);
    }

    public int describeContents() {
        return 0;
    }
}

