/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import com.google.android.datatransport.runtime.ProtoEncoderDoNotUse;
import com.google.android.datatransport.runtime.firebase.transport.ClientMetrics;
import com.google.android.datatransport.runtime.firebase.transport.GlobalMetrics;
import com.google.android.datatransport.runtime.firebase.transport.LogEventDropped;
import com.google.android.datatransport.runtime.firebase.transport.LogSourceMetrics;
import com.google.android.datatransport.runtime.firebase.transport.StorageMetrics;
import com.google.android.datatransport.runtime.firebase.transport.TimeWindow;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import com.google.firebase.encoders.proto.AtProtobuf;
import java.io.IOException;
import java.lang.annotation.Annotation;

public final class AutoProtoEncoderDoNotUseEncoder
implements Configurator {
    public static final int CODEGEN_VERSION = 2;
    public static final Configurator CONFIG = new AutoProtoEncoderDoNotUseEncoder();

    private AutoProtoEncoderDoNotUseEncoder() {
    }

    public void configure(EncoderConfig<?> cfg) {
        cfg.registerEncoder(ProtoEncoderDoNotUse.class, (ObjectEncoder)ProtoEncoderDoNotUseEncoder.INSTANCE);
        cfg.registerEncoder(ClientMetrics.class, (ObjectEncoder)ClientMetricsEncoder.INSTANCE);
        cfg.registerEncoder(TimeWindow.class, (ObjectEncoder)TimeWindowEncoder.INSTANCE);
        cfg.registerEncoder(LogSourceMetrics.class, (ObjectEncoder)LogSourceMetricsEncoder.INSTANCE);
        cfg.registerEncoder(LogEventDropped.class, (ObjectEncoder)LogEventDroppedEncoder.INSTANCE);
        cfg.registerEncoder(GlobalMetrics.class, (ObjectEncoder)GlobalMetricsEncoder.INSTANCE);
        cfg.registerEncoder(StorageMetrics.class, (ObjectEncoder)StorageMetricsEncoder.INSTANCE);
    }

    private static final class ProtoEncoderDoNotUseEncoder
    implements ObjectEncoder<ProtoEncoderDoNotUse> {
        static final ProtoEncoderDoNotUseEncoder INSTANCE = new ProtoEncoderDoNotUseEncoder();
        private static final FieldDescriptor CLIENTMETRICS_DESCRIPTOR = FieldDescriptor.of((String)"clientMetrics");

        private ProtoEncoderDoNotUseEncoder() {
        }

        public void encode(ProtoEncoderDoNotUse value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(CLIENTMETRICS_DESCRIPTOR, (Object)value.getClientMetrics());
        }
    }

    private static final class ClientMetricsEncoder
    implements ObjectEncoder<ClientMetrics> {
        static final ClientMetricsEncoder INSTANCE = new ClientMetricsEncoder();
        private static final FieldDescriptor WINDOW_DESCRIPTOR = FieldDescriptor.builder((String)"window").withProperty((Annotation)AtProtobuf.builder().tag(1).build()).build();
        private static final FieldDescriptor LOGSOURCEMETRICS_DESCRIPTOR = FieldDescriptor.builder((String)"logSourceMetrics").withProperty((Annotation)AtProtobuf.builder().tag(2).build()).build();
        private static final FieldDescriptor GLOBALMETRICS_DESCRIPTOR = FieldDescriptor.builder((String)"globalMetrics").withProperty((Annotation)AtProtobuf.builder().tag(3).build()).build();
        private static final FieldDescriptor APPNAMESPACE_DESCRIPTOR = FieldDescriptor.builder((String)"appNamespace").withProperty((Annotation)AtProtobuf.builder().tag(4).build()).build();

        private ClientMetricsEncoder() {
        }

        public void encode(ClientMetrics value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(WINDOW_DESCRIPTOR, (Object)value.getWindowInternal());
            ctx.add(LOGSOURCEMETRICS_DESCRIPTOR, value.getLogSourceMetricsList());
            ctx.add(GLOBALMETRICS_DESCRIPTOR, (Object)value.getGlobalMetricsInternal());
            ctx.add(APPNAMESPACE_DESCRIPTOR, (Object)value.getAppNamespace());
        }
    }

    private static final class TimeWindowEncoder
    implements ObjectEncoder<TimeWindow> {
        static final TimeWindowEncoder INSTANCE = new TimeWindowEncoder();
        private static final FieldDescriptor STARTMS_DESCRIPTOR = FieldDescriptor.builder((String)"startMs").withProperty((Annotation)AtProtobuf.builder().tag(1).build()).build();
        private static final FieldDescriptor ENDMS_DESCRIPTOR = FieldDescriptor.builder((String)"endMs").withProperty((Annotation)AtProtobuf.builder().tag(2).build()).build();

        private TimeWindowEncoder() {
        }

        public void encode(TimeWindow value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(STARTMS_DESCRIPTOR, value.getStartMs());
            ctx.add(ENDMS_DESCRIPTOR, value.getEndMs());
        }
    }

    private static final class LogSourceMetricsEncoder
    implements ObjectEncoder<LogSourceMetrics> {
        static final LogSourceMetricsEncoder INSTANCE = new LogSourceMetricsEncoder();
        private static final FieldDescriptor LOGSOURCE_DESCRIPTOR = FieldDescriptor.builder((String)"logSource").withProperty((Annotation)AtProtobuf.builder().tag(1).build()).build();
        private static final FieldDescriptor LOGEVENTDROPPED_DESCRIPTOR = FieldDescriptor.builder((String)"logEventDropped").withProperty((Annotation)AtProtobuf.builder().tag(2).build()).build();

        private LogSourceMetricsEncoder() {
        }

        public void encode(LogSourceMetrics value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(LOGSOURCE_DESCRIPTOR, (Object)value.getLogSource());
            ctx.add(LOGEVENTDROPPED_DESCRIPTOR, value.getLogEventDroppedList());
        }
    }

    private static final class LogEventDroppedEncoder
    implements ObjectEncoder<LogEventDropped> {
        static final LogEventDroppedEncoder INSTANCE = new LogEventDroppedEncoder();
        private static final FieldDescriptor EVENTSDROPPEDCOUNT_DESCRIPTOR = FieldDescriptor.builder((String)"eventsDroppedCount").withProperty((Annotation)AtProtobuf.builder().tag(1).build()).build();
        private static final FieldDescriptor REASON_DESCRIPTOR = FieldDescriptor.builder((String)"reason").withProperty((Annotation)AtProtobuf.builder().tag(3).build()).build();

        private LogEventDroppedEncoder() {
        }

        public void encode(LogEventDropped value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(EVENTSDROPPEDCOUNT_DESCRIPTOR, value.getEventsDroppedCount());
            ctx.add(REASON_DESCRIPTOR, (Object)value.getReason());
        }
    }

    private static final class GlobalMetricsEncoder
    implements ObjectEncoder<GlobalMetrics> {
        static final GlobalMetricsEncoder INSTANCE = new GlobalMetricsEncoder();
        private static final FieldDescriptor STORAGEMETRICS_DESCRIPTOR = FieldDescriptor.builder((String)"storageMetrics").withProperty((Annotation)AtProtobuf.builder().tag(1).build()).build();

        private GlobalMetricsEncoder() {
        }

        public void encode(GlobalMetrics value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(STORAGEMETRICS_DESCRIPTOR, (Object)value.getStorageMetricsInternal());
        }
    }

    private static final class StorageMetricsEncoder
    implements ObjectEncoder<StorageMetrics> {
        static final StorageMetricsEncoder INSTANCE = new StorageMetricsEncoder();
        private static final FieldDescriptor CURRENTCACHESIZEBYTES_DESCRIPTOR = FieldDescriptor.builder((String)"currentCacheSizeBytes").withProperty((Annotation)AtProtobuf.builder().tag(1).build()).build();
        private static final FieldDescriptor MAXCACHESIZEBYTES_DESCRIPTOR = FieldDescriptor.builder((String)"maxCacheSizeBytes").withProperty((Annotation)AtProtobuf.builder().tag(2).build()).build();

        private StorageMetricsEncoder() {
        }

        public void encode(StorageMetrics value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(CURRENTCACHESIZEBYTES_DESCRIPTOR, value.getCurrentCacheSizeBytes());
            ctx.add(MAXCACHESIZEBYTES_DESCRIPTOR, value.getMaxCacheSizeBytes());
        }
    }
}

