/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import androidx.annotation.WorkerThread;
import com.google.android.datatransport.Priority;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.TransportImpl;
import com.google.android.datatransport.runtime.TransportRuntime;

public final class ForcedSender {
    @WorkerThread
    public static void sendBlocking(Transport<?> transport, Priority priority) {
        TransportContext context = ForcedSender.getTransportContextOrThrow(transport).withPriority(priority);
        TransportRuntime.getInstance().getUploader().logAndUpdateState(context, 1);
    }

    private static TransportContext getTransportContextOrThrow(Transport<?> transport) {
        if (transport instanceof TransportImpl) {
            return ((TransportImpl)transport).getTransportContext();
        }
        throw new IllegalArgumentException("Expected instance of TransportImpl.");
    }

    private ForcedSender() {
    }
}

