/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$Lambda$1;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$Lambda$2;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$Lambda$3;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$Lambda$4;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$Lambda$5;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.scheduling.persistence.PersistedEvent;
import com.google.android.datatransport.runtime.synchronization.SynchronizationException;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.time.WallTime;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class Uploader {
    private static final String LOG_TAG = "Uploader";
    private final Context context;
    private final BackendRegistry backendRegistry;
    private final EventStore eventStore;
    private final WorkScheduler workScheduler;
    private final Executor executor;
    private final SynchronizationGuard guard;
    private final Clock clock;

    @Inject
    public Uploader(Context context, BackendRegistry backendRegistry, EventStore eventStore, WorkScheduler workScheduler, Executor executor, SynchronizationGuard guard, @WallTime Clock clock) {
        this.context = context;
        this.backendRegistry = backendRegistry;
        this.eventStore = eventStore;
        this.workScheduler = workScheduler;
        this.executor = executor;
        this.guard = guard;
        this.clock = clock;
    }

    boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public void upload(TransportContext transportContext, int attemptNumber, Runnable callback) {
        this.executor.execute(Uploader$$Lambda$1.lambdaFactory$(this, transportContext, attemptNumber, callback));
    }

    void logAndUpdateState(TransportContext transportContext, int attemptNumber) {
        BackendResponse response;
        TransportBackend backend = this.backendRegistry.get(transportContext.getBackendName());
        Iterable persistedEvents = (Iterable)this.guard.runCriticalSection(Uploader$$Lambda$2.lambdaFactory$(this, transportContext));
        if (!persistedEvents.iterator().hasNext()) {
            return;
        }
        if (backend == null) {
            Logging.d(LOG_TAG, "Unknown backend for %s, deleting event batch for it...", (Object)transportContext);
            response = BackendResponse.fatalError();
        } else {
            ArrayList<EventInternal> eventInternals = new ArrayList<EventInternal>();
            for (PersistedEvent persistedEvent : persistedEvents) {
                eventInternals.add(persistedEvent.getEvent());
            }
            response = backend.send(BackendRequest.builder().setEvents(eventInternals).setExtras(transportContext.getExtras()).build());
        }
        this.guard.runCriticalSection(Uploader$$Lambda$3.lambdaFactory$(this, response, persistedEvents, transportContext, attemptNumber));
    }

    static /* synthetic */ Object lambda$logAndUpdateState$3(Uploader this_, BackendResponse response, Iterable persistedEvents, TransportContext transportContext, int attemptNumber) {
        if (response.getStatus() == BackendResponse.Status.TRANSIENT_ERROR) {
            this_.eventStore.recordFailure(persistedEvents);
            this_.workScheduler.schedule(transportContext, attemptNumber + 1);
        } else {
            this_.eventStore.recordSuccess(persistedEvents);
            if (response.getStatus() == BackendResponse.Status.OK) {
                this_.eventStore.recordNextCallTime(transportContext, this_.clock.getTime() + response.getNextRequestWaitMillis());
            }
            if (this_.eventStore.hasPendingEventsFor(transportContext)) {
                this_.workScheduler.schedule(transportContext, 1, true);
            }
        }
        return null;
    }

    static /* synthetic */ Iterable lambda$logAndUpdateState$2(Uploader this_, TransportContext transportContext) {
        return this_.eventStore.loadBatch(transportContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$upload$1(Uploader this_, TransportContext transportContext, int attemptNumber, Runnable callback) {
        try {
            EventStore eventStore = this_.eventStore;
            eventStore.getClass();
            this_.guard.runCriticalSection(Uploader$$Lambda$4.lambdaFactory$(eventStore));
            if (!this_.isNetworkAvailable()) {
                this_.guard.runCriticalSection(Uploader$$Lambda$5.lambdaFactory$(this_, transportContext, attemptNumber));
            } else {
                this_.logAndUpdateState(transportContext, attemptNumber);
            }
        }
        catch (SynchronizationException e) {
            this_.workScheduler.schedule(transportContext, attemptNumber + 1);
        }
        finally {
            callback.run();
        }
    }

    static /* synthetic */ Object lambda$upload$0(Uploader this_, TransportContext transportContext, int attemptNumber) {
        this_.workScheduler.schedule(transportContext, attemptNumber + 1);
        return null;
    }
}

