/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.backends;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.datatransport.runtime.backends.BackendFactory;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.CreationContext;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.backends.TransportBackendDiscovery;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class MetadataBackendRegistry
implements BackendRegistry {
    private static final String TAG = "BackendRegistry";
    private static final String BACKEND_KEY_PREFIX = "backend:";
    private final Context applicationContext;
    private final CreationContext creationContext;
    private final Map<String, TransportBackend> backends = new HashMap<String, TransportBackend>();
    private Map<String, String> backendProviders = null;

    @Inject
    MetadataBackendRegistry(Context applicationContext, CreationContext creationContext) {
        this.applicationContext = applicationContext;
        this.creationContext = creationContext;
    }

    @Override
    @Nullable
    public synchronized TransportBackend get(String name) {
        if (this.backends.containsKey(name)) {
            return this.backends.get(name);
        }
        String backendProviderName = this.getBackendProviders().get(name);
        if (backendProviderName == null) {
            return null;
        }
        try {
            BackendFactory provider = Class.forName(backendProviderName).asSubclass(BackendFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            TransportBackend newBackend = provider.create(this.creationContext);
            this.backends.put(name, newBackend);
            return newBackend;
        }
        catch (ClassNotFoundException e) {
            Log.w((String)TAG, (String)String.format("Class %s is not found.", backendProviderName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (String)String.format("Could not instantiate %s.", backendProviderName), (Throwable)e);
        }
        catch (InstantiationException e) {
            Log.w((String)TAG, (String)String.format("Could not instantiate %s.", backendProviderName), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.w((String)TAG, (String)String.format("Could not instantiate %s", backendProviderName), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (String)String.format("Could not instantiate %s", backendProviderName), (Throwable)e);
        }
        return null;
    }

    private Map<String, String> getBackendProviders() {
        if (this.backendProviders == null) {
            this.backendProviders = this.discover(this.applicationContext);
        }
        return this.backendProviders;
    }

    private Map<String, String> discover(Context ctx) {
        Bundle metadata = MetadataBackendRegistry.getMetadata(ctx);
        if (metadata == null) {
            Log.w((String)TAG, (String)"Could not retrieve metadata, returning empty list of transport backends.");
            return Collections.emptyMap();
        }
        HashMap<String, String> backendNames = new HashMap<String, String>();
        for (String key : metadata.keySet()) {
            Object rawValue = metadata.get(key);
            if (!(rawValue instanceof String) || !key.startsWith(BACKEND_KEY_PREFIX)) continue;
            for (String name : ((String)rawValue).split(",", -1)) {
                if ((name = name.trim()).isEmpty()) continue;
                backendNames.put(name, key.substring(BACKEND_KEY_PREFIX.length()));
            }
        }
        return backendNames;
    }

    private static Bundle getMetadata(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            if (manager == null) {
                Log.w((String)TAG, (String)"Context has no PackageManager.");
                return null;
            }
            ServiceInfo info = manager.getServiceInfo(new ComponentName(context, TransportBackendDiscovery.class), 128);
            if (info == null) {
                Log.w((String)TAG, (String)"TransportBackendDiscovery has no service info.");
                return null;
            }
            return info.metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Application info not found.");
            return null;
        }
    }
}

