/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.persistence;

import com.google.android.datatransport.runtime.scheduling.persistence.AutoValue_EventStoreConfig;
import com.google.auto.value.AutoValue;

@AutoValue
abstract class EventStoreConfig {
    private static final long MAX_DB_STORAGE_SIZE_IN_BYTES = 0xA00000L;
    private static final int LOAD_BATCH_SIZE = 200;
    private static final int LOCK_TIME_OUT_MS = 10000;
    private static final long DURATION_ONE_WEEK_MS = 604800000L;
    static final EventStoreConfig DEFAULT = EventStoreConfig.builder().setMaxStorageSizeInBytes(0xA00000L).setLoadBatchSize(200).setCriticalSectionEnterTimeoutMs(10000).setEventCleanUpAge(604800000L).build();

    EventStoreConfig() {
    }

    abstract long getMaxStorageSizeInBytes();

    abstract int getLoadBatchSize();

    abstract int getCriticalSectionEnterTimeoutMs();

    abstract long getEventCleanUpAge();

    static Builder builder() {
        return new AutoValue_EventStoreConfig.Builder();
    }

    Builder toBuilder() {
        return EventStoreConfig.builder().setMaxStorageSizeInBytes(this.getMaxStorageSizeInBytes()).setLoadBatchSize(this.getLoadBatchSize()).setCriticalSectionEnterTimeoutMs(this.getCriticalSectionEnterTimeoutMs()).setEventCleanUpAge(this.getEventCleanUpAge());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setMaxStorageSizeInBytes(long var1);

        abstract Builder setLoadBatchSize(int var1);

        abstract Builder setCriticalSectionEnterTimeoutMs(int var1);

        abstract Builder setEventCleanUpAge(long var1);

        abstract EventStoreConfig build();
    }
}

