/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.VisibleForTesting;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.AlarmManagerSchedulerBroadcastReceiver;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;

public class AlarmManagerScheduler
implements WorkScheduler {
    static final String ATTEMPT_NUMBER = "attemptNumber";
    static final String BACKEND_NAME = "backendName";
    static final String EVENT_PRIORITY = "priority";
    private final Context context;
    private final EventStore eventStore;
    private AlarmManager alarmManager;
    private final SchedulerConfig config;

    public AlarmManagerScheduler(Context applicationContext, EventStore eventStore, SchedulerConfig config) {
        this(applicationContext, eventStore, (AlarmManager)applicationContext.getSystemService("alarm"), config);
    }

    @VisibleForTesting
    AlarmManagerScheduler(Context applicationContext, EventStore eventStore, AlarmManager alarmManager, SchedulerConfig config) {
        this.context = applicationContext;
        this.eventStore = eventStore;
        this.alarmManager = alarmManager;
        this.config = config;
    }

    @VisibleForTesting
    boolean isJobServiceOn(Intent intent) {
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0x20000000) != null;
    }

    @Override
    public void schedule(TransportContext transportContext, int attemptNumber) {
        Uri.Builder intentDataBuilder = new Uri.Builder();
        intentDataBuilder.appendQueryParameter(BACKEND_NAME, transportContext.getBackendName());
        intentDataBuilder.appendQueryParameter(EVENT_PRIORITY, String.valueOf(transportContext.getPriority().ordinal()));
        Intent intent = new Intent(this.context, AlarmManagerSchedulerBroadcastReceiver.class);
        intent.setData(intentDataBuilder.build());
        intent.putExtra(ATTEMPT_NUMBER, attemptNumber);
        if (this.isJobServiceOn(intent)) {
            return;
        }
        long backendTime = this.eventStore.getNextCallTime(transportContext);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
        this.alarmManager.set(3, this.config.getScheduleDelay(transportContext.getPriority(), backendTime, attemptNumber), pendingIntent);
    }
}

