/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.datatransport.cct.internal.AutoValue_LogEvent;
import com.google.android.datatransport.cct.internal.ComplianceData;
import com.google.android.datatransport.cct.internal.NetworkConnectionInfo;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class LogEvent {
    public abstract long getEventTimeMs();

    @Nullable
    public abstract Integer getEventCode();

    @Nullable
    public abstract ComplianceData getComplianceData();

    public abstract long getEventUptimeMs();

    @Nullable
    public abstract byte[] getSourceExtension();

    @Nullable
    public abstract String getSourceExtensionJsonProto3();

    public abstract long getTimezoneOffsetSeconds();

    @Nullable
    public abstract NetworkConnectionInfo getNetworkConnectionInfo();

    @NonNull
    public static Builder protoBuilder(@NonNull byte[] sourceExtension) {
        return LogEvent.builder().setSourceExtension(sourceExtension);
    }

    @NonNull
    public static Builder jsonBuilder(@NonNull String sourceJsonExtension) {
        return LogEvent.builder().setSourceExtensionJsonProto3(sourceJsonExtension);
    }

    private static Builder builder() {
        return new AutoValue_LogEvent.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @NonNull
        public abstract Builder setEventTimeMs(long var1);

        @NonNull
        public abstract Builder setEventCode(@Nullable Integer var1);

        @NonNull
        public abstract Builder setComplianceData(@Nullable ComplianceData var1);

        @NonNull
        public abstract Builder setEventUptimeMs(long var1);

        @NonNull
        abstract Builder setSourceExtension(@Nullable byte[] var1);

        @NonNull
        abstract Builder setSourceExtensionJsonProto3(@Nullable String var1);

        @NonNull
        public abstract Builder setTimezoneOffsetSeconds(long var1);

        @NonNull
        public abstract Builder setNetworkConnectionInfo(@Nullable NetworkConnectionInfo var1);

        @NonNull
        public abstract LogEvent build();
    }
}

