/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import androidx.annotation.Nullable;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.datatransport.cct.a.zzaa;
import com.google.android.datatransport.cct.a.zzo;
import com.google.android.datatransport.cct.a.zzq;
import com.google.android.datatransport.cct.a.zzs;
import com.google.android.datatransport.cct.a.zzt;
import com.google.android.datatransport.cct.a.zzv;
import com.google.android.datatransport.cct.a.zzx;
import com.google.android.datatransport.cct.a.zzy;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.retries.Function;
import com.google.android.datatransport.runtime.retries.Retries;
import com.google.android.datatransport.runtime.retries.RetryStrategy;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;

final class zzc
implements TransportBackend {
    private final DataEncoder zza;
    private final ConnectivityManager zzb;
    final URL zzc;
    private final Clock zzd;
    private final Clock zze;
    private final int zzf;

    private static URL zza(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid url: " + string, malformedURLException);
        }
    }

    zzc(Context context, Clock clock, Clock clock2) {
        zzc zzc2 = this;
        this.zza = zzs.zza();
        zzc2.zzb = (ConnectivityManager)context.getSystemService("connectivity");
        zzc2.zzc = com.google.android.datatransport.cct.zzc.zza(CCTDestination.zza);
        this.zzd = clock2;
        this.zze = clock;
        this.zzf = 40000;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private zzb zza(zza var1_5) throws IOException {
        block19: {
            block18: {
                v0 = var1_5;
                var2_6 = v0.zza;
                Logging.d((String)"CctTransportBackend", (String)"Making request to: %s", (Object)var2_6);
                var2_6 = (HttpURLConnection)v0.zza.openConnection();
                var2_6.setConnectTimeout(30000);
                var2_6.setReadTimeout(this.zzf);
                var2_6.setDoOutput(true);
                var2_6.setInstanceFollowRedirects(false);
                var2_6.setRequestMethod("POST");
                v1 = new Object[1];
                var3_7 = v1;
                v1[0] = "2.2.0";
                var2_6.setRequestProperty("User-Agent", String.format("datatransport/%s android/", (Object[])var3_7));
                var2_6.setRequestProperty("Content-Encoding", "gzip");
                var2_6.setRequestProperty("Content-Type", "application/json");
                var2_6.setRequestProperty("Accept-Encoding", "gzip");
                var3_7 = v0.zzc;
                if (var3_7 != null) {
                    var2_6.setRequestProperty("X-Goog-Api-Key", (String)var3_7);
                }
                v2 = var2_6;
                var3_7 = Channels.newChannel(v2.getOutputStream());
                var4_8 = v3;
                v3 = new ByteArrayOutputStream();
                v4 = v3;
                v5 = var5_10 = v6;
                v7 = this;
                var5_10(var4_8);
                {
                    catch (Throwable v8) {
                        var3_7.close();
                        throw v8;
                    }
                }
                v7.zza.encode((Object)var1_5.zzb, (Writer)new OutputStreamWriter(var5_10));
                v5.close();
                var3_7.write(ByteBuffer.wrap(v4.toByteArray()));
                var0_1 = v2.getResponseCode();
                Logging.i((String)"CctTransportBackend", (String)("Status Code: " + var0_1));
                Logging.i((String)"CctTransportBackend", (String)("Content-Type: " + var2_6.getHeaderField("Content-Type")));
                Logging.i((String)"CctTransportBackend", (String)("Content-Encoding: " + var2_6.getHeaderField("Content-Encoding")));
                if (var0_1 == 302 || var0_1 == 301 || var0_1 == 307) ** GOTO lbl73
                if (var0_1 == 200) break block18;
                v9 = v10;
                v11 = v10;
                v9(var0_1, null, 0L);
                var3_7.close();
                return v11;
            }
            var1_5 = var2_6.getHeaderField("Content-Encoding");
            if (var1_5 != null && var1_5.equals("gzip")) {
                var1_5 = v12;
                v12 = new GZIPInputStream(var2_6.getInputStream());
                break block19;
            }
            var1_5 = var2_6.getInputStream();
        }
        var4_9 = zzx.zza(new InputStreamReader((InputStream)var1_5)).zza();
        v13 = var2_6 = v14;
        v15 = var3_7;
        v16 = var1_5;
        var2_6(var0_1, null, var4_9);
        v16.close();
        v15.close();
        return v13;
        catch (Throwable v17) {
            block20: {
                var1_5.close();
                throw v17;
lbl73:
                // 1 sources

                var1_5 = var2_6.getHeaderField("Location");
                v18 = new zzb(var0_1, new URL((String)var1_5), 0L);
                var3_7.close();
                return v18;
                catch (Throwable v19) {
                    break block20;
                }
                catch (IOException var0_2) {
                    ** GOTO lbl-1000
                }
                catch (EncodingException var0_3) {
                    // empty catch block
                }
lbl-1000:
                // 2 sources

                {
                    Logging.e((String)"CctTransportBackend", (String)"Couldn't encode request, returning with 400", (Throwable)var0_4);
                    v20 = var0_4 = v21;
                    v22 = var3_7;
                    v23 = var5_10;
                    var0_4(400, null, 0L);
                }
                v23.close();
                v22.close();
                return v20;
            }
            var5_10.close();
            throw v19;
        }
    }

    static /* synthetic */ zza zza(zza zza2, zzb zzb2) {
        URL uRL = zzb2.zzb;
        if (uRL != null) {
            Logging.d((String)"CctTransportBackend", (String)"Following redirect to: %s", (Object)uRL);
            return zza2.zza(zzb2.zzb);
        }
        return null;
    }

    static /* synthetic */ zzb zza(zzc zzc2, zza zza2) {
        return zzc2.zza(zza2);
    }

    public EventInternal decorate(EventInternal eventInternal) {
        int n;
        zzc zzc2 = zzc2.zzb.getActiveNetworkInfo();
        EventInternal.Builder builder = eventInternal.toBuilder().addMetadata("sdk-version", Build.VERSION.SDK_INT).addMetadata("model", Build.MODEL).addMetadata("hardware", Build.HARDWARE).addMetadata("device", Build.DEVICE).addMetadata("product", Build.PRODUCT).addMetadata("os-uild", Build.ID).addMetadata("manufacturer", Build.MANUFACTURER).addMetadata("fingerprint", Build.FINGERPRINT);
        Calendar.getInstance();
        eventInternal = builder.addMetadata("tz-offset", (long)(TimeZone.getDefault().getOffset(Calendar.getInstance().getTimeInMillis()) / 1000));
        String string = "net-type";
        int n2 = zzc2 == null ? zzy.zzc.zzs.zza() : zzc2.getType();
        eventInternal = eventInternal.addMetadata(string, n2);
        string = "mobile-subtype";
        if (zzc2 == null) {
            n = zzy.zzb.zza.zza();
        } else {
            n = zzc2.getSubtype();
            if (n == -1) {
                n = zzy.zzb.zzu.zza();
            } else if (zzy.zzb.zza(n) == null) {
                n = 0;
            }
        }
        return eventInternal.addMetadata(string, n).build();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackendResponse send(BackendRequest object) {
        ArrayList arrayList;
        Object object2;
        HashMap hashMap;
        Object object3 = hashMap;
        hashMap = new HashMap();
        for (EventInternal eventInternal : object.getEvents()) {
            object2 = eventInternal.getTransportName();
            if (!((HashMap)object3).containsKey(object2)) {
                ArrayList<EventInternal> arrayList2 = new ArrayList<EventInternal>();
                arrayList2.add(eventInternal);
                ((HashMap)object3).put(object2, arrayList2);
                continue;
            }
            ((List)((HashMap)object3).get(object2)).add(eventInternal);
        }
        HashMap hashMap2 = object3;
        object3 = arrayList;
        arrayList = new ArrayList();
        Object object4 = hashMap2.entrySet().iterator();
        while (true) {
            Iterator iterator;
            ArrayList<zzt> arrayList3;
            if (object4.hasNext()) {
                ArrayList<zzt> arrayList4;
                Map.Entry entry = (Map.Entry)object4.next();
                object2 = (EventInternal)((List)entry.getValue()).get(0);
                object2 = zzv.zza().zza(zzaa.zza).zza(((zzc)((Object)zzb2)).zze.getTime()).zzb(((zzc)((Object)zzb2)).zzd.getTime()).zza(zzq.zza().zza(zzq.zzb.zzb).zza(com.google.android.datatransport.cct.a.zza.zza().zza(object2.getInteger("sdk-version")).zze(object2.get("model")).zzc(object2.get("hardware")).zza(object2.get("device")).zzg(object2.get("product")).zzf(object2.get("os-uild")).zzd(object2.get("manufacturer")).zzb(object2.get("fingerprint")).zza()).zza());
                try {
                    ((zzv.zza)object2).zzb(Integer.valueOf((String)entry.getKey()));
                }
                catch (NumberFormatException numberFormatException) {
                    ((zzv.zza)object2).zzb((String)entry.getKey());
                }
                arrayList3 = arrayList4;
                arrayList4 = new ArrayList<zzt>();
                iterator = ((List)entry.getValue()).iterator();
            } else {
                object3 = zzo.zza((List<zzv>)object3);
                object4 = null;
                URL uRL = ((zzc)((Object)zzb2)).zzc;
                if (object.getExtras() != null) {
                    try {
                        object = CCTDestination.fromByteArray(object.getExtras());
                        if (((CCTDestination)object).getAPIKey() != null) {
                            object4 = ((CCTDestination)object).getAPIKey();
                        }
                        if (((CCTDestination)object).getEndPoint() != null) {
                            URL uRL2 = com.google.android.datatransport.cct.zzc.zza(((CCTDestination)object).getEndPoint());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return BackendResponse.fatalError();
                    }
                }
                try {
                    void var4_12;
                    zzb zzb2 = (zzb)Retries.retry((int)5, (Object)new zza((URL)var4_12, (zzo)object3, (String)object4), (Function)com.google.android.datatransport.cct.zza.zza((zzc)((Object)zzb2)), (RetryStrategy)com.google.android.datatransport.cct.zzb.zza());
                    if (zzb2.zza == 200) {
                        return BackendResponse.ok((long)zzb2.zzc);
                    }
                    int n = zzb2.zza;
                    if (n >= 500) return BackendResponse.transientError();
                    if (n != 404) return BackendResponse.fatalError();
                    return BackendResponse.transientError();
                }
                catch (IOException iOException) {
                    Logging.e((String)"CctTransportBackend", (String)"Could not make request to the backend", (Throwable)iOException);
                    return BackendResponse.transientError();
                }
            }
            while (iterator.hasNext()) {
                Encoding encoding;
                block24: {
                    Object object5;
                    EventInternal eventInternal;
                    block23: {
                        block22: {
                            eventInternal = (EventInternal)iterator.next();
                            object5 = eventInternal.getEncodedPayload();
                            encoding = object5.getEncoding();
                            if (!encoding.equals((Object)Encoding.of((String)"proto"))) break block22;
                            object5 = zzt.zza(object5.getBytes());
                            break block23;
                        }
                        if (!encoding.equals((Object)Encoding.of((String)"json"))) break block24;
                        object5 = zzt.zza(new String(object5.getBytes(), Charset.forName("UTF-8")));
                    }
                    ((zzt.zza)object5).zza(eventInternal.getEventMillis()).zzb(eventInternal.getUptimeMillis()).zzc(eventInternal.getLong("tz-offset")).zza(zzy.zza().zza(zzy.zzc.zza(eventInternal.getInteger("net-type"))).zza(zzy.zzb.zza(eventInternal.getInteger("mobile-subtype"))).zza());
                    if (eventInternal.getCode() != null) {
                        ((zzt.zza)object5).zza(eventInternal.getCode());
                    }
                    arrayList3.add(((zzt.zza)object5).zza());
                    continue;
                }
                Logging.w((String)"CctTransportBackend", (String)"Received event of unsupported encoding %s. Skipping...", (Object)encoding);
            }
            Object object6 = object2;
            ((zzv.zza)object6).zza(arrayList3);
            object3.add(((zzv.zza)object6).zza());
        }
    }

    static final class zza {
        final URL zza;
        final zzo zzb;
        @Nullable
        final String zzc;

        zza(URL uRL, zzo zzo2, @Nullable String string) {
            this.zza = uRL;
            this.zzb = zzo2;
            this.zzc = string;
        }

        zza zza(URL uRL) {
            return new zza(uRL, this.zzb, this.zzc);
        }
    }

    static final class zzb {
        final int zza;
        @Nullable
        final URL zzb;
        final long zzc;

        zzb(int n, @Nullable URL uRL, long l) {
            this.zza = n;
            this.zzb = uRL;
            this.zzc = l;
        }
    }
}

