/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.datatransport.cct.a.zzb;
import com.google.android.datatransport.cct.a.zzc;
import com.google.android.datatransport.cct.a.zze;
import com.google.android.datatransport.cct.a.zzf;
import com.google.android.datatransport.cct.a.zzh;
import com.google.android.datatransport.cct.a.zzi;
import com.google.android.datatransport.cct.a.zzk;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

final class zza
implements TransportBackend {
    private static final Logger zza = Logger.getLogger(zza.class.getName());
    private final ConnectivityManager zzb;
    private final URL zzc;
    private final Clock zzd;
    private final Clock zze;
    private final int zzf;

    private static URL zza(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid url: " + string, malformedURLException);
        }
    }

    private zza(Context context, String string, Clock clock, Clock clock2, int n) {
        this.zzb = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzc = com.google.android.datatransport.cct.zza.zza(string);
        this.zzd = clock2;
        this.zze = clock;
        this.zzf = 40000;
    }

    zza(Context context, String string, Clock clock, Clock clock2) {
        this(context, string, clock, clock2, 40000);
    }

    public final EventInternal decorate(EventInternal eventInternal) {
        TimeZone timeZone;
        NetworkInfo networkInfo = this.zzb.getActiveNetworkInfo();
        EventInternal.Builder builder = timeZone.toBuilder().addMetadata("sdk-version", Build.VERSION.SDK_INT).addMetadata("model", Build.MODEL).addMetadata("hardware", Build.HARDWARE).addMetadata("device", Build.DEVICE).addMetadata("product", Build.PRODUCT).addMetadata("os-uild", Build.ID).addMetadata("manufacturer", Build.MANUFACTURER).addMetadata("fingerprint", Build.FINGERPRINT);
        Calendar.getInstance();
        timeZone = TimeZone.getDefault();
        int n = networkInfo.getSubtype();
        return builder.addMetadata("tz-offset", (long)(timeZone.getOffset(Calendar.getInstance().getTimeInMillis()) / 1000)).addMetadata("net-type", networkInfo.getType()).addMetadata("mobile-subtype", n == -1 ? 100 : (zzi.zzb.zza(n) != null ? n : 0)).build();
    }

    private BackendResponse zza(zzb zzb2) throws IOException {
        Object object = (HttpURLConnection)this.zzc.openConnection();
        ((URLConnection)object).setConnectTimeout(30000);
        ((URLConnection)object).setReadTimeout(this.zzf);
        ((URLConnection)object).setDoOutput(true);
        ((HttpURLConnection)object).setInstanceFollowRedirects(false);
        ((HttpURLConnection)object).setRequestMethod("POST");
        ((URLConnection)object).setRequestProperty("Content-Encoding", "gzip");
        ((URLConnection)object).setRequestProperty("Content-Type", "application/x-protobuf");
        WritableByteChannel writableByteChannel = Channels.newChannel(((URLConnection)object).getOutputStream());
        try {
            long l;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            try {
                zzb2.writeTo(gZIPOutputStream);
            }
            finally {
                gZIPOutputStream.close();
            }
            writableByteChannel.write(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            int n = ((HttpURLConnection)object).getResponseCode();
            zza.info("Status Code: " + n);
            object = ((URLConnection)object).getInputStream();
            try {
                try {
                    l = zzh.zza((InputStream)object).zza();
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    BackendResponse backendResponse = BackendResponse.fatalError();
                    ((InputStream)object).close();
                    writableByteChannel.close();
                    return backendResponse;
                }
            }
            finally {
                ((InputStream)object).close();
            }
            if (n == 200) {
                BackendResponse backendResponse = BackendResponse.ok((long)l);
                return backendResponse;
            }
            if (n >= 500 || n == 404) {
                BackendResponse backendResponse = BackendResponse.transientError();
                return backendResponse;
            }
            BackendResponse backendResponse = BackendResponse.fatalError();
            return backendResponse;
        }
        finally {
            writableByteChannel.close();
        }
    }

    public final BackendResponse send(BackendRequest request) {
        EventInternal eventInternal2;
        Object object;
        Object object2 = object;
        object = this;
        Object object3 = new HashMap<String, EventInternal>();
        for (Object object4 : object2.getEvents()) {
            String object5 = object4.getTransportName();
            if (!((HashMap)object3).containsKey(object5)) {
                eventInternal2 = new ArrayList();
                eventInternal2.add(object4);
                ((HashMap)object3).put(object5, eventInternal2);
                continue;
            }
            ((List)((HashMap)object3).get(object5)).add(object4);
        }
        object2 = com.google.android.datatransport.cct.a.zzb.zza();
        for (Map.Entry entry : ((HashMap)object3).entrySet()) {
            eventInternal2 = (EventInternal)((List)entry.getValue()).get(0);
            object3 = com.google.android.datatransport.cct.a.zzf.zza().zza(Integer.valueOf((String)entry.getKey())).zza(zzk.zzb.zza).zza(((zza)object).zze.getTime()).zzb(((zza)object).zzd.getTime()).zza((zzc)com.google.android.datatransport.cct.a.zzc.zza().zza(zzc.zzb.zzb).zza((com.google.android.datatransport.cct.a.zza)com.google.android.datatransport.cct.a.zza.zza().zza(eventInternal2.getInteger("sdk-version")).zza(eventInternal2.get("model")).zzc(eventInternal2.get("hardware")).zzd(eventInternal2.get("device")).zzb(eventInternal2.get("product")).zze(eventInternal2.get("os-uild")).zzf(eventInternal2.get("manufacturer")).zzg(eventInternal2.get("fingerprint")).build()).build());
            for (EventInternal eventInternal2 : (List)entry.getValue()) {
                zze.zza zza2 = com.google.android.datatransport.cct.a.zze.zza().zza(eventInternal2.getEventMillis()).zzb(eventInternal2.getUptimeMillis()).zzc(eventInternal2.getLong("tz-offset")).zza(ByteString.copyFrom((byte[])eventInternal2.getPayload())).zza(zzi.zza().zza(eventInternal2.getInteger("net-type")).zzb(eventInternal2.getInteger("mobile-subtype")));
                if (eventInternal2.getCode() != null) {
                    zza2.zza(eventInternal2.getCode());
                }
                ((zzf.zza)object3).zza(zza2);
            }
            ((zzb.zza)object2).zza((zzf)object3.build());
        }
        object = (zzb)object2.build();
        try {
            return this.zza((zzb)object);
        }
        catch (IOException iOException) {
            zza.log(Level.SEVERE, "Could not make request to the backend", iOException);
            return BackendResponse.transientError();
        }
    }
}

